/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.react;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.frameworks.react.ReactXmlElementDescriptor;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.resolve.ES6QualifiedNameResolver;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSRecordMemberSourceFactory;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveType;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSXPropTypesUtil {
    public static final String PROPS_IS_REQUIRED_NAME = "isRequired";

    @NotNull
    public static JSRecordType convertFlowRecordType(@NotNull JSRecordType type) {
        PsiElement element;
        DialectOptionHolder holder;
        if (type == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(0);
        }
        if ((holder = DialectDetector.dialectOfElement(element = type.getSource().getSourceElement())) == null || !holder.isFlow) {
            JSRecordType jSRecordType = type;
            if (jSRecordType == null) {
                JSXPropTypesUtil.$$$reportNull$$$0(1);
            }
            return jSRecordType;
        }
        List members = type.getTypeMembers();
        List<JSRecordType.TypeMember> newMembers = members.stream().map(member -> {
            if (!(member instanceof JSRecordType.PropertySignature)) {
                return member;
            }
            return JSXPropTypesUtil.convertSignature((JSRecordType.PropertySignature)member);
        }).collect(Collectors.toList());
        JSRecordTypeImpl jSRecordTypeImpl = new JSRecordTypeImpl(type.getSource(), newMembers);
        if (jSRecordTypeImpl == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(2);
        }
        return jSRecordTypeImpl;
    }

    @NotNull
    private static JSRecordType.PropertySignature convertSignature(@NotNull JSRecordType.PropertySignature member) {
        String typeName;
        String parsedType;
        JSRecordType.MemberSource memberSource;
        if (member == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(3);
        }
        if ((memberSource = member.getMemberSource()).getSingleElement() instanceof JSImplicitElement) {
            JSRecordType.PropertySignature propertySignature = member;
            if (propertySignature == null) {
                JSXPropTypesUtil.$$$reportNull$$$0(4);
            }
            return propertySignature;
        }
        JSType type = member.getType();
        if (type instanceof JSPrimitiveType) {
            JSRecordType.PropertySignature propertySignature = member;
            if (propertySignature == null) {
                JSXPropTypesUtil.$$$reportNull$$$0(5);
            }
            return propertySignature;
        }
        if (!(type instanceof JSNamedType)) {
            JSRecordTypeImpl.PropertySignatureImpl propertySignatureImpl = JSXPropTypesUtil.wrapAsOptional(member, type);
            if (propertySignatureImpl == null) {
                JSXPropTypesUtil.$$$reportNull$$$0(6);
            }
            return propertySignatureImpl;
        }
        boolean isOptional = true;
        JSType newReturnType = type;
        String text = type.getTypeText();
        List elements = StringUtil.split((String)text, (String)".");
        if (elements.size() == 1) {
            JSRecordType.PropertySignature propertySignature = member;
            if (propertySignature == null) {
                JSXPropTypesUtil.$$$reportNull$$$0(7);
            }
            return propertySignature;
        }
        String lastItem = (String)ContainerUtil.getLastItem((List)elements);
        if (PROPS_IS_REQUIRED_NAME.equals(lastItem)) {
            isOptional = false;
            elements = elements.subList(0, elements.size() - 1);
        }
        if ((parsedType = JSXPropTypesUtil.parseType(typeName = (String)ContainerUtil.getLastItem((List)elements))) != null) {
            newReturnType = JSNamedType.createType(parsedType, type.getSource(), ((JSNamedType)type).getTypeContext());
            PsiElement provider = !memberSource.isEmpty() ? memberSource.getSingleElement() : type.getSource().getSourceElement();
            JSImplicitElementImpl.Builder propsBuilder = new JSImplicitElementImpl.Builder(member.getMemberName(), provider).setTypeString(parsedType).setType(JSImplicitElement.Type.Property);
            if (!isOptional) {
                propsBuilder = propsBuilder.setUserString("r");
            }
            memberSource = JSRecordMemberSourceFactory.createSource((PsiElement)propsBuilder.toImplicitElement());
        }
        JSRecordTypeImpl.PropertySignatureImpl propertySignatureImpl = new JSRecordTypeImpl.PropertySignatureImpl(member.getMemberName(), newReturnType, isOptional, memberSource);
        if (propertySignatureImpl == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(8);
        }
        return propertySignatureImpl;
    }

    @NotNull
    private static JSRecordTypeImpl.PropertySignatureImpl wrapAsOptional(@NotNull JSRecordType.PropertySignature member, JSType type) {
        if (member == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(9);
        }
        JSRecordTypeImpl.PropertySignatureImpl propertySignatureImpl = new JSRecordTypeImpl.PropertySignatureImpl(member.getMemberName(), type, true);
        if (propertySignatureImpl == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(10);
        }
        return propertySignatureImpl;
    }

    @NotNull
    public static Stream<JSPsiElementBase> resolveNamespacePropTypes(@NotNull ReactXmlElementDescriptor.NamespaceInfo namespaceInfo, @NotNull GlobalSearchScope scope) {
        if (namespaceInfo == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(11);
        }
        if (scope == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(12);
        }
        String namespace = namespaceInfo.getNamespace().replace(".props", ".propTypes");
        Collection<JSPsiElementBase> elements = JSClassResolver.getInstance().findElementsByQNameIncludingImplicit(namespace, scope);
        for (JSPsiElementBase element : elements) {
            String reference;
            if (!(element instanceof JSDefinitionExpression)) continue;
            PsiElement meaningfulElement = JSStubBasedPsiTreeUtil.calculateMeaningfulElement((PsiElement)element);
            if (meaningfulElement instanceof JSDefinitionExpression && !StringUtil.isEmptyOrSpaces((String)(reference = ((JSDefinitionExpression)meaningfulElement).getInitializerReference()))) {
                Collection<PsiElement> resolvedElements = new ES6QualifiedNameResolver(meaningfulElement).resolveQualifiedName(reference);
                meaningfulElement = (PsiElement)ContainerUtil.getFirstItem(resolvedElements);
            }
            if (meaningfulElement instanceof JSVariable) {
                meaningfulElement = ((JSVariable)meaningfulElement).getInitializerOrStub();
            }
            if (!(meaningfulElement instanceof JSObjectLiteralExpression)) continue;
            Stream<JSPsiElementBase> stream = JSXPropTypesUtil.convertObjectLiteralToPropsType((JSObjectLiteralExpression)meaningfulElement);
            if (stream == null) {
                JSXPropTypesUtil.$$$reportNull$$$0(13);
            }
            return stream;
        }
        Stream<JSPsiElementBase> stream = Stream.empty();
        if (stream == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(14);
        }
        return stream;
    }

    @NotNull
    private static Stream<JSPsiElementBase> convertObjectLiteralToPropsType(@NotNull JSObjectLiteralExpression expression) {
        JSProperty[] properties;
        if (expression == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(15);
        }
        if ((properties = expression.getProperties()).length == 0) {
            Stream<JSPsiElementBase> stream = Stream.empty();
            if (stream == null) {
                JSXPropTypesUtil.$$$reportNull$$$0(16);
            }
            return stream;
        }
        Stream<JSPsiElementBase> stream = Arrays.stream(properties).filter(el -> el.getName() != null).map(property -> {
            Collection elements;
            JSElementIndexingData data = property.getIndexingData();
            if (data != null && (elements = data.getImplicitElements()) != null) {
                for (JSImplicitElement element : elements) {
                    if (!element.getQualifiedName().endsWith("props." + element.getName())) continue;
                    return element;
                }
            }
            String name = property.getName();
            assert (name != null);
            return JSXPropTypesUtil.createSimpleImplicitElement(property, JSQualifiedNameImpl.fromQualifiedName(name)).toImplicitElement();
        });
        if (stream == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(17);
        }
        return stream;
    }

    @NotNull
    public static JSImplicitElementImpl createImplicitReactPropsElement(@NotNull JSProperty property, @NotNull JSQualifiedNameImpl prop) {
        if (property == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(18);
        }
        if (prop == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(19);
        }
        JSImplicitElementImpl.Builder propBuilder = JSXPropTypesUtil.createSimpleImplicitElement(property, prop).setTypeString(JSXPropTypesUtil.computeType(property.getValue()));
        if (JSXPropTypesUtil.isRequired(property.getValue())) {
            propBuilder.setUserString("r");
        }
        JSImplicitElementImpl jSImplicitElementImpl = propBuilder.toImplicitElement();
        if (jSImplicitElementImpl == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(20);
        }
        return jSImplicitElementImpl;
    }

    private static JSImplicitElementImpl.Builder createSimpleImplicitElement(@NotNull JSProperty property, @NotNull JSQualifiedNameImpl prop) {
        if (property == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(21);
        }
        if (prop == null) {
            JSXPropTypesUtil.$$$reportNull$$$0(22);
        }
        return new JSImplicitElementImpl.Builder(prop, (PsiElement)property).setContext(JSContext.INSTANCE).setType(JSImplicitElement.Type.Property).setNamespaceExplicitlyDeclared(true);
    }

    private static boolean isRequired(@Nullable JSExpression value) {
        return value instanceof JSReferenceExpression && PROPS_IS_REQUIRED_NAME.equals(((JSReferenceExpression)value).getReferenceName());
    }

    @Nullable
    private static String computeType(@Nullable JSExpression value) {
        if (value instanceof JSReferenceExpression) {
            String name = ((JSReferenceExpression)value).getReferenceName();
            String resultType = JSXPropTypesUtil.parseType(name);
            if (resultType != null) {
                return resultType;
            }
            if (PROPS_IS_REQUIRED_NAME.equals(name)) {
                return JSXPropTypesUtil.computeType(((JSReferenceExpression)value).getQualifier());
            }
        }
        return null;
    }

    @Nullable
    public static String parseType(@Nullable String name) {
        if ("string".equals(name) || "object".equals(name) || "number".equals(name)) {
            return StringUtil.capitalize((String)name);
        }
        if ("bool".equals(name)) {
            return "Boolean";
        }
        if ("fn".equals(name) || "fun".equals(name)) {
            return "Function";
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/frameworks/react/JSXPropTypesUtil";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespaceInfo";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prop";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/frameworks/react/JSXPropTypesUtil";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "convertFlowRecordType";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "convertSignature";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapAsOptional";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveNamespacePropTypes";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "convertObjectLiteralToPropsType";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createImplicitReactPropsElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "convertFlowRecordType";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 20: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "convertSignature";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "wrapAsOptional";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "resolveNamespacePropTypes";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "convertObjectLiteralToPropsType";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createImplicitReactPropsElement";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createSimpleImplicitElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

