/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.react;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.LegacyCompletionContributor;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.XmlTagInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.frameworks.react.ReactXmlExtension;
import com.intellij.lang.javascript.frameworks.react.tsx.TypeScriptReactComponentUtil;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.JSExportedMembersIndex;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.typescript.completion.ES6ImportCompletionUtil;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.xml.TagNameReference;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import icons.JavaScriptLanguageIcons;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReactComponentCompletionContributor
extends CompletionContributor {
    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        String prefix;
        boolean needComponents;
        if (parameters == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(0);
        }
        if (result == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(1);
        }
        boolean bl = needComponents = StringUtil.isEmpty((String)(prefix = result.getPrefixMatcher().getPrefix())) || ReactXmlExtension.isComponentName(prefix);
        if (!needComponents) {
            return;
        }
        LegacyCompletionContributor.processReferences((CompletionParameters)parameters, (CompletionResultSet)result, (reference, set) -> {
            if (result == null) {
                ReactComponentCompletionContributor.$$$reportNull$$$0(24);
            }
            if (!(reference instanceof TagNameReference)) {
                return;
            }
            TagNameReference tagNameReference = (TagNameReference)reference;
            PsiElement element = tagNameReference.getElement();
            if (element instanceof XmlTag && tagNameReference.isStartTagFlag() && !ReactXmlExtension.nonJsxTag((XmlTag)element)) {
                HashSet<String> collectedNames = new HashSet<String>();
                XmlTag tag = (XmlTag)element;
                boolean isTypeScript = DialectDetector.isTypeScript(element);
                ReactComponentCompletionContributor.addLocalVariants(result, tag, collectedNames, isTypeScript);
                ReactComponentCompletionContributor.addExportedComponents(result, tag, collectedNames, isTypeScript);
            }
        });
    }

    private static void addExportedComponents(@NotNull CompletionResultSet result, @NotNull XmlTag tag, @NotNull Set<String> names, boolean isTypeScript) {
        if (result == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(2);
        }
        if (tag == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(3);
        }
        if (names == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(4);
        }
        Project project = tag.getProject();
        GlobalSearchScope scope = ReactComponentCompletionContributor.createScope((PsiElement)tag, project);
        HashSet classesToHierarchyCheck = ContainerUtil.newHashSet();
        PrefixMatcher prefixMatcher = result.getPrefixMatcher();
        Processor processor = element -> {
            String name;
            if (names == null) {
                ReactComponentCompletionContributor.$$$reportNull$$$0(21);
            }
            if (result == null) {
                ReactComponentCompletionContributor.$$$reportNull$$$0(22);
            }
            if (tag == null) {
                ReactComponentCompletionContributor.$$$reportNull$$$0(23);
            }
            if (!ReactXmlExtension.isComponentName(name = ES6ImportPsiUtil.getExportedElementName(element)) || !prefixMatcher.prefixMatches(name) || names.contains(name)) {
                return true;
            }
            if (element instanceof JSClass) {
                JSClass jsClass = (JSClass)element;
                ThreeState state = ReactXmlExtension.isAcceptableClassComponent(jsClass);
                switch (state) {
                    case YES: {
                        ReactComponentCompletionContributor.addComponentWithImportInsertHandler(result, tag, isTypeScript, (PsiElement)jsClass);
                        return true;
                    }
                    case NO: {
                        return true;
                    }
                }
                classesToHierarchyCheck.add(jsClass);
                return true;
            }
            if (!DialectDetector.isJSX((PsiElement)element)) {
                return true;
            }
            if (element instanceof JSVariable) {
                JSFunctionExpression expression = ((JSVariable)element).tryGetFunctionExpressionInitializer();
                if (expression != null && ReactXmlExtension.isAcceptableFunctionComponent((JSFunction)expression)) {
                    ReactComponentCompletionContributor.addComponentWithImportInsertHandler(result, tag, isTypeScript, (PsiElement)element);
                }
                return true;
            }
            if (element instanceof JSFunction) {
                if (ReactXmlExtension.isAcceptableFunctionComponent((JSFunction)element)) {
                    ReactComponentCompletionContributor.addComponentWithImportInsertHandler(result, tag, isTypeScript, (PsiElement)element);
                }
                return true;
            }
            return true;
        };
        ReactComponentCompletionContributor.processExportedElementsForKey(project, "exp", scope, (Processor<JSElement>)processor);
        ReactComponentCompletionContributor.processExportedElementsForKey(project, "def", scope, (Processor<JSElement>)processor);
        ReactComponentCompletionContributor.addClassesWithCheckHierarchy(result, tag, classesToHierarchyCheck, isTypeScript);
    }

    private static void addClassesWithCheckHierarchy(@NotNull CompletionResultSet result, @NotNull XmlTag tag, Collection<JSClass> classesToHierarchyCheck, boolean isTypeScript) {
        if (result == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(5);
        }
        if (tag == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(6);
        }
        if (classesToHierarchyCheck.isEmpty()) {
            return;
        }
        for (JSClass jsClass : classesToHierarchyCheck) {
            TypeScriptUtil.JSClassHierarchyProcessor processor = (aClass, typeSubstitutor, fromImplements) -> {
                String name;
                if (result == null) {
                    ReactComponentCompletionContributor.$$$reportNull$$$0(17);
                }
                if (tag == null) {
                    ReactComponentCompletionContributor.$$$reportNull$$$0(18);
                }
                if (aClass == null) {
                    ReactComponentCompletionContributor.$$$reportNull$$$0(19);
                }
                if (typeSubstitutor == null) {
                    ReactComponentCompletionContributor.$$$reportNull$$$0(20);
                }
                if (TypeScriptReactComponentUtil.REACT_COMPONENT_NAMES.contains(name = aClass.getName())) {
                    ReactComponentCompletionContributor.addComponentWithImportInsertHandler(result, tag, isTypeScript, (PsiElement)jsClass);
                    return false;
                }
                return true;
            };
            JSClassUtils.processClassesInHierarchy(jsClass, false, processor);
        }
    }

    @NotNull
    public static GlobalSearchScope createScope(@NotNull PsiElement element, final Project project) {
        if (element == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(7);
        }
        DelegatingGlobalSearchScope delegatingGlobalSearchScope = new DelegatingGlobalSearchScope(ES6CreateImportUtil.createSymbolToImportSearchScope(project, (PsiElement)element.getContainingFile())){

            public boolean contains(@NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!super.contains(file)) {
                    return false;
                }
                JSLanguageDialect dialect = DialectDetector.getLanguageDialect(file, project);
                if (dialect == null) {
                    return false;
                }
                DialectOptionHolder holder = dialect.getOptionHolder();
                if (holder.isJSX) {
                    return true;
                }
                return holder.isTypeScript && TypeScriptUtil.isDefinitionFile(file);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/frameworks/react/ReactComponentCompletionContributor$1", "contains"));
            }
        };
        if (delegatingGlobalSearchScope == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(8);
        }
        return delegatingGlobalSearchScope;
    }

    private static void processExportedElementsForKey(Project project, String key, GlobalSearchScope scope, Processor<JSElement> processor) {
        StubIndex.getInstance().processElements(JSExportedMembersIndex.KEY, (Object)key, project, scope, JSElement.class, processor);
    }

    private static void addLocalVariants(final @NotNull CompletionResultSet result, @NotNull XmlTag tag, final Set<String> collectedNames, final boolean isStrict) {
        if (result == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(9);
        }
        if (tag == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(10);
        }
        JSReferenceExpressionImpl.doProcessLocalDeclarations((PsiElement)tag, null, new ResolveProcessor(null, (PsiElement)tag){

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (JSCorePredefinedLibrariesProvider.getAllJSPredefinedLibraryFiles().contains(element.getContainingFile().getVirtualFile())) {
                    return false;
                }
                Collection<PsiElement> elementsByImport = ReactXmlExtension.getElementsByImport(element);
                for (PsiElement candidate : elementsByImport) {
                    boolean isComponent;
                    String name = ReactXmlExtension.getEffectiveName(element, candidate);
                    if (name == null || !ReactXmlExtension.isComponentName(name) || collectedNames.contains(name)) continue;
                    if (isStrict) {
                        isComponent = ReactXmlExtension.isReactComponent(candidate);
                        if (!isComponent && ReactXmlExtension.isPossibleReactComponent(candidate)) {
                            collectedNames.add(name);
                        }
                    } else {
                        isComponent = ReactXmlExtension.isPossibleReactComponent(candidate);
                    }
                    if (!isComponent) continue;
                    ReactComponentCompletionContributor.addLookupElement(candidate, name, result);
                    collectedNames.add(name);
                    break;
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/frameworks/react/ReactComponentCompletionContributor$2";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, false, true, null);
    }

    private static void addLookupElement(PsiElement candidate, String name, CompletionResultSet result) {
        LookupElementBuilder lookup = ReactComponentCompletionContributor.createLookup(name, candidate);
        result.addElement((LookupElement)lookup);
    }

    private static void addComponentWithImportInsertHandler(@NotNull CompletionResultSet result, @NotNull XmlTag tag, boolean isTypeScript, @NotNull PsiElement el) {
        if (result == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(11);
        }
        if (tag == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(12);
        }
        if (el == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(13);
        }
        boolean isCandidateTypeScript = DialectDetector.isTypeScript(el);
        if (isTypeScript && !isCandidateTypeScript) {
            return;
        }
        JSQualifiedNamedElement element = (JSQualifiedNamedElement)el;
        String qualifiedName = element.getQualifiedName();
        if (qualifiedName == null) {
            return;
        }
        String name = element.getName();
        ReactComponentCompletionContributor.addLookupItemWithImportInsertHandler(result, (PsiElement)element, name, tag);
    }

    private static void addLookupItemWithImportInsertHandler(@NotNull CompletionResultSet result, @NotNull PsiElement candidate, String name, XmlTag tag) {
        if (result == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(14);
        }
        if (candidate == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(15);
        }
        if (!ES6CreateImportUtil.isAvailableForImport(candidate, (PsiElement)tag)) {
            return;
        }
        LookupElementBuilder lookup = ReactComponentCompletionContributor.createLookup(name, null);
        lookup = lookup.withInsertHandler((InsertHandler)new InsertHandler<LookupElement>(){

            public void handleInsert(InsertionContext context, LookupElement item) {
                PsiFile originalFile = context.getFile();
                PsiElement originalElement = originalFile.findElementAt(context.getStartOffset());
                if (originalElement != null) {
                    ES6ImportCompletionUtil.insertLookupItem(context, item, (Consumer<JSElement>)((Consumer)el -> {
                        if (el != null) {
                            PsiDocumentManager.getInstance((Project)context.getProject()).commitDocument(context.getDocument());
                            PsiDocumentManager.getInstance((Project)context.getProject()).doPostponedOperationsAndUnblockDocument(context.getDocument());
                            XmlTagInsertHandler.INSTANCE.handleInsert(context, item);
                        }
                    }));
                }
            }
        });
        result.addElement((LookupElement)lookup);
    }

    private static LookupElementBuilder createLookup(@NotNull String name, @Nullable PsiElement candidate) {
        if (name == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(16);
        }
        ItemPresentation presentation = candidate instanceof JSNamedElement ? ((JSNamedElement)candidate).getPresentation() : null;
        LookupElementBuilder lookup = (candidate == null ? LookupElementBuilder.create((String)name) : LookupElementBuilder.create((Object)candidate, (String)name)).withTypeText(presentation != null ? presentation.getLocationString() : null, true).withIcon(JavaScriptLanguageIcons.Logos.Jsx_16);
        lookup = lookup.withInsertHandler((InsertHandler)XmlTagInsertHandler.INSTANCE);
        return lookup;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 9: 
            case 11: 
            case 14: 
            case 17: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 12: 
            case 18: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 4: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/frameworks/react/ReactComponentCompletionContributor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "el";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSubstitutor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/frameworks/react/ReactComponentCompletionContributor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fillCompletionVariants";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addExportedComponents";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addClassesWithCheckHierarchy";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createScope";
                break;
            }
            case 8: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addLocalVariants";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addComponentWithImportInsertHandler";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addLookupItemWithImportInsertHandler";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createLookup";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addClassesWithCheckHierarchy$2";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addExportedComponents$1";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "lambda$fillCompletionVariants$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

