/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.react;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.dialects.JSXHarmonyLanguageDialect;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.frameworks.react.JSXPropTypesUtil;
import com.intellij.lang.javascript.frameworks.react.ReactXmlExtension;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.impl.JSElementIndexingDataImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.types.JSFileElementType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReactFrameworkIndexingHandler
extends FrameworkIndexingHandler {
    public static final String REACT_COMPOSITE_COMPONENT = "ReactCompositeComponent";
    public static final String REACT_COMPONENT = "ReactComponent";
    public static final String PROPS = "props";
    public static final String WRAPPED_COMPONENT_NAME = "wrapped.component.name";
    public static final String PROP_TYPES = "propTypes";

    @Override
    public void processCallExpression(@NotNull JSCallExpression callExpression, @NotNull JSElementIndexingData outData) {
        if (callExpression == null) {
            ReactFrameworkIndexingHandler.$$$reportNull$$$0(0);
        }
        if (outData == null) {
            ReactFrameworkIndexingHandler.$$$reportNull$$$0(1);
        }
        if (callExpression.getContext() instanceof JSExportAssignment) {
            ReactFrameworkIndexingHandler.processExportAssignmentCall(callExpression, outData);
        }
        if (!JSXHarmonyLanguageDialect.isReactComponent((JSExpression)callExpression)) {
            return;
        }
        ReactFrameworkIndexingHandler.addClassFromVariable(callExpression, outData);
    }

    private static void processExportAssignmentCall(@NotNull JSCallExpression callExpression, @NotNull JSElementIndexingData outData) {
        JSExpression[] arguments;
        if (callExpression == null) {
            ReactFrameworkIndexingHandler.$$$reportNull$$$0(2);
        }
        if (outData == null) {
            ReactFrameworkIndexingHandler.$$$reportNull$$$0(3);
        }
        for (JSExpression argument : arguments = callExpression.getArguments()) {
            String name;
            JSReferenceExpression ref;
            JSExpression qualifier;
            if (!(argument instanceof JSReferenceExpression) || (qualifier = (ref = (JSReferenceExpression)argument).getQualifier()) != null || !ReactXmlExtension.isComponentName(name = ref.getReferenceName())) continue;
            outData.putUserString(WRAPPED_COMPONENT_NAME, name);
        }
    }

    private static void addClassFromVariable(JSCallExpression callExpression, @NotNull JSElementIndexingData outData) {
        JSQualifiedNamedElement variable;
        if (outData == null) {
            ReactFrameworkIndexingHandler.$$$reportNull$$$0(4);
        }
        if ((variable = (JSQualifiedNamedElement)PsiTreeUtil.getParentOfType((PsiElement)callExpression, JSVariable.class)) == null) {
            JSAssignmentExpression assignment = (JSAssignmentExpression)PsiTreeUtil.getParentOfType((PsiElement)callExpression, JSAssignmentExpression.class);
            JSDefinitionExpression jSDefinitionExpression = variable = assignment != null ? assignment.getDefinitionExpression() : null;
        }
        if (variable != null) {
            String name = variable.getName();
            if (name == null) {
                return;
            }
            if (JSDocumentationUtils.isClassOrInterface(variable) == JSElementBase.ClassOrInterface.NONE) {
                JSImplicitElementImpl.Builder clazz = new JSImplicitElementImpl.Builder(name, (PsiElement)callExpression).setNamespace(variable.getNamespace()).setType(JSImplicitElement.Type.Class).setTypeString(REACT_COMPOSITE_COMPONENT);
                outData.addImplicitElement((JSImplicitElement)clazz.toImplicitElement());
            }
        }
    }

    @Override
    public void addContextNames(PsiElement context, List<String> names) {
        if (context == null) {
            return;
        }
        JSCallExpression call = (JSCallExpression)PsiTreeUtil.getParentOfType((PsiElement)context, JSCallExpression.class);
        if (call != null && JSXHarmonyLanguageDialect.isReactComponent((JSExpression)call)) {
            names.add(REACT_COMPONENT);
        }
        if (this.hasPropTypes(context)) {
            names.add(REACT_COMPONENT);
        }
    }

    @Override
    @Nullable
    public JSElementIndexingData processAnyProperty(@NotNull JSProperty property, @Nullable JSElementIndexingData outData) {
        boolean isPropTypesNamespace;
        if (property == null) {
            ReactFrameworkIndexingHandler.$$$reportNull$$$0(5);
        }
        JSQualifiedName namespace = property.getNamespace();
        String name = property.getName();
        if (name == null) {
            return outData;
        }
        boolean bl = isPropTypesNamespace = namespace != null && PROP_TYPES.equals(namespace.getName());
        if (isPropTypesNamespace || ReactFrameworkIndexingHandler.shouldCreateImplicitElement(property)) {
            JSQualifiedName parent;
            JSQualifiedName jSQualifiedName = parent = isPropTypesNamespace ? namespace.getParent() : null;
            if (outData == null) {
                outData = new JSElementIndexingDataImpl();
            }
            JSQualifiedNameImpl props = JSQualifiedNameImpl.create(PROPS, parent);
            JSQualifiedNameImpl prop = JSQualifiedNameImpl.create(name, props);
            JSImplicitElementImpl element = JSXPropTypesUtil.createImplicitReactPropsElement(property, prop);
            outData.addImplicitElement((JSImplicitElement)element);
            PsiElement object = property.getParent();
            if (isPropTypesNamespace && object instanceof JSObjectLiteralExpression && ((JSObjectLiteralExpression)object).getFirstProperty() == property) {
                JSImplicitElementImpl.Builder propsBuilder = new JSImplicitElementImpl.Builder(props, (PsiElement)property).setNamespace(parent).setTypeString(props.getQualifiedName()).setType(JSImplicitElement.Type.Property);
                outData.addImplicitElement((JSImplicitElement)propsBuilder.toImplicitElement());
            }
        }
        return outData;
    }

    private static boolean shouldCreateImplicitElement(@NotNull JSProperty property) {
        JSExpression value;
        if (property == null) {
            ReactFrameworkIndexingHandler.$$$reportNull$$$0(6);
        }
        if ((value = property.getValue()) instanceof JSReferenceExpression) {
            JSExpression qualifier = ((JSReferenceExpression)value).getQualifier();
            while (qualifier instanceof JSReferenceExpression) {
                if ("PropTypes".equals(((JSReferenceExpression)qualifier).getReferenceName())) {
                    return true;
                }
                qualifier = ((JSReferenceExpression)qualifier).getQualifier();
            }
        }
        return false;
    }

    @Override
    public boolean addTypeFromResolveResult(JSTypeEvaluator evaluator, PsiElement result, boolean hasSomeType) {
        if (result instanceof JSParameter && PROPS.equals(((JSParameter)result).getName()) && DialectDetector.isJSX(result) && !DialectDetector.isTypeScript(result)) {
            String qualifiedName;
            JSFunction function = ((JSParameter)result).getDeclaringFunction();
            String string = qualifiedName = function != null ? function.getQualifiedName() : null;
            if (function != null && ReactXmlExtension.isComponentName(function.getName())) {
                JSTypeSource source = JSTypeSourceFactory.createTypeSource(result);
                JSType type = JSNamedType.createType(qualifiedName + "." + PROPS, source, JSContext.INSTANCE);
                evaluator.addType(type, result);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean shouldCreateStubForCallExpression(ASTNode node) {
        IElementType type;
        ASTNode treeParent;
        ASTNode parent = node.getTreeParent();
        if (parent.getElementType() == ES6ElementTypes.EXPORT_DEFAULT_ASSIGNMENT && (treeParent = parent.getTreeParent()) != null && (type = treeParent.getElementType()) instanceof JSFileElementType) {
            Language language = type.getLanguage();
            return language == JavaScriptSupportLoader.TYPESCRIPT_JSX || language.isKindOf((Language)JavaScriptSupportLoader.JSX_HARMONY);
        }
        return super.shouldCreateStubForCallExpression(node);
    }

    @Override
    public int getVersion() {
        return 7;
    }

    protected boolean hasPropTypes(PsiElement context) {
        JSClass clazz = DialectDetector.isES6(context) ? (JSClass)PsiTreeUtil.getParentOfType((PsiElement)context, JSClass.class) : null;
        GlobalSearchScope scope = JSResolveUtil.getResolveScope(context);
        String name = clazz != null ? clazz.getQualifiedName() + ".propTypes" : null;
        List propTypes = name != null ? JSClassResolver.getInstance().findElementsByQNameIncludingImplicit(name, scope) : Collections.emptyList();
        return !propTypes.isEmpty();
    }

    static {
        JSImplicitElement.ourUserStringsRegistry.registerUserString("r");
        JSElementIndexingData.ourUserStringKeysRegisty.registerUserString(WRAPPED_COMPONENT_NAME);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outData";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/frameworks/react/ReactFrameworkIndexingHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processCallExpression";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "processExportAssignmentCall";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addClassFromVariable";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "processAnyProperty";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldCreateImplicitElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

