/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.react.tsx;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.ecmascript6.TypeScriptImportHandler;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.frameworks.react.ReactXmlExtension;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptReactComponentUtil {
    public static final String ELEMENT_CLASS_NAME = "ElementClass";
    public static final Set<String> REACT_COMPONENT_NAMES = ContainerUtil.newHashSet((Object[])new String[]{"Component", "PureComponent"});
    public static final String PROPS_FIELD_NAME = "props";

    @NotNull
    public static Collection<JSClass> resolveComponent(@NotNull XmlTag tag) {
        if (tag == null) {
            TypeScriptReactComponentUtil.$$$reportNull$$$0(0);
        }
        JSTypeResolveResult result = TypeScriptImportHandler.getInstance().resolveName(tag.getName(), (PsiElement)tag);
        ArrayList toReturn = ContainerUtil.newArrayList();
        for (PsiElement psiElement : result.getElements()) {
            JSClass jsClass;
            if (!(psiElement instanceof JSClass) || (jsClass = (JSClass)psiElement).isInterface()) continue;
            toReturn.add(jsClass);
        }
        ArrayList arrayList = toReturn;
        if (arrayList == null) {
            TypeScriptReactComponentUtil.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    public static JSType getGenericPropType(XmlTag tag) {
        if (!DialectDetector.isTypeScript((PsiElement)tag)) {
            return null;
        }
        PsiReference reference = tag.getReference();
        if (reference == null) {
            return null;
        }
        PsiElement resolveCandidate = reference.resolve();
        Collection<PsiElement> elements = ReactXmlExtension.getElementsByImport(resolveCandidate, false);
        for (PsiElement resolve : elements) {
            JSType result;
            Collection<PsiElement> items;
            boolean forceOptional = false;
            if (resolve instanceof JSCallExpression && (items = ReactXmlExtension.resolveCallExpression((JSCallExpression)resolve)).size() == 1) {
                resolve = (PsiElement)ContainerUtil.getFirstItem(items);
                forceOptional = true;
            }
            if ((result = TypeScriptReactComponentUtil.getTypeFromPsiElement(resolve)) == null) continue;
            return forceOptional ? result.copyWithStrict(false) : result;
        }
        return null;
    }

    @Nullable
    private static JSType getTypeFromPsiElement(PsiElement resolve) {
        JSParameterListElement[] parameters;
        if (resolve instanceof JSVariable) {
            resolve = ((JSVariable)resolve).tryGetFunctionExpressionInitializer();
        }
        if (resolve instanceof JSClass) {
            Pair<JSClass, JSType> type = TypeScriptReactComponentUtil.getPropsType((JSClass)resolve);
            if (type != null && type.second != null) {
                return TypeScriptUtil.applyGenericsToType((JSType)type.second, (JSClass)resolve, (JSClass)type.first);
            }
        } else if (resolve instanceof JSFunction && (parameters = ((JSFunction)resolve).getParameters()).length == 1) {
            return parameters[0].getType();
        }
        return null;
    }

    @Nullable
    public static Pair<JSClass, JSType> getPropsType(@NotNull JSClass componentClass) {
        if (componentClass == null) {
            TypeScriptReactComponentUtil.$$$reportNull$$$0(2);
        }
        for (JSClass<?> aClass : TypeScriptUtil.getNonStrictParents(componentClass, false)) {
            JSField props = aClass.findFieldByName(PROPS_FIELD_NAME);
            if (!REACT_COMPONENT_NAMES.contains(aClass.getName()) || props == null) continue;
            return Pair.create(aClass, (Object)props.getType());
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/frameworks/react/tsx/TypeScriptReactComponentUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/frameworks/react/tsx/TypeScriptReactComponentUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolveComponent";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPropsType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

