/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.highlighting;

import com.intellij.lang.javascript.ActionScriptFileType;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public class JSProblemFileHighlightFilter
implements Condition<VirtualFile> {
    private final Project myProject;

    public JSProblemFileHighlightFilter(@NotNull Project project) {
        if (project == null) {
            JSProblemFileHighlightFilter.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    public boolean value(@NotNull VirtualFile file) {
        if (file == null) {
            JSProblemFileHighlightFilter.$$$reportNull$$$0(1);
        }
        if (file.isDirectory()) {
            return false;
        }
        FileType fileType = file.getFileType();
        if (fileType == ActionScriptFileType.INSTANCE || JavaScriptSupportLoader.isMxmlOrFxgFile(file)) {
            return ProjectFileIndex.getInstance((Project)this.myProject).isInSource(file);
        }
        if (DialectDetector.JAVASCRIPT_FILE_TYPES.contains(fileType) || TypeScriptUtil.TYPESCRIPT_FILE_TYPES.contains(fileType)) {
            ProjectFileIndex index = ProjectFileIndex.getInstance((Project)this.myProject);
            return !index.isExcluded(file) && !index.isInLibrary(file);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/highlighting/JSProblemFileHighlightFilter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "value";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

