/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.highlighting;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.ecmascript6.psi.ES6Property;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.highlighting.DefaultJSTextAttributeKeysProvider;
import com.intellij.lang.javascript.highlighting.ECMAL4Highlighter;
import com.intellij.lang.javascript.highlighting.JSHighlighter;
import com.intellij.lang.javascript.highlighting.JSTextAttributeKeysProvider;
import com.intellij.lang.javascript.highlighting.TypeScriptHighlighter;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSLabeledStatement;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiReferenceElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatementWithLabelReference;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunctionSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptGenericOrMappedTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptIndexSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecmal4.JSAttribute;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.ImplicitJSVariableImpl;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.validation.JSKeywordHighlighterVisitor;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import gnu.trove.TObjectIntHashMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSSemanticHighlightingUtil {
    @NonNls
    public static final String INSTANCE_FIELD = "instance field";
    @NonNls
    public static final String INSTANCE_METHOD = "instance method";
    @NonNls
    public static final String PARAMETER_MESSAGE = "parameter";
    private static boolean debug = ApplicationManager.getApplication().isUnitTestMode();

    private JSSemanticHighlightingUtil() {
    }

    private static boolean isClassContext(PsiElement element) {
        if (element == null) {
            return false;
        }
        PsiElement context = element.getContext();
        if (context instanceof JSClass) {
            return true;
        }
        return context instanceof JSFile && context.getContext() != null;
    }

    private static boolean isTypeScriptInterfaceReference(PsiElement element) {
        return element instanceof TypeScriptObjectType && JSSemanticHighlightingUtil.isClassContext(element);
    }

    private static JSTextAttributeKeysProvider getTextAttributeKeysProvider(PsiElement element) {
        Language lang;
        JSTextAttributeKeysProvider attributeKeysProvider;
        JSTextAttributeKeysProvider result = DefaultJSTextAttributeKeysProvider.getInstance();
        if (element != null && (attributeKeysProvider = (JSTextAttributeKeysProvider)JSTextAttributeKeysProvider.INSTANCE.forLanguage(lang = DialectDetector.languageOfElement(element))) != null) {
            result = attributeKeysProvider;
        }
        return result;
    }

    public static void highlight(JSPsiReferenceElement node, JSHighlighter highlighter, AnnotationHolder holder) {
        TextAttributeKeyInfo info;
        if (node instanceof JSReferenceExpression && ((JSReferenceExpression)node).getQualifier() == null && node.getNode().findChildByType(JSDocumentationUtils.ourPrimitiveTypeFilter) != null && JSResolveUtil.isExprInTypeContext((JSReferenceExpression)node)) {
            return;
        }
        ResolveResult[] results = node.multiResolve(false);
        if (results.length == 0) {
            return;
        }
        if (results == JSResolveResult.TOO_MANY_CANDIDATES && node instanceof JSReferenceExpression) {
            TextAttributeKeyInfo info2 = JSSemanticHighlightingUtil.guessHighlightingForReference((JSReferenceExpression)node, highlighter);
            JSSemanticHighlightingUtil.lineMarker((PsiElement)node, info2.type, info2.text, holder);
            return;
        }
        if (JSSemanticHighlightingUtil.isGlobalUndefined(node, results)) {
            JSKeywordHighlighterVisitor.highlightKeyword(node.getNode(), holder);
            return;
        }
        if (JSSemanticHighlightingUtil.isActionScriptClass(highlighter, results) && (info = JSSemanticHighlightingUtil.buildHighlightForResolveResult(results[0].getElement(), (PsiElement)node, highlighter)) != null) {
            ASTNode genericSignature = node.getNode().findChildByType(JSElementTypes.GENERIC_SIGNATURE);
            JSSemanticHighlightingUtil.justLineMarker((PsiElement)(genericSignature == null ? node : node.getReferenceNameElement()), info.getType(), info.getText(), holder);
            return;
        }
        TObjectIntHashMap countByTypes = new TObjectIntHashMap();
        boolean tsdOccurred = false;
        for (ResolveResult r : results) {
            TextAttributeKeyInfo info3;
            boolean isFromTsd;
            PsiElement resolve = r.getElement();
            if (resolve == null) continue;
            PsiFile file = resolve.getContainingFile();
            boolean bl = isFromTsd = file != null && DialectDetector.isTypeScriptDefinitionFile(resolve.getContainingFile());
            if (isFromTsd && !tsdOccurred) {
                tsdOccurred = true;
                countByTypes = new TObjectIntHashMap();
            }
            if (tsdOccurred && !isFromTsd || (info3 = JSSemanticHighlightingUtil.buildHighlightForResolveResult(resolve, (PsiElement)node, highlighter)) == null) continue;
            countByTypes.put((Object)info3, countByTypes.get((Object)info3) + 1);
        }
        Ref maxCount = Ref.create((Object)0);
        Ref info4 = Ref.create(null);
        countByTypes.forEachEntry((key, count) -> {
            if (count > (Integer)maxCount.get()) {
                maxCount.set((Object)count);
                info4.set(key);
            } else if (count == (Integer)maxCount.get() && ((TextAttributeKeyInfo)info4.get()).text.compareTo(((TextAttributeKeyInfo)key).text) > 0) {
                info4.set(key);
            }
            return true;
        });
        if (info4.get() != null) {
            JSSemanticHighlightingUtil.lineMarker((PsiElement)node, ((TextAttributeKeyInfo)info4.get()).type, ((TextAttributeKeyInfo)info4.get()).text, holder);
        }
    }

    private static boolean isGlobalUndefined(@NotNull JSPsiReferenceElement node, @NotNull ResolveResult[] results) {
        if (node == null) {
            JSSemanticHighlightingUtil.$$$reportNull$$$0(0);
        }
        if (results == null) {
            JSSemanticHighlightingUtil.$$$reportNull$$$0(1);
        }
        return results.length == 1 && results[0].getElement() == node && "undefined".equals(node.getReferenceName());
    }

    private static boolean isActionScriptClass(@NotNull JSHighlighter highlighter, @NotNull ResolveResult[] results) {
        if (highlighter == null) {
            JSSemanticHighlightingUtil.$$$reportNull$$$0(2);
        }
        if (results == null) {
            JSSemanticHighlightingUtil.$$$reportNull$$$0(3);
        }
        return results.length == 1 && highlighter.getDialectOptionsHolder() == DialectOptionHolder.ECMA_4 && results[0].getElement() instanceof JSClass;
    }

    @NotNull
    private static TextAttributeKeyInfo guessHighlightingForReference(@NotNull JSReferenceExpression referenceExpression, JSHighlighter highlighter) {
        boolean isGlobal;
        PsiElement parent;
        if (referenceExpression == null) {
            JSSemanticHighlightingUtil.$$$reportNull$$$0(4);
        }
        boolean isMethod = (parent = referenceExpression.getParent()) instanceof JSCallExpression && ((JSCallExpression)parent).getMethodExpression() == referenceExpression;
        boolean bl = isGlobal = referenceExpression.getQualifier() == null;
        if (isMethod) {
            TextAttributeKeyInfo textAttributeKeyInfo = isGlobal ? TextAttributeKeyInfo.globalFunction(highlighter) : TextAttributeKeyInfo.instanceMethod(highlighter, (PsiElement)referenceExpression);
            if (textAttributeKeyInfo == null) {
                JSSemanticHighlightingUtil.$$$reportNull$$$0(5);
            }
            return textAttributeKeyInfo;
        }
        TextAttributeKeyInfo textAttributeKeyInfo = isGlobal ? TextAttributeKeyInfo.globalVariable(highlighter, JSSemanticHighlightingUtil.getTextAttributeKeysProvider((PsiElement)referenceExpression)) : TextAttributeKeyInfo.instanceMemberVariable(highlighter);
        if (textAttributeKeyInfo == null) {
            JSSemanticHighlightingUtil.$$$reportNull$$$0(6);
        }
        return textAttributeKeyInfo;
    }

    public static void highlight(@NotNull PsiElement place, @NotNull PsiElement resolve, JSHighlighter highlighter, AnnotationHolder holder) {
        TextAttributeKeyInfo info;
        if (place == null) {
            JSSemanticHighlightingUtil.$$$reportNull$$$0(7);
        }
        if (resolve == null) {
            JSSemanticHighlightingUtil.$$$reportNull$$$0(8);
        }
        if ((info = JSSemanticHighlightingUtil.buildHighlightForResolveResult(resolve, place, highlighter)) != null) {
            JSSemanticHighlightingUtil.lineMarker(place, info.type, info.text, holder);
        }
    }

    @Nullable
    private static TextAttributeKeyInfo buildHighlightForResolveResult(@NotNull PsiElement resolve, @NotNull PsiElement place, JSHighlighter highlighter) {
        PsiElement targetElement;
        TextAttributeKeyInfo targetElementInfo;
        if (resolve == null) {
            JSSemanticHighlightingUtil.$$$reportNull$$$0(9);
        }
        if (place == null) {
            JSSemanticHighlightingUtil.$$$reportNull$$$0(10);
        }
        return (targetElementInfo = JSSemanticHighlightingUtil.buildHighlightForElement(targetElement = JSSemanticHighlightingUtil.calculateMeaningfulElementForHighlighting(resolve), place, highlighter)) != null ? targetElementInfo : JSSemanticHighlightingUtil.buildHighlightForElement(resolve, place, highlighter);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static TextAttributeKeyInfo buildHighlightForElement(@NotNull PsiElement resolve, @NotNull PsiElement place, JSHighlighter highlighter) {
        if (resolve == null) {
            JSSemanticHighlightingUtil.$$$reportNull$$$0(11);
        }
        if (place == null) {
            JSSemanticHighlightingUtil.$$$reportNull$$$0(12);
        }
        boolean isStatic = false;
        boolean isMethod = false;
        boolean isFunction = false;
        boolean isField = false;
        TextAttributeKeyInfo info = null;
        JSTextAttributeKeysProvider attributesKeyProvider = JSSemanticHighlightingUtil.getTextAttributeKeysProvider(place);
        if (resolve instanceof JSImplicitElement) {
            JSImplicitElement implicitElement = (JSImplicitElement)resolve;
            JSImplicitElement.Type type = implicitElement.getType();
            switch (type) {
                case Class: {
                    return JSSemanticHighlightingUtil.buildHighlightForClass(place, false, highlighter);
                }
                case Interface: {
                    return JSSemanticHighlightingUtil.buildHighlightForClass(place, true, highlighter);
                }
                case Function: {
                    if (implicitElement.getNamespace() == null) {
                        isFunction = true;
                    } else {
                        isMethod = true;
                    }
                    isStatic = implicitElement.getJSContext() == JSContext.STATIC;
                    break;
                }
                case Namespace: {
                    info = TextAttributeKeyInfo.globalVariable(highlighter, attributesKeyProvider);
                    break;
                }
                case Variable: {
                    if (implicitElement.getNamespace() == null && implicitElement.isNamespaceExplicitlyDeclared()) {
                        info = TextAttributeKeyInfo.globalVariable(highlighter, attributesKeyProvider);
                        break;
                    }
                }
                case Property: 
                case Tag: {
                    isField = true;
                    isStatic = implicitElement.getJSContext() == JSContext.STATIC;
                }
            }
        } else {
            if (resolve instanceof JSProperty) {
                return JSSemanticHighlightingUtil.buildHighlightForProperty((JSProperty)resolve, place, highlighter);
            }
            if (resolve instanceof JSAttributeListOwner) {
                if (resolve instanceof JSVariable) {
                    return JSSemanticHighlightingUtil.buildHighlightForVariable((JSVariable)resolve, place, highlighter);
                }
                if (resolve instanceof JSClass) {
                    return JSSemanticHighlightingUtil.buildHighlightForClass(place, ((JSClass)resolve).isInterface(), highlighter);
                }
                JSAttributeList attributeList = ((JSAttributeListOwner)resolve).getAttributeList();
                if (attributeList != null) {
                    isStatic = attributeList.hasModifier(JSAttributeList.ModifierType.STATIC);
                }
                DialectOptionHolder dialect = DialectDetector.dialectOfFile(resolve.getContainingFile());
                boolean bl = isMethod = resolve instanceof JSFunction && (!((JSFunction)resolve).isConstructor() || dialect != null && dialect.isJavaScript());
                if (isMethod && !JSSemanticHighlightingUtil.isClassContext(resolve) && !JSSemanticHighlightingUtil.isTypeScriptInterfaceReference(resolve.getContext())) {
                    isMethod = false;
                    isFunction = true;
                }
                if (JSResolveUtil.isConstructorFunction(resolve)) {
                    if (place != resolve) return JSSemanticHighlightingUtil.buildHighlightForClass(place, false, highlighter);
                    if (!"constructor".equals(((JSAttributeListOwner)resolve).getName())) return JSSemanticHighlightingUtil.buildHighlightForClass(place, false, highlighter);
                    info = TextAttributeKeyInfo.constructor(highlighter);
                }
            } else if (resolve instanceof JSDefinitionExpression) {
                if (JSPsiImplUtils.calculatePossibleFunction(resolve, place) != null) {
                    isMethod = true;
                } else {
                    isField = true;
                }
            }
        }
        if (isMethod) {
            info = isStatic ? TextAttributeKeyInfo.staticMethod(highlighter) : TextAttributeKeyInfo.instanceMethod(highlighter, place);
        } else if (isFunction) {
            info = TextAttributeKeyInfo.globalFunction(highlighter);
        } else if (isField) {
            info = TextAttributeKeyInfo.field(highlighter, attributesKeyProvider);
        }
        if (info != null) return info;
        return attributesKeyProvider.getTextAttributeKeyInfoForResolveResult(resolve, highlighter);
    }

    @NotNull
    private static TextAttributeKeyInfo buildHighlightForClass(@NotNull PsiElement place, boolean isInterface, JSHighlighter highlighter) {
        if (place == null) {
            JSSemanticHighlightingUtil.$$$reportNull$$$0(13);
        }
        TextAttributesKey type = highlighter.getMappedKey(isInterface ? JSHighlighter.JS_INTERFACE : JSSemanticHighlightingUtil.getTextAttributeKeysProvider(place).getTextAttributesKeyForClass());
        TextAttributeKeyInfo textAttributeKeyInfo = new TextAttributeKeyInfo(type, isInterface ? "interface" : "class");
        if (textAttributeKeyInfo == null) {
            JSSemanticHighlightingUtil.$$$reportNull$$$0(14);
        }
        return textAttributeKeyInfo;
    }

    @Nullable
    private static TextAttributeKeyInfo buildHighlightForVariable(@NotNull JSVariable element, @NotNull PsiElement place, JSHighlighter highlighter) {
        if (element == null) {
            JSSemanticHighlightingUtil.$$$reportNull$$$0(15);
        }
        if (place == null) {
            JSSemanticHighlightingUtil.$$$reportNull$$$0(16);
        }
        JSTextAttributeKeysProvider attributesKeyProvider = JSSemanticHighlightingUtil.getTextAttributeKeysProvider(place);
        if (element instanceof JSParameter && !TypeScriptPsiUtil.isFieldParameter((JSParameter)element)) {
            return TextAttributeKeyInfo.parameter(highlighter, attributesKeyProvider);
        }
        if (element.tryGetFunctionExpressionInitializer() != null) {
            return TextAttributeKeyInfo.globalFunction(highlighter);
        }
        if (JSSemanticHighlightingUtil.isClassContext(element.getContext()) || element.getNamespace() != null || JSSemanticHighlightingUtil.isTypeScriptFieldParameter((JSFieldVariable)element)) {
            boolean isStatic = element.getJSContext() == JSContext.STATIC;
            return isStatic ? TextAttributeKeyInfo.staticMemberVariable(highlighter) : TextAttributeKeyInfo.instanceMemberVariable(highlighter);
        }
        boolean localVariable = false;
        if (element instanceof ImplicitJSVariableImpl) {
            JSType type = element.getType();
            if (type != null && "Arguments".equals(type.getTypeText())) {
                localVariable = true;
            }
        } else {
            JSElement node = JSPsiImplUtils.getScopeNode((JSNamedElement)element);
            boolean bl = localVariable = node instanceof JSFunction || node instanceof JSFile && ((JSFile)node).isCommonJSModule();
        }
        if (localVariable) {
            return TextAttributeKeyInfo.localVariable(highlighter, attributesKeyProvider);
        }
        return TextAttributeKeyInfo.globalVariable(highlighter, attributesKeyProvider);
    }

    private static boolean isTypeScriptFieldParameter(@NotNull JSFieldVariable element) {
        if (element == null) {
            JSSemanticHighlightingUtil.$$$reportNull$$$0(17);
        }
        return element instanceof JSParameter && TypeScriptPsiUtil.isFieldParameter((JSParameter)element);
    }

    public static void highlight(JSAttribute attribute, AnnotationHolder holder) {
        JSSemanticHighlightingUtil.lineMarker((PsiElement)attribute, ECMAL4Highlighter.ECMAL4_METADATA, "attribute", holder);
    }

    public static void highlight(JSLabeledStatement labeledStatement, JSHighlighter highlighter, AnnotationHolder holder) {
        PsiElement labelIdentifier = labeledStatement.getLabelIdentifier();
        if (labelIdentifier != null) {
            JSSemanticHighlightingUtil.lineMarker(labelIdentifier, highlighter.getMappedKey(JSHighlighter.JS_LABEL), "label", holder);
        }
    }

    public static void highlight(JSStatementWithLabelReference labeledStatement, JSHighlighter highlighter, AnnotationHolder holder) {
        PsiElement labelIdentifier = labeledStatement.getLabelIdentifier();
        if (labelIdentifier != null) {
            JSSemanticHighlightingUtil.lineMarker(labelIdentifier, highlighter.getMappedKey(JSHighlighter.JS_LABEL), "label", holder);
        }
    }

    private static void lineMarker(@NotNull PsiElement element, TextAttributesKey attrKey, String debugName, AnnotationHolder holder) {
        if (element == null) {
            JSSemanticHighlightingUtil.$$$reportNull$$$0(18);
        }
        if (attrKey == null) {
            return;
        }
        PsiElement markedNode = element.getLastChild();
        if (markedNode == null) {
            markedNode = element;
        }
        while (markedNode.getNode().getElementType() != JSTokenTypes.IDENTIFIER && markedNode.getPrevSibling() != null) {
            markedNode = markedNode.getPrevSibling();
        }
        if (element instanceof JSAttribute) {
            markedNode = element;
        } else if (element instanceof JSNamedElement) {
            PsiElement nameElement = ((JSNamedElement)element).getNameIdentifier();
            if (nameElement != null) {
                markedNode = nameElement;
            } else if (element instanceof ES6Property) {
                markedNode = null;
            }
        }
        if (markedNode == null) {
            return;
        }
        JSSemanticHighlightingUtil.justLineMarker(markedNode, attrKey, debugName, holder);
    }

    private static void justLineMarker(PsiElement markedNode, TextAttributesKey attrKey, String debugName, AnnotationHolder holder) {
        holder.createInfoAnnotation(markedNode, debug ? debugName : null).setTextAttributes(attrKey);
    }

    public static void highlight(JSProperty node, JSHighlighter highlighter, AnnotationHolder holder) {
        if (node instanceof ES6Property && ((ES6Property)node).isShorthanded()) {
            return;
        }
        TextAttributeKeyInfo info = JSSemanticHighlightingUtil.buildHighlightForProperty(node, (PsiElement)node, highlighter);
        JSSemanticHighlightingUtil.lineMarker((PsiElement)node, info.getType(), info.getText(), holder);
    }

    private static TextAttributeKeyInfo buildHighlightForProperty(JSProperty node, PsiElement place, JSHighlighter highlighter) {
        if (JSPsiImplUtils.calculatePossibleFunction((PsiElement)node, place) != null) {
            return TextAttributeKeyInfo.instanceMethod(highlighter, place);
        }
        return TextAttributeKeyInfo.field(highlighter, JSSemanticHighlightingUtil.getTextAttributeKeysProvider(place));
    }

    public static void highlight(JSVariable node, JSHighlighter highlighter, AnnotationHolder holder) {
        PsiElement nameIdentifier;
        if (!(node instanceof JSParameter) && ((nameIdentifier = node.getNameIdentifier()) == null || nameIdentifier instanceof JSReferenceExpression)) {
            return;
        }
        TextAttributeKeyInfo info = JSSemanticHighlightingUtil.buildHighlightForResolveResult((PsiElement)node, (PsiElement)node, highlighter);
        if (info != null) {
            JSSemanticHighlightingUtil.lineMarker((PsiElement)node, info.getType(), info.getText(), holder);
        }
    }

    public static void highlight(TypeScriptPropertySignature signature, JSHighlighter highlighter, AnnotationHolder holder) {
        JSSemanticHighlightingUtil.lineMarker((PsiElement)signature, highlighter.getMappedKey(JSHighlighter.JS_INSTANCE_MEMBER_VARIABLE), "TypeScript property signature", holder);
    }

    public static void highlight(TypeScriptFunctionSignature signature, JSHighlighter highlighter, AnnotationHolder holder) {
        JSSemanticHighlightingUtil.lineMarker((PsiElement)signature, highlighter.getMappedKey(JSHighlighter.JS_INSTANCE_MEMBER_FUNCTION), "TypeScript function signature", holder);
    }

    public static void highlight(TypeScriptGenericOrMappedTypeParameter parameter, JSHighlighter highlighter, AnnotationHolder holder) {
        JSSemanticHighlightingUtil.lineMarker((PsiElement)parameter, highlighter.getMappedKey(TypeScriptHighlighter.TS_TYPE_PARAMETER), "TypeScript type parameter", holder);
    }

    public static void highlight(TypeScriptIndexSignature signature, JSHighlighter highlighter, AnnotationHolder holder) {
        PsiElement element = signature.getParameterNameElement();
        if (element != null) {
            JSSemanticHighlightingUtil.lineMarker(element, highlighter.getMappedKey(JSHighlighter.JS_INSTANCE_MEMBER_VARIABLE), "TypeScript function signature", holder);
        }
    }

    public static void highlight(@NotNull TypeScriptModule<?> module, JSHighlighter highlighter, AnnotationHolder holder) {
        if (module == null) {
            JSSemanticHighlightingUtil.$$$reportNull$$$0(19);
        }
        if (DialectDetector.isTypeScript(module)) {
            JSSemanticHighlightingUtil.lineMarker(module, highlighter.getMappedKey(TypeScriptHighlighter.TS_MODULE_NAME), "moduleName", holder);
        } else {
            JSSemanticHighlightingUtil.lineMarker(module, highlighter.getMappedKey(JSHighlighter.JS_MODULE_NAME), "moduleName", holder);
        }
    }

    @NotNull
    private static PsiElement calculateMeaningfulElementForHighlighting(@NotNull PsiElement element) {
        if (element == null) {
            JSSemanticHighlightingUtil.$$$reportNull$$$0(20);
        }
        PsiElement psiElement = JSStubBasedPsiTreeUtil.calculateTargetElementForHighlighting(element);
        if (psiElement == null) {
            JSSemanticHighlightingUtil.$$$reportNull$$$0(21);
        }
        return psiElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 14: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 14: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 5: 
            case 6: 
            case 14: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/highlighting/JSSemanticHighlightingUtil";
                break;
            }
            case 7: 
            case 10: 
            case 12: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolve";
                break;
            }
            case 15: 
            case 17: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/highlighting/JSSemanticHighlightingUtil";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "guessHighlightingForReference";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "buildHighlightForClass";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateMeaningfulElementForHighlighting";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isGlobalUndefined";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isActionScriptClass";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "guessHighlightingForReference";
                break;
            }
            case 5: 
            case 6: 
            case 14: 
            case 21: {
                break;
            }
            case 7: 
            case 8: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "highlight";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "buildHighlightForResolveResult";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "buildHighlightForElement";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "buildHighlightForClass";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "buildHighlightForVariable";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isTypeScriptFieldParameter";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lineMarker";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "calculateMeaningfulElementForHighlighting";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 14: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class TextAttributeKeyInfo {
        private final TextAttributesKey type;
        private final String text;

        public TextAttributeKeyInfo(@NotNull TextAttributesKey type, @NotNull String text) {
            if (type == null) {
                TextAttributeKeyInfo.$$$reportNull$$$0(0);
            }
            if (text == null) {
                TextAttributeKeyInfo.$$$reportNull$$$0(1);
            }
            this.type = type;
            this.text = text;
        }

        @NotNull
        public TextAttributesKey getType() {
            TextAttributesKey textAttributesKey = this.type;
            if (textAttributesKey == null) {
                TextAttributeKeyInfo.$$$reportNull$$$0(2);
            }
            return textAttributesKey;
        }

        @NotNull
        public String getText() {
            String string = this.text;
            if (string == null) {
                TextAttributeKeyInfo.$$$reportNull$$$0(3);
            }
            return string;
        }

        public static TextAttributeKeyInfo localVariable(JSHighlighter highlighter, JSTextAttributeKeysProvider provider) {
            return new TextAttributeKeyInfo(highlighter.getMappedKey(provider.getAttributesKeyForLocalVariable()), "local variable");
        }

        public static TextAttributeKeyInfo staticMemberVariable(JSHighlighter highlighter) {
            return new TextAttributeKeyInfo(highlighter.getMappedKey(JSHighlighter.JS_STATIC_MEMBER_VARIABLE), "static field");
        }

        public static TextAttributeKeyInfo parameter(JSHighlighter highlighter, JSTextAttributeKeysProvider provider) {
            return new TextAttributeKeyInfo(highlighter.getMappedKey(provider.getAttributesKeyForParameter()), JSSemanticHighlightingUtil.PARAMETER_MESSAGE);
        }

        public static TextAttributeKeyInfo field(JSHighlighter highlighter, JSTextAttributeKeysProvider provider) {
            return new TextAttributeKeyInfo(highlighter.getMappedKey(provider.getTextAttributesKeyForInstanceField()), JSSemanticHighlightingUtil.INSTANCE_FIELD);
        }

        public static TextAttributeKeyInfo instanceMemberVariable(JSHighlighter highlighter) {
            return new TextAttributeKeyInfo(highlighter.getMappedKey(JSHighlighter.JS_INSTANCE_MEMBER_VARIABLE), "field");
        }

        public static TextAttributeKeyInfo globalFunction(JSHighlighter highlighter) {
            return new TextAttributeKeyInfo(highlighter.getMappedKey(JSHighlighter.JS_GLOBAL_FUNCTION), "global function");
        }

        public static TextAttributeKeyInfo instanceMethod(JSHighlighter highlighter, PsiElement place) {
            return new TextAttributeKeyInfo(highlighter.getMappedKey(JSSemanticHighlightingUtil.getTextAttributeKeysProvider(place).getTextAttributesKeyForInstanceMethod()), JSSemanticHighlightingUtil.INSTANCE_METHOD);
        }

        public static TextAttributeKeyInfo staticMethod(JSHighlighter highlighter) {
            return new TextAttributeKeyInfo(highlighter.getMappedKey(JSHighlighter.JS_STATIC_MEMBER_FUNCTION), "static method");
        }

        public static TextAttributeKeyInfo constructor(JSHighlighter highlighter) {
            return new TextAttributeKeyInfo(highlighter.getMappedKey(JSHighlighter.JS_KEYWORD), "constructor");
        }

        public static TextAttributeKeyInfo globalVariable(JSHighlighter highlighter, JSTextAttributeKeysProvider provider) {
            return new TextAttributeKeyInfo(highlighter.getMappedKey(provider.getAttributesKeyForGlobalVariable()), "global variable");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TextAttributeKeyInfo info = (TextAttributeKeyInfo)o;
            if (!this.type.equals((Object)info.type)) {
                return false;
            }
            return this.text.equals(info.text);
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = 31 * result + this.text.hashCode();
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/highlighting/JSSemanticHighlightingUtil$TextAttributeKeyInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/highlighting/JSSemanticHighlightingUtil$TextAttributeKeyInfo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

