/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.imports;

import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclarationPart;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.imports.JSModuleImportOptimizerBase;
import com.intellij.lang.javascript.imports.JSOptimizeImportUtil;
import com.intellij.lang.javascript.inspections.ES6UnusedImportsInspection;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.typescript.imports.ES6UnusedImportsHelper;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.LinkedMultiMap;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ImportOptimizer
extends JSModuleImportOptimizerBase {
    public final boolean supports(PsiFile file) {
        if (!(file instanceof JSFile)) {
            return false;
        }
        JSFile jsFile = (JSFile)file;
        return this.checkDialect(DialectDetector.dialectOfFile((PsiFile)jsFile));
    }

    protected boolean checkDialect(@Nullable DialectOptionHolder holder) {
        return holder != null && holder.hasFeature(JSLanguageFeature.IMPORT_DECLARATIONS) && !holder.isFlow;
    }

    @Override
    @NotNull
    public Collection<JSModuleImportOptimizerBase.UnusedModuleInfo> getModulesInfo(@NotNull PsiFile file) {
        Collection<ES6ImportDeclaration> declarations;
        if (file == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(0);
        }
        if ((declarations = ES6ImportPsiUtil.getImportDeclarations((PsiElement)file)).isEmpty()) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                ES6ImportOptimizer.$$$reportNull$$$0(1);
            }
            return list;
        }
        final ArrayList infos = ContainerUtil.newArrayList();
        for (ES6ImportDeclaration declaration : declarations) {
            ES6UnusedImportsHelper.UnusedInfo info = ES6UnusedImportsHelper.getInfo(declaration);
            if (!info.isSideEffectImport() && ES6ImportPsiUtil.getFromClauseText((ES6ImportExportDeclaration)declaration) == null) continue;
            infos.add(info);
        }
        final List<String> importTexts = this.buildNewImportsText(file, infos);
        JSModuleImportOptimizerBase.UnusedModuleInfo info = new JSModuleImportOptimizerBase.UnusedModuleInfo(){

            @Override
            public List<String> getImportTexts() {
                return importTexts;
            }

            @Override
            public PsiElement getAnchor() {
                ES6UnusedImportsHelper.UnusedInfo item = (ES6UnusedImportsHelper.UnusedInfo)ContainerUtil.getFirstItem((List)infos);
                if (item != null) {
                    return item.getDeclaration();
                }
                return (PsiElement)ContainerUtil.getFirstItem((Collection)declarations);
            }

            @Override
            public List<PsiElement> getOldImports() {
                return infos.stream().map(el -> el.getDeclaration()).collect(Collectors.toList());
            }
        };
        List list = ContainerUtil.createMaybeSingletonList((Object)info);
        if (list == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    private List<String> buildNewImportsText(@NotNull PsiFile file, @NotNull List<ES6UnusedImportsHelper.UnusedInfo> infos) {
        if (file == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(3);
        }
        if (infos == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(4);
        }
        MultiMap<String, ES6UnusedImportsHelper.UnusedInfo> result = ES6ImportOptimizer.groupByFromClause(infos);
        boolean merge = JSCodeStyleSettings.isMergeImports((PsiElement)file);
        ArrayList importsResult = ContainerUtil.newArrayList();
        HashSet visitedImports = ContainerUtil.newHashSet();
        HashSet visitedSideEffectImports = ContainerUtil.newHashSet();
        Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
        ArrayList toProcessInfos = ContainerUtil.newArrayList(infos);
        ES6ImportOptimizer.sortByModuleName(file, toProcessInfos);
        for (ES6UnusedImportsHelper.UnusedInfo info : toProcessInfos) {
            Collection mergedImports;
            ES6ImportDeclaration declaration = info.getDeclaration();
            if (info.isSideEffectImport()) {
                if (!visitedSideEffectImports.add(declaration.getImportModuleText())) continue;
                ArrayList sideEffectImportWithComments = ContainerUtil.newArrayList();
                ES6ImportOptimizer.addSideEffectImport(file, document, sideEffectImportWithComments, info);
                JSOptimizeImportUtil.fillImportsWithNewLines(importsResult, (PsiElement)declaration, sideEffectImportWithComments);
                continue;
            }
            String fromText = ES6ImportPsiUtil.getUnquotedFromClauseText((ES6ImportExportDeclaration)declaration);
            if (fromText == null || !visitedImports.add(fromText) || (mergedImports = result.get((Object)fromText)).isEmpty()) continue;
            ArrayList currentImports = ContainerUtil.newArrayList();
            if (merge) {
                this.processMergedImports(file, document, currentImports, fromText, mergedImports);
            } else {
                HashSet visitedBindingNames = ContainerUtil.newHashSet();
                HashSet visitedSpecifierNames = ContainerUtil.newHashSet();
                for (ES6UnusedImportsHelper.UnusedInfo mergedInfo : mergedImports) {
                    List<String> importBodyText = this.getImportBodyText(file, document, ContainerUtil.createMaybeSingletonList((Object)mergedInfo), fromText, visitedBindingNames, visitedSpecifierNames);
                    currentImports.addAll(importBodyText);
                }
            }
            JSOptimizeImportUtil.fillImportsWithNewLines(importsResult, (PsiElement)declaration, currentImports);
        }
        ArrayList arrayList = importsResult;
        if (arrayList == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    private static void sortByModuleName(@NotNull PsiFile file, @NotNull List<ES6UnusedImportsHelper.UnusedInfo> infos) {
        if (file == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(6);
        }
        if (infos == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(7);
        }
        JSCodeStyleSettings settings = JSCodeStyleSettings.getSettings((PsiElement)file);
        if (!settings.IMPORT_SORT_MODULE_NAME) {
            return;
        }
        Comparator<String> comparator = ES6ImportPsiUtil.getStringImportFromComparator((PsiElement)file);
        ContainerUtil.sort(infos, (o1, o2) -> {
            ES6ImportDeclaration declaration1 = o1.getDeclaration();
            ES6ImportDeclaration declaration2 = o2.getDeclaration();
            String fromClauseText1 = ES6ImportPsiUtil.getUnquotedFromClauseOrModuleText((ES6ImportExportDeclaration)declaration1);
            String fromClauseText2 = ES6ImportPsiUtil.getUnquotedFromClauseOrModuleText((ES6ImportExportDeclaration)declaration2);
            return comparator.compare(fromClauseText1, fromClauseText2);
        });
    }

    protected void processMergedImports(@NotNull PsiFile file, @Nullable Document document, List<String> importsResult, String fromText, Collection<ES6UnusedImportsHelper.UnusedInfo> mergedImports) {
        if (file == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(8);
        }
        importsResult.addAll(this.getImportBodyText(file, document, mergedImports, fromText));
    }

    private static void addSideEffectImport(@NotNull PsiFile file, @Nullable Document document, @NotNull List<String> importsResult, @NotNull ES6UnusedImportsHelper.UnusedInfo info) {
        ES6ImportDeclaration declaration;
        String name;
        if (file == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(9);
        }
        if (importsResult == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(10);
        }
        if (info == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(11);
        }
        if (!StringUtil.isEmpty((String)(name = (declaration = info.getDeclaration()).getImportModuleText()))) {
            List<PsiElement> prevComments = JSOptimizeImportUtil.getPrevComments(document, (PsiElement)declaration);
            importsResult.addAll(JSOptimizeImportUtil.getPsiElementsAsStrings(prevComments));
            StringBuilder builder = new StringBuilder();
            builder.append("import ");
            ImportStyle style = ES6ImportOptimizer.getImportStyle(file, declaration);
            ES6ImportOptimizer.addFromPartWithoutKeyword(style, StringUtil.unquoteString((String)name), builder);
            JSOptimizeImportUtil.addSameLineComments(document, (PsiElement)declaration, builder);
            importsResult.add(builder.toString());
        }
    }

    @NotNull
    private static MultiMap<String, ES6UnusedImportsHelper.UnusedInfo> groupByFromClause(@NotNull Collection<ES6UnusedImportsHelper.UnusedInfo> infos) {
        if (infos == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(12);
        }
        LinkedMultiMap results = new LinkedMultiMap();
        for (ES6UnusedImportsHelper.UnusedInfo info : infos) {
            ES6ImportDeclaration declaration = info.getDeclaration();
            String text = ES6ImportPsiUtil.getUnquotedFromClauseText((ES6ImportExportDeclaration)declaration);
            if (text == null) continue;
            results.putValue((Object)text, (Object)info);
        }
        LinkedMultiMap linkedMultiMap = results;
        if (linkedMultiMap == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(13);
        }
        return linkedMultiMap;
    }

    private static boolean isSuppressedUnused(ES6ImportExportDeclaration declaration) {
        return SuppressionUtil.isSuppressedInStatement((PsiElement)declaration, (String)ES6UnusedImportsInspection.SHORT_NAME, ES6ImportDeclaration.class);
    }

    protected List<String> getImportBodyText(@NotNull PsiFile file, @Nullable Document document, @NotNull Collection<ES6UnusedImportsHelper.UnusedInfo> mergedImports, @NotNull String fromPart) {
        if (file == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(14);
        }
        if (mergedImports == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(15);
        }
        if (fromPart == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(16);
        }
        HashSet bindings = ContainerUtil.newHashSet();
        HashSet specifiers = ContainerUtil.newHashSet();
        return this.getImportBodyText(file, document, mergedImports, fromPart, bindings, specifiers);
    }

    @NotNull
    private static <PartType extends ES6ImportExportDeclarationPart> MultiMap<PartType, ES6ImportDeclaration> getUniqueImportParts(@NotNull List<PartType> parts, @NotNull Collection<String> visitedNames) {
        if (parts == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(17);
        }
        if (visitedNames == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(18);
        }
        MultiMap mergedParts = MultiMap.createLinked();
        HashMap names = ContainerUtil.newHashMap();
        for (ES6ImportExportDeclarationPart importPart : parts) {
            String name = importPart.getDeclaredName();
            if (name == null || visitedNames.contains(name)) continue;
            ES6ImportExportDeclarationPart storedPart = (ES6ImportExportDeclarationPart)ContainerUtil.getOrCreate((Map)names, (Object)name, (Object)importPart);
            mergedParts.putValue((Object)storedPart, (Object)((ES6ImportDeclaration)importPart.getDeclaration()));
        }
        visitedNames.addAll(names.keySet());
        MultiMap multiMap = mergedParts;
        if (multiMap == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(19);
        }
        return multiMap;
    }

    protected List<String> getImportBodyText(@NotNull PsiFile context, @Nullable Document document, @NotNull Collection<ES6UnusedImportsHelper.UnusedInfo> mergedImports, @NotNull String fromPart, @NotNull Collection<String> visitedBindingNames, @NotNull Collection<String> visitedSpecifierNames) {
        if (context == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(20);
        }
        if (mergedImports == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(21);
        }
        if (fromPart == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(22);
        }
        if (visitedBindingNames == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(23);
        }
        if (visitedSpecifierNames == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(24);
        }
        ArrayList bindings = ContainerUtil.newArrayList();
        ArrayList specifiers = ContainerUtil.newArrayList();
        ArrayList prevCommentsToProcess = ContainerUtil.newArrayList();
        HashMap lineCommentsToProcess = ContainerUtil.newHashMap();
        for (ES6UnusedImportsHelper.UnusedInfo importInfo : mergedImports) {
            ES6ImportDeclaration declaration = importInfo.getDeclaration();
            ES6ImportOptimizer.fillUsedBindingsAndSpecifiers(bindings, specifiers, importInfo, declaration);
            PsiElement comment = JSOptimizeImportUtil.getLineComment(document, (PsiElement)declaration);
            if (comment != null) {
                lineCommentsToProcess.put(declaration, comment);
            }
            prevCommentsToProcess.addAll(JSOptimizeImportUtil.getPrevComments(document, (PsiElement)declaration));
        }
        ES6ImportOptimizer.sortSpecifiers(context, specifiers);
        MultiMap uniqueBindings = ES6ImportOptimizer.getUniqueImportParts(bindings, visitedBindingNames);
        MultiMap uniqueSpecifiers = ES6ImportOptimizer.getUniqueImportParts(specifiers, visitedSpecifierNames);
        ImportBuilder importBuilder = new ImportBuilder(ES6ImportOptimizer.getImportStyle(context, mergedImports), this.getImportPrefix(mergedImports), fromPart);
        ArrayList resultListOfImports = ContainerUtil.newArrayList();
        importBuilder = ES6ImportOptimizer.appendBindings(uniqueBindings, importBuilder, lineCommentsToProcess, resultListOfImports);
        ES6ImportOptimizer.appendSpecifiers(uniqueSpecifiers, importBuilder, lineCommentsToProcess);
        if (!importBuilder.isEmpty()) {
            resultListOfImports.add(importBuilder.createImportString());
        }
        return ContainerUtil.concat(JSOptimizeImportUtil.getPsiElementsAsStrings(prevCommentsToProcess), (List)resultListOfImports);
    }

    private static void sortSpecifiers(@NotNull PsiFile context, @NotNull List<ES6ImportSpecifier> specifiers) {
        if (context == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(25);
        }
        if (specifiers == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(26);
        }
        if (JSCodeStyleSettings.getSettings((PsiElement)context).IMPORT_SORT_MEMBERS) {
            Comparator<ES6ImportSpecifier> comparator = ES6ImportPsiUtil.getImportMemberComparator((PsiElement)context);
            ContainerUtil.sort(specifiers, comparator);
        }
    }

    private static ImportBuilder appendBindings(@NotNull MultiMap<ES6ImportedBinding, ES6ImportDeclaration> uniqueBindings, @NotNull ImportBuilder importBuilder, @NotNull Map<ES6ImportDeclaration, PsiElement> lineCommentsToProcess, @NotNull List<String> listOfImports) {
        if (uniqueBindings == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(27);
        }
        if (importBuilder == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(28);
        }
        if (lineCommentsToProcess == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(29);
        }
        if (listOfImports == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(30);
        }
        int bindingCount = 0;
        boolean lastIsAll = false;
        for (Map.Entry bindingWithDeclarations : uniqueBindings.entrySet()) {
            ES6ImportedBinding binding = (ES6ImportedBinding)bindingWithDeclarations.getKey();
            if (bindingCount > 0) {
                if (bindingCount == 1 && !lastIsAll && binding.isNamespaceImport()) {
                    importBuilder.append(", ");
                } else {
                    listOfImports.add(importBuilder.createImportString());
                    importBuilder = importBuilder.cloneBuilder();
                    bindingCount = 0;
                }
            }
            ++bindingCount;
            ImportBuilder finalImportBuilder = importBuilder;
            ((Collection)bindingWithDeclarations.getValue()).forEach(decl -> {
                if (lineCommentsToProcess == null) {
                    ES6ImportOptimizer.$$$reportNull$$$0(62);
                }
                ES6ImportOptimizer.addLineCommentsToBuilder(lineCommentsToProcess, finalImportBuilder, decl);
            });
            importBuilder.append(binding.getText());
            lastIsAll = binding.isNamespaceImport();
        }
        if (lastIsAll) {
            listOfImports.add(importBuilder.createImportString());
            return importBuilder.cloneBuilder();
        }
        return importBuilder;
    }

    private static void appendSpecifiers(@NotNull MultiMap<ES6ImportSpecifier, ES6ImportDeclaration> uniqueSpecifiers, @NotNull ImportBuilder importBuilder, @NotNull Map<ES6ImportDeclaration, PsiElement> lineCommentsToProcess) {
        if (uniqueSpecifiers == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(31);
        }
        if (importBuilder == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(32);
        }
        if (lineCommentsToProcess == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(33);
        }
        if (uniqueSpecifiers.isEmpty()) {
            return;
        }
        if (!importBuilder.isEmpty()) {
            importBuilder.append(", ");
        }
        importBuilder.append("{");
        String specifierList = StringUtil.join((Collection)uniqueSpecifiers.entrySet(), el -> {
            if (lineCommentsToProcess == null) {
                ES6ImportOptimizer.$$$reportNull$$$0(58);
            }
            if (importBuilder == null) {
                ES6ImportOptimizer.$$$reportNull$$$0(59);
            }
            ES6ImportSpecifier specifier = (ES6ImportSpecifier)el.getKey();
            ((Collection)el.getValue()).forEach(decl -> {
                if (lineCommentsToProcess == null) {
                    ES6ImportOptimizer.$$$reportNull$$$0(60);
                }
                if (importBuilder == null) {
                    ES6ImportOptimizer.$$$reportNull$$$0(61);
                }
                ES6ImportOptimizer.addLineCommentsToBuilder(lineCommentsToProcess, importBuilder, decl);
            });
            return specifier.getText();
        }, (String)", ");
        importBuilder.append(specifierList);
        if (importBuilder.myStyle.myAddTrailingComma) {
            importBuilder.append(", ");
        }
        importBuilder.append("}");
    }

    private static void addLineCommentsToBuilder(@NotNull Map<ES6ImportDeclaration, PsiElement> lineCommentsToProcess, @NotNull ImportBuilder builder, @NotNull ES6ImportDeclaration declaration) {
        PsiElement comment;
        if (lineCommentsToProcess == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(34);
        }
        if (builder == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(35);
        }
        if (declaration == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(36);
        }
        if ((comment = lineCommentsToProcess.remove(declaration)) != null) {
            builder.addLineComment(comment);
        }
    }

    private static void fillUsedBindingsAndSpecifiers(List<ES6ImportedBinding> bindings, List<ES6ImportSpecifier> specifiers, ES6UnusedImportsHelper.UnusedInfo importInfo, ES6ImportDeclaration declaration) {
        boolean isSuppressedUnused = ES6ImportOptimizer.isSuppressedUnused((ES6ImportExportDeclaration)declaration);
        ES6ImportOptimizer.fillUsedSpecifiers(specifiers, importInfo, declaration, isSuppressedUnused);
        ES6ImportOptimizer.fillUsedBindings(bindings, importInfo, declaration, isSuppressedUnused);
    }

    private static void fillUsedBindings(List<ES6ImportedBinding> bindings, ES6UnusedImportsHelper.UnusedInfo importInfo, ES6ImportDeclaration declaration, boolean isSuppressedUnused) {
        ES6ImportedBinding[] currentBindings = declaration.getImportedBindings();
        Collection<Object> unusedBindings = isSuppressedUnused ? ContainerUtil.newArrayList() : importInfo.getUnusedBindings();
        bindings.addAll(Arrays.stream(currentBindings).filter(el -> !unusedBindings.contains(el)).collect(Collectors.toList()));
    }

    private static void fillUsedSpecifiers(List<ES6ImportSpecifier> specifiers, ES6UnusedImportsHelper.UnusedInfo importInfo, ES6ImportDeclaration declaration, boolean isSuppressedUnused) {
        ES6ImportSpecifier[] currentSpecifiers = declaration.getImportSpecifiers();
        Collection<Object> unusedSpecifiers = isSuppressedUnused ? ContainerUtil.newArrayList() : importInfo.getUnusedSpecifiers();
        specifiers.addAll(Arrays.stream(currentSpecifiers).filter(el -> !unusedSpecifiers.contains(el)).collect(Collectors.toList()));
    }

    @NotNull
    protected String getImportPrefix(@NotNull Collection<ES6UnusedImportsHelper.UnusedInfo> imports) {
        if (imports == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(37);
        }
        if ("import " == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(38);
        }
        return "import ";
    }

    private static void addFromPart(@NotNull ImportStyle style, @NotNull String fromPart, @NotNull StringBuilder importBody) {
        if (style == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(39);
        }
        if (fromPart == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(40);
        }
        if (importBody == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(41);
        }
        importBody.append(" from ");
        ES6ImportOptimizer.addFromPartWithoutKeyword(style, fromPart, importBody);
    }

    @NotNull
    private static ImportStyle getImportStyle(PsiFile context, @NotNull Collection<ES6UnusedImportsHelper.UnusedInfo> mergedImports) {
        ES6UnusedImportsHelper.UnusedInfo item;
        if (mergedImports == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(42);
        }
        if ((item = (ES6UnusedImportsHelper.UnusedInfo)ContainerUtil.getFirstItem(mergedImports)) == null) {
            ImportStyle importStyle = ES6ImportOptimizer.getDefaultImportStyle(context);
            if (importStyle == null) {
                ES6ImportOptimizer.$$$reportNull$$$0(43);
            }
            return importStyle;
        }
        ES6ImportDeclaration declaration = item.getDeclaration();
        ImportStyle importStyle = ES6ImportOptimizer.getImportStyle(context, declaration);
        if (importStyle == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(44);
        }
        return importStyle;
    }

    @NotNull
    private static ImportStyle getDefaultImportStyle(@NotNull PsiFile context) {
        if (context == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(45);
        }
        ImportStyle importStyle = new ImportStyle(JSCodeStyleSettings.getQuote((PsiElement)context), false, JSCodeStyleSettings.getSemicolon(context));
        if (importStyle == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(46);
        }
        return importStyle;
    }

    private static ImportStyle getImportStyle(@NotNull PsiFile context, @NotNull ES6ImportDeclaration declaration) {
        if (context == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(47);
        }
        if (declaration == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(48);
        }
        String semicolon = ES6ImportOptimizer.getSemicolon(context, declaration);
        String quote = ES6ImportOptimizer.getQuote(context, declaration);
        boolean shouldAddTrailingCommaToSpecifiers = ES6ImportOptimizer.shouldAddTrailingCommaToSpecifiers(context, declaration);
        return new ImportStyle(quote, shouldAddTrailingCommaToSpecifiers, semicolon);
    }

    private static boolean shouldAddTrailingCommaToSpecifiers(@NotNull PsiFile context, @NotNull ES6ImportDeclaration declaration) {
        ES6ImportSpecifier[] specifiers;
        if (context == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(49);
        }
        if (declaration == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(50);
        }
        if ((specifiers = declaration.getImportSpecifiers()).length == 0) {
            return false;
        }
        JSCodeStyleSettings settings = JSCodeStyleSettings.getSettings((PsiElement)context);
        if (settings.ENFORCE_TRAILING_COMMA == JSCodeStyleSettings.TrailingCommaOption.Remove) {
            return false;
        }
        ES6ImportSpecifier lastSpecifier = specifiers[specifiers.length - 1];
        PsiElement sibling = JSPsiImplUtils.getNextSiblingIgnoreWhitespace((PsiElement)lastSpecifier);
        return sibling != null && sibling.getNode().getElementType() == JSTokenTypes.COMMA;
    }

    private static String getQuote(@NotNull PsiFile context, @NotNull ES6ImportDeclaration declaration) {
        if (context == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(51);
        }
        if (declaration == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(52);
        }
        ASTNode declarationNode = declaration.getNode();
        ES6FromClause clause = declaration.getFromClause();
        ASTNode parentNode = clause == null ? declarationNode : clause.getNode();
        ASTNode stringLiteral = parentNode.findChildByType(JSTokenTypes.STRING_LITERAL);
        return ES6ImportPsiUtil.getQuote((PsiElement)context, stringLiteral);
    }

    private static String getSemicolon(@NotNull PsiFile context, @NotNull ES6ImportDeclaration declaration) {
        if (context == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(53);
        }
        if (declaration == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(54);
        }
        JSCodeStyleSettings settings = JSCodeStyleSettings.getSettings((PsiElement)context);
        if (settings.FORCE_SEMICOLON_STYLE) {
            return JSCodeStyleSettings.getSemicolon(context);
        }
        ASTNode declarationNode = declaration.getNode();
        ASTNode semicolonNode = declarationNode.findChildByType(JSTokenTypes.SEMICOLON);
        return semicolonNode == null ? "" : semicolonNode.getText();
    }

    private static void addFromPartWithoutKeyword(@NotNull ImportStyle style, @NotNull String fromPart, @NotNull StringBuilder importBody) {
        if (style == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(55);
        }
        if (fromPart == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(56);
        }
        if (importBody == null) {
            ES6ImportOptimizer.$$$reportNull$$$0(57);
        }
        String quote = style.myQuote;
        importBody.append(quote);
        importBody.append(fromPart);
        importBody.append(quote);
        importBody.append(style.mySemicolon);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 13: 
            case 19: 
            case 38: 
            case 43: 
            case 44: 
            case 46: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 13: 
            case 19: 
            case 38: 
            case 43: 
            case 44: 
            case 46: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 13: 
            case 19: 
            case 38: 
            case 43: 
            case 44: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/imports/ES6ImportOptimizer";
                break;
            }
            case 4: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importsResult";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 15: 
            case 21: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mergedImports";
                break;
            }
            case 16: 
            case 22: 
            case 40: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromPart";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parts";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitedNames";
                break;
            }
            case 20: 
            case 25: 
            case 45: 
            case 47: 
            case 49: 
            case 51: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitedBindingNames";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitedSpecifierNames";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specifiers";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uniqueBindings";
                break;
            }
            case 28: 
            case 32: 
            case 59: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importBuilder";
                break;
            }
            case 29: 
            case 33: 
            case 34: 
            case 58: 
            case 60: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineCommentsToProcess";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listOfImports";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uniqueSpecifiers";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 36: 
            case 48: 
            case 50: 
            case 52: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imports";
                break;
            }
            case 39: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "style";
                break;
            }
            case 41: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importBody";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/imports/ES6ImportOptimizer";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getModulesInfo";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "buildNewImportsText";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "groupByFromClause";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getUniqueImportParts";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportPrefix";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportStyle";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultImportStyle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getModulesInfo";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 13: 
            case 19: 
            case 38: 
            case 43: 
            case 44: 
            case 46: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "buildNewImportsText";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "sortByModuleName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processMergedImports";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addSideEffectImport";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "groupByFromClause";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getImportBodyText";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getUniqueImportParts";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "sortSpecifiers";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "appendBindings";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "appendSpecifiers";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "addLineCommentsToBuilder";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getImportPrefix";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "addFromPart";
                break;
            }
            case 42: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getImportStyle";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultImportStyle";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "shouldAddTrailingCommaToSpecifiers";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getQuote";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getSemicolon";
                break;
            }
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "addFromPartWithoutKeyword";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "lambda$appendSpecifiers$3";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$2";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "lambda$appendBindings$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 13: 
            case 19: 
            case 38: 
            case 43: 
            case 44: 
            case 46: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class ImportBuilder {
        @NotNull
        private final ImportStyle myStyle;
        @NotNull
        private final String myImportPrefix;
        @NotNull
        private final String myFromPart;
        @NotNull
        private final StringBuilder myCurrentText;
        @NotNull
        private final List<PsiElement> myLineComments;

        public ImportBuilder(@NotNull ImportStyle style, @NotNull String importPrefix, @NotNull String fromPart) {
            if (style == null) {
                ImportBuilder.$$$reportNull$$$0(0);
            }
            if (importPrefix == null) {
                ImportBuilder.$$$reportNull$$$0(1);
            }
            if (fromPart == null) {
                ImportBuilder.$$$reportNull$$$0(2);
            }
            this.myStyle = style;
            this.myImportPrefix = importPrefix;
            this.myFromPart = fromPart;
            this.myCurrentText = new StringBuilder();
            this.myLineComments = ContainerUtil.newArrayList();
        }

        private void append(@NotNull String text) {
            if (text == null) {
                ImportBuilder.$$$reportNull$$$0(3);
            }
            this.myCurrentText.append(text);
        }

        private boolean isEmpty() {
            return this.myCurrentText.length() == 0;
        }

        private void addLineComment(@NotNull PsiElement comment) {
            if (comment == null) {
                ImportBuilder.$$$reportNull$$$0(4);
            }
            this.myLineComments.add(comment);
        }

        @NotNull
        private String createImportString() {
            assert (!this.isEmpty());
            ES6ImportOptimizer.addFromPart(this.myStyle, this.myFromPart, this.myCurrentText);
            JSOptimizeImportUtil.addSameLineComments(this.myCurrentText, JSOptimizeImportUtil.getPsiElementsAsStrings(this.myLineComments));
            String string = this.myImportPrefix + this.myCurrentText.toString();
            if (string == null) {
                ImportBuilder.$$$reportNull$$$0(5);
            }
            return string;
        }

        @NotNull
        private ImportBuilder cloneBuilder() {
            ImportBuilder importBuilder = new ImportBuilder(this.myStyle, this.myImportPrefix, this.myFromPart);
            if (importBuilder == null) {
                ImportBuilder.$$$reportNull$$$0(6);
            }
            return importBuilder;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "style";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "importPrefix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fromPart";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "comment";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/imports/ES6ImportOptimizer$ImportBuilder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/imports/ES6ImportOptimizer$ImportBuilder";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createImportString";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "cloneBuilder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "append";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "addLineComment";
                    break;
                }
                case 5: 
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ImportStyle {
        private final String mySemicolon;
        private final String myQuote;
        private final boolean myAddTrailingComma;

        public ImportStyle(String quote, boolean addTrailingComma, String semicolon) {
            this.mySemicolon = semicolon;
            this.myQuote = quote;
            this.myAddTrailingComma = addTrailingComma;
        }
    }
}

