/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.index;

import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartFMap;
import com.intellij.util.SmartList;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ES6ImportIndex
extends FileBasedIndexExtension<ImportKey, List<ImportInfo>> {
    public static final ID<ImportKey, List<ImportInfo>> INDEX_ID = ID.create((String)"es6.import.index");
    public static final int INDEX_VERSION = 0;

    @NotNull
    public ID<ImportKey, List<ImportInfo>> getName() {
        ID<ImportKey, List<ImportInfo>> iD = INDEX_ID;
        if (iD == null) {
            ES6ImportIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @NotNull
    public DataIndexer<ImportKey, List<ImportInfo>, FileContent> getIndexer() {
        DataIndexer<ImportKey, List<ImportInfo>, FileContent> dataIndexer = new DataIndexer<ImportKey, List<ImportInfo>, FileContent>(){

            @NotNull
            public Map<ImportKey, List<ImportInfo>> map(@NotNull FileContent content) {
                JSFile file;
                if (content == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((file = (JSFile)ObjectUtils.tryCast((Object)content.getPsiFile(), JSFile.class)) == null || JSCorePredefinedLibrariesProvider.isLibraryElement((PsiElement)file)) {
                    SmartFMap smartFMap = SmartFMap.emptyMap();
                    if (smartFMap == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return smartFMap;
                }
                Set paths = file.getReferencedPaths();
                if (paths.isEmpty()) {
                    SmartFMap smartFMap = SmartFMap.emptyMap();
                    if (smartFMap == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return smartFMap;
                }
                Map map = FactoryMap.create(key1 -> new SmartList());
                ImportFileKeyImpl fileKey = new ImportFileKeyImpl(content.getFile());
                List infos = (List)map.get(fileKey);
                for (String path : paths) {
                    int index = (path = StringUtil.trimEnd((String)FileUtil.toSystemIndependentName((String)StringUtil.unquoteString((String)path)), (String)"/")).lastIndexOf("/");
                    String name = index >= 0 ? path.substring(index + 1, path.length()) : path;
                    String fixedName = TypeScriptUtil.getFileNameWithoutExtension(name);
                    ImportInfoImpl impl = new ImportInfoImpl(path);
                    ImportNameKeyImpl key = new ImportNameKeyImpl(fixedName);
                    ((List)map.get(key)).add(impl);
                    infos.add(impl);
                }
                Map map2 = map;
                if (map2 == null) {
                    1.$$$reportNull$$$0(3);
                }
                return map2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "content";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/index/ES6ImportIndex$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/index/ES6ImportIndex$1";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "map";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "map";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (dataIndexer == null) {
            ES6ImportIndex.$$$reportNull$$$0(1);
        }
        return dataIndexer;
    }

    @NotNull
    public KeyDescriptor<ImportKey> getKeyDescriptor() {
        KeyDescriptor<ImportKey> keyDescriptor = new KeyDescriptor<ImportKey>(){

            public int getHashCode(ImportKey value) {
                return value.hashCode();
            }

            public boolean isEqual(ImportKey val1, ImportKey val2) {
                return val1.equals(val2);
            }

            public void save(@NotNull DataOutput out, ImportKey value) throws IOException {
                if (out == null) {
                    2.$$$reportNull$$$0(0);
                }
                out.writeBoolean(value.isName());
                value.writeValue(out);
            }

            public ImportKey read(@NotNull DataInput in) throws IOException {
                boolean isInclude;
                if (in == null) {
                    2.$$$reportNull$$$0(1);
                }
                return (isInclude = in.readBoolean()) ? new ImportNameKeyImpl(IOUtil.readUTF((DataInput)in)) : new ImportFileKeyImpl(in.readInt());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "out";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "in";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/javascript/index/ES6ImportIndex$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "save";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "read";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (keyDescriptor == null) {
            ES6ImportIndex.$$$reportNull$$$0(2);
        }
        return keyDescriptor;
    }

    public int getVersion() {
        return 0;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        DefaultFileTypeSpecificInputFilter defaultFileTypeSpecificInputFilter = new DefaultFileTypeSpecificInputFilter(TypeScriptUtil.TYPESCRIPT_FILE_TYPES_ARRAY){

            public boolean acceptInput(@NotNull VirtualFile file) {
                if (file == null) {
                    3.$$$reportNull$$$0(0);
                }
                return file.getFileSystem() != JarFileSystem.getInstance();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/index/ES6ImportIndex$3", "acceptInput"));
            }
        };
        if (defaultFileTypeSpecificInputFilter == null) {
            ES6ImportIndex.$$$reportNull$$$0(3);
        }
        return defaultFileTypeSpecificInputFilter;
    }

    public static MultiMap<VirtualFile, ImportInfo> getIncludingFileCandidates(String fileName, GlobalSearchScope scope) {
        MultiMap result = MultiMap.createSmart();
        FileBasedIndex.ValueProcessor processor = (file, value) -> {
            result.put((Object)file, (Collection)value);
            return true;
        };
        FileBasedIndex.getInstance().processValues(INDEX_ID, (Object)new ImportNameKeyImpl(fileName), null, processor, scope);
        return result;
    }

    public static List<ImportInfo> getIncludes(VirtualFile file, GlobalSearchScope scope) {
        ArrayList<ImportInfo> result = new ArrayList<ImportInfo>();
        FileBasedIndex.getInstance().processValues(INDEX_ID, (Object)new ImportFileKeyImpl(file), file, (candidate, value) -> {
            result.addAll((Collection<ImportInfo>)value);
            return true;
        }, scope);
        return result;
    }

    @NotNull
    public DataExternalizer<List<ImportInfo>> getValueExternalizer() {
        DataExternalizer<List<ImportInfo>> dataExternalizer = new DataExternalizer<List<ImportInfo>>(){

            public void save(@NotNull DataOutput out, List<ImportInfo> value) throws IOException {
                if (out == null) {
                    4.$$$reportNull$$$0(0);
                }
                out.writeInt(value.size());
                for (ImportInfo info : value) {
                    IOUtil.writeUTF((DataOutput)out, (String)info.getPath());
                }
            }

            public List<ImportInfo> read(@NotNull DataInput in) throws IOException {
                if (in == null) {
                    4.$$$reportNull$$$0(1);
                }
                int size = in.readInt();
                ArrayList<ImportInfo> infos = new ArrayList<ImportInfo>(size);
                for (int i = 0; i < size; ++i) {
                    infos.add(new ImportInfoImpl(IOUtil.readUTF((DataInput)in)));
                }
                return infos;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "out";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "in";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/javascript/index/ES6ImportIndex$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "save";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "read";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (dataExternalizer == null) {
            ES6ImportIndex.$$$reportNull$$$0(4);
        }
        return dataExternalizer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/lang/javascript/index/ES6ImportIndex";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ImportInfoImpl
    implements ImportInfo {
        private final String myPath;

        public ImportInfoImpl(String path) {
            this.myPath = path;
        }

        @Override
        public String getPath() {
            return this.myPath;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ImportInfoImpl)) {
                return false;
            }
            ImportInfoImpl info = (ImportInfoImpl)o;
            return Objects.equals(this.myPath, info.myPath);
        }

        public int hashCode() {
            return Objects.hash(this.myPath);
        }
    }

    public static interface ImportInfo {
        public String getPath();
    }

    private static class ImportNameKeyImpl
    implements ImportKey {
        private final String myFileName;

        public ImportNameKeyImpl(String fileName) {
            this.myFileName = fileName;
        }

        @Override
        public boolean isName() {
            return true;
        }

        @Override
        public void writeValue(DataOutput out) throws IOException {
            IOUtil.writeUTF((DataOutput)out, (String)this.myFileName);
        }

        public int hashCode() {
            return this.myFileName.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof ImportNameKeyImpl && ((ImportNameKeyImpl)obj).myFileName.equals(this.myFileName);
        }
    }

    private static class ImportFileKeyImpl
    implements ImportKey {
        private final int myFileId;

        private ImportFileKeyImpl(int fileId) {
            this.myFileId = fileId;
        }

        private ImportFileKeyImpl(VirtualFile file) {
            this.myFileId = FileBasedIndex.getFileId((VirtualFile)file);
        }

        @Override
        public boolean isName() {
            return false;
        }

        @Override
        public void writeValue(DataOutput out) throws IOException {
            out.writeInt(this.myFileId);
        }

        public int hashCode() {
            return this.myFileId;
        }

        public boolean equals(Object obj) {
            return obj instanceof ImportFileKeyImpl && ((ImportFileKeyImpl)obj).myFileId == this.myFileId;
        }
    }

    public static interface ImportKey {
        public boolean isName();

        public void writeValue(DataOutput var1) throws IOException;
    }
}

