/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSConvertParametersToObjectIntention
extends JavaScriptIntention {
    private static final Logger LOGGER = Logger.getInstance(JSConvertParametersToObjectIntention.class);
    private static final String PARAMETERS_VARIABLE = "parameters";

    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"js.convert.parameters.to.object.intention.name", (Object[])new Object[0]);
        if (string == null) {
            JSConvertParametersToObjectIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = JSBundle.message((String)"js.convert.parameters.to.object.intention.name", (Object[])new Object[0]);
        if (string == null) {
            JSConvertParametersToObjectIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            JSConvertParametersToObjectIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            JSConvertParametersToObjectIntention.$$$reportNull$$$0(3);
        }
        if (!super.isAvailable(project, editor, element)) {
            return false;
        }
        JSParameterList parameterList = (JSParameterList)PsiTreeUtil.getParentOfType((PsiElement)element, JSParameterList.class);
        Object[] parameters = parameterList != null ? parameterList.getParameters() : JSParameterListElement.EMPTY_ARRAY;
        return parameters.length > 0 && ContainerUtil.and((Object[])parameters, JSConvertParametersToObjectIntention::isSimpleParameter);
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        JSFunction funcRef;
        JSParameterList parameterList;
        if (project == null) {
            JSConvertParametersToObjectIntention.$$$reportNull$$$0(4);
        }
        if (element == null) {
            JSConvertParametersToObjectIntention.$$$reportNull$$$0(5);
        }
        if ((parameterList = (JSParameterList)PsiTreeUtil.getParentOfType((PsiElement)element, JSParameterList.class)) == null) {
            return;
        }
        JSFunction function = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)parameterList, JSFunction.class);
        while (JSPsiImplUtils.isTypeSignature(function)) {
            if ((function = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)function, JSFunction.class)) == null) {
                HintManager.getInstance().showErrorHint(editor, JSBundle.message((String)"js.convert.parameters.to.object.unavailable.for.type.function", (Object[])new Object[0]));
                return;
            }
            parameterList = function.getParameterList();
        }
        if (parameterList == null) {
            HintManager.getInstance().showErrorHint(editor, JSBundle.message((String)"js.convert.parameters.to.object.unavailable.for.function.no.parameters", (Object[])new Object[0]));
            return;
        }
        if (JSPsiImplUtils.isArrowFunction(function)) {
            HintManager.getInstance().showErrorHint(editor, JSBundle.message((String)"js.convert.parameters.to.object.unavailable.for.arrow.function", (Object[])new Object[0]));
            return;
        }
        Object object = funcRef = function instanceof JSFunctionExpression ? JSPsiImplUtils.getInitializedElement((JSExpression)((JSFunctionExpression)function)) : function;
        if (function == null) {
            return;
        }
        JSParameter[] parameters = parameterList.getParameterVariables();
        if (parameters.length == 0) {
            return;
        }
        ArrayList callExpressions = ContainerUtil.newArrayList();
        if (!JSConvertParametersToObjectIntention.fillFunctionUsagesWithProgress(element, function, (JSNamedElement)funcRef, callExpressions)) {
            return;
        }
        JSFunction finalFunction = function;
        JSParameterList finalParameterList = parameterList;
        WriteCommandAction.runWriteCommandAction((Project)project, () -> {
            if (element == null) {
                JSConvertParametersToObjectIntention.$$$reportNull$$$0(25);
            }
            if (!FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{finalFunction})) {
                return;
            }
            JSConvertParametersToObjectIntention.addVariablesInitializationToFunctionBody(element, parameters, finalFunction);
            JSConvertParametersToObjectIntention.replaceParametersInFunctionSignature(finalParameterList, parameters);
            JSConvertParametersToObjectIntention.replaceArgumentsInCalls(parameters, callExpressions);
        });
    }

    private static void replaceArgumentsInCalls(@NotNull JSParameter[] parameters, @NotNull List<JSCallExpression> callExpressions) {
        if (parameters == null) {
            JSConvertParametersToObjectIntention.$$$reportNull$$$0(6);
        }
        if (callExpressions == null) {
            JSConvertParametersToObjectIntention.$$$reportNull$$$0(7);
        }
        for (JSCallExpression call : callExpressions) {
            ASTNode newArgumentNode;
            JSExpression[] arguments;
            int argToReplaceCount;
            JSArgumentList argumentList = call.getArgumentList();
            if (argumentList == null || !FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{argumentList}) || (argToReplaceCount = Math.min((arguments = argumentList.getArguments()).length, parameters.length)) <= 0) continue;
            String newArgument = JSConvertParametersToObjectIntention.wrapArgumentsWithObjectLiteral(parameters, arguments, argToReplaceCount);
            if (argToReplaceCount > 1) {
                argumentList.getNode().removeRange(arguments[0].getNode(), arguments[argToReplaceCount - 1].getNode());
            }
            if ((newArgumentNode = JSChangeUtil.createExpressionWithContext(newArgument, (PsiElement)call)) != null) {
                arguments[argToReplaceCount - 1].replace(newArgumentNode.getPsi());
                continue;
            }
            LOGGER.error("Failed to create expression: " + newArgument);
        }
    }

    private static void replaceParametersInFunctionSignature(@NotNull JSParameterList parameterList, @NotNull JSParameter[] parameters) {
        if (parameterList == null) {
            JSConvertParametersToObjectIntention.$$$reportNull$$$0(8);
        }
        if (parameters == null) {
            JSConvertParametersToObjectIntention.$$$reportNull$$$0(9);
        }
        String typeString = JSConvertParametersToObjectIntention.getNewParameterType(parameterList, parameters);
        JSParameter firstParam = parameters[0];
        JSParameter lastParam = parameters[parameters.length - 1];
        if (parameters.length > 1) {
            parameterList.getNode().removeRange(firstParam.getNode(), lastParam.getNode());
        }
        String templateFunctionText = "function f(parameters" + typeString + ") {}";
        ASTNode text = JSChangeUtil.createStatementFromTextWithContext(templateFunctionText, (PsiElement)parameterList);
        assert (text != null);
        JSFunction templateFunction = (JSFunction)text.getPsi();
        JSParameterList list = templateFunction.getParameterList();
        assert (list != null);
        lastParam.replace((PsiElement)list.getParameters()[0]);
    }

    @NotNull
    private static String getNewParameterType(@NotNull JSParameterList parameterList, @NotNull JSParameter[] parameters) {
        if (parameterList == null) {
            JSConvertParametersToObjectIntention.$$$reportNull$$$0(10);
        }
        if (parameters == null) {
            JSConvertParametersToObjectIntention.$$$reportNull$$$0(11);
        }
        String newCompositeParameterType = null;
        DialectOptionHolder holder = DialectDetector.dialectOfElement((PsiElement)parameterList);
        if (holder != null && holder.isTypeScript) {
            newCompositeParameterType = StringUtil.join((Object[])parameters, parameter -> {
                if (parameterList == null) {
                    JSConvertParametersToObjectIntention.$$$reportNull$$$0(24);
                }
                JSType type = parameter.getType();
                String name = parameter.getName();
                return name + ": " + (type != null ? type.getTypeText(JSType.TypeTextFormat.CODE) : JSClassUtils.getAnyTypeString((PsiElement)parameterList, true));
            }, (String)", ");
        }
        String string = StringUtil.isEmpty(newCompositeParameterType) ? "" : ": { " + newCompositeParameterType + " }";
        if (string == null) {
            JSConvertParametersToObjectIntention.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static boolean fillFunctionUsagesWithProgress(@NotNull PsiElement invocationElement, @NotNull JSFunction function, @Nullable JSNamedElement funcRef, @NotNull List<JSCallExpression> callExpressions) {
        PsiElement funcGrandParent;
        PsiElement funcParent;
        if (invocationElement == null) {
            JSConvertParametersToObjectIntention.$$$reportNull$$$0(13);
        }
        if (function == null) {
            JSConvertParametersToObjectIntention.$$$reportNull$$$0(14);
        }
        if (callExpressions == null) {
            JSConvertParametersToObjectIntention.$$$reportNull$$$0(15);
        }
        if ((funcParent = function.getParent()) instanceof JSCallExpression) {
            callExpressions.add((JSCallExpression)funcParent);
        }
        if (funcParent instanceof JSParenthesizedExpression && (funcGrandParent = funcParent.getParent()) instanceof JSCallExpression) {
            callExpressions.add((JSCallExpression)funcGrandParent);
        }
        if (funcRef != null) {
            return ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                if (callExpressions == null) {
                    JSConvertParametersToObjectIntention.$$$reportNull$$$0(22);
                }
                ApplicationManager.getApplication().runReadAction(() -> {
                    if (callExpressions == null) {
                        JSConvertParametersToObjectIntention.$$$reportNull$$$0(23);
                    }
                    for (PsiReference reference : ReferencesSearch.search((PsiElement)funcRef).findAll()) {
                        PsiElement referenceElement = reference.getElement();
                        PsiElement parent = referenceElement.getParent();
                        if (!(parent instanceof JSCallExpression)) continue;
                        callExpressions.add((JSCallExpression)parent);
                    }
                });
            }, "Find Usages", true, invocationElement.getProject());
        }
        return true;
    }

    private static boolean isSimpleParameter(JSParameterListElement p) {
        JSParameter simpleParameter = (JSParameter)ObjectUtils.tryCast((Object)p, JSParameter.class);
        if (simpleParameter == null) {
            return false;
        }
        return !simpleParameter.isRest() && !TypeScriptPsiUtil.isFieldParameter(simpleParameter);
    }

    @NotNull
    private static String wrapArgumentsWithObjectLiteral(@NotNull JSParameter[] parameters, @NotNull JSExpression[] arguments, int argToReplaceCount) {
        if (parameters == null) {
            JSConvertParametersToObjectIntention.$$$reportNull$$$0(16);
        }
        if (arguments == null) {
            JSConvertParametersToObjectIntention.$$$reportNull$$$0(17);
        }
        StringBuilder builder = new StringBuilder(argToReplaceCount * 4);
        builder.append("{");
        for (int i = 0; i < argToReplaceCount; ++i) {
            builder.append(parameters[i].getName());
            builder.append(" : ");
            builder.append(arguments[i].getText());
            if (i >= argToReplaceCount - 1) continue;
            builder.append(", ");
        }
        builder.append("}");
        String string = builder.toString();
        if (string == null) {
            JSConvertParametersToObjectIntention.$$$reportNull$$$0(18);
        }
        return string;
    }

    private static void addVariablesInitializationToFunctionBody(@NotNull PsiElement context, @NotNull JSParameter[] parameters, @NotNull JSFunction function) {
        JSSourceElement[] bodies;
        if (context == null) {
            JSConvertParametersToObjectIntention.$$$reportNull$$$0(19);
        }
        if (parameters == null) {
            JSConvertParametersToObjectIntention.$$$reportNull$$$0(20);
        }
        if (function == null) {
            JSConvertParametersToObjectIntention.$$$reportNull$$$0(21);
        }
        if ((bodies = function.getBody()).length != 1) {
            return;
        }
        JSBlockStatement body = (JSBlockStatement)bodies[0];
        PsiElement anchor = body.getFirstChild();
        String variablePrefix = JSChangeUtil.getVariablePrefix(context);
        String semicolon = JSCodeStyleSettings.getSemicolon(function.getContainingFile());
        DialectOptionHolder holder = DialectDetector.dialectOfElement(context);
        if (holder != null && holder.hasFeature(JSLanguageFeature.DESTRUCTURING_ASSIGNMENT) && parameters.length > 1) {
            String joinedParameters = StringUtil.join((Object[])parameters, parameter -> parameter.getName(), (String)", ");
            String variableText = variablePrefix + " { " + joinedParameters + " } = " + PARAMETERS_VARIABLE + semicolon;
            ASTNode decl = JSChangeUtil.createStatementFromTextWithContext(variableText, context);
            body.addAfter(decl.getPsi(), anchor);
        } else {
            for (JSParameter parameter2 : parameters) {
                String parameterName = parameter2.getName();
                String variableText = variablePrefix + " " + parameterName + " = " + PARAMETERS_VARIABLE + "." + parameterName + semicolon;
                ASTNode decl = JSChangeUtil.createStatementFromTextWithContext(variableText, context);
                if (decl == null) {
                    LOGGER.error("Cannot parse statement " + variableText);
                    return;
                }
                anchor = body.addAfter(decl.getPsi(), anchor);
            }
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/JSConvertParametersToObjectIntention";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: 
            case 9: 
            case 11: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = PARAMETERS_VARIABLE;
                break;
            }
            case 7: 
            case 15: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpressions";
                break;
            }
            case 8: 
            case 10: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterList";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invocationElement";
                break;
            }
            case 14: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/JSConvertParametersToObjectIntention";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewParameterType";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapArgumentsWithObjectLiteral";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "replaceArgumentsInCalls";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "replaceParametersInFunctionSignature";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getNewParameterType";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "fillFunctionUsagesWithProgress";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "wrapArgumentsWithObjectLiteral";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addVariablesInitializationToFunctionBody";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "lambda$fillFunctionUsagesWithProgress$3";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$2";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getNewParameterType$1";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "lambda$invoke$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

