/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageDescriptor;
import com.intellij.javascript.nodejs.util.NodePackageField;
import com.intellij.json.JsonFileType;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.linter.JSLinterFileLevelAnnotation;
import com.intellij.lang.javascript.linter.JSLinterUtil;
import com.intellij.lang.javascript.linter.JSNpmLinterState;
import com.intellij.lang.javascript.linter.eslint.EslintConfiguration;
import com.intellij.lang.javascript.linter.eslint.EslintState;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.util.Alarm;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import java.awt.Dimension;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.TimeUnit;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ESLintConfigTranslator {
    private final Project myProject;
    private final VirtualFile myConfig;
    @NotNull
    private EslintState myState;
    private String myError;

    public ESLintConfigTranslator(@NotNull Project project, @NotNull VirtualFile config2) {
        if (project == null) {
            ESLintConfigTranslator.$$$reportNull$$$0(0);
        }
        if (config2 == null) {
            ESLintConfigTranslator.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myConfig = config2;
        this.myState = (EslintState)EslintConfiguration.getInstance(this.myProject).getExtendedState().getState();
    }

    public boolean configureNodeAndPackage(boolean forceSilent) {
        JSLinterFileLevelAnnotation annotation = JSLinterUtil.validateInterpreterAndPackage(this.myProject, "eslint", this.myState);
        if (!ApplicationManager.getApplication().isUnitTestMode() && annotation != null) {
            if (forceSilent ? !this.tryToFindAlternativeEslint() : !this.showEditDialog()) {
                return false;
            }
            annotation = JSLinterUtil.validateInterpreterAndPackage(this.myProject, "eslint", this.myState);
        }
        String prefix = JSBundle.message((String)"javascript.linter.import.translate.config.title", (Object[])new Object[0]) + ": ";
        this.myError = annotation != null ? prefix + annotation.getMessage() : (!Files.exists(ESLintConfigTranslator.executablePath(this.myState), new LinkOption[0]) ? prefix + "Can not find './bin/eslint.js' under eslint package" : null);
        return this.myError == null;
    }

    private boolean tryToFindAlternativeEslint() {
        NodeJsInterpreter interpreter = this.myState.getInterpreterRef().resolve(this.myProject);
        if (interpreter == null || interpreter.validate(this.myProject) != null) {
            return false;
        }
        NodePackage alternativeEslint = new NodePackageDescriptor("eslint").listAvailable(this.myProject, interpreter, null).stream().filter(pack -> pack.isValid()).findFirst().orElse(null);
        if (alternativeEslint == null) {
            return false;
        }
        this.myState = new EslintState.Builder(this.myState).setEslintPackagePath(alternativeEslint.getSystemDependentPath()).build();
        return true;
    }

    public String getError() {
        return this.myError;
    }

    private boolean showEditDialog() {
        NodeJsInterpreterField nodeJsInterpreterField = new NodeJsInterpreterField(this.myProject, false);
        nodeJsInterpreterField.setInterpreter(NodeJsInterpreterManager.getInstance(this.myProject).getDefault());
        NodePackageField eslintPackageField = new NodePackageField(this.myProject, "eslint", () -> nodeJsInterpreterField.getInterpreter());
        final JLabel errorLabel = new JLabel("");
        errorLabel.setFont(UIUtil.getTitledBorderFont());
        String explanationKey = "javascript.linter.import.translate.config.purpose.message";
        JEditorPane explanation = SwingHelper.createHtmlLabel((String)JSBundle.message((String)"javascript.linter.import.translate.config.purpose.message", (Object[])new Object[0]).replace("\n", "<br/>"), null, null);
        JPanel panel = new FormBuilder().setAlignLabelOnRight(true).setHorizontalGap(10).setVerticalGap(4).setFormLeftIndent(10).addComponent((JComponent)explanation).addVerticalGap(4).addLabeledComponent("&Node interpreter:", (JComponent)((Object)nodeJsInterpreterField)).addLabeledComponent(JSBundle.message((String)"eslint.configurable.eslintPackage.label", (Object[])new Object[0]), (JComponent)((Object)eslintPackageField)).addVerticalGap(4).addComponentToRightColumn((JComponent)errorLabel).getPanel();
        JPanel centerPanel = SwingHelper.wrapWithHorizontalStretch((JComponent)panel);
        centerPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        centerPanel.setMinimumSize((Dimension)JBUI.size((int)300, (int)140));
        final DialogBuilder builder = new DialogBuilder();
        builder.setTitle(JSBundle.message((String)"javascript.linter.import.translate.config.title", (Object[])new Object[0]));
        builder.setCenterPanel((JComponent)centerPanel);
        builder.setPreferredFocusComponent((JComponent)((Object)nodeJsInterpreterField));
        builder.setDimensionServiceKey(ESLintConfigTranslator.class.getName());
        final Factory stateFactory = () -> new EslintState.Builder().setInterpreterRef(nodeJsInterpreterField.getInterpreterRef()).setEslintPackagePath(eslintPackageField.getSelected().getSystemDependentPath()).build();
        final Ref adjusted = new Ref((Object)false);
        final Alarm alarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)builder);
        alarm.addRequest(new Runnable(){

            @Override
            public void run() {
                JSLinterFileLevelAnnotation annotation = JSLinterUtil.validateInterpreterAndPackage(ESLintConfigTranslator.this.myProject, "eslint", (JSNpmLinterState)stateFactory.create());
                if (annotation != null) {
                    if (!((Boolean)adjusted.get()).booleanValue()) {
                        SwingHelper.adjustDialogSizeToFitPreferredSize((DialogWrapper)builder.getDialogWrapper());
                        adjusted.set((Object)true);
                    }
                    errorLabel.setText(JSLinterUtil.getRedErrorTextHtml(annotation.getMessage()));
                    builder.setOkActionEnabled(false);
                } else {
                    errorLabel.setText("");
                    builder.setOkActionEnabled(true);
                }
                alarm.addRequest((Runnable)this, 200, ModalityState.any());
            }
        }, 200, ModalityState.any());
        int result = builder.show();
        Disposer.dispose((Disposable)alarm);
        if (result == 0) {
            this.myState = (EslintState)stateFactory.create();
            return true;
        }
        return false;
    }

    @NotNull
    public PsiFile translate() throws ExecutionException {
        String interpreter = JSLanguageServiceUtil.getInterpreterPathIfValid(this.myState.getInterpreterRef().resolve(this.myProject));
        assert (interpreter != null);
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.withCharset(StandardCharsets.UTF_8);
        commandLine.withWorkDirectory(this.myConfig.getParent().getPath());
        commandLine.setExePath(interpreter);
        commandLine.addParameters(new String[]{ESLintConfigTranslator.executablePath(this.myState).toString(), "-c", this.myConfig.getPath(), "--print-config", this.myConfig.getPath()});
        CapturingProcessHandler processHandler = new CapturingProcessHandler(commandLine);
        ProcessOutput processOutput = processHandler.runProcess((int)TimeUnit.SECONDS.toMillis(10L));
        if (processOutput.isTimeout()) {
            this.throwExecutionException("Timeout", null);
        }
        int exitCode = processOutput.getExitCode();
        String stderr = processOutput.getStderr();
        boolean errorIsEmpty = StringUtil.isEmptyOrSpaces((String)stderr);
        if (exitCode != 0 || !errorIsEmpty) {
            this.throwExecutionException("Error", errorIsEmpty ? processOutput.getStdout() : stderr);
        }
        PsiFile psiFile = (PsiFile)ReadAction.compute(() -> PsiFileFactory.getInstance((Project)this.myProject).createFileFromText(".eslintrc.json", (FileType)JsonFileType.INSTANCE, (CharSequence)processOutput.getStdout()));
        if (psiFile == null) {
            ESLintConfigTranslator.$$$reportNull$$$0(2);
        }
        return psiFile;
    }

    @NotNull
    private static Path executablePath(EslintState state) {
        Path path = Paths.get(state.getEslintPackagePath(), "bin", "eslint.js");
        if (path == null) {
            ESLintConfigTranslator.$$$reportNull$$$0(3);
        }
        return path;
    }

    private void throwExecutionException(@NotNull String reason, @Nullable String details) throws ExecutionException {
        if (reason == null) {
            ESLintConfigTranslator.$$$reportNull$$$0(4);
        }
        String detailsText = StringUtil.isEmptyOrSpaces((String)details) ? "" : ": " + details;
        String error = JsonFileType.INSTANCE.equals(this.myConfig.getFileType()) ? String.format("%s on attempt to find parent and base ESLint configuration files of '%s'%s", reason, this.myConfig.getName(), detailsText) : String.format("%s on attempt to find parent and base ESLint configuration files and convert '%s' to JSON%s", reason, this.myConfig.getName(), detailsText);
        throw new ExecutionException(error);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/ESLintConfigTranslator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/ESLintConfigTranslator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "translate";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "executablePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "throwExecutionException";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

