/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.javascript.JSFileReference;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSModuleNameInfo {
    @Nullable
    private final VirtualFile myModule;
    @NotNull
    private final VirtualFile myResolvedFile;
    @NotNull
    private final String myModuleName;
    @NotNull
    private final String myQuote;

    public JSModuleNameInfo(@Nullable String path, @NotNull VirtualFile module, @NotNull PsiElement context) {
        if (module == null) {
            JSModuleNameInfo.$$$reportNull$$$0(0);
        }
        if (context == null) {
            JSModuleNameInfo.$$$reportNull$$$0(1);
        }
        this(path, module, module, context, true);
    }

    public JSModuleNameInfo(@Nullable String path, @Nullable VirtualFile moduleFileOrDir, @NotNull VirtualFile resolvedFile, @NotNull PsiElement context) {
        if (resolvedFile == null) {
            JSModuleNameInfo.$$$reportNull$$$0(2);
        }
        if (context == null) {
            JSModuleNameInfo.$$$reportNull$$$0(3);
        }
        this(path, moduleFileOrDir, resolvedFile, context, true);
    }

    public JSModuleNameInfo(@Nullable String path, @Nullable VirtualFile moduleFileOrDir, @NotNull VirtualFile resolvedFile, @NotNull PsiElement context, boolean removeExtension) {
        if (resolvedFile == null) {
            JSModuleNameInfo.$$$reportNull$$$0(4);
        }
        if (context == null) {
            JSModuleNameInfo.$$$reportNull$$$0(5);
        }
        this.myQuote = JSCodeStyleSettings.getQuote(context);
        String extension = removeExtension ? JSFileReference.findImplicitExtension(path) : null;
        String externalModuleName = StringUtil.notNullize((String)path);
        if (extension != null) {
            externalModuleName = StringUtil.trimEnd((String)externalModuleName, (String)extension);
        }
        this.myModuleName = externalModuleName;
        this.myModule = moduleFileOrDir;
        this.myResolvedFile = resolvedFile;
    }

    public boolean isValid() {
        return this.getModule() != null && !StringUtil.isEmpty((String)this.myModuleName);
    }

    @NotNull
    public String getModuleName() {
        String string = this.myModuleName;
        if (string == null) {
            JSModuleNameInfo.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public String getPath() {
        String string = this.myQuote + this.getModuleName() + this.myQuote;
        if (string == null) {
            JSModuleNameInfo.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    public VirtualFile getModule() {
        return this.myModule;
    }

    @NotNull
    public VirtualFile getPathFile() {
        VirtualFile virtualFile = this.myResolvedFile;
        if (virtualFile == null) {
            JSModuleNameInfo.$$$reportNull$$$0(8);
        }
        return virtualFile;
    }

    public String toString() {
        return this.getPath();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedFile";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/modules/JSModuleNameInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/modules/JSModuleNameInfo";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

