/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.parsing;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.parsing.ExpressionParser;
import com.intellij.lang.javascript.parsing.JavaScriptParser;
import com.intellij.lang.javascript.parsing.JavaScriptParserBase;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class JSPsiTypeParser<P extends JavaScriptParser>
extends JavaScriptParserBase<P> {
    protected JSPsiTypeParser(P parser) {
        super(parser);
    }

    public boolean parseType() {
        IElementType tokenType = this.builder.getTokenType();
        if (JSDocumentationUtils.ourPrimitiveTypeFilter.contains(tokenType)) {
            this.builder.advanceLexer();
        } else if (!((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).parseQualifiedTypeName()) {
            this.builder.error(this.getTypeNameExpectedMessage());
        }
        return true;
    }

    public boolean tryParseType() {
        if (this.builder.getTokenType() == JSTokenTypes.COLON && this.isECMAL4()) {
            IElementType tokenType;
            this.builder.advanceLexer();
            boolean b = this.parseType();
            if (b && ((tokenType = this.builder.getTokenType()) == JSTokenTypes.QUEST || tokenType == JSTokenTypes.EXCL)) {
                this.builder.advanceLexer();
            }
            return b;
        }
        return false;
    }

    public boolean tryParseArrowFunctionReturnType() {
        return this.tryParseType();
    }

    public boolean tryParseTypeParameterList() {
        return true;
    }

    public boolean tryParseTypeArgumentList(boolean revert) {
        return this.tryParseTypeArgumentList(revert, false);
    }

    public boolean tryParseTypeArgumentList(boolean revert, boolean allowNewLine) {
        return true;
    }

    public boolean parseTypeAliasType() {
        throw new UnsupportedOperationException("Not supported");
    }

    @NotNull
    protected String getTypeNameExpectedMessage() {
        String string = JSBundle.message((String)"javascript.parser.message.expected.typename.or.*", (Object[])new Object[0]);
        if (string == null) {
            JSPsiTypeParser.$$$reportNull$$$0(0);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/parsing/JSPsiTypeParser", "getTypeNameExpectedMessage"));
    }
}

