/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSDestructuringArray;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSDestructuringElement;
import com.intellij.lang.javascript.psi.JSDestructuringObject;
import com.intellij.lang.javascript.psi.JSDestructuringParameter;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.impl.JSDestructuringElementImpl;
import com.intellij.lang.javascript.psi.impl.JSParameterListImpl;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.stubs.impl.JSDestructuringParameterStubImpl;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSParameterTypeDecoratorImpl;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDestructuringParameterImpl
extends JSDestructuringElementImpl<JSDestructuringParameterStubImpl>
implements JSDestructuringParameter,
StubBasedPsiElement<JSDestructuringParameterStubImpl> {
    public JSDestructuringParameterImpl(ASTNode node) {
        super(node);
    }

    public JSDestructuringParameterImpl(JSDestructuringParameterStubImpl stub) {
        super(stub, (IStubElementType)JSStubElementTypes.DESTRUCTURING_PARAMETER);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            JSDestructuringParameterImpl.$$$reportNull$$$0(0);
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSDestructuringElement((JSDestructuringElement)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Nullable
    public String getName() {
        JSDestructuringContainer target = this.getTarget();
        if (target == null) {
            return null;
        }
        return target.getText();
    }

    public boolean isOptional() {
        JSDestructuringParameterStubImpl stub = (JSDestructuringParameterStubImpl)this.getGreenStub();
        if (stub != null) {
            return stub.isOptional();
        }
        return this.getInitializer() != null || this.getNode().findChildByType(JSTokenTypes.QUEST) != null;
    }

    public boolean isRest() {
        JSDestructuringParameterStubImpl parameterStub = (JSDestructuringParameterStubImpl)this.getGreenStub();
        if (parameterStub != null) {
            return parameterStub.isRest();
        }
        return this.getNode().findChildByType(JSTokenTypes.DOT_DOT_DOT) != null;
    }

    @NotNull
    public JSParameterTypeDecorator getTypeDecorator() {
        JSParameterTypeDecoratorImpl jSParameterTypeDecoratorImpl = new JSParameterTypeDecoratorImpl(this.getType(), this.isOptional(), this.isRest(), true);
        if (jSParameterTypeDecoratorImpl == null) {
            JSDestructuringParameterImpl.$$$reportNull$$$0(1);
        }
        return jSParameterTypeDecoratorImpl;
    }

    @Nullable
    public JSType getTypeIncludingOverridden() {
        return this.getType();
    }

    @Override
    @Nullable
    public JSExpression getInitializer() {
        return JSPsiImplUtils.getInitializer(this.getNode());
    }

    @Override
    @Nullable
    public JSType getType() {
        JSType type = super.getType();
        if (type != null) {
            return type;
        }
        return this.buildTypeFromDestructuring();
    }

    @NotNull
    private JSType buildTypeFromDestructuring() {
        JSDestructuringContainer target = this.getTarget();
        Object object = target != null ? JSDestructuringParameterImpl.buildElement(this, (JSElement)target) : JSAnyType.get((PsiElement)this, true);
        if (object == null) {
            JSDestructuringParameterImpl.$$$reportNull$$$0(2);
        }
        return object;
    }

    @Nullable
    public JSElement getDeclarationElement() {
        return this.getTarget();
    }

    private static JSType buildDestructuringObject(@NotNull JSElement context, @NotNull JSDestructuringObject object) {
        if (context == null) {
            JSDestructuringParameterImpl.$$$reportNull$$$0(3);
        }
        if (object == null) {
            JSDestructuringParameterImpl.$$$reportNull$$$0(4);
        }
        ArrayList member = ContainerUtil.newArrayList();
        for (JSDestructuringProperty property : object.getProperties()) {
            String name = property.getName();
            if (StringUtil.isEmpty((String)name)) continue;
            JSInitializerOwner element = property.getDestructuringElement();
            JSType type = JSDestructuringParameterImpl.buildElement(context, (JSElement)element);
            boolean optional = element == null || element.getInitializer() != null;
            member.add(new JSRecordTypeImpl.PropertySignatureImpl(name, type, optional |= element instanceof JSParameter && ((JSParameter)element).isOptional()));
        }
        return new JSRecordTypeImpl(JSTypeSourceFactory.createTypeSource((PsiElement)object, true), member);
    }

    @NotNull
    private static JSType buildElement(@NotNull JSElement context, @Nullable JSElement element) {
        JSType elementType;
        if (context == null) {
            JSDestructuringParameterImpl.$$$reportNull$$$0(5);
        }
        if (element instanceof JSDestructuringObject) {
            JSType jSType = JSDestructuringParameterImpl.buildDestructuringObject(context, (JSDestructuringObject)element);
            if (jSType == null) {
                JSDestructuringParameterImpl.$$$reportNull$$$0(6);
            }
            return jSType;
        }
        if (element instanceof JSDestructuringArray) {
            JSType jSType = JSDestructuringParameterImpl.buildDestructuringArray(context, (JSDestructuringArray)element);
            if (jSType == null) {
                JSDestructuringParameterImpl.$$$reportNull$$$0(7);
            }
            return jSType;
        }
        if (element instanceof JSParameter && !DialectDetector.isTypeScript((PsiElement)context) && (elementType = ((JSParameter)element).getType()) != null) {
            JSType jSType = elementType;
            if (jSType == null) {
                JSDestructuringParameterImpl.$$$reportNull$$$0(8);
            }
            return jSType;
        }
        JSAnyType jSAnyType = JSAnyType.get((PsiElement)context, true);
        if (jSAnyType == null) {
            JSDestructuringParameterImpl.$$$reportNull$$$0(9);
        }
        return jSAnyType;
    }

    private static JSType buildDestructuringArray(@NotNull JSElement context, @NotNull JSDestructuringArray element) {
        if (context == null) {
            JSDestructuringParameterImpl.$$$reportNull$$$0(10);
        }
        if (element == null) {
            JSDestructuringParameterImpl.$$$reportNull$$$0(11);
        }
        JSInitializerOwner[] elements = element.getElements();
        List<JSTypeUtils.TypeProvider> providers = Arrays.stream(elements).filter(el -> el != null).map(el -> {
            if (context == null) {
                JSDestructuringParameterImpl.$$$reportNull$$$0(12);
            }
            return () -> {
                if (context == null) {
                    JSDestructuringParameterImpl.$$$reportNull$$$0(13);
                }
                return JSDestructuringParameterImpl.buildElement(context, (JSElement)el);
            };
        }).collect(Collectors.toList());
        JSType commonType = JSTypeUtils.getCommonType(providers, (PsiElement)context, true);
        return new JSArrayTypeImpl(commonType, JSTypeSourceFactory.createTypeSource((PsiElement)element, true));
    }

    @Override
    public void delete() throws IncorrectOperationException {
        if (!JSParameterListImpl.handleChildDeletion((JSParameterListElement)this)) {
            super.delete();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/impl/JSDestructuringParameterImpl";
                break;
            }
            case 3: 
            case 5: 
            case 10: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSDestructuringParameterImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeDecorator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTypeFromDestructuring";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "buildElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "buildDestructuringObject";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "buildElement";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "buildDestructuringArray";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$buildDestructuringArray$2";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

