/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSEvaluableType;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSParameterTypeDecoratorImpl;
import com.intellij.lang.javascript.psi.types.JSRecordMemberSourceFactory;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSCompositeTypeImpl
extends JSCompositeTypeBaseImpl
implements JSUnionType {
    private boolean myIsOptimized;
    public static final int TYPES_NUMBER_LIMIT = 5;
    public static final Comparator<JSType> GENERIC_PARAMETER_LAST = (o1, o2) -> {
        if (o1 instanceof JSUndefinedType) {
            return o2 instanceof JSUndefinedType ? 0 : 1;
        }
        if (o2 instanceof JSUndefinedType) {
            return -1;
        }
        if (o1 instanceof JSNullType) {
            return o2 instanceof JSNullType ? 0 : 1;
        }
        if (o2 instanceof JSNullType) {
            return -1;
        }
        if (o1 instanceof JSGenericParameterImpl) {
            return o2 instanceof JSGenericParameterImpl ? 0 : 1;
        }
        if (o2 instanceof JSGenericParameterImpl) {
            return -1;
        }
        return 0;
    };

    @Contract(value="!null -> !null")
    public static JSType optimizeTypeIfComposite(@Nullable JSType currentType) {
        return JSCompositeTypeImpl.optimizeTypeIfComposite(currentType, true, false);
    }

    @Contract(value="!null,_ -> !null")
    public static JSType optimizeTypeIfComposite(@Nullable JSType currentType, boolean allowResolve) {
        return JSCompositeTypeImpl.optimizeTypeIfComposite(currentType, allowResolve, false);
    }

    @NotNull
    private static JSType optimizeTypeForSubstitute(@NotNull JSCompositeTypeImpl currentType) {
        if (currentType == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(0);
        }
        JSType jSType = JSCompositeTypeImpl.optimizeTypeIfComposite(currentType, true, true);
        if (jSType == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(1);
        }
        return jSType;
    }

    @Contract(value="!null,_,_ -> !null")
    private static JSType optimizeTypeIfComposite(@Nullable JSType currentType, boolean allowResolve, boolean removeNullAndUndefinedTypes) {
        List preFilteredTypes;
        if (!(currentType instanceof JSCompositeTypeImpl)) {
            return currentType;
        }
        JSCompositeTypeImpl compositeType = (JSCompositeTypeImpl)currentType;
        if (compositeType.isOptimized()) {
            return compositeType;
        }
        List<JSType> originalNestedTypes = compositeType.getTypes();
        if (originalNestedTypes.isEmpty()) {
            return compositeType;
        }
        Stream<JSType> typeStream = originalNestedTypes.stream().filter(el -> !JSCompositeTypeImpl.isEmptyType(el));
        if (removeNullAndUndefinedTypes || !currentType.getSource().isStrict() || !((JSCompositeTypeImpl)currentType).isTypeScript()) {
            typeStream = typeStream.filter(el -> !JSCompositeTypeImpl.isNullOrUndefinedType(el));
        }
        if ((preFilteredTypes = typeStream.collect(Collectors.toList())).size() == 0) {
            return (JSType)ContainerUtil.getFirstItem(originalNestedTypes);
        }
        if (preFilteredTypes.size() == 1) {
            return (JSType)ContainerUtil.getFirstItem(preFilteredTypes);
        }
        List<JSType> types = JSCompositeTypeImpl.flattenTypes(preFilteredTypes.stream().map(el -> JSCompositeTypeImpl.getTypeOfType(el, allowResolve)).filter(el -> !JSCompositeTypeImpl.isEmptyType(el)), JSCompositeTypeImpl.class);
        if (types.size() == 1) {
            return (JSType)ContainerUtil.getFirstItem(types);
        }
        ArrayList filteredEqualsTypes = ContainerUtil.newArrayList(types);
        HashSet removedTypes = ContainerUtil.newHashSet();
        ProcessingContext context = new ProcessingContext();
        for (JSType fromCompare : types) {
            if (removedTypes.contains(fromCompare)) continue;
            Iterator iterator = filteredEqualsTypes.iterator();
            while (iterator.hasNext()) {
                JSType toCompare = (JSType)iterator.next();
                if (fromCompare == toCompare || !fromCompare.isEquivalentTo(toCompare, context, allowResolve)) continue;
                iterator.remove();
                removedTypes.add(toCompare);
            }
        }
        int filteredSize = filteredEqualsTypes.size();
        if (filteredSize == 1) {
            return (JSType)filteredEqualsTypes.get(0);
        }
        if (filteredSize == originalNestedTypes.size() && !allowResolve) {
            return currentType;
        }
        return new JSCompositeTypeImpl(compositeType.getSource(), allowResolve, filteredEqualsTypes);
    }

    @NotNull
    public static JSType getCommonType(@NotNull JSType type1, @NotNull JSType type2, @Nullable JSTypeSource source, boolean allowResolve) {
        if (type1 == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(2);
        }
        if (type2 == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(3);
        }
        if (type1 == type2) {
            JSType jSType = type1;
            if (jSType == null) {
                JSCompositeTypeImpl.$$$reportNull$$$0(4);
            }
            return jSType;
        }
        if (type1 instanceof JSAnyType) {
            JSType jSType = type1;
            if (jSType == null) {
                JSCompositeTypeImpl.$$$reportNull$$$0(5);
            }
            return jSType;
        }
        if (type2 instanceof JSAnyType) {
            JSType jSType = type2;
            if (jSType == null) {
                JSCompositeTypeImpl.$$$reportNull$$$0(6);
            }
            return jSType;
        }
        if (JSCompositeTypeImpl.isEmptyType(type1) || JSCompositeTypeImpl.isNullOrUndefinedType(type1)) {
            JSType jSType = type2;
            if (jSType == null) {
                JSCompositeTypeImpl.$$$reportNull$$$0(7);
            }
            return jSType;
        }
        if (JSCompositeTypeImpl.isEmptyType(type2) || JSCompositeTypeImpl.isNullOrUndefinedType(type2)) {
            JSType jSType = type1;
            if (jSType == null) {
                JSCompositeTypeImpl.$$$reportNull$$$0(8);
            }
            return jSType;
        }
        if (!allowResolve && type1 instanceof JSNamedType && type2 instanceof JSNamedType && type1.getTypeText().equals(type2.getTypeText())) {
            JSType jSType = type1;
            if (jSType == null) {
                JSCompositeTypeImpl.$$$reportNull$$$0(9);
            }
            return jSType;
        }
        List<JSType> allCommonTypes = JSCompositeTypeImpl.flattenTypes(Stream.of(type1, type2), JSCompositeTypeImpl.class);
        if (source == null) {
            source = type1 instanceof JSCompositeTypeImpl || !(type2 instanceof JSCompositeTypeImpl) ? type1.getSource() : type2.getSource();
        }
        JSType jSType = JSCompositeTypeImpl.getCommonType(allCommonTypes, source, allowResolve);
        if (jSType == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(10);
        }
        return jSType;
    }

    @NotNull
    public static JSType getCommonType(@NotNull Collection<JSType> allCommonTypes, @NotNull JSTypeSource source, boolean allowResolve) {
        if (allCommonTypes == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(11);
        }
        if (source == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(12);
        }
        ArrayList result = ContainerUtil.newArrayList();
        List<JSType> flattenTypes = JSCompositeTypeImpl.flattenTypes(allCommonTypes.stream(), JSCompositeTypeImpl.class);
        for (JSType currentType : flattenTypes) {
            if (currentType instanceof JSAnyType) {
                JSType jSType = currentType;
                if (jSType == null) {
                    JSCompositeTypeImpl.$$$reportNull$$$0(13);
                }
                return jSType;
            }
            if (JSCompositeTypeImpl.isEmptyType(currentType) || JSCompositeTypeImpl.isNullOrUndefinedType(currentType) && !source.isTypeScript()) continue;
            boolean add = true;
            for (JSType resultedType : result) {
                if (!currentType.isEquivalentTo(resultedType, null, allowResolve)) continue;
                add = false;
                break;
            }
            if (!add) continue;
            result.add(currentType);
        }
        if (result.size() == 1) {
            JSType jSType = (JSType)ContainerUtil.getFirstItem((Collection)result, null);
            if (jSType == null) {
                JSCompositeTypeImpl.$$$reportNull$$$0(14);
            }
            return jSType;
        }
        JSCompositeTypeImpl jSCompositeTypeImpl = new JSCompositeTypeImpl(source, result);
        if (jSCompositeTypeImpl == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(15);
        }
        return jSCompositeTypeImpl;
    }

    @NotNull
    private static JSType getTypeOfType(JSType type, boolean allowResolve) {
        if (!allowResolve) {
            JSType jSType = type;
            if (jSType == null) {
                JSCompositeTypeImpl.$$$reportNull$$$0(16);
            }
            return jSType;
        }
        JSType jSType = type instanceof JSEvaluableType ? type.substitute() : type;
        if (jSType == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(17);
        }
        return jSType;
    }

    private JSCompositeTypeImpl(JSTypeSource source, boolean isOptimized, List<JSType> _types) {
        super(source, _types);
        this.myIsOptimized = false;
        this.myIsOptimized = isOptimized;
    }

    public JSCompositeTypeImpl(JSTypeSource source, JSType ... _types) {
        super(source, _types);
        this.myIsOptimized = false;
    }

    public JSCompositeTypeImpl(@NotNull JSTypeSource source, List<JSType> _types) {
        if (source == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(18);
        }
        super(source, _types);
        this.myIsOptimized = false;
    }

    @Override
    @NotNull
    protected String getTypeSeparator() {
        if ("|" == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(19);
        }
        return "|";
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        TypeScriptEnum enumDeclaration;
        JSResolvedTypeInfo resolvedType;
        if (elementType == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(20);
        }
        if (this.isEquivalentTo(elementType, processingContext)) {
            return true;
        }
        if (elementType instanceof JSCompositeTypeImpl && this.isTypeScript()) {
            return JSTypeCastUtil.checkAssignableComposite(this, (JSCompositeTypeImpl)elementType, processingContext, this.getSource().isStrict() && elementType.getSource().isStrict());
        }
        if (elementType instanceof JSResolvableType && (resolvedType = ((JSResolvableType)elementType).resolveType()) != null && resolvedType.isEnumWithLiteralValues() && (enumDeclaration = resolvedType.getDeclarationOfType(TypeScriptEnum.class)) != null) {
            JSField[] members = enumDeclaration.getFields();
            ArrayList combinedTypeMembers = ContainerUtil.newArrayListWithCapacity((int)members.length);
            for (JSField member : members) {
                combinedTypeMembers.add(JSNamedType.createType(elementType.getTypeText() + "." + member.getName(), JSTypeSourceFactory.createTypeSource((PsiElement)member, true), JSTypeContext.INSTANCE, false));
            }
            if (combinedTypeMembers.size() > 0 && this.isDirectlyAssignableTypeImpl(new JSCompositeTypeImpl(JSTypeSourceFactory.createTypeSource((PsiElement)enumDeclaration, true), combinedTypeMembers), processingContext)) {
                return true;
            }
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    @Override
    @NotNull
    protected JSTypeCastUtil.AssignableResult isDirectlyAssignableTypeCommon(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        JSTypeCastUtil.AssignableResult common;
        if (elementType == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(21);
        }
        if ((common = super.isDirectlyAssignableTypeCommon(elementType, processingContext)).isStrict()) {
            JSTypeCastUtil.AssignableResult assignableResult = common;
            if (assignableResult == null) {
                JSCompositeTypeImpl.$$$reportNull$$$0(22);
            }
            return assignableResult;
        }
        for (JSType t : this.getTypes()) {
            if (JSCompositeTypeImpl.isEmptyType(t) || JSCompositeTypeImpl.isNullOrUndefinedType(t)) {
                if (!t.isEquivalentTo(elementType, processingContext)) continue;
                JSTypeCastUtil.AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(true);
                if (assignableResult == null) {
                    JSCompositeTypeImpl.$$$reportNull$$$0(23);
                }
                return assignableResult;
            }
            if (!t.isDirectlyAssignableType(elementType, processingContext)) continue;
            JSTypeCastUtil.AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(true);
            if (assignableResult == null) {
                JSCompositeTypeImpl.$$$reportNull$$$0(24);
            }
            return assignableResult;
        }
        JSTypeCastUtil.AssignableResult assignableResult = common;
        if (assignableResult == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(25);
        }
        return assignableResult;
    }

    private boolean isOptimized() {
        return this.myIsOptimized;
    }

    @Override
    @NotNull
    protected JSCompositeTypeImpl createType(@NotNull List<JSType> transformedTypes, @NotNull JSTypeSource newSource) {
        JSType type;
        if (transformedTypes == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(26);
        }
        if (newSource == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(27);
        }
        JSCompositeTypeImpl jSCompositeTypeImpl = (type = JSCompositeTypeImpl.getCommonType(transformedTypes, newSource, false)) instanceof JSCompositeTypeImpl ? (JSCompositeTypeImpl)type : new JSCompositeTypeImpl(newSource, type);
        if (jSCompositeTypeImpl == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(28);
        }
        return jSCompositeTypeImpl;
    }

    @Override
    @NotNull
    public JSType substitute() {
        JSType result = this.getSimpleCompositeTypeResult();
        if (result != null) {
            JSType jSType = result;
            if (jSType == null) {
                JSCompositeTypeImpl.$$$reportNull$$$0(29);
            }
            return jSType;
        }
        JSType rawTypeToProcess = JSCompositeTypeImpl.optimizeTypeForSubstitute(this);
        if (!(rawTypeToProcess instanceof JSCompositeTypeImpl)) {
            JSType jSType = rawTypeToProcess;
            if (jSType == null) {
                JSCompositeTypeImpl.$$$reportNull$$$0(30);
            }
            return jSType;
        }
        JSCompositeTypeImpl typeToProcess = (JSCompositeTypeImpl)rawTypeToProcess;
        Collection<JSRecordType> resolvedTypes = typeToProcess.getNestedTypesAsRecordType();
        if (resolvedTypes.isEmpty()) {
            JSAnyType jSAnyType = JSAnyType.get(this.getSource().getSourceElement(), this.getSource().isStrict());
            if (jSAnyType == null) {
                JSCompositeTypeImpl.$$$reportNull$$$0(31);
            }
            return jSAnyType;
        }
        JSRecordType item = (JSRecordType)ContainerUtil.getFirstItem(resolvedTypes);
        resolvedTypes.remove(item);
        assert (item != null);
        ArrayList resultMembers = ContainerUtil.newArrayList();
        for (JSRecordType.TypeMember member : item.getTypeMembers()) {
            if (member instanceof JSRecordType.PropertySignature) {
                this.addCommonPropertyMember(resolvedTypes, resultMembers, (JSRecordType.PropertySignature)member);
                continue;
            }
            if (!(member instanceof JSRecordType.CallSignature)) continue;
            this.addCommonCallSignatureMember(resolvedTypes, resultMembers, (JSRecordType.CallSignature)member);
        }
        JSRecordTypeImpl jSRecordTypeImpl = new JSRecordTypeImpl(this.getSource(), resultMembers);
        if (jSRecordTypeImpl == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(32);
        }
        return jSRecordTypeImpl;
    }

    private void addCommonCallSignatureMember(@NotNull Collection<JSRecordType> typesToMerge, @NotNull List<JSRecordType.TypeMember> resultMembers, @NotNull JSRecordType.CallSignature currentProperty) {
        if (typesToMerge == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(33);
        }
        if (resultMembers == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(34);
        }
        if (currentProperty == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(35);
        }
        JSFunctionTypeImpl commonType = null;
        PsiElement sourceElement = this.getSource().getSourceElement();
        DialectOptionHolder holder = sourceElement == null ? null : DialectDetector.dialectOfElement(sourceElement);
        JSType currentPropertyRawType = currentProperty.getFunctionType();
        if (!(currentPropertyRawType instanceof JSFunctionTypeImpl)) {
            return;
        }
        for (JSRecordType resolvedType : typesToMerge) {
            Collection<JSFunctionTypeImpl> functionTypes = JSCompositeTypeImpl.getCallSignatureForMerge(resolvedType, currentProperty);
            if (functionTypes.isEmpty()) {
                return;
            }
            JSFunctionTypeImpl currentPropertyType = (JSFunctionTypeImpl)currentPropertyRawType;
            for (JSFunctionTypeImpl type : functionTypes) {
                JSFunctionTypeImpl typeToUse;
                if (type.isEquivalentToImpl(typeToUse = (JSFunctionTypeImpl)((Object)ObjectUtils.coalesce(commonType, (Object)((Object)currentPropertyType))), null, true)) continue;
                List<JSParameterTypeDecorator> parameters = typeToUse.getParameters();
                List<JSParameterTypeDecorator> rParameters = type.getParameters();
                ArrayList resultParameters = ContainerUtil.newArrayList();
                for (int i = 0; i < parameters.size(); ++i) {
                    JSParameterTypeDecorator lDecorator = parameters.get(i);
                    JSParameterTypeDecorator rDecorator = rParameters.get(i);
                    JSType lType = lDecorator.getType();
                    JSType rType = rDecorator.getType();
                    JSType parameterType = JSCompositeTypeImpl.getCommonTypeWithDialect(holder, lType, rType);
                    resultParameters.add(new JSParameterTypeDecoratorImpl(parameterType, lDecorator.isOptional() && rDecorator.isOptional(), lDecorator.isRest() && rDecorator.isRest(), rDecorator.isExplicitlyDeclared() && lDecorator.isExplicitlyDeclared()));
                }
                JSType lReturnType = typeToUse.getReturnType();
                JSType rReturnType = type.getReturnType();
                JSType resultReturn = JSCompositeTypeImpl.getCommonTypeWithDialect(holder, lReturnType, rReturnType);
                commonType = new JSFunctionTypeImpl(typeToUse.getSource(), resultParameters, resultReturn);
            }
        }
        if (commonType == null) {
            resultMembers.add((JSRecordType.TypeMember)currentProperty);
            return;
        }
        resultMembers.add((JSRecordType.TypeMember)new JSRecordTypeImpl.CallSignatureImpl(currentProperty.hasNew(), commonType));
    }

    @Nullable
    private static JSType getCommonTypeWithDialect(@Nullable DialectOptionHolder holder, @Nullable JSType lType, @Nullable JSType rType) {
        JSType parameterType = null;
        if (lType != null && rType != null) {
            parameterType = JSTypeUtils.getCommonType(lType, rType, holder, true);
        }
        return parameterType != null ? parameterType : (lType == null ? rType : lType);
    }

    private void addCommonPropertyMember(@NotNull Collection<JSRecordType> typesToMerge, @NotNull List<JSRecordType.TypeMember> resultMembers, @NotNull JSRecordType.PropertySignature currentProperty) {
        if (typesToMerge == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(36);
        }
        if (resultMembers == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(37);
        }
        if (currentProperty == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(38);
        }
        JSType commonType = null;
        String memberName = currentProperty.getMemberName();
        JSRecordType.MemberSource source = currentProperty.getMemberSource();
        ArrayList allProps = ContainerUtil.newArrayList((Iterable)source.getAllSourceElements());
        for (JSRecordType resolvedType : typesToMerge) {
            Collection<JSRecordType.PropertySignature> signatures = JSCompositeTypeImpl.getPropertiesWithName(resolvedType, memberName);
            if (signatures.isEmpty()) {
                return;
            }
            commonType = this.getCommonPropertyType(signatures, currentProperty, commonType);
            allProps.addAll(signatures.stream().map(s -> s.getMemberSource()).flatMap(s -> s.getAllSourceElements().stream()).collect(Collectors.toList()));
        }
        String name = currentProperty.getMemberName();
        boolean optional = currentProperty.isOptional();
        resultMembers.add((JSRecordType.TypeMember)new JSRecordTypeImpl.PropertySignatureImpl(name, commonType, optional, JSRecordMemberSourceFactory.createSource(allProps, JSRecordType.MemberSourceKind.Union)));
    }

    private static Collection<JSFunctionTypeImpl> getCallSignatureForMerge(@NotNull JSRecordType resolvedType, @NotNull JSRecordType.CallSignature currentProperty) {
        if (resolvedType == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(39);
        }
        if (currentProperty == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(40);
        }
        List result = ContainerUtil.newSmartList();
        JSType functionType = currentProperty.getFunctionType();
        boolean hasNew = currentProperty.hasNew();
        JSFunctionTypeImpl impl = (JSFunctionTypeImpl)((Object)ObjectUtils.tryCast((Object)functionType, JSFunctionTypeImpl.class));
        if (impl == null) {
            return ContainerUtil.emptyList();
        }
        for (JSRecordType.TypeMember member : resolvedType.getTypeMembers()) {
            JSType rFunctionType;
            JSFunctionTypeImpl rImpl;
            if (!(member instanceof JSRecordType.CallSignature) || ((JSRecordType.CallSignature)member).hasNew() != hasNew || (rImpl = (JSFunctionTypeImpl)((Object)ObjectUtils.tryCast((Object)(rFunctionType = ((JSRecordType.CallSignature)member).getFunctionType()), JSFunctionTypeImpl.class))) == null || rImpl.getParameters().size() != impl.getParameters().size()) continue;
            result.add(rImpl);
        }
        return result;
    }

    private static Collection<JSRecordType.PropertySignature> getPropertiesWithName(@NotNull JSRecordType resolvedType, @NotNull String name) {
        if (resolvedType == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(41);
        }
        if (name == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(42);
        }
        return resolvedType.getTypeMembers().stream().filter(el -> {
            if (name == null) {
                JSCompositeTypeImpl.$$$reportNull$$$0(45);
            }
            return el instanceof JSRecordType.PropertySignature && name.equals(((JSRecordType.PropertySignature)el).getMemberName());
        }).map(el -> (JSRecordType.PropertySignature)el).collect(Collectors.toList());
    }

    @Nullable
    private JSType getCommonPropertyType(@NotNull Collection<JSRecordType.PropertySignature> signatures, @NotNull JSRecordType.PropertySignature currentProperty, @Nullable JSType commonType) {
        if (signatures == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(43);
        }
        if (currentProperty == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(44);
        }
        for (JSRecordType.PropertySignature typeMember : signatures) {
            if (currentProperty.isEquivalentTo((JSRecordType.TypeMember)typeMember, true)) {
                return commonType == null ? currentProperty.getType() : commonType;
            }
            PsiElement sourceElement = this.getSource().getSourceElement();
            if (!StringUtil.equals((CharSequence)currentProperty.getMemberName(), (CharSequence)typeMember.getMemberName())) continue;
            JSType type1 = currentProperty.getType();
            JSType type2 = typeMember.getType();
            DialectOptionHolder holder = sourceElement == null ? null : DialectDetector.dialectOfElement(sourceElement);
            JSType typeToUse = (JSType)ObjectUtils.coalesce((Object)commonType, (Object)type1);
            commonType = JSCompositeTypeImpl.getCommonTypeWithDialect(holder, typeToUse, type2);
        }
        return commonType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentType";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSCompositeTypeImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type1";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type2";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allCommonTypes";
                break;
            }
            case 12: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transformedTypes";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSource";
                break;
            }
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typesToMerge";
                break;
            }
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultMembers";
                break;
            }
            case 35: 
            case 38: 
            case 40: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentProperty";
                break;
            }
            case 39: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedType";
                break;
            }
            case 42: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signatures";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSCompositeTypeImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "optimizeTypeForSubstitute";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonType";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeOfType";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSeparator";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "isDirectlyAssignableTypeCommon";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "createType";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "substitute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "optimizeTypeForSubstitute";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                break;
            }
            case 2: 
            case 3: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getCommonType";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeCommon";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createType";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "addCommonCallSignatureMember";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "addCommonPropertyMember";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getCallSignatureForMerge";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getPropertiesWithName";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getCommonPropertyType";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getPropertiesWithName$7";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

