/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSFreshObjectLiteralType;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSParameterTypeDecoratorImpl;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveFunctionType;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSFunctionTypeImpl
extends JSTypeBaseImpl
implements JSType.CompositeStructure {
    @NotNull
    private final List<JSParameterTypeDecorator> myParameters;
    private final JSType myThisType;
    private final JSType myNewType;
    private final JSType myReturnType;

    public JSFunctionTypeImpl(@NotNull JSTypeSource source, @NotNull List<JSParameterTypeDecorator> parameters, @Nullable JSType returnType) {
        if (source == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(0);
        }
        if (parameters == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(1);
        }
        this(source, parameters, returnType, null, null);
    }

    public JSFunctionTypeImpl(@NotNull JSTypeSource source, @NotNull List<JSParameterTypeDecorator> parameters, @Nullable JSType returnType, @Nullable JSType thisType, @Nullable JSType newType) {
        if (source == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(2);
        }
        if (parameters == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(3);
        }
        super(source);
        this.myParameters = Collections.unmodifiableList(parameters);
        this.myReturnType = returnType;
        this.myThisType = thisType;
        this.myNewType = newType;
    }

    @NotNull
    public String getTypeText(JSType.TypeTextFormat format) {
        String string = this.getTypeText(format, true);
        if (string == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    String getTypeText(JSType.TypeTextFormat format, boolean appendKeyword) {
        boolean typeScriptCodeFormat;
        boolean bl = typeScriptCodeFormat = (format == JSType.TypeTextFormat.CODE || format == JSType.TypeTextFormat.PRESENTABLE) && this.isTypeScript();
        if (format == JSType.TypeTextFormat.CODE && this.isEcma()) {
            if ("Function" == null) {
                JSFunctionTypeImpl.$$$reportNull$$$0(5);
            }
            return "Function";
        }
        if (format == JSType.TypeTextFormat.RESOLVED) {
            if ("Function" == null) {
                JSFunctionTypeImpl.$$$reportNull$$$0(6);
            }
            return "Function";
        }
        StringBuilder builder = new StringBuilder();
        if (appendKeyword && !typeScriptCodeFormat) {
            builder.append("function");
        }
        builder.append("(");
        String prefix = "";
        if (this.myThisType != null && !typeScriptCodeFormat) {
            builder.append("this:");
            JSFunctionTypeImpl.appendAndWrapIfNeed(builder, this.myThisType, format);
            prefix = ", ";
        }
        if (this.myNewType != null && !typeScriptCodeFormat) {
            builder.append(prefix);
            builder.append("new:");
            JSFunctionTypeImpl.appendAndWrapIfNeed(builder, this.myNewType, format);
            prefix = ", ";
        }
        int pIndex = 1;
        for (JSParameterTypeDecorator decorator : this.myParameters) {
            JSType parameter = this.getParameterType(decorator, format);
            builder.append(prefix);
            if (typeScriptCodeFormat) {
                if (decorator.isRest()) {
                    builder.append("...");
                }
                builder.append(this.getParameterName(pIndex++));
                if (decorator.isOptional()) {
                    builder.append("?");
                }
                if (parameter == null) {
                    prefix = ", ";
                    continue;
                }
                builder.append(": ");
            }
            if (decorator.isRest()) {
                assert (parameter != null);
                if (typeScriptCodeFormat) {
                    builder.append(parameter.getTypeText(format));
                    builder.append("[]");
                } else {
                    builder.append("...[");
                    builder.append(parameter.getTypeText(format));
                    builder.append("]");
                }
            } else {
                if (parameter == null) {
                    parameter = JSAnyType.get((PsiElement)this.getScope(), false);
                }
                JSFunctionTypeImpl.appendAndWrapIfNeed(builder, parameter, format);
            }
            if (decorator.isOptional() && !typeScriptCodeFormat) {
                builder.append("=");
            }
            prefix = ", ";
        }
        builder.append(")");
        if (this.myReturnType != null) {
            builder.append(typeScriptCodeFormat ? " => " : ": ");
            JSFunctionTypeImpl.appendAndWrapIfNeed(builder, this.myReturnType, format);
        }
        String string = builder.toString();
        if (string == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public List<Pair<String, JSParameterTypeDecorator>> getParametersWithName() {
        ArrayList result = ContainerUtil.newArrayList();
        int i = 1;
        for (JSParameterTypeDecorator decorator : this.getParameters()) {
            result.add(Pair.create((Object)this.getParameterName(i++), (Object)decorator));
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @NotNull
    public List<Pair<String, JSParameterTypeDecorator>> getParametersWithNameOrGenerated() {
        ArrayList result = ContainerUtil.newArrayList();
        int i = 1;
        for (JSParameterTypeDecorator decorator : this.getParameters()) {
            String name = this.getParameterName(i);
            result.add(Pair.create((Object)(!StringUtil.isEmpty((String)name) ? name : "p" + i), (Object)decorator));
            ++i;
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @Nullable
    protected JSType getParameterType(@NotNull JSParameterTypeDecorator decorator, @NotNull JSType.TypeTextFormat format) {
        JSType parameter;
        if (decorator == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(10);
        }
        if (format == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(11);
        }
        if ((parameter = decorator.getType()) == null) {
            parameter = JSAnyType.get((PsiElement)this.getScope(), false);
        }
        return parameter;
    }

    @Nullable
    protected String getParameterName(int index) {
        return null;
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        if (elementType == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(12);
        }
        if (elementType instanceof JSFunctionTypeImpl) {
            JSFunctionTypeImpl functionType = (JSFunctionTypeImpl)elementType;
            if (this.isTypeScript()) {
                JSRecordType recordType = this.asRecordType();
                return recordType.isDirectlyAssignableType(elementType, processingContext);
            }
            if (this.myThisType != null && functionType.myThisType != null && !this.myThisType.isDirectlyAssignableType(functionType.myThisType, processingContext)) {
                return false;
            }
            if (this.myNewType != null && functionType.myNewType != null && !this.myNewType.isDirectlyAssignableType(functionType.myNewType, processingContext)) {
                return false;
            }
            if (this.myReturnType != null && functionType.myReturnType != null && !this.myReturnType.isDirectlyAssignableType(functionType.myReturnType, processingContext)) {
                return false;
            }
            return JSTypeUtils.areArgumentsAssignable(functionType.getParameters(), this.getParameters(), processingContext, true, true, false);
        }
        if (elementType instanceof JSRecordType) {
            JSRecordType recordType = (JSRecordType)elementType;
            for (JSRecordType.TypeMember typeMember : recordType.getTypeMembers()) {
                if (!(typeMember instanceof JSRecordType.CallSignature) || ((JSRecordType.CallSignature)typeMember).hasNew() || !this.isDirectlyAssignableType(((JSRecordType.CallSignature)typeMember).getFunctionType(), processingContext)) continue;
                return true;
            }
            return false;
        }
        if (elementType instanceof JSTypeImpl || elementType instanceof JSGenericTypeImpl) {
            JSType resolvedElementType;
            if (elementType instanceof JSTypeImpl && ((JSTypeImpl)elementType).inheritsFunction()) {
                return true;
            }
            if (this.isTypeScript() && (resolvedElementType = elementType.substitute()) != elementType) {
                return this.isDirectlyAssignableType(resolvedElementType, processingContext);
            }
        } else if (elementType instanceof JSPrimitiveFunctionType || elementType instanceof JSNullType) {
            return true;
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    private static void appendAndWrapIfNeed(@NotNull StringBuilder builder, @NotNull JSType type, @NotNull JSType.TypeTextFormat format) {
        boolean isNeedWrap;
        if (builder == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(13);
        }
        if (type == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(14);
        }
        if (format == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(15);
        }
        if (isNeedWrap = type instanceof JSUnionOrIntersectionType) {
            builder.append("(");
        }
        builder.append(type.getTypeText(format));
        if (isNeedWrap) {
            builder.append(")");
        }
    }

    @Override
    public boolean isEquivalentToImpl(@NotNull JSType type, ProcessingContext processingContext, boolean allowResolve) {
        if (type == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(16);
        }
        if (type instanceof JSFunctionTypeImpl) {
            JSFunctionTypeImpl functionType = (JSFunctionTypeImpl)type;
            if (this.myThisType != null && !this.myThisType.isEquivalentTo(functionType.getThisType(), processingContext, allowResolve)) {
                return false;
            }
            if (this.myNewType != null && !this.myNewType.isEquivalentTo(functionType.getNewType(), processingContext, allowResolve)) {
                return false;
            }
            if (this.myReturnType != null && !this.myReturnType.isEquivalentTo(functionType.getReturnType(), processingContext, allowResolve)) {
                return false;
            }
            Iterator<JSParameterTypeDecorator> iterator = functionType.getParameters().iterator();
            for (JSParameterTypeDecorator p : this.getParameters()) {
                if (!iterator.hasNext()) {
                    return false;
                }
                JSParameterTypeDecorator next = iterator.next();
                JSType paramType = p.getType();
                if (p.isOptional() == next.isOptional() && p.isRest() == next.isRest() && p.isExplicitlyDeclared() == next.isExplicitlyDeclared() && (paramType != null || next.getType() == null) && (paramType == null || paramType.isEquivalentTo(next.getType(), processingContext, allowResolve))) continue;
                return false;
            }
            return !iterator.hasNext();
        }
        return false;
    }

    @NotNull
    public List<JSParameterTypeDecorator> getParameters() {
        List<JSParameterTypeDecorator> list = this.myParameters;
        if (list == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(17);
        }
        return list;
    }

    @Nullable
    public JSType getThisType() {
        return this.myThisType;
    }

    @Nullable
    public JSType getNewType() {
        return this.myNewType;
    }

    @Nullable
    public JSType getReturnType() {
        return this.myReturnType;
    }

    @Override
    public void accept(JSRecursiveTypeVisitor visitor) {
        visitor.visitJSFunctionType((JSType)this);
    }

    @Override
    public void acceptChildren(JSRecursiveTypeVisitor visitor) {
        if (this.myNewType != null) {
            this.myNewType.accept(visitor);
        }
        if (this.myReturnType != null) {
            this.myReturnType.accept(visitor);
        }
        if (this.myThisType != null) {
            this.myThisType.accept(visitor);
        }
        for (JSParameterTypeDecorator parameter : this.myParameters) {
            JSType type = parameter.getType();
            if (type == null) continue;
            type.accept(visitor);
        }
    }

    @Override
    @NotNull
    protected JSType copyTypeHierarchy(@NotNull Function<JSType, JSType> childTransform) {
        if (childTransform == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(18);
        }
        JSType oldNewType = this.getNewType();
        JSType newType = JSTypeUtils.transformTypeHierarchySafe(oldNewType, childTransform);
        JSType oldReturnType = this.getReturnType();
        JSType returnType = JSTypeUtils.transformTypeHierarchySafe(oldReturnType, childTransform);
        JSType oldThis = this.getThisType();
        JSType thisType = JSTypeUtils.transformTypeHierarchySafe(oldThis, childTransform);
        boolean hasChangedParameterDecorator = false;
        ArrayList<JSParameterTypeDecorator> newParameters = new ArrayList<JSParameterTypeDecorator>();
        for (JSParameterTypeDecorator p : this.getParameters()) {
            JSType newParamType;
            JSType oldParamType = p.getType();
            if (oldParamType == (newParamType = JSTypeUtils.transformTypeHierarchySafe(oldParamType, childTransform))) {
                newParameters.add(p);
                continue;
            }
            newParameters.add(new JSParameterTypeDecoratorImpl(newParamType, p.isOptional(), p.isRest(), p.isExplicitlyDeclared()));
            hasChangedParameterDecorator = true;
        }
        if (!hasChangedParameterDecorator && oldNewType == newType && oldReturnType == returnType && oldThis == thisType) {
            JSFunctionTypeImpl jSFunctionTypeImpl = this;
            if (jSFunctionTypeImpl == null) {
                JSFunctionTypeImpl.$$$reportNull$$$0(19);
            }
            return jSFunctionTypeImpl;
        }
        if (returnType instanceof JSFreshObjectLiteralType) {
            returnType = ((JSFreshObjectLiteralType)returnType).removeFreshness();
        }
        JSFunctionTypeImpl jSFunctionTypeImpl = this.createType(this.getSource(), newType, returnType, thisType, newParameters);
        if (jSFunctionTypeImpl == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(20);
        }
        return jSFunctionTypeImpl;
    }

    @NotNull
    protected JSFunctionTypeImpl createType(@NotNull JSTypeSource newSource, JSType newType, JSType returnType, JSType thisType, ArrayList<JSParameterTypeDecorator> newParameters) {
        if (newSource == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(21);
        }
        JSFunctionTypeImpl jSFunctionTypeImpl = new JSFunctionTypeImpl(newSource, newParameters, returnType, thisType, newType);
        if (jSFunctionTypeImpl == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(22);
        }
        return jSFunctionTypeImpl;
    }

    @Override
    @NotNull
    protected JSType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(23);
        }
        JSFunctionTypeImpl jSFunctionTypeImpl = new JSFunctionTypeImpl(source, this.getParameters(), this.getReturnType(), this.getThisType(), this.getNewType());
        if (jSFunctionTypeImpl == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(24);
        }
        return jSFunctionTypeImpl;
    }

    @Override
    @NotNull
    protected JSRecordType asRecordTypeNoCache() {
        JSRecordTypeImpl.CallSignatureImpl callSignature = new JSRecordTypeImpl.CallSignatureImpl(false, this);
        JSRecordTypeImpl jSRecordTypeImpl = new JSRecordTypeImpl(this.getSource(), Collections.singletonList(callSignature));
        if (jSRecordTypeImpl == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(25);
        }
        return jSRecordTypeImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSFunctionTypeImpl";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decorator";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childTransform";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSFunctionTypeImpl";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getParametersWithName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getParametersWithNameOrGenerated";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "copyTypeHierarchy";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createType";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithNewSource";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "asRecordTypeNoCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 25: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getParameterType";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "appendAndWrapIfNeed";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToImpl";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "copyTypeHierarchy";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createType";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

