/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSCompositeFunctionPropertySignatureImpl;
import com.intellij.lang.javascript.psi.types.JSFreshObjectLiteralType;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSRecordMemberSourceFactory;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeComparingCache;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.lang.javascript.psi.types.primitives.JSObjectType;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSRecordTypeImpl
extends JSTypeBaseImpl
implements JSRecordType,
JSType.CompositeStructure {
    @NotNull
    private final List<JSRecordType.TypeMember> myTypeMembers;

    public JSRecordTypeImpl(@NotNull JSTypeSource source, @NotNull List<JSRecordType.TypeMember> typeMembers) {
        if (source == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(0);
        }
        if (typeMembers == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(1);
        }
        this(source, typeMembers, true);
    }

    public JSRecordTypeImpl(@NotNull JSTypeSource source, @NotNull List<JSRecordType.TypeMember> typeMembers, boolean removeFreshness) {
        if (source == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(2);
        }
        if (typeMembers == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(3);
        }
        super(source);
        THashMap overloads = new THashMap();
        boolean hasOverloads = false;
        for (JSRecordType.TypeMember member : typeMembers) {
            if (!(member instanceof JSRecordType.PropertySignature)) continue;
            JSRecordType.PropertySignature propertySignature = (JSRecordType.PropertySignature)member;
            String name = propertySignature.getMemberName();
            List addedWithSameName = (List)overloads.get(name);
            if (addedWithSameName == null) {
                overloads.put(name, new SmartList((Object)propertySignature));
                continue;
            }
            hasOverloads = true;
            addedWithSameName.add(propertySignature);
        }
        if (removeFreshness) {
            typeMembers = JSRecordTypeImpl.removeFreshnessIfNeeded(typeMembers);
        }
        if (hasOverloads) {
            List<JSRecordType.TypeMember> newTypeMembers = JSRecordTypeImpl.collectMergedMembers(source, typeMembers, (Map<String, List<JSRecordType.PropertySignature>>)overloads);
            this.myTypeMembers = Collections.unmodifiableList(newTypeMembers);
        } else {
            this.myTypeMembers = Collections.unmodifiableList(typeMembers);
        }
    }

    @NotNull
    private static List<JSRecordType.TypeMember> removeFreshnessIfNeeded(@NotNull List<JSRecordType.TypeMember> typeMembers) {
        if (typeMembers == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(4);
        }
        ArrayList<JSRecordType.TypeMember> newTypeMembers = new ArrayList<JSRecordType.TypeMember>(typeMembers.size());
        for (JSRecordType.TypeMember member : typeMembers) {
            JSRecordType.PropertySignature propertySignature;
            JSType propertySignatureType;
            if (member instanceof JSRecordType.PropertySignature && (propertySignatureType = (propertySignature = (JSRecordType.PropertySignature)member).getType()) instanceof JSFreshObjectLiteralType) {
                newTypeMembers.add((JSRecordType.TypeMember)new PropertySignatureImpl(propertySignature.getMemberName(), (JSType)((JSFreshObjectLiteralType)propertySignatureType).removeFreshness(), propertySignature.isOptional(), member.getMemberSource()));
                continue;
            }
            newTypeMembers.add(member);
        }
        ArrayList<JSRecordType.TypeMember> arrayList = newTypeMembers;
        if (arrayList == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @NotNull
    private static List<JSRecordType.TypeMember> collectMergedMembers(@NotNull JSTypeSource source, @NotNull List<JSRecordType.TypeMember> typeMembers, @NotNull Map<String, List<JSRecordType.PropertySignature>> overloads) {
        if (source == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(6);
        }
        if (typeMembers == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(7);
        }
        if (overloads == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(8);
        }
        ArrayList<JSRecordType.TypeMember> newTypeMembers = new ArrayList<JSRecordType.TypeMember>(typeMembers.size());
        block0: for (JSRecordType.TypeMember member : typeMembers) {
            if (!(member instanceof JSRecordType.PropertySignature)) {
                newTypeMembers.add(member);
                continue;
            }
            String name = ((JSRecordType.PropertySignature)member).getMemberName();
            List<JSRecordType.PropertySignature> signaturesToMerge = overloads.get(name);
            if (signaturesToMerge == null) continue;
            if (signaturesToMerge.size() == 1) {
                newTypeMembers.add((JSRecordType.TypeMember)signaturesToMerge.get(0));
                continue;
            }
            ArrayList<JSRecordType.PropertySignature> toMerge = new ArrayList<JSRecordType.PropertySignature>(signaturesToMerge.size());
            boolean isAllMergedSignatureOptional = true;
            for (JSRecordType.PropertySignature signature : signaturesToMerge) {
                JSType type;
                if (!signature.isOptional()) {
                    isAllMergedSignatureOptional = false;
                }
                if (!((type = signature.getType()) instanceof JSFunctionTypeImpl)) {
                    newTypeMembers.add((JSRecordType.TypeMember)signature);
                    continue block0;
                }
                toMerge.add(signature);
            }
            newTypeMembers.add((JSRecordType.TypeMember)new JSCompositeFunctionPropertySignatureImpl(name, toMerge, isAllMergedSignatureOptional, source));
            overloads.remove(name);
        }
        ArrayList<JSRecordType.TypeMember> arrayList = newTypeMembers;
        if (arrayList == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @NotNull
    public String getTypeText(JSType.TypeTextFormat format) {
        StringBuilder builder = new StringBuilder("{");
        String prefix = "";
        boolean useTypeScriptRecordTypeFormat = format == JSType.TypeTextFormat.CODE && this.isTypeScript();
        for (JSRecordType.TypeMember typeMember : this.myTypeMembers) {
            builder.append(prefix);
            if (typeMember instanceof JSRecordType.PropertySignature) {
                JSType propertyType;
                JSRecordType.PropertySignature property = (JSRecordType.PropertySignature)typeMember;
                String name = property.getMemberName();
                String fixedName = JSSymbolUtil.handleSpecialPropertyNames(name, '\"');
                builder.append(fixedName);
                if (property.isOptional()) {
                    builder.append('?');
                }
                if ((propertyType = property.getType()) != null) {
                    builder.append(": ");
                    boolean appendBrackets = JSTypeUtils.isNeedWrapTypeForSerialization(propertyType);
                    if (appendBrackets) {
                        builder.append("(");
                    }
                    builder.append(propertyType.getTypeText(format));
                    if (appendBrackets) {
                        builder.append(")");
                    }
                }
            } else if (typeMember instanceof JSRecordType.CallSignature) {
                JSRecordType.CallSignature call = (JSRecordType.CallSignature)typeMember;
                if (call.hasNew()) {
                    builder.append("new");
                }
                builder.append(((JSFunctionTypeImpl)call.getFunctionType()).getTypeText(format, false));
            } else if (typeMember instanceof JSRecordType.IndexSignature) {
                JSRecordType.IndexSignature indexSignature = (JSRecordType.IndexSignature)typeMember;
                if (format == JSType.TypeTextFormat.SERIALIZED) {
                    builder.append("#idx(");
                }
                builder.append("[");
                if (format != JSType.TypeTextFormat.SERIALIZED) {
                    builder.append("p: ");
                }
                builder.append(indexSignature.getMemberParameterType().getTypeText(format));
                builder.append("]");
                builder.append(": ");
                builder.append(indexSignature.getMemberType().getTypeText(format));
                if (format == JSType.TypeTextFormat.SERIALIZED) {
                    builder.append(")");
                }
            }
            prefix = useTypeScriptRecordTypeFormat ? "; " : ", ";
        }
        builder.append("}");
        String string = builder.toString();
        if (string == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        if (elementType == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(11);
        }
        if (this.canSubstitute(elementType)) {
            JSType substitute = elementType.substitute();
            if (elementType != substitute) {
                if (processingContext == null) {
                    processingContext = new ProcessingContext();
                }
                if (JSTypeCastUtil.startRecursiveTypesComparison(this, elementType, processingContext)) {
                    boolean result = this.isDirectlyAssignableType(substitute, processingContext);
                    JSTypeCastUtil.endRecursiveTypesComparison(this, elementType, processingContext);
                    return result;
                }
            }
            elementType = JSRecordTypeImpl.convertToRecordTypeIfPossible(elementType);
        }
        if (elementType instanceof JSArrayType) {
            elementType = JSRecordTypeImpl.convertToRecordTypeIfPossible(((JSArrayType)elementType).asGenericType());
        }
        if (elementType instanceof JSRecordType) {
            return this.isDirectlyAssignableRecordType((JSRecordType)elementType, processingContext);
        }
        if (elementType instanceof JSObjectType) {
            return true;
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    @NotNull
    private static JSType convertToRecordTypeIfPossible(@NotNull JSType elementType) {
        JSRecordType recordTypeCandidate;
        if (elementType == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(12);
        }
        Object object = (recordTypeCandidate = elementType.asRecordType()) == JSTypeCastUtil.NO_RECORD_TYPE ? elementType : recordTypeCandidate;
        if (object == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(13);
        }
        return object;
    }

    protected boolean canSubstitute(@NotNull JSType elementType) {
        if (elementType == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(14);
        }
        if (elementType instanceof JSFunctionTypeImpl) {
            return true;
        }
        return elementType instanceof JSNamedType || elementType instanceof JSGenericTypeImpl;
    }

    private boolean isDirectlyAssignableRecordType(@NotNull JSRecordType recordType, @Nullable ProcessingContext processingContext) {
        boolean subtyping;
        if (recordType == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(15);
        }
        THashMap recTypeProperties = new THashMap(recordType.getTypeMembers().size());
        List callSignatures = null;
        JSRecordType.IndexSignature stringIndexSignature = null;
        JSRecordType.IndexSignature numericIndexSignature = null;
        block8: for (JSRecordType.TypeMember typeMember : recordType.getTypeMembers()) {
            if (typeMember instanceof JSRecordType.CallSignature) {
                if (callSignatures == null) {
                    callSignatures = ContainerUtil.newSmartList();
                }
                callSignatures.add((JSRecordType.CallSignature)typeMember);
                continue;
            }
            if (typeMember instanceof JSRecordType.IndexSignature) {
                switch (((JSRecordType.IndexSignature)typeMember).getIndexSignatureKind()) {
                    case STRING: {
                        stringIndexSignature = (JSRecordType.IndexSignature)typeMember;
                        continue block8;
                    }
                    case NUMERIC: {
                        numericIndexSignature = (JSRecordType.IndexSignature)typeMember;
                        continue block8;
                    }
                }
                continue;
            }
            if (!(typeMember instanceof JSRecordType.PropertySignature)) continue;
            JSRecordTypeImpl.addPropertyToMap((Map<String, List<JSRecordType.PropertySignature>>)recTypeProperties, (JSRecordType.PropertySignature)typeMember);
        }
        JSTypeSource source = recordType.getSource();
        JSUndefinedType undefinedType = null;
        JSRecordType functionRecord = null;
        boolean bl = subtyping = processingContext != null && processingContext.get(JSTypeComparingCache.SUBTYPING_CONTEXT) != null;
        if (subtyping && !this.checkExistingProperties(recordType)) {
            return false;
        }
        for (JSRecordType.TypeMember typeMember : this.getTypeMembers()) {
            if (typeMember instanceof JSRecordType.PropertySignature) {
                String propName = ((JSRecordType.PropertySignature)typeMember).getMemberName();
                List recordPropertyTypes = (List)recTypeProperties.get(propName);
                if (recordPropertyTypes == null && !((JSRecordType.PropertySignature)typeMember).isOptional()) {
                    if (source.getLanguage() == JSTypeSource.SourceLanguage.JS) {
                        if (undefinedType == null) {
                            undefinedType = new JSUndefinedType(source);
                        }
                        if (JSRecordTypeImpl.isUndefinedProperty((JSRecordType.PropertySignature)typeMember, undefinedType, processingContext)) continue;
                    }
                    if (callSignatures != null) {
                        if (functionRecord == null) {
                            functionRecord = TypeScriptUtil.getFunctionTypeMembers(this.getSource().getSourceElement());
                        }
                        if (functionRecord != null && this.checkFunctionInterfaceProperties(processingContext, functionRecord, typeMember)) continue;
                    }
                    return false;
                }
                if (recordPropertyTypes == null || this.checkPropertySignaturesAssignable((JSRecordType.PropertySignature)typeMember, recordPropertyTypes, processingContext)) continue;
                return false;
            }
            if (typeMember instanceof JSRecordType.CallSignature) {
                if (callSignatures == null) {
                    return false;
                }
                if (this.checkCallSignaturesAssignable((JSRecordType.CallSignature)typeMember, callSignatures, processingContext)) continue;
                return false;
            }
            if (!(typeMember instanceof JSRecordType.IndexSignature)) continue;
            switch (((JSRecordType.IndexSignature)typeMember).getIndexSignatureKind()) {
                case STRING: {
                    JSType memberType = ((JSRecordType.IndexSignature)typeMember).getMemberType();
                    if (stringIndexSignature == null || memberType.isDirectlyAssignableType(stringIndexSignature.getMemberType(), processingContext)) break;
                    return false;
                }
                case NUMERIC: {
                    JSType memType = ((JSRecordType.IndexSignature)typeMember).getMemberType();
                    if (numericIndexSignature == null || memType.isDirectlyAssignableType(numericIndexSignature.getMemberType(), processingContext) || stringIndexSignature != null && memType.isDirectlyAssignableType(stringIndexSignature.getMemberType(), processingContext)) break;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean checkExistingProperties(@NotNull JSRecordType type) {
        if (type == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(16);
        }
        Set currentNames = this.getTypeMembers().stream().filter(el -> el instanceof JSRecordType.PropertySignature).map(el -> ((JSRecordType.PropertySignature)el).getMemberName()).collect(Collectors.toSet());
        for (JSRecordType.TypeMember member : type.getTypeMembers()) {
            if (!(member instanceof JSRecordType.PropertySignature) || currentNames.contains(((JSRecordType.PropertySignature)member).getMemberName())) continue;
            return false;
        }
        return true;
    }

    private boolean checkPropertySignaturesAssignable(@NotNull JSRecordType.PropertySignature propertySignature, @NotNull List<JSRecordType.PropertySignature> recordPropertyTypes, @Nullable ProcessingContext processingContext) {
        JSRecordType.PropertySignature recordPropertyTypeMember;
        if (propertySignature == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(17);
        }
        if (recordPropertyTypes == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(18);
        }
        JSType propertyType = propertySignature.getType();
        boolean hasAssignable = false;
        Iterator<JSRecordType.PropertySignature> iterator = recordPropertyTypes.iterator();
        while (iterator.hasNext() && !(hasAssignable = this.checkPropertySignatureAssignable(propertySignature, propertyType, recordPropertyTypeMember = iterator.next(), processingContext))) {
        }
        return hasAssignable;
    }

    private static boolean isUndefinedProperty(@NotNull JSRecordType.PropertySignature typeMember, @NotNull JSType undefinedType, @Nullable ProcessingContext processingContext) {
        JSType propertyType;
        if (typeMember == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(19);
        }
        if (undefinedType == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(20);
        }
        return (propertyType = typeMember.getType()) == null || undefinedType.isDirectlyAssignableType(propertyType, processingContext);
    }

    private boolean checkPropertySignatureAssignable(@NotNull JSRecordType.PropertySignature signature, @Nullable JSType type, @NotNull JSRecordType.PropertySignature otherSignature, @Nullable ProcessingContext processingContext) {
        if (signature == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(21);
        }
        if (otherSignature == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(22);
        }
        if (signature.isEquivalentTo((JSRecordType.TypeMember)otherSignature, false)) {
            return true;
        }
        JSType otherType = otherSignature.getType();
        return this.skipTypeChecking(type) || this.skipTypeChecking(otherType) || type.isDirectlyAssignableType(otherType, processingContext);
    }

    private boolean checkCallSignaturesAssignable(@NotNull JSRecordType.CallSignature typeMember, @NotNull List<JSRecordType.CallSignature> callSignatures, @Nullable ProcessingContext processingContext) {
        if (typeMember == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(23);
        }
        if (callSignatures == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(24);
        }
        for (JSRecordType.CallSignature callSignature : callSignatures) {
            typeMember.isEquivalentTo((JSRecordType.TypeMember)callSignature, false);
        }
        for (JSRecordType.CallSignature callSignature : callSignatures) {
            if (typeMember.hasNew() != callSignature.hasNew()) continue;
            JSFunctionTypeImpl functionType = (JSFunctionTypeImpl)typeMember.getFunctionType();
            JSType returnType = functionType.getReturnType();
            JSFunctionTypeImpl otherFunctionType = (JSFunctionTypeImpl)callSignature.getFunctionType();
            JSType otherReturnType = otherFunctionType.getReturnType();
            if (!this.checkFunctionsArguments(processingContext, functionType, otherFunctionType)) continue;
            if (returnType == null || returnType instanceof JSVoidType) {
                return true;
            }
            boolean oldValue = false;
            if (processingContext != null) {
                oldValue = processingContext.get(JSGenericParameterImpl.CALL_ENV_KEY) == Boolean.TRUE;
                processingContext.put(JSGenericParameterImpl.CALL_ENV_KEY, (Object)true);
            }
            boolean directlyAssignableType = returnType.isDirectlyAssignableType(otherReturnType, processingContext);
            if (processingContext != null) {
                processingContext.put(JSGenericParameterImpl.CALL_ENV_KEY, (Object)(oldValue ? Boolean.valueOf(true) : null));
            }
            if (!directlyAssignableType) continue;
            return true;
        }
        return false;
    }

    private boolean checkFunctionsArguments(@Nullable ProcessingContext processingContext, JSFunctionTypeImpl functionType, JSFunctionTypeImpl otherFunctionType) {
        return JSTypeUtils.areArgumentsAssignable(functionType.getParameters(), otherFunctionType.getParameters(), processingContext, true, !this.isTypeScript(), this.isTypeScript());
    }

    private boolean checkFunctionInterfaceProperties(@Nullable ProcessingContext processingContext, @NotNull JSRecordType functionRecord, @NotNull JSRecordType.TypeMember typeMember) {
        if (functionRecord == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(25);
        }
        if (typeMember == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(26);
        }
        boolean exists = false;
        JSRecordType.PropertySignature propertyWithName = null;
        for (JSRecordType.TypeMember member : functionRecord.getTypeMembers()) {
            JSRecordType.MemberSource source = member.getMemberSource();
            PsiElement memberSource = source.getSingleElement();
            JSRecordType.MemberSource typeMemberSource = typeMember.getMemberSource();
            if (memberSource != null && memberSource.isEquivalentTo(typeMemberSource.getSingleElement()) || typeMember.isEquivalentTo(member, true)) {
                exists = true;
                break;
            }
            if (!(member instanceof JSRecordType.PropertySignature) || !((JSRecordType.PropertySignature)typeMember).getMemberName().equals(((JSRecordType.PropertySignature)member).getMemberName())) continue;
            propertyWithName = (JSRecordType.PropertySignature)member;
        }
        if (!exists && propertyWithName != null) {
            exists = new JSRecordTypeImpl(this.getSource(), ContainerUtil.createMaybeSingletonList((Object)typeMember)).isDirectlyAssignableRecordType(new JSRecordTypeImpl(functionRecord.getSource(), ContainerUtil.createMaybeSingletonList(propertyWithName)), processingContext);
        }
        return exists;
    }

    private static void addPropertyToMap(Map<String, List<JSRecordType.PropertySignature>> recTypeProperties, JSRecordType.PropertySignature typeMember) {
        String name = typeMember.getMemberName();
        List<JSRecordType.PropertySignature> types = recTypeProperties.get(name);
        if (types != null) {
            types.add(typeMember);
        } else {
            recTypeProperties.put(name, ContainerUtil.newSmartList((Object)typeMember));
        }
    }

    @Override
    public boolean isEquivalentToImpl(@NotNull JSType type, ProcessingContext processingContext, boolean allowResolve) {
        if (type == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(27);
        }
        if (!(type instanceof JSRecordType)) {
            return false;
        }
        JSRecordType otherType = (JSRecordType)type;
        List otherMembers = otherType.getTypeMembers();
        List<JSRecordType.TypeMember> members = this.getTypeMembers();
        if (otherMembers.size() != members.size()) {
            return false;
        }
        for (int i = 0; i < members.size(); ++i) {
            JSRecordType.TypeMember member;
            JSRecordType.TypeMember otherMember = (JSRecordType.TypeMember)otherMembers.get(i);
            if (otherMember.isEquivalentTo(member = members.get(i), allowResolve)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public List<JSRecordType.TypeMember> getTypeMembers() {
        List<JSRecordType.TypeMember> list = this.myTypeMembers;
        if (list == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(28);
        }
        return list;
    }

    public boolean hasProperty(String name) {
        for (JSRecordType.TypeMember typeMember : this.myTypeMembers) {
            if (!(typeMember instanceof JSRecordType.PropertySignature) || !name.equals(((JSRecordType.PropertySignature)typeMember).getMemberName())) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public JSRecordType.PropertySignature findPropertySignature(@NotNull String name) {
        if (name == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(29);
        }
        for (JSRecordType.TypeMember typeMember : this.myTypeMembers) {
            if (!(typeMember instanceof JSRecordType.PropertySignature) || !name.equals(((JSRecordType.PropertySignature)typeMember).getMemberName())) continue;
            return (JSRecordType.PropertySignature)typeMember;
        }
        return null;
    }

    @Override
    public void accept(JSRecursiveTypeVisitor visitor) {
        visitor.visitJSRecordType((JSType)this);
    }

    private boolean skipTypeChecking(JSType type) {
        return type == null || this.isTypeScript() && !type.getSource().isStrict();
    }

    @Override
    public void acceptChildren(JSRecursiveTypeVisitor visitor) {
        for (JSRecordType.TypeMember typeMember : this.myTypeMembers) {
            JSType type;
            if (typeMember instanceof JSRecordType.PropertySignature) {
                type = ((JSRecordType.PropertySignature)typeMember).getType();
                if (type == null) continue;
                type.accept(visitor);
                continue;
            }
            if (typeMember instanceof JSRecordType.CallSignature) {
                type = ((JSRecordType.CallSignature)typeMember).getFunctionType();
                type.accept(visitor);
                continue;
            }
            if (!(typeMember instanceof JSRecordType.IndexSignature)) continue;
            JSType parameterType = ((JSRecordType.IndexSignature)typeMember).getMemberParameterType();
            parameterType.accept(visitor);
            JSType type2 = ((JSRecordType.IndexSignature)typeMember).getMemberType();
            type2.accept(visitor);
        }
    }

    @Override
    @NotNull
    protected JSType copyTypeHierarchy(@NotNull Function<JSType, JSType> childTransform) {
        if (childTransform == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(30);
        }
        List<JSRecordType.TypeMember> oldMembers = this.getTypeMembers();
        ArrayList<JSRecordType.TypeMember> newMembers = new ArrayList<JSRecordType.TypeMember>();
        JSTypeSource appliedTypeSource = this.getSource();
        boolean shouldCleanSource = appliedTypeSource.getSourceElement() == null;
        for (JSRecordType.TypeMember member : oldMembers) {
            newMembers.add(member.copyTypeHierarchy(childTransform, shouldCleanSource));
        }
        if (ContainerUtil.equalsIdentity(oldMembers, newMembers)) {
            JSRecordTypeImpl jSRecordTypeImpl = this;
            if (jSRecordTypeImpl == null) {
                JSRecordTypeImpl.$$$reportNull$$$0(31);
            }
            return jSRecordTypeImpl;
        }
        JSRecordTypeImpl jSRecordTypeImpl = new JSRecordTypeImpl(this.getSource(), newMembers);
        if (jSRecordTypeImpl == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(32);
        }
        return jSRecordTypeImpl;
    }

    @NotNull
    public static JSRecordType.CallSignature copyCallSignature(@NotNull JSRecordType.CallSignature callSignature, @NotNull Function<JSType, JSType> childTransform) {
        JSFunctionTypeImpl newType;
        JSType oldType;
        if (callSignature == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(33);
        }
        if (childTransform == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(34);
        }
        if ((oldType = callSignature.getFunctionType()) == (newType = (JSFunctionTypeImpl)JSTypeUtils.transformTypeHierarchySafe(oldType, childTransform))) {
            JSRecordType.CallSignature callSignature2 = callSignature;
            if (callSignature2 == null) {
                JSRecordTypeImpl.$$$reportNull$$$0(35);
            }
            return callSignature2;
        }
        CallSignatureImpl callSignatureImpl = new CallSignatureImpl(callSignature.hasNew(), newType);
        if (callSignatureImpl == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(36);
        }
        return callSignatureImpl;
    }

    @NotNull
    public static JSRecordType.IndexSignature copyIndexSignature(@NotNull JSRecordType.IndexSignature indexSignature, @NotNull Function<JSType, JSType> childTransform, boolean shouldCleanSource) {
        if (indexSignature == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(37);
        }
        if (childTransform == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(38);
        }
        JSType oldMemberParameterType = indexSignature.getMemberParameterType();
        JSType newMemberParameterType = JSTypeUtils.transformTypeHierarchySafe(oldMemberParameterType, childTransform);
        JSType oldType = indexSignature.getMemberType();
        JSType newType = JSTypeUtils.transformTypeHierarchySafe(oldType, childTransform);
        if (!shouldCleanSource && oldMemberParameterType == newMemberParameterType && oldType == newType) {
            JSRecordType.IndexSignature indexSignature2 = indexSignature;
            if (indexSignature2 == null) {
                JSRecordTypeImpl.$$$reportNull$$$0(39);
            }
            return indexSignature2;
        }
        JSRecordType.MemberSource sourceElement = shouldCleanSource ? JSRecordMemberSourceFactory.createEmptySource() : indexSignature.getMemberSource();
        IndexSignatureImpl indexSignatureImpl = new IndexSignatureImpl(newMemberParameterType, newType, sourceElement);
        if (indexSignatureImpl == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(40);
        }
        return indexSignatureImpl;
    }

    @NotNull
    public static JSRecordType.PropertySignature copyPropertySignature(@NotNull JSRecordType.PropertySignature propertySignature, @NotNull Function<JSType, JSType> childTransform, boolean shouldCleanSource) {
        if (propertySignature == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(41);
        }
        if (childTransform == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(42);
        }
        JSType oldType = propertySignature.getType();
        JSType type = JSTypeUtils.transformTypeHierarchySafe(oldType, childTransform);
        if (!shouldCleanSource && oldType == type) {
            JSRecordType.PropertySignature propertySignature2 = propertySignature;
            if (propertySignature2 == null) {
                JSRecordTypeImpl.$$$reportNull$$$0(43);
            }
            return propertySignature2;
        }
        JSRecordType.MemberSource sourceElement = shouldCleanSource ? JSRecordMemberSourceFactory.createEmptySource() : propertySignature.getMemberSource();
        PropertySignatureImpl propertySignatureImpl = new PropertySignatureImpl(propertySignature.getMemberName(), type, propertySignature.isOptional(), sourceElement);
        if (propertySignatureImpl == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(44);
        }
        return propertySignatureImpl;
    }

    @Override
    @NotNull
    protected JSType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(45);
        }
        List<JSRecordType.TypeMember> newMembers = this.getMembersWithNewSource(source);
        JSRecordTypeImpl jSRecordTypeImpl = new JSRecordTypeImpl(source, newMembers);
        if (jSRecordTypeImpl == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(46);
        }
        return jSRecordTypeImpl;
    }

    @NotNull
    protected final List<JSRecordType.TypeMember> getMembersWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(47);
        }
        List<JSRecordType.TypeMember> members = this.getTypeMembers();
        ArrayList newMembers = ContainerUtil.newArrayList();
        for (JSRecordType.TypeMember member : members) {
            JSCompositeFunctionPropertySignatureImpl propertySignature;
            if (member instanceof JSCompositeFunctionPropertySignatureImpl && ((propertySignature = (JSCompositeFunctionPropertySignatureImpl)member).getTypeSource() == JSTypeSource.EMPTY || source == JSTypeSource.EMPTY)) {
                newMembers.add(propertySignature.copyWithNewSource(source));
                continue;
            }
            newMembers.add(member);
        }
        ArrayList arrayList = newMembers;
        if (arrayList == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(48);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public JSRecordType asRecordType() {
        JSRecordTypeImpl jSRecordTypeImpl = this;
        if (jSRecordTypeImpl == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(49);
        }
        return jSRecordTypeImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 13: 
            case 28: 
            case 31: 
            case 32: 
            case 35: 
            case 36: 
            case 39: 
            case 40: 
            case 43: 
            case 44: 
            case 46: 
            case 48: 
            case 49: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 13: 
            case 28: 
            case 31: 
            case 32: 
            case 35: 
            case 36: 
            case 39: 
            case 40: 
            case 43: 
            case 44: 
            case 46: 
            case 48: 
            case 49: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeMembers";
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 13: 
            case 28: 
            case 31: 
            case 32: 
            case 35: 
            case 36: 
            case 39: 
            case 40: 
            case 43: 
            case 44: 
            case 46: 
            case 48: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "overloads";
                break;
            }
            case 11: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recordType";
                break;
            }
            case 16: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 17: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertySignature";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recordPropertyTypes";
                break;
            }
            case 19: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeMember";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "undefinedType";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherSignature";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callSignatures";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionRecord";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 30: 
            case 34: 
            case 38: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childTransform";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callSignature";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexSignature";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "removeFreshnessIfNeeded";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "collectMergedMembers";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeText";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToRecordTypeIfPossible";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeMembers";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "copyTypeHierarchy";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "copyCallSignature";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "copyIndexSignature";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "copyPropertySignature";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithNewSource";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getMembersWithNewSource";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "asRecordType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeFreshnessIfNeeded";
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 13: 
            case 28: 
            case 31: 
            case 32: 
            case 35: 
            case 36: 
            case 39: 
            case 40: 
            case 43: 
            case 44: 
            case 46: 
            case 48: 
            case 49: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "collectMergedMembers";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "convertToRecordTypeIfPossible";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "canSubstitute";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableRecordType";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "checkExistingProperties";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "checkPropertySignaturesAssignable";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isUndefinedProperty";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "checkPropertySignatureAssignable";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "checkCallSignaturesAssignable";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "checkFunctionInterfaceProperties";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToImpl";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "findPropertySignature";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "copyTypeHierarchy";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "copyCallSignature";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "copyIndexSignature";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "copyPropertySignature";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getMembersWithNewSource";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 13: 
            case 28: 
            case 31: 
            case 32: 
            case 35: 
            case 36: 
            case 39: 
            case 40: 
            case 43: 
            case 44: 
            case 46: 
            case 48: 
            case 49: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class PropertySignatureImpl
    implements JSRecordType.PropertySignature {
        @NotNull
        private final String name;
        @Nullable
        private final JSType type;
        private final boolean optional;
        @NotNull
        private JSRecordType.MemberSource mySource;

        public PropertySignatureImpl(@NotNull String name, @Nullable JSType type, boolean optional, @Nullable PsiElement singleSource) {
            if (name == null) {
                PropertySignatureImpl.$$$reportNull$$$0(0);
            }
            this(name, type, optional, JSRecordMemberSourceFactory.createSource(singleSource));
        }

        public PropertySignatureImpl(@NotNull String name, @Nullable JSType type, boolean optional, @NotNull JSRecordType.MemberSource source) {
            if (name == null) {
                PropertySignatureImpl.$$$reportNull$$$0(1);
            }
            if (source == null) {
                PropertySignatureImpl.$$$reportNull$$$0(2);
            }
            this(name, type, optional);
            this.mySource = source;
        }

        public PropertySignatureImpl(@NotNull String name, @Nullable JSType type, boolean optional) {
            if (name == null) {
                PropertySignatureImpl.$$$reportNull$$$0(3);
            }
            this.name = name;
            this.type = type;
            this.optional = optional;
            this.mySource = JSRecordMemberSourceFactory.createEmptySource();
        }

        @NotNull
        public String getMemberName() {
            String string = this.name;
            if (string == null) {
                PropertySignatureImpl.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Nullable
        public JSType getType() {
            return this.type;
        }

        public boolean isOptional() {
            return this.optional;
        }

        public boolean isEquivalentTo(JSRecordType.TypeMember other, boolean allowResolve) {
            return JSRecordType.arePropertySignaturesEqual((JSRecordType.PropertySignature)this, (JSRecordType.TypeMember)other, (boolean)allowResolve);
        }

        @NotNull
        public JSRecordType.MemberSource getMemberSource() {
            JSRecordType.MemberSource memberSource = this.mySource;
            if (memberSource == null) {
                PropertySignatureImpl.$$$reportNull$$$0(5);
            }
            return memberSource;
        }

        @NotNull
        public JSRecordType.PropertySignature copyTypeHierarchy(@NotNull Function<JSType, JSType> childTransform, boolean shouldCleanSourceElement) {
            if (childTransform == null) {
                PropertySignatureImpl.$$$reportNull$$$0(6);
            }
            JSRecordType.PropertySignature propertySignature = JSRecordTypeImpl.copyPropertySignature(this, childTransform, shouldCleanSourceElement);
            if (propertySignature == null) {
                PropertySignatureImpl.$$$reportNull$$$0(7);
            }
            return propertySignature;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 4: 
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl$PropertySignatureImpl";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "childTransform";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl$PropertySignatureImpl";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMemberName";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMemberSource";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "copyTypeHierarchy";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: 
                case 7: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "copyTypeHierarchy";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class IndexSignatureImpl
    implements JSRecordType.IndexSignature {
        @Nullable
        private final JSType parameterType;
        @Nullable
        private final JSType type;
        @NotNull
        private final JSRecordType.MemberSource mySource;

        public IndexSignatureImpl(@Nullable JSType parameterType, @Nullable JSType type, @Nullable PsiElement singleSource) {
            this(parameterType, type, JSRecordMemberSourceFactory.createSource(singleSource));
        }

        public IndexSignatureImpl(@Nullable JSType parameterType, @Nullable JSType type, @NotNull JSRecordType.MemberSource source) {
            if (source == null) {
                IndexSignatureImpl.$$$reportNull$$$0(0);
            }
            this.mySource = source;
            this.parameterType = parameterType;
            this.type = type;
        }

        @NotNull
        public final JSType getMemberParameterType() {
            Object object = this.parameterType != null ? this.parameterType : JSAnyType.get(null, false);
            if (object == null) {
                IndexSignatureImpl.$$$reportNull$$$0(1);
            }
            return object;
        }

        @NotNull
        public JSRecordType.IndexSignatureKind getIndexSignatureKind() {
            JSRecordType.IndexSignatureKind indexSignatureKind = IndexSignatureImpl.getIndexerKindFromType(this.getMemberParameterType());
            if (indexSignatureKind == null) {
                IndexSignatureImpl.$$$reportNull$$$0(2);
            }
            return indexSignatureKind;
        }

        @NotNull
        public final JSType getMemberType() {
            Object object = this.type != null ? this.type : JSAnyType.get(null, false);
            if (object == null) {
                IndexSignatureImpl.$$$reportNull$$$0(3);
            }
            return object;
        }

        public boolean isEquivalentTo(JSRecordType.TypeMember other, boolean allowResolve) {
            return JSRecordType.areIndexSignaturesEqual((JSRecordType.IndexSignature)this, (JSRecordType.TypeMember)other, (boolean)allowResolve);
        }

        @NotNull
        public final JSRecordType.MemberSource getMemberSource() {
            JSRecordType.MemberSource memberSource = this.mySource;
            if (memberSource == null) {
                IndexSignatureImpl.$$$reportNull$$$0(4);
            }
            return memberSource;
        }

        @NotNull
        public final JSRecordType.IndexSignature copyTypeHierarchy(@NotNull Function<JSType, JSType> childTransform, boolean shouldCleanSourceElement) {
            if (childTransform == null) {
                IndexSignatureImpl.$$$reportNull$$$0(5);
            }
            JSRecordType.IndexSignature indexSignature = JSRecordTypeImpl.copyIndexSignature(this, childTransform, shouldCleanSourceElement);
            if (indexSignature == null) {
                IndexSignatureImpl.$$$reportNull$$$0(6);
            }
            return indexSignature;
        }

        @NotNull
        public static JSRecordType.IndexSignatureKind getIndexerKindFromType(@Nullable JSType memberParameterType) {
            if (memberParameterType instanceof JSStringType) {
                JSRecordType.IndexSignatureKind indexSignatureKind = JSRecordType.IndexSignatureKind.STRING;
                if (indexSignatureKind == null) {
                    IndexSignatureImpl.$$$reportNull$$$0(7);
                }
                return indexSignatureKind;
            }
            if (memberParameterType instanceof JSNumberType) {
                JSRecordType.IndexSignatureKind indexSignatureKind = JSRecordType.IndexSignatureKind.NUMERIC;
                if (indexSignatureKind == null) {
                    IndexSignatureImpl.$$$reportNull$$$0(8);
                }
                return indexSignatureKind;
            }
            JSRecordType.IndexSignatureKind indexSignatureKind = JSRecordType.IndexSignatureKind.UNKNOWN;
            if (indexSignatureKind == null) {
                IndexSignatureImpl.$$$reportNull$$$0(9);
            }
            return indexSignatureKind;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl$IndexSignatureImpl";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "childTransform";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl$IndexSignatureImpl";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMemberParameterType";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIndexSignatureKind";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMemberType";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMemberSource";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "copyTypeHierarchy";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIndexerKindFromType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "copyTypeHierarchy";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class CallSignatureImpl
    implements JSRecordType.CallSignature {
        private final boolean hasNew;
        @NotNull
        private final JSFunctionTypeImpl functionType;

        public CallSignatureImpl(boolean hasNew, @NotNull JSFunctionTypeImpl functionType) {
            if (functionType == null) {
                CallSignatureImpl.$$$reportNull$$$0(0);
            }
            this.hasNew = hasNew;
            this.functionType = functionType;
        }

        public boolean hasNew() {
            return this.hasNew;
        }

        @NotNull
        public JSFunctionTypeImpl getFunctionType() {
            JSFunctionTypeImpl jSFunctionTypeImpl = this.functionType;
            if (jSFunctionTypeImpl == null) {
                CallSignatureImpl.$$$reportNull$$$0(1);
            }
            return jSFunctionTypeImpl;
        }

        public boolean isEquivalentTo(JSRecordType.TypeMember other, boolean allowResolve) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof JSRecordType.CallSignature)) {
                return false;
            }
            return JSRecordType.areCallSignaturesEqual((JSRecordType.CallSignature)this, (JSRecordType.TypeMember)other, (boolean)allowResolve);
        }

        @NotNull
        public JSRecordType.MemberSource getMemberSource() {
            JSRecordType.MemberSource memberSource = JSRecordMemberSourceFactory.createSource(this.functionType.getSource().getSourceElement());
            if (memberSource == null) {
                CallSignatureImpl.$$$reportNull$$$0(2);
            }
            return memberSource;
        }

        @NotNull
        public JSRecordType.CallSignature copyTypeHierarchy(@NotNull Function<JSType, JSType> childTransform, boolean shouldCleanSourceElement) {
            if (childTransform == null) {
                CallSignatureImpl.$$$reportNull$$$0(3);
            }
            JSRecordType.CallSignature callSignature = JSRecordTypeImpl.copyCallSignature(this, childTransform);
            if (callSignature == null) {
                CallSignatureImpl.$$$reportNull$$$0(4);
            }
            return callSignature;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "functionType";
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl$CallSignatureImpl";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "childTransform";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl$CallSignatureImpl";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFunctionType";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMemberSource";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "copyTypeHierarchy";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "copyTypeHierarchy";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

