/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSImportHandlingUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeHelper;
import com.intellij.lang.javascript.psi.types.JSFreshObjectLiteralType;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeComparingCache;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeofTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSTypeBaseImpl
extends UserDataHolderBase
implements JSType {
    private static boolean ASSERT_ON_RECORD_TYPE_USAGE = false;
    @NotNull
    private JSTypeSource mySource;

    public static void assertOnRecordTypeUsage(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(0);
        }
        ASSERT_ON_RECORD_TYPE_USAGE = true;
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                ASSERT_ON_RECORD_TYPE_USAGE = false;
            }
        });
    }

    protected JSTypeBaseImpl(@NotNull JSTypeSource source) {
        if (source == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(1);
        }
        this.mySource = source;
    }

    @NotNull
    public String getTypeText() {
        String string = this.getTypeText(JSType.TypeTextFormat.SIMPLE);
        if (string == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getResolvedTypeText() {
        String string = this.getTypeText(JSType.TypeTextFormat.RESOLVED);
        if (string == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public JSTypeSource getSource() {
        JSTypeSource jSTypeSource = this.mySource;
        if (jSTypeSource == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(4);
        }
        return jSTypeSource;
    }

    public final boolean isDirectlyAssignableType(@Nullable JSType elementType, @Nullable ProcessingContext processingContext) {
        JSTypeComparingCache cache;
        if (elementType == this || elementType == null || this.isEquivalentTo(elementType, processingContext, false) || JSTypeCastUtil.isAlwaysAssignableType(elementType, this.isJavaScript() && elementType.getSource().isJavaScript())) {
            return true;
        }
        ProgressManager.checkCanceled();
        JSFreshObjectLiteralType freshType = elementType instanceof JSFreshObjectLiteralType ? (JSFreshObjectLiteralType)elementType : null;
        JSTypeComparingCache jSTypeComparingCache = cache = processingContext == null ? null : (JSTypeComparingCache)processingContext.get(JSTypeComparingCache.TYPE_COMPARATOR);
        if (cache != null) {
            JSTypeCastUtil.AssignableResult assignableResult = cache.areAssignableTypes(this, elementType, processingContext);
            if (assignableResult.isStrict()) {
                boolean result = assignableResult.isAssignable();
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    this.checkCachedValue(elementType, processingContext, result);
                }
                return result;
            }
            if (assignableResult != JSTypeCastUtil.AssignableResult.NO_CACHE) {
                if (freshType != null) {
                    elementType = ((JSFreshObjectLiteralType)elementType).removeFreshness();
                }
                boolean result = this.checkAssignability(elementType, processingContext, freshType);
                cache.putAssignableTypes(this, elementType, processingContext, JSTypeCastUtil.toStrictAssignable(result));
                return result;
            }
        }
        if (freshType != null) {
            elementType = ((JSFreshObjectLiteralType)elementType).removeFreshness();
        }
        return this.checkAssignability(elementType, processingContext, freshType);
    }

    private boolean checkAssignability(@NotNull JSType elementType, @Nullable ProcessingContext processingContext, JSFreshObjectLiteralType freshType) {
        if (elementType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(5);
        }
        return this.isDirectlyAssignableTypeImpl(elementType, processingContext) && (!this.isTypeScript() || freshType == null || JSTypeCastUtil.compareByExcessProperties(this, freshType));
    }

    private void checkCachedValue(@NotNull JSType elementType, @NotNull ProcessingContext processingContext, boolean result) {
        Boolean subtyping;
        if (elementType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(6);
        }
        if (processingContext == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(7);
        }
        ProcessingContext newContext = new ProcessingContext();
        Boolean aBoolean = (Boolean)processingContext.get(JSGenericParameterImpl.CALL_ENV_KEY);
        if (aBoolean != null) {
            newContext.put(JSGenericParameterImpl.CALL_ENV_KEY, (Object)aBoolean);
        }
        if ((subtyping = (Boolean)processingContext.get(JSTypeComparingCache.SUBTYPING_CONTEXT)) != null) {
            newContext.put(JSTypeComparingCache.SUBTYPING_CONTEXT, (Object)subtyping);
        }
        assert (result == this.isDirectlyAssignableTypeImpl(elementType, newContext));
    }

    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        if (elementType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(8);
        }
        return this.isDirectlyAssignableTypeCommon(elementType, processingContext).isAssignable();
    }

    @NotNull
    protected JSTypeCastUtil.AssignableResult isDirectlyAssignableTypeCommon(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        if (elementType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(9);
        }
        JSTypeCastUtil.AssignableResult assignableResult = JSTypeCastUtil.isDirectlyAssignableTypeCommon(this, elementType, processingContext);
        if (assignableResult == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(10);
        }
        return assignableResult;
    }

    public void accept(JSRecursiveTypeVisitor visitor) {
        visitor.visitJSTypeBaseImpl((JSType)this);
    }

    public void acceptChildren(JSRecursiveTypeVisitor visitor) {
    }

    public void setSourceIfEmpty(final @NotNull JSTypeSource source) {
        if (source == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(11);
        }
        JSRecursiveTypeVisitor visitor = new JSRecursiveTypeVisitor(){

            public void visitJSTypeBaseImpl(JSType type) {
                if (((JSTypeBaseImpl)type).mySource == JSTypeSource.EMPTY) {
                    ((JSTypeBaseImpl)type).mySource = source;
                }
                super.visitJSTypeBaseImpl(type);
            }
        };
        this.accept(visitor);
    }

    @Nullable
    public PsiFile getScope() {
        return this.mySource.getScope();
    }

    public boolean isEcma() {
        return this.mySource.isEcma();
    }

    public boolean isTypeScript() {
        return this.mySource.isTypeScript();
    }

    public boolean isJavaScript() {
        return this.mySource.isJavaScript();
    }

    @NotNull
    protected JSTypeHelper getTypeHelper() {
        JSLanguageDialect language = null;
        switch (this.getSource().getLanguage()) {
            case TS: {
                language = JavaScriptSupportLoader.TYPESCRIPT;
                break;
            }
            case AS: {
                language = JavaScriptSupportLoader.ECMA_SCRIPT_L4;
                break;
            }
            case JS: {
                language = JavascriptLanguage.INSTANCE;
            }
        }
        JSTypeHelper jSTypeHelper = JSDialectSpecificHandlersFactory.forLanguage(language).getTypeHelper();
        if (jSTypeHelper == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(12);
        }
        return jSTypeHelper;
    }

    @Nullable
    public JSClass resolveClass() {
        return null;
    }

    @NotNull
    public final JSType transformTypeHierarchy(@NotNull Function<JSType, JSType> transformation) {
        JSType transformedType;
        if (transformation == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(13);
        }
        if (this != (transformedType = (JSType)transformation.fun((Object)this))) {
            JSType jSType = transformedType;
            if (jSType == null) {
                JSTypeBaseImpl.$$$reportNull$$$0(14);
            }
            return jSType;
        }
        JSType jSType = this.copyTypeHierarchy(transformation);
        if (jSType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(15);
        }
        return jSType;
    }

    @NotNull
    protected abstract JSType copyTypeHierarchy(@NotNull Function<JSType, JSType> var1);

    @NotNull
    public JSType substitute() {
        JSTypeBaseImpl jSTypeBaseImpl = this;
        if (jSTypeBaseImpl == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(16);
        }
        return jSTypeBaseImpl;
    }

    public final boolean isEquivalentTo(@Nullable JSType type, @Nullable ProcessingContext processingContext) {
        return this.isEquivalentTo(type, processingContext, true);
    }

    public final boolean isEquivalentTo(@Nullable JSType type, @Nullable ProcessingContext processingContext, boolean allowResolve) {
        if (this == type) {
            return true;
        }
        if (type == null) {
            return false;
        }
        if (this.isEquivalentToImpl(type, processingContext, allowResolve)) {
            return true;
        }
        return this.isEquivalentCommon(type, processingContext, allowResolve);
    }

    protected boolean isEquivalentCommon(@Nullable JSType rOperand, @Nullable ProcessingContext processingContext, boolean allowResolve) {
        if (rOperand instanceof JSGenericParameterImpl) {
            return rOperand.isEquivalentTo((JSType)this, processingContext, allowResolve);
        }
        if (rOperand instanceof JSTypeofTypeImpl) {
            return rOperand.isEquivalentTo((JSType)this, processingContext, allowResolve);
        }
        return false;
    }

    @NotNull
    public final JSType copyWithStrict(boolean strict) {
        JSTypeSource source = this.getSource();
        if (source.isStrict() == strict) {
            JSTypeBaseImpl jSTypeBaseImpl = this;
            if (jSTypeBaseImpl == null) {
                JSTypeBaseImpl.$$$reportNull$$$0(17);
            }
            return jSTypeBaseImpl;
        }
        JSType jSType = this.copyWithNewSource(JSTypeSourceFactory.copyTypeSource(source, strict));
        if (jSType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(18);
        }
        return jSType;
    }

    @NotNull
    protected abstract JSType copyWithNewSource(@NotNull JSTypeSource var1);

    protected abstract boolean isEquivalentToImpl(@NotNull JSType var1, ProcessingContext var2, boolean var3);

    @NotNull
    public JSRecordType asRecordType() {
        if (ASSERT_ON_RECORD_TYPE_USAGE) {
            throw new AssertionError((Object)"Record type must be not used");
        }
        JSTypeSource source = this.getSource();
        PsiElement element = source.getSourceElement();
        if (element != null) {
            JSRecordType jSRecordType = (JSRecordType)CachedValuesManager.getManager((Project)element.getProject()).getCachedValue((UserDataHolder)this, () -> CachedValueProvider.Result.create((Object)this.asRecordTypeNoCache(), (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()}));
            if (jSRecordType == null) {
                JSTypeBaseImpl.$$$reportNull$$$0(19);
            }
            return jSRecordType;
        }
        JSRecordType jSRecordType = this.asRecordTypeNoCache();
        if (jSRecordType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(20);
        }
        return jSRecordType;
    }

    @NotNull
    protected JSRecordType asRecordTypeNoCache() {
        String id;
        JSRecordType result;
        JSType substitute = this.substitute();
        if (substitute != this && (result = (JSRecordType)RecursionManager.doPreventingRecursion((Object)(id = JSTypeCastUtil.getTypeIdForComparison(this)), (boolean)false, () -> substitute.asRecordType())) != null) {
            JSRecordType jSRecordType = result;
            if (jSRecordType == null) {
                JSTypeBaseImpl.$$$reportNull$$$0(21);
            }
            return jSRecordType;
        }
        PsiElement element = this.getSource().getSourceElement();
        if (element != null) {
            if (this.isEcma()) {
                JSRecordType jSRecordType = JSTypeCastUtil.NO_RECORD_TYPE;
                if (jSRecordType == null) {
                    JSTypeBaseImpl.$$$reportNull$$$0(22);
                }
                return jSRecordType;
            }
            Collection<? extends PsiElement> resolvedElements = this.resolveElementsForRecordType(element);
            if (this.isJavaScript() && resolvedElements.isEmpty()) {
                JSRecordType jSRecordType = JSTypeCastUtil.NO_RECORD_TYPE;
                if (jSRecordType == null) {
                    JSTypeBaseImpl.$$$reportNull$$$0(23);
                }
                return jSRecordType;
            }
            JSRecordType jSRecordType = TypeScriptTypeParser.buildResolvedType(resolvedElements, this);
            if (jSRecordType == null) {
                JSTypeBaseImpl.$$$reportNull$$$0(24);
            }
            return jSRecordType;
        }
        JSRecordType jSRecordType = TypeScriptTypeParser.buildResolvedType(ContainerUtil.emptyList(), this);
        if (jSRecordType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(25);
        }
        return jSRecordType;
    }

    protected Collection<? extends PsiElement> resolveElementsForRecordType(@NotNull PsiElement element) {
        if (element == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(26);
        }
        return JSImportHandlingUtil.resolveElementsByType(this, element);
    }

    public static JSType replaceSourceRecursive(@Nullable JSType type, final @NotNull JSTypeSource newSource) {
        if (newSource == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(27);
        }
        if (type == null) {
            return null;
        }
        Function<JSType, JSType> function = new Function<JSType, JSType>(){

            public JSType fun(JSType currentType) {
                if (currentType instanceof JSTypeBaseImpl) {
                    if (currentType.getSource() == newSource) {
                        return currentType;
                    }
                    JSType elementResult = ((JSTypeBaseImpl)currentType).copyWithNewSource(newSource);
                    if (elementResult == currentType) {
                        return elementResult;
                    }
                    return elementResult.transformTypeHierarchy((Function)this);
                }
                assert (false);
                return currentType;
            }
        };
        return type.transformTypeHierarchy((Function)function);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 1: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSTypeBaseImpl";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transformation";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSTypeBaseImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedTypeText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSource";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "isDirectlyAssignableTypeCommon";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeHelper";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "transformTypeHierarchy";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "substitute";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithStrict";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "asRecordType";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "asRecordTypeNoCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "assertOnRecordTypeUsage";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkAssignability";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkCachedValue";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeCommon";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setSourceIfEmpty";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "transformTypeHierarchy";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "resolveElementsForRecordType";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "replaceSourceRecursive";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

