/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSEvaluableType;
import com.intellij.lang.javascript.psi.types.JSForInStringType;
import com.intellij.lang.javascript.psi.types.JSIntersectionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNumberLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSSpecialNamedTypeImpl;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptIndexedAccessJSTypeImpl
extends JSTypeBaseImpl
implements JSType.CompositeStructure,
JSEvaluableType {
    @NotNull
    private final JSType myOwner;
    @NotNull
    private final JSType myParameterType;

    public TypeScriptIndexedAccessJSTypeImpl(@NotNull JSType owner, @NotNull JSType parameterType, @NotNull JSTypeSource source) {
        if (owner == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(0);
        }
        if (parameterType == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(1);
        }
        if (source == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(2);
        }
        super(source);
        this.myOwner = owner;
        this.myParameterType = parameterType;
    }

    @NotNull
    public String getTypeText(JSType.TypeTextFormat format) {
        boolean isSerialized = format == JSType.TypeTextFormat.SERIALIZED;
        StringBuilder result = new StringBuilder();
        if (isSerialized) {
            result.append("#indt");
            result.append("(");
        }
        result.append(this.getOwner().getTypeText(format));
        result.append(isSerialized ? "," : "[");
        JSType type = this.getParameterType();
        result.append(type.getTypeText(format));
        result.append(isSerialized ? "" : "]");
        if (isSerialized) {
            result.append(")");
        }
        String string = result.toString();
        if (string == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NotNull
    protected JSType copyTypeHierarchy(@NotNull Function<JSType, JSType> childTransform) {
        if (childTransform == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(4);
        }
        JSType newOwner = JSTypeUtils.transformTypeHierarchySafe(this.getOwner(), childTransform);
        JSType newParameterType = JSTypeUtils.transformTypeHierarchySafe(this.getParameterType(), childTransform);
        TypeScriptIndexedAccessJSTypeImpl typeScriptIndexedAccessJSTypeImpl = new TypeScriptIndexedAccessJSTypeImpl(newOwner, newParameterType, this.getSource());
        if (typeScriptIndexedAccessJSTypeImpl == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(5);
        }
        return typeScriptIndexedAccessJSTypeImpl;
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        JSType substitute;
        if (elementType == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(6);
        }
        if ((substitute = this.substitute()) != this && substitute.isDirectlyAssignableType(elementType, processingContext)) {
            return true;
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    @Override
    @NotNull
    protected JSType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(7);
        }
        TypeScriptIndexedAccessJSTypeImpl typeScriptIndexedAccessJSTypeImpl = new TypeScriptIndexedAccessJSTypeImpl(this.getOwner(), this.getParameterType(), source);
        if (typeScriptIndexedAccessJSTypeImpl == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(8);
        }
        return typeScriptIndexedAccessJSTypeImpl;
    }

    @Override
    protected boolean isEquivalentToImpl(@NotNull JSType type, ProcessingContext context, boolean allowResolve) {
        if (type == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(9);
        }
        if (type instanceof TypeScriptIndexedAccessJSTypeImpl) {
            TypeScriptIndexedAccessJSTypeImpl indexedAccessJSType = (TypeScriptIndexedAccessJSTypeImpl)type;
            return indexedAccessJSType.getOwner().isEquivalentTo(this.getOwner(), context, allowResolve) && indexedAccessJSType.getParameterType().isEquivalentTo(this.getParameterType(), context, allowResolve);
        }
        return false;
    }

    @Override
    @NotNull
    public JSType substitute() {
        JSType type = (JSType)RecursionManager.doPreventingRecursion((Object)JSTypeCastUtil.getTypeIdForComparison(this), (boolean)false, () -> this.substituteImpl());
        TypeScriptIndexedAccessJSTypeImpl typeScriptIndexedAccessJSTypeImpl = type == null ? this : type;
        if (typeScriptIndexedAccessJSTypeImpl == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(10);
        }
        return typeScriptIndexedAccessJSTypeImpl;
    }

    @NotNull
    private JSType substituteImpl() {
        JSType owner = this.getOwner();
        JSType ownerType = JSTypeUtils.getValuableType(owner);
        JSType parameterType = this.getParameterType();
        if (JSTypeUtils.hasGenericParameter(ownerType) || JSTypeUtils.hasGenericParameter(parameterType)) {
            TypeScriptIndexedAccessJSTypeImpl typeScriptIndexedAccessJSTypeImpl = this;
            if (typeScriptIndexedAccessJSTypeImpl == null) {
                TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(11);
            }
            return typeScriptIndexedAccessJSTypeImpl;
        }
        Collection<String> parameterStrings = TypeScriptIndexedAccessJSTypeImpl.getParameterStrings(parameterType);
        HashSet strings = new HashSet(parameterStrings);
        JSRecordType recordType = ownerType.asRecordType();
        List result = ContainerUtil.newSmartList();
        List members = recordType.getTypeMembers();
        if (!strings.isEmpty()) {
            for (JSRecordType.TypeMember member : members) {
                JSType type;
                JSRecordType.PropertySignature propertySignature;
                String name;
                if (!(member instanceof JSRecordType.PropertySignature) || !strings.contains(name = (propertySignature = (JSRecordType.PropertySignature)member).getMemberName()) || (type = propertySignature.getType()) == null) continue;
                result.add(type);
            }
            if (result.size() != 0) {
                JSCompositeTypeImpl jSCompositeTypeImpl = result.size() == 1 ? (JSType)result.get(0) : new JSCompositeTypeImpl(this.getSource(), result);
                if (jSCompositeTypeImpl == null) {
                    TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(12);
                }
                return jSCompositeTypeImpl;
            }
        }
        boolean matchNumericIndexer = false;
        boolean matchStringIndexer = false;
        if (parameterType.isDirectlyAssignableType(JSSpecialNamedTypeImpl.getSpecialType("number", this.getSource(), JSTypeContext.INSTANCE, false), null) || parameterType instanceof JSForInStringType) {
            matchNumericIndexer = true;
        } else if (parameterType.isDirectlyAssignableType(JSSpecialNamedTypeImpl.getSpecialType("string", this.getSource(), JSTypeContext.INSTANCE, false), null)) {
            matchStringIndexer = true;
        }
        if (!matchStringIndexer && !matchNumericIndexer) {
            JSAnyType jSAnyType = JSAnyType.getWithLanguage(this.getSource().getLanguage(), this.getSource().isStrict());
            if (jSAnyType == null) {
                TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(13);
            }
            return jSAnyType;
        }
        for (JSRecordType.TypeMember member : members) {
            if (!(member instanceof JSRecordType.IndexSignature)) continue;
            if (matchNumericIndexer && ((JSRecordType.IndexSignature)member).getIndexSignatureKind() == JSRecordType.IndexSignatureKind.NUMERIC) {
                JSType jSType = ((JSRecordType.IndexSignature)member).getMemberType();
                if (jSType == null) {
                    TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(14);
                }
                return jSType;
            }
            if (!matchStringIndexer || ((JSRecordType.IndexSignature)member).getIndexSignatureKind() != JSRecordType.IndexSignatureKind.STRING) continue;
            JSType jSType = ((JSRecordType.IndexSignature)member).getMemberType();
            if (jSType == null) {
                TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(15);
            }
            return jSType;
        }
        JSAnyType jSAnyType = JSAnyType.getWithLanguage(this.getSource().getLanguage(), this.getSource().isStrict());
        if (jSAnyType == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(16);
        }
        return jSAnyType;
    }

    @NotNull
    public static Collection<String> getParameterStrings(@NotNull JSType parameterType) {
        JSType type;
        JSType typeDef;
        if (parameterType == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(17);
        }
        if (parameterType instanceof JSTypeImpl && (typeDef = ((JSTypeImpl)parameterType).getTypedef()) != null) {
            parameterType = typeDef;
        }
        if ((type = JSTypeUtils.getValuableType(parameterType)) instanceof JSStringLiteralTypeImpl) {
            List list = ContainerUtil.createMaybeSingletonList((Object)((JSStringLiteralTypeImpl)type).getLiteral());
            if (list == null) {
                TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(18);
            }
            return list;
        }
        if (type instanceof JSNumberLiteralTypeImpl) {
            List list = ContainerUtil.createMaybeSingletonList((Object)((JSNumberLiteralTypeImpl)type).getValueAsString());
            if (list == null) {
                TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(19);
            }
            return list;
        }
        if (type instanceof JSCompositeTypeImpl) {
            LinkedHashSet result = ContainerUtil.newLinkedHashSet();
            for (JSType jsType : ((JSCompositeTypeImpl)type).getTypes()) {
                result.addAll(TypeScriptIndexedAccessJSTypeImpl.getParameterStrings(jsType));
            }
            LinkedHashSet linkedHashSet = result;
            if (linkedHashSet == null) {
                TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(20);
            }
            return linkedHashSet;
        }
        if (type instanceof JSIntersectionTypeImpl) {
            HashSet strings = new HashSet();
            for (JSType constituent : ((JSIntersectionTypeImpl)type).getTypes()) {
                if (strings.isEmpty()) {
                    strings.addAll(TypeScriptIndexedAccessJSTypeImpl.getParameterStrings(constituent));
                    continue;
                }
                strings.retainAll(TypeScriptIndexedAccessJSTypeImpl.getParameterStrings(constituent));
            }
            HashSet hashSet = strings;
            if (hashSet == null) {
                TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(21);
            }
            return hashSet;
        }
        JSType substitute = parameterType.substitute();
        if (substitute != parameterType) {
            Collection<String> collection = TypeScriptIndexedAccessJSTypeImpl.getParameterStrings(substitute);
            if (collection == null) {
                TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(22);
            }
            return collection;
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(23);
        }
        return list;
    }

    @NotNull
    public JSType getOwner() {
        JSType jSType = this.myOwner;
        if (jSType == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(24);
        }
        return jSType;
    }

    @NotNull
    public JSType getParameterType() {
        JSType jSType = this.myParameterType;
        if (jSType == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(25);
        }
        return jSType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 1: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterType";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/TypeScriptIndexedAccessJSTypeImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childTransform";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/TypeScriptIndexedAccessJSTypeImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "copyTypeHierarchy";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithNewSource";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "substitute";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteImpl";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterStrings";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwner";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "copyTypeHierarchy";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToImpl";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getParameterStrings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

