/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types.guard;

import com.intellij.codeInsight.controlflow.ControlFlow;
import com.intellij.codeInsight.controlflow.ControlFlowUtil;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.controlflow.JSControlFlowService;
import com.intellij.lang.javascript.psi.controlflow.instruction.JSCaseBlockInstruction;
import com.intellij.lang.javascript.psi.controlflow.instruction.JSConditionInstruction;
import com.intellij.lang.javascript.psi.controlflow.instruction.JSEntryPointInstruction;
import com.intellij.lang.javascript.psi.controlflow.instruction.JSModificationInstruction;
import com.intellij.lang.javascript.psi.controlflow.instruction.JSReadWriteInstruction;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.types.JSArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardChecker;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.lang.javascript.psi.types.primitives.TypeScriptNeverJSTypeImpl;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSControlFlowTypeGuard
extends JSTypeGuardChecker {
    private static final Logger LOGGER = Logger.getInstance(JSControlFlowTypeGuard.class);
    private static final Key<Boolean> EVOLVING_ARRAY = Key.create((String)"js.cf.type.guard.evolving.array");
    private final boolean myUseAutoVariableType;
    private final boolean myUseAutoArrayType;
    private final boolean myStrictNullCheck;
    private final Map<Instruction, JSType> myCalculatedTypes;

    @Nullable
    private static JSType addUndefinedTypeForOptionalParameters(@Nullable JSType startType, @Nullable PsiElement resolveResult, @Nullable TypeScriptConfig config2) {
        if (config2 == null) {
            return startType;
        }
        if (resolveResult instanceof JSParameter && ((JSParameter)resolveResult).isOptional() && startType != null) {
            JSTypeSource source = JSTypeSourceFactory.createTypeSource(resolveResult, true);
            return new JSCompositeTypeImpl(source, startType, JSNamedType.createType("undefined", source, JSContext.UNKNOWN));
        }
        return startType;
    }

    public JSControlFlowTypeGuard(@NotNull JSReferenceExpression reference, @Nullable JSType startType, @Nullable PsiElement resolveResult) {
        if (reference == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(0);
        }
        this(reference, startType, resolveResult, TypeScriptConfigUtil.getConfigForPsiFile(reference.getContainingFile()));
    }

    private JSControlFlowTypeGuard(@NotNull JSReferenceExpression reference, @Nullable JSType startType, @Nullable PsiElement resolveResult, @Nullable TypeScriptConfig config2) {
        if (reference == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(1);
        }
        super(reference, JSControlFlowTypeGuard.addUndefinedTypeForOptionalParameters(startType, resolveResult, config2), resolveResult);
        this.myCalculatedTypes = ContainerUtil.newHashMap();
        if (resolveResult instanceof JSVariable && JSControlFlowTypeGuard.useAutoTypes(reference, resolveResult, config2)) {
            JSVariable variable = (JSVariable)resolveResult;
            JSExpression initializer = variable.getInitializer();
            this.myUseAutoVariableType = !variable.isConst() && (initializer == null || JSSymbolUtil.isUndefinedExpression(initializer) || JSSymbolUtil.isNullLiteral(initializer));
            this.myUseAutoArrayType = !this.myUseAutoVariableType && JSControlFlowTypeGuard.isEmptyArrayExpression(initializer);
        } else {
            this.myUseAutoVariableType = false;
            this.myUseAutoArrayType = false;
        }
        this.myStrictNullCheck = config2 != null && config2.strictNullChecks();
    }

    public static boolean isEvolvingArrayOperationTarget(@NotNull JSExpression expression) {
        PsiElement parent;
        if (expression == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(2);
        }
        if ((parent = expression.getParent()) instanceof JSIndexedPropertyAccessExpression && parent instanceof JSDefinitionExpression) {
            return true;
        }
        if (expression instanceof JSReferenceExpression && parent instanceof JSReferenceExpression) {
            JSReferenceExpression parentExpression = (JSReferenceExpression)parent;
            if (parentExpression.getParent() instanceof JSReferenceExpression) {
                return false;
            }
            String name = parentExpression.getName();
            return JSControlFlowTypeGuard.isPushOrUnshiftName(name) || "length".equals(name);
        }
        return false;
    }

    public static boolean isPushOrUnshiftName(@Nullable String name) {
        return "push".equals(name) || "unshift".equals(name);
    }

    public static boolean isEmptyArrayExpression(@Nullable JSExpression expression) {
        return expression != null && expression instanceof JSArrayLiteralExpression && ((JSArrayLiteralExpression)expression).getExpressions().length == 0;
    }

    public static boolean useAutoTypes(@NotNull JSReferenceExpression reference, @NotNull PsiElement resolveResult, @Nullable TypeScriptConfig config2) {
        if (reference == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(3);
        }
        if (resolveResult == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(4);
        }
        if (config2 == null || !config2.noImplicitAny() || !reference.getContainingFile().equals(resolveResult.getContainingFile()) || resolveResult.getParent() instanceof JSDestructuringContainer) {
            return false;
        }
        JSVariable result = (JSVariable)resolveResult;
        if (result.getTypeElement() != null) {
            return false;
        }
        JSAttributeList list = result.getAttributeList();
        if (list != null && list.hasModifier(JSAttributeList.ModifierType.EXPORT)) {
            return false;
        }
        return !TypeScriptPsiUtil.isAmbientDeclaration(resolveResult);
    }

    @Override
    @NotNull
    protected JSType getNarrowedTypeImpl() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Instruction instruction = this.getControlFlowInstruction((PsiElement)this.myReference);
        if (instruction == null) {
            JSType jSType = this.myDeclaredType;
            if (jSType == null) {
                JSControlFlowTypeGuard.$$$reportNull$$$0(5);
            }
            return jSType;
        }
        JSType result = this.getTypeAtFlowNode(instruction);
        JSType jSType = JSControlFlowTypeGuard.isEvolvingArrayType(result) && JSControlFlowTypeGuard.isEvolvingArrayOperationTarget(this.myReference) ? this.myDeclaredType : this.finalizeEvolvingArrayType(result);
        if (jSType == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(6);
        }
        return jSType;
    }

    @Nullable
    public Instruction getControlFlowInstruction(@NotNull PsiElement context) {
        JSElement executionScope;
        ControlFlow flow;
        if (context == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(7);
        }
        if ((flow = this.getControlFlowScope(executionScope = (JSElement)PsiTreeUtil.getParentOfType((PsiElement)context, (Class[])new Class[]{JSExecutionScope.class, JSClass.class}))) == null) {
            return null;
        }
        Instruction[] instructions = flow.getInstructions();
        int indexOfElement = ControlFlowUtil.findInstructionNumberByElement((Instruction[])instructions, (PsiElement)context);
        if (indexOfElement == -1) {
            Document document = PsiDocumentManager.getInstance((Project)context.getProject()).getDocument(context.getContainingFile());
            assert (document != null);
            int number = document.getLineNumber(context.getNode().getStartOffset());
            LOGGER.debug("Control flow must contain all semantic elements for correct type inference, line " + number + ", class " + context.getClass());
            return null;
        }
        return instructions[indexOfElement];
    }

    @Nullable
    public ControlFlow getControlFlowScope(JSElement executionScope) {
        if (executionScope == null || executionScope instanceof JSClass) {
            return null;
        }
        return JSControlFlowService.getService(this.myReference.getProject()).getControlFlow(executionScope);
    }

    @NotNull
    private JSType getTypeAtFlowNode(@NotNull Instruction currentInstruction) {
        if (currentInstruction == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(8);
        }
        ProgressManager.checkCanceled();
        JSType type = this.myCalculatedTypes.get(currentInstruction);
        if (type != null) {
            JSType jSType = type;
            if (jSType == null) {
                JSControlFlowTypeGuard.$$$reportNull$$$0(9);
            }
            return jSType;
        }
        this.myCalculatedTypes.put(currentInstruction, this.myDeclaredType);
        type = this.getTypeAtFlowNodeImpl(currentInstruction);
        this.myCalculatedTypes.put(currentInstruction, type);
        JSType jSType = type;
        if (jSType == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(10);
        }
        return jSType;
    }

    @NotNull
    private JSType getTypeAtFlowNodeImpl(@NotNull Instruction currentInstruction) {
        if (currentInstruction == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(11);
        }
        HashSet visitedInstructions = ContainerUtil.newHashSet();
        while (currentInstruction != null) {
            JSType result;
            JSType assignmentType;
            if (!visitedInstructions.add(currentInstruction)) {
                JSType jSType = this.myDeclaredType;
                if (jSType == null) {
                    JSControlFlowTypeGuard.$$$reportNull$$$0(12);
                }
                return jSType;
            }
            if (currentInstruction instanceof JSEntryPointInstruction) {
                boolean isReferenceExpression;
                JSElement scope = ((JSEntryPointInstruction)currentInstruction).getScope();
                if (scope instanceof JSFile || (!(isReferenceExpression = this.myReference instanceof JSReferenceExpression) || ((JSReferenceExpression)this.myReference).getQualifier() != null) && (isReferenceExpression || this.myReference instanceof JSThisExpression)) break;
                JSType jSType = this.getTypeAtParentScope((PsiElement)scope);
                if (jSType == null) {
                    JSControlFlowTypeGuard.$$$reportNull$$$0(13);
                }
                return jSType;
            }
            if (currentInstruction instanceof JSReadWriteInstruction && (assignmentType = this.getTypeAtFlowAssignment(currentInstruction)) != null) {
                JSType jSType = assignmentType;
                if (jSType == null) {
                    JSControlFlowTypeGuard.$$$reportNull$$$0(14);
                }
                return jSType;
            }
            if (currentInstruction instanceof JSModificationInstruction && this.myUseAutoArrayType && (result = this.getTypeAtFlowArrayMutation((JSModificationInstruction)currentInstruction)) != null) {
                JSType jSType = result;
                if (jSType == null) {
                    JSControlFlowTypeGuard.$$$reportNull$$$0(15);
                }
                return jSType;
            }
            if (currentInstruction instanceof JSCaseBlockInstruction) {
                JSType jSType = this.getTypeAtCaseBlock((JSCaseBlockInstruction)currentInstruction);
                if (jSType == null) {
                    JSControlFlowTypeGuard.$$$reportNull$$$0(16);
                }
                return jSType;
            }
            if (currentInstruction instanceof JSConditionInstruction) {
                JSType jSType = this.getTypeAtFlowCondition((JSConditionInstruction)currentInstruction);
                if (jSType == null) {
                    JSControlFlowTypeGuard.$$$reportNull$$$0(17);
                }
                return jSType;
            }
            Collection prevInstructions = currentInstruction.allPred();
            int size = prevInstructions.size();
            if (size == 0) break;
            if (size > 1) {
                JSType jSType = this.getPrevFlowType(currentInstruction);
                if (jSType == null) {
                    JSControlFlowTypeGuard.$$$reportNull$$$0(18);
                }
                return jSType;
            }
            currentInstruction = (Instruction)ContainerUtil.getFirstItem((Collection)prevInstructions);
        }
        JSType jSType = this.myDeclaredType;
        if (jSType == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(19);
        }
        return jSType;
    }

    @Nullable
    private JSType getTypeAtFlowAssignment(@NotNull Instruction currentInstruction) {
        PsiElement element;
        JSElement referenceElement;
        JSReadWriteInstruction readWriteInstruction;
        ReadWriteAccessDetector.Access access;
        if (currentInstruction == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(20);
        }
        if (((access = (readWriteInstruction = (JSReadWriteInstruction)currentInstruction).getAccess()) == ReadWriteAccessDetector.Access.Write || access == ReadWriteAccessDetector.Access.ReadWrite) && (referenceElement = JSControlFlowTypeGuard.getAssignTarget(element = currentInstruction.getElement())) != null) {
            if (JSControlFlowTypeGuard.isMatchingReference((PsiElement)this.myReference, (PsiElement)referenceElement)) {
                JSType initializerType;
                if (access == ReadWriteAccessDetector.Access.ReadWrite) {
                    JSType prevType = this.getPrevFlowType(currentInstruction);
                    return this.getBaseTypeOfLiteralType(prevType);
                }
                if (this.myUseAutoArrayType) {
                    JSType initializerType2;
                    JSExpression initializer = JSControlFlowTypeGuard.getInitializerExpression(element);
                    if (element instanceof JSVariable || JSControlFlowTypeGuard.isEmptyArrayExpression(initializer)) {
                        return this.getEvolvingArrayType(new TypeScriptNeverJSTypeImpl(this.mySource));
                    }
                    if (initializer != null && (initializerType2 = JSControlFlowTypeGuard.getInitializerType(element)) != null) {
                        JSType typeToUse = this.getBaseTypeOfLiteralType(initializerType2);
                        return TypeScriptTypeRelations.isTypeAssignableTo(typeToUse, this.myDeclaredType, this.myProcessingContext) ? typeToUse : JSNamedType.createType("Array", this.mySource, JSContext.INSTANCE);
                    }
                }
                if (this.myUseAutoVariableType && !(element instanceof JSVariable) && (initializerType = JSControlFlowTypeGuard.getInitializerType(element)) != null) {
                    return this.getBaseTypeOfLiteralType(initializerType);
                }
                if (this.myDeclaredType instanceof JSUnionType && (initializerType = JSControlFlowTypeGuard.getInitializerType(element)) != null) {
                    return this.getAssignmentReducedType((JSUnionType)this.myDeclaredType, initializerType);
                }
                return this.myDeclaredType;
            }
            if (JSControlFlowTypeGuard.containsMatchingReference((PsiElement)this.myReference, element)) {
                return this.myDeclaredType;
            }
        }
        return null;
    }

    @NotNull
    protected JSType getAssignmentReducedType(@NotNull JSUnionType currentType, @NotNull JSType assignmentType) {
        if (currentType == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(21);
        }
        if (assignmentType == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(22);
        }
        if (currentType.isEquivalentTo(assignmentType, this.myProcessingContext, true)) {
            JSUnionType jSUnionType = currentType;
            if (jSUnionType == null) {
                JSControlFlowTypeGuard.$$$reportNull$$$0(23);
            }
            return jSUnionType;
        }
        if (assignmentType instanceof TypeScriptNeverJSTypeImpl) {
            JSType jSType = assignmentType;
            if (jSType == null) {
                JSControlFlowTypeGuard.$$$reportNull$$$0(24);
            }
            return jSType;
        }
        JSType resultType = TypeScriptTypeRelations.filterType(currentType, (Predicate<JSType>)((Predicate)el -> {
            if (assignmentType == null) {
                JSControlFlowTypeGuard.$$$reportNull$$$0(57);
            }
            return TypeScriptTypeRelations.typeMaybeAssignableTo(assignmentType, el, this.myProcessingContext);
        }), (PsiElement)this.myReference);
        JSUnionType jSUnionType = resultType instanceof TypeScriptNeverJSTypeImpl ? currentType : resultType;
        if (jSUnionType == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(25);
        }
        return jSUnionType;
    }

    @NotNull
    private JSType getTypeAtParentScope(@NotNull PsiElement scope) {
        if (scope == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(26);
        }
        ArrayList candidateParents = ContainerUtil.newArrayList((Object[])new PsiElement[]{scope});
        JSElement cfScope = null;
        for (PsiElement parent = scope.getParent(); parent != null; parent = parent.getParent()) {
            if (parent instanceof JSClass) {
                JSType jSType = this.myDeclaredType;
                if (jSType == null) {
                    JSControlFlowTypeGuard.$$$reportNull$$$0(27);
                }
                return jSType;
            }
            if (parent instanceof JSElement && JSControlFlowService.isControlFlowScope(parent)) {
                cfScope = (JSElement)parent;
                break;
            }
            candidateParents.add(parent);
        }
        if (cfScope != null) {
            ControlFlow flowScope = this.getControlFlowScope(cfScope);
            if (flowScope == null) {
                JSType jSType = this.myDeclaredType;
                if (jSType == null) {
                    JSControlFlowTypeGuard.$$$reportNull$$$0(28);
                }
                return jSType;
            }
            Instruction[] instructions = flowScope.getInstructions();
            for (PsiElement candidateScope : candidateParents) {
                int numberByElement = ControlFlowUtil.findInstructionNumberByElement((Instruction[])instructions, (PsiElement)candidateScope);
                if (numberByElement == -1) continue;
                JSType jSType = this.getTypeAtFlowNode(instructions[numberByElement]);
                if (jSType == null) {
                    JSControlFlowTypeGuard.$$$reportNull$$$0(29);
                }
                return jSType;
            }
        }
        JSType jSType = this.myDeclaredType;
        if (jSType == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(30);
        }
        return jSType;
    }

    @Nullable
    private JSType getTypeAtFlowArrayMutation(@NotNull JSModificationInstruction instruction) {
        JSExpression expression;
        if (instruction == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(31);
        }
        if (JSControlFlowTypeGuard.isMatchingReference((PsiElement)this.myReference, (PsiElement)JSControlFlowTypeGuard.getReferenceCandidate(expression = instruction.getExpression()))) {
            JSType prevType = this.getPrevFlowType(instruction);
            if (prevType instanceof JSArrayTypeImpl && JSControlFlowTypeGuard.isEvolvingArrayType(prevType)) {
                JSExpression indexExpression;
                JSExpression elExpression;
                JSDefinitionExpression definitionExpression;
                JSArrayTypeImpl arrayType = (JSArrayTypeImpl)prevType;
                PsiElement element = instruction.getElement();
                JSType startType = arrayType.getType();
                if (element instanceof JSCallExpression) {
                    JSExpression[] arguments = ((JSCallExpression)element).getArguments();
                    if (arguments.length > 0) {
                        JSType currentType = startType;
                        for (JSExpression argument : arguments) {
                            currentType = this.addEvolvingArrayElementType(currentType, argument);
                        }
                        return currentType == startType ? arrayType : this.getEvolvingArrayType(currentType);
                    }
                } else if (element instanceof JSAssignmentExpression && (definitionExpression = ((JSAssignmentExpression)element).getDefinitionExpression()) != null && (elExpression = definitionExpression.getExpression()) instanceof JSIndexedPropertyAccessExpression && JSControlFlowTypeGuard.isIndexExpressionNumberLike(indexExpression = ((JSIndexedPropertyAccessExpression)elExpression).getIndexExpression())) {
                    JSExpression initializer = definitionExpression.getInitializer();
                    JSType type = this.addEvolvingArrayElementType(startType, initializer);
                    return type == startType ? arrayType : this.getEvolvingArrayType(type);
                }
            }
            return prevType;
        }
        return null;
    }

    private static boolean isIndexExpressionNumberLike(@Nullable JSExpression indexExpression) {
        if (indexExpression == null) {
            return false;
        }
        JSType type = JSControlFlowTypeGuard.getExpressionTypeForTypeGuard(indexExpression);
        JSType exactType = JSControlFlowTypeGuard.getExactType(type);
        return exactType instanceof JSNumberType;
    }

    private JSType addEvolvingArrayElementType(@NotNull JSType currentParameter, @Nullable JSExpression newParameterType) {
        if (currentParameter == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(32);
        }
        if (newParameterType == null) {
            return currentParameter;
        }
        JSType type = JSControlFlowTypeGuard.getExpressionTypeForTypeGuard(newParameterType);
        if (type == null) {
            return currentParameter;
        }
        JSType baseType = this.getBaseTypeOfLiteralType(type);
        return this.getUnionType(currentParameter, baseType);
    }

    @NotNull
    private JSType getTypeAtCaseBlock(@NotNull JSCaseBlockInstruction instruction) {
        if (instruction == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(33);
        }
        JSType prevType = this.getPrevFlowType((Instruction)instruction);
        JSCaseBlockInstruction startBlock = instruction.getStartBlock();
        JSSwitchStatement statement = instruction.getSwitchStatement();
        if (statement == null) {
            JSType jSType = prevType;
            if (jSType == null) {
                JSControlFlowTypeGuard.$$$reportNull$$$0(34);
            }
            return jSType;
        }
        JSType jSType = this.getTypeAtSwitchClause(JSControlFlowTypeGuard.getExactType(prevType), statement, startBlock.getIndex(), instruction.getIndex());
        if (jSType == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(35);
        }
        return jSType;
    }

    @NotNull
    private JSType getTypeAtFlowCondition(@NotNull JSConditionInstruction instruction) {
        JSType prevType;
        if (instruction == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(36);
        }
        if ((prevType = this.getPrevFlowType((Instruction)instruction)) instanceof TypeScriptNeverJSTypeImpl) {
            JSType jSType = prevType;
            if (jSType == null) {
                JSControlFlowTypeGuard.$$$reportNull$$$0(37);
            }
            return jSType;
        }
        boolean assumeTrue = instruction.getValue();
        PsiElement element = instruction.getElement();
        if (element instanceof JSExpression) {
            JSType narrowType = this.narrowType(prevType, (JSExpression)element, assumeTrue);
            if (narrowType == prevType) {
                JSType jSType = prevType;
                if (jSType == null) {
                    JSControlFlowTypeGuard.$$$reportNull$$$0(38);
                }
                return jSType;
            }
            JSType jSType = narrowType;
            if (jSType == null) {
                JSControlFlowTypeGuard.$$$reportNull$$$0(39);
            }
            return jSType;
        }
        JSType jSType = prevType;
        if (jSType == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(40);
        }
        return jSType;
    }

    @NotNull
    private JSType getPrevFlowType(@NotNull Instruction instruction) {
        Collection instructions;
        int size;
        if (instruction == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(41);
        }
        if ((size = (instructions = instruction.allPred()).size()) == 0) {
            JSType jSType = this.myDeclaredType;
            if (jSType == null) {
                JSControlFlowTypeGuard.$$$reportNull$$$0(42);
            }
            return jSType;
        }
        if (size == 1) {
            JSType jSType = this.getTypeAtFlowNode((Instruction)instructions.iterator().next());
            if (jSType == null) {
                JSControlFlowTypeGuard.$$$reportNull$$$0(43);
            }
            return jSType;
        }
        LinkedHashSet resultTypes = ContainerUtil.newLinkedHashSet();
        for (Instruction prevInstructions : instructions) {
            JSType currentType = this.getTypeAtFlowNode(prevInstructions);
            if (currentType == this.myDeclaredType) {
                JSType jSType = this.myDeclaredType;
                if (jSType == null) {
                    JSControlFlowTypeGuard.$$$reportNull$$$0(44);
                }
                return jSType;
            }
            resultTypes.add(currentType);
        }
        if (resultTypes.size() == 0) {
            JSType jSType = this.myDeclaredType;
            if (jSType == null) {
                JSControlFlowTypeGuard.$$$reportNull$$$0(45);
            }
            return jSType;
        }
        JSType jSType = this.getUnionOrEvolvingArrayType(resultTypes, this.mySource);
        if (jSType == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(46);
        }
        return jSType;
    }

    @Contract(value="null -> null")
    private static JSElement getAssignTarget(@Nullable PsiElement element) {
        if (element instanceof JSAssignmentExpression) {
            element = ((JSAssignmentExpression)element).getDefinitionExpression();
        }
        if (element instanceof JSDefinitionExpression) {
            return ((JSDefinitionExpression)element).getExpression();
        }
        if (element instanceof JSVariable) {
            return (JSVariable)element;
        }
        return null;
    }

    @Nullable
    private static JSType getInitializerType(@Nullable PsiElement element) {
        JSExpression expression = JSControlFlowTypeGuard.getInitializerExpression(element);
        return expression == null ? null : JSControlFlowTypeGuard.getExpressionTypeForTypeGuard(expression);
    }

    @Nullable
    private static JSExpression getInitializerExpression(@Nullable PsiElement element) {
        if (element instanceof JSAssignmentExpression) {
            element = ((JSAssignmentExpression)element).getDefinitionExpression();
        }
        if (element instanceof JSInitializerOwner) {
            return ((JSInitializerOwner)element).getInitializer();
        }
        return null;
    }

    private JSType getUnionOrEvolvingArrayType(@NotNull Collection<JSType> types, @NotNull JSTypeSource source) {
        if (types == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(47);
        }
        if (source == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(48);
        }
        boolean allEvolving = true;
        boolean hasEvolving = false;
        for (JSType type : types) {
            boolean isEvolving = JSControlFlowTypeGuard.isEvolvingArrayType(type);
            allEvolving &= isEvolving;
            hasEvolving |= isEvolving;
        }
        if (allEvolving) {
            return this.mergeEvolvingArrays(types, source);
        }
        if (hasEvolving) {
            types = types.stream().map(el -> this.finalizeEvolvingArrayType((JSType)el)).collect(Collectors.toList());
        }
        return TypeScriptTypeRelations.getUnionType(types, source);
    }

    private JSType mergeEvolvingArrays(@NotNull Collection<JSType> types, @NotNull JSTypeSource source) {
        if (types == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(49);
        }
        if (source == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(50);
        }
        List<JSType> nestedTypes = types.stream().filter(el -> el instanceof JSArrayTypeImpl).map(el -> ((JSArrayTypeImpl)el).getType()).collect(Collectors.toList());
        JSType unionType = TypeScriptTypeRelations.getUnionType(nestedTypes, source);
        return this.getEvolvingArrayType(unionType);
    }

    private static boolean isEvolvingArrayType(@NotNull JSType arrayType) {
        if (arrayType == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(51);
        }
        return arrayType.getUserData(EVOLVING_ARRAY) != null;
    }

    @NotNull
    private JSType getEvolvingArrayType(@NotNull JSType parameterType) {
        if (parameterType == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(52);
        }
        JSArrayTypeImpl type = new JSArrayTypeImpl(parameterType, this.mySource);
        type.putUserData(EVOLVING_ARRAY, true);
        JSArrayTypeImpl jSArrayTypeImpl = type;
        if (jSArrayTypeImpl == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(53);
        }
        return jSArrayTypeImpl;
    }

    @Override
    protected boolean strictNullChecks() {
        return this.myStrictNullCheck;
    }

    @NotNull
    private JSType finalizeEvolvingArrayType(@NotNull JSType arrayType) {
        if (arrayType == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(54);
        }
        if (arrayType instanceof JSArrayTypeImpl) {
            JSType type = ((JSArrayTypeImpl)arrayType).getType();
            if (type instanceof TypeScriptNeverJSTypeImpl) {
                JSType jSType = this.myDeclaredType;
                if (jSType == null) {
                    JSControlFlowTypeGuard.$$$reportNull$$$0(55);
                }
                return jSType;
            }
            arrayType.putUserData(EVOLVING_ARRAY, null);
        }
        JSType jSType = arrayType;
        if (jSType == null) {
            JSControlFlowTypeGuard.$$$reportNull$$$0(56);
        }
        return jSType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 53: 
            case 55: 
            case 56: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 53: 
            case 55: 
            case 56: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 53: 
            case 55: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/guard/JSControlFlowTypeGuard";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: 
            case 11: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentInstruction";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentType";
                break;
            }
            case 22: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignmentType";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 31: 
            case 33: 
            case 36: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentParameter";
                break;
            }
            case 47: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 48: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 51: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayType";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/guard/JSControlFlowTypeGuard";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getNarrowedTypeImpl";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeAtFlowNode";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeAtFlowNodeImpl";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getAssignmentReducedType";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeAtParentScope";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeAtCaseBlock";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeAtFlowCondition";
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrevFlowType";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getEvolvingArrayType";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "finalizeEvolvingArrayType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isEvolvingArrayOperationTarget";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "useAutoTypes";
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 53: 
            case 55: 
            case 56: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getControlFlowInstruction";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTypeAtFlowNode";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getTypeAtFlowNodeImpl";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getTypeAtFlowAssignment";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getAssignmentReducedType";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getTypeAtParentScope";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getTypeAtFlowArrayMutation";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "addEvolvingArrayElementType";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getTypeAtCaseBlock";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getTypeAtFlowCondition";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getPrevFlowType";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getUnionOrEvolvingArrayType";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "mergeEvolvingArrays";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "isEvolvingArrayType";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getEvolvingArrayType";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "finalizeEvolvingArrayType";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getAssignmentReducedType$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 53: 
            case 55: 
            case 56: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

