/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types.guard;

import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeComparingCache;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.primitives.TypeScriptNeverJSTypeImpl;
import com.intellij.psi.PsiElement;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Predicate;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptTypeRelations {
    public static boolean isTypeIdenticalTo(@Nullable JSType source, @Nullable JSType target, @Nullable ProcessingContext context) {
        return false;
    }

    public static boolean isTypeSubtypeOf(@Nullable JSType source, @Nullable JSType target, @NotNull ProcessingContext processingContext) {
        if (processingContext == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(0);
        }
        if (source == null || target == null) {
            return false;
        }
        assert (processingContext.get(JSTypeComparingCache.SUBTYPING_CONTEXT) != null);
        return target.isDirectlyAssignableType(source, processingContext);
    }

    public static boolean isTypeInstanceOf(@Nullable JSType source, @Nullable JSType target, @NotNull ProcessingContext subtypingContext) {
        if (subtypingContext == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(1);
        }
        return TypeScriptTypeRelations.isTypeSubtypeOf(source, target, subtypingContext);
    }

    public static boolean areTypesComparable(@Nullable JSType type1, @Nullable JSType type2, @Nullable ProcessingContext context) {
        return TypeScriptTypeRelations.isTypeComparableTo(type1, type2, context) || TypeScriptTypeRelations.isTypeComparableTo(type2, type1, context);
    }

    public static boolean isTypeComparableTo(@Nullable JSType source, @Nullable JSType target, @Nullable ProcessingContext context) {
        return source != null && source.isDirectlyAssignableType(target, context);
    }

    public static boolean compareTypesAssignable(@Nullable JSType source, @Nullable JSType target, @Nullable ProcessingContext context) {
        return source != null && source.isDirectlyAssignableType(target, context);
    }

    public static boolean isTypeAssignableTo(@Nullable JSType source, @Nullable JSType target, @Nullable ProcessingContext context) {
        return target != null && target.isDirectlyAssignableType(source, context);
    }

    public static boolean isTypeSubsetOf(@Nullable JSType source, @Nullable JSType target, @Nullable ProcessingContext context) {
        if (source == null || target == null) {
            return source == target;
        }
        if (source.isEquivalentTo(target, context)) {
            return true;
        }
        return target instanceof JSCompositeTypeImpl && TypeScriptTypeRelations.isTypeSubsetOfUnionType(source, (JSCompositeTypeImpl)target, context);
    }

    public static boolean typeMaybeAssignableTo(@Nullable JSType source, @Nullable JSType target, @Nullable ProcessingContext context) {
        if (source instanceof JSCompositeTypeImpl) {
            return ((JSCompositeTypeImpl)source).getTypes().stream().anyMatch(el -> TypeScriptTypeRelations.typeMaybeAssignableTo(el, target, context));
        }
        return TypeScriptTypeRelations.isTypeAssignableTo(source, target, context);
    }

    public static boolean isTypeSubsetOfUnionType(@NotNull JSType source, @NotNull JSCompositeTypeImpl target, @Nullable ProcessingContext context) {
        if (source == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(2);
        }
        if (target == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(3);
        }
        List<JSType> types = target.getTypes();
        if (source instanceof JSCompositeTypeImpl) {
            List<JSType> subTypes = ((JSCompositeTypeImpl)source).getTypes();
            for (JSType type : subTypes) {
                if (TypeScriptTypeRelations.containsType(types, type, context)) continue;
                return false;
            }
            return true;
        }
        return TypeScriptTypeRelations.containsType(types, source, context);
    }

    public static boolean containsType(@NotNull List<JSType> types, @NotNull JSType sourceType, @Nullable ProcessingContext context) {
        if (types == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(4);
        }
        if (sourceType == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(5);
        }
        return types.stream().anyMatch(el -> {
            if (sourceType == null) {
                TypeScriptTypeRelations.$$$reportNull$$$0(18);
            }
            return el.isEquivalentTo(sourceType, context);
        });
    }

    static JSType expandType(@Nullable JSType type) {
        return JSTypeUtils.getValuableType(type);
    }

    @NotNull
    public static JSType filterType(@Nullable JSType type, @NotNull Predicate<JSType> filter, @NotNull PsiElement context) {
        if (filter == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(6);
        }
        if (context == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(7);
        }
        if (type == null) {
            TypeScriptNeverJSTypeImpl typeScriptNeverJSTypeImpl = new TypeScriptNeverJSTypeImpl(JSTypeSourceFactory.createTypeSource(context, true));
            if (typeScriptNeverJSTypeImpl == null) {
                TypeScriptTypeRelations.$$$reportNull$$$0(8);
            }
            return typeScriptNeverJSTypeImpl;
        }
        if ((type = TypeScriptTypeRelations.expandType(type)) instanceof JSCompositeTypeImpl) {
            List<JSType> types = ((JSCompositeTypeImpl)type).getTypes();
            List<JSType> resultTypes = types.stream().filter(el -> {
                if (filter == null) {
                    TypeScriptTypeRelations.$$$reportNull$$$0(17);
                }
                return filter.apply(el);
            }).collect(Collectors.toList());
            if (types.size() == resultTypes.size()) {
                JSType jSType = type;
                if (jSType == null) {
                    TypeScriptTypeRelations.$$$reportNull$$$0(9);
                }
                return jSType;
            }
            JSType jSType = TypeScriptTypeRelations.getUnionType(resultTypes, type.getSource());
            if (jSType == null) {
                TypeScriptTypeRelations.$$$reportNull$$$0(10);
            }
            return jSType;
        }
        Object object = filter.apply((Object)type) ? type : new TypeScriptNeverJSTypeImpl(type.getSource());
        if (object == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(11);
        }
        return object;
    }

    @NotNull
    public static JSType getUnionType(@NotNull Collection<JSType> resultTypes, @NotNull JSTypeSource source) {
        if (resultTypes == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(12);
        }
        if (source == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(13);
        }
        if (resultTypes.isEmpty()) {
            TypeScriptNeverJSTypeImpl typeScriptNeverJSTypeImpl = new TypeScriptNeverJSTypeImpl(source);
            if (typeScriptNeverJSTypeImpl == null) {
                TypeScriptTypeRelations.$$$reportNull$$$0(14);
            }
            return typeScriptNeverJSTypeImpl;
        }
        if (resultTypes.size() == 1) {
            JSType jSType = (JSType)ContainerUtil.getFirstItem(resultTypes, null);
            if (jSType == null) {
                TypeScriptTypeRelations.$$$reportNull$$$0(15);
            }
            return jSType;
        }
        JSType jSType = JSCompositeTypeImpl.getCommonType(resultTypes, source, true);
        if (jSType == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(16);
        }
        return jSType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subtypingContext";
                break;
            }
            case 2: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 5: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceType";
                break;
            }
            case 6: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/guard/TypeScriptTypeRelations";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/guard/TypeScriptTypeRelations";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "filterType";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnionType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isTypeSubtypeOf";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isTypeInstanceOf";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isTypeSubsetOfUnionType";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "containsType";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "filterType";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getUnionType";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "lambda$filterType$2";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$containsType$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

