/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.util;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.ecmascript6.TypeScriptResolveProcessor;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSSuperExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSClassUtils {
    private JSClassUtils() {
    }

    public static boolean canHaveClasses(@NotNull PsiElement element) {
        DialectOptionHolder holder;
        if (element == null) {
            JSClassUtils.$$$reportNull$$$0(0);
        }
        return (holder = DialectDetector.dialectOfElement(element)) != null && holder.hasFeature(JSLanguageFeature.CLASSES);
    }

    public static boolean isES6ClassImplementation(@Nullable PsiElement context) {
        DialectOptionHolder holder = DialectDetector.dialectOfElement(context);
        return JSClassUtils.isES6ClassImplementation(holder);
    }

    public static boolean isES6ClassImplementation(@Nullable DialectOptionHolder holder) {
        return holder != null && (holder.isECMA6 || holder.isTypeScript);
    }

    @NotNull
    public static String createClassFunctionName(@NotNull String name, @NotNull PsiElement context) {
        DialectOptionHolder holder;
        if (name == null) {
            JSClassUtils.$$$reportNull$$$0(1);
        }
        if (context == null) {
            JSClassUtils.$$$reportNull$$$0(2);
        }
        if (JSClassUtils.isES6ClassImplementation(holder = DialectDetector.dialectOfElement(context))) {
            String string = name;
            if (string == null) {
                JSClassUtils.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = "function " + name;
        if (string == null) {
            JSClassUtils.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    public static String getDefaultFieldQualifier(@NotNull PsiElement context, boolean withDot) {
        DialectOptionHolder holder;
        if (context == null) {
            JSClassUtils.$$$reportNull$$$0(5);
        }
        if ((holder = DialectDetector.dialectOfElement(context)) != null && (holder.isTypeScript || holder.isECMA6)) {
            return "this" + (withDot ? "." : "");
        }
        return null;
    }

    @Nullable
    public static String getAnyTypeString(@NotNull PsiElement context, boolean strict) {
        DialectOptionHolder holder;
        if (context == null) {
            JSClassUtils.$$$reportNull$$$0(6);
        }
        if ((holder = DialectDetector.dialectOfElement(context)) != null && holder.isECMA4) {
            return "*";
        }
        if (holder != null && holder.isTypeScript && strict) {
            return "any";
        }
        return null;
    }

    public static String createConstructorSignatureForClass(JSClass jsClass, boolean isPublic) {
        DialectOptionHolder holder = DialectDetector.dialectOfElement((PsiElement)jsClass);
        assert (holder != null);
        if (holder.isECMA4) {
            return (isPublic ? "public " : "") + "function " + jsClass.getName();
        }
        return "constructor";
    }

    @NotNull
    public static String getCast(@NotNull String type, @NotNull String expr, @NotNull DialectOptionHolder holder) {
        if (type == null) {
            JSClassUtils.$$$reportNull$$$0(7);
        }
        if (expr == null) {
            JSClassUtils.$$$reportNull$$$0(8);
        }
        if (holder == null) {
            JSClassUtils.$$$reportNull$$$0(9);
        }
        if (holder.isTypeScript) {
            if (holder.isJSX) {
                String string = expr + " as " + type;
                if (string == null) {
                    JSClassUtils.$$$reportNull$$$0(10);
                }
                return string;
            }
            String string = "<" + type + ">" + expr;
            if (string == null) {
                JSClassUtils.$$$reportNull$$$0(11);
            }
            return string;
        }
        String string = type + "(" + expr + ")";
        if (string == null) {
            JSClassUtils.$$$reportNull$$$0(12);
        }
        return string;
    }

    public static boolean isAllowImplementation(@NotNull JSClass jsClass, @Nullable PsiElement context) {
        if (jsClass == null) {
            JSClassUtils.$$$reportNull$$$0(13);
        }
        return jsClass.isInterface() || context != null && DialectDetector.isTypeScript(context);
    }

    @Contract(value="null -> false")
    public static boolean isPossibleHierarchyMember(@Nullable PsiElement element) {
        return element instanceof JSFunction || element instanceof JSField && DialectDetector.isTypeScript(element);
    }

    public static boolean processClassesInHierarchy(@NotNull JSClass<?> clazz, boolean includeInterfaces, @NotNull TypeScriptUtil.JSClassHierarchyProcessor processor) {
        if (clazz == null) {
            JSClassUtils.$$$reportNull$$$0(14);
        }
        if (processor == null) {
            JSClassUtils.$$$reportNull$$$0(15);
        }
        return JSClassUtils.processClassesInHierarchyImpl(clazz, includeInterfaces, processor, JSTypeSubstitutor.EMPTY, null, ContainerUtil.newHashSet());
    }

    private static boolean processClassesInHierarchyImpl(@NotNull JSClass<?> clazz, boolean includeInterfaces, @NotNull TypeScriptUtil.JSClassHierarchyProcessor processor, @NotNull JSTypeSubstitutor typeSubstitutor, @Nullable Boolean fromImplements, @NotNull Set<JSClass> visited) {
        if (clazz == null) {
            JSClassUtils.$$$reportNull$$$0(16);
        }
        if (processor == null) {
            JSClassUtils.$$$reportNull$$$0(17);
        }
        if (typeSubstitutor == null) {
            JSClassUtils.$$$reportNull$$$0(18);
        }
        if (visited == null) {
            JSClassUtils.$$$reportNull$$$0(19);
        }
        if (!visited.add(clazz)) {
            return true;
        }
        if (!processor.process(clazz, typeSubstitutor, fromImplements != null && fromImplements != false)) {
            return false;
        }
        if (clazz instanceof TypeScriptEnum) {
            return JSClassUtils.processEnumSuperClassesInHierarchy((TypeScriptEnum)clazz, includeInterfaces, processor, typeSubstitutor, fromImplements, visited);
        }
        ArrayList superReferences = ContainerUtil.newArrayList();
        JSReferenceList extendsList = clazz.getExtendsList();
        JSReferenceList implementsList = includeInterfaces ? clazz.getImplementsList() : null;
        int extendsListElementsLeft = 0;
        if (extendsList != null) {
            superReferences.addAll(extendsList.getResolvedExpressions());
            extendsListElementsLeft = superReferences.size();
        }
        if (implementsList != null) {
            superReferences.addAll(implementsList.getResolvedExpressions());
        }
        for (Pair superReference : superReferences) {
            List<JSType> typeArguments = JSClassUtils.buildTypeArguments((JSReferenceListMember)superReference.first);
            boolean currentFromImplements = fromImplements == null ? extendsListElementsLeft-- <= 0 : fromImplements;
            Collection classes = (Collection)superReference.second;
            if (classes == null) continue;
            for (JSClass superClass : classes) {
                JSTypeSubstitutor combinedSubstitutor = JSClassUtils.combineSubstitutor(typeSubstitutor, typeArguments, superClass);
                if (includeInterfaces && superClass instanceof TypeScriptTypeAlias) {
                    ArrayList<JSClass> aliasResolves = new ArrayList<JSClass>();
                    TypeScriptUtil.resolveAliasToClass((TypeScriptTypeAlias)superClass, aliasResolves, null);
                    for (JSClass aliasResolve : aliasResolves) {
                        if (!JSClassUtils.canInclude(includeInterfaces, aliasResolve) || JSClassUtils.processClassesInHierarchyImpl(aliasResolve, includeInterfaces, processor, JSTypeSubstitutor.EMPTY, currentFromImplements, visited)) continue;
                        return false;
                    }
                    continue;
                }
                if (!JSClassUtils.canInclude(includeInterfaces, superClass) || JSClassUtils.processClassesInHierarchyImpl(superClass, includeInterfaces, processor, combinedSubstitutor, currentFromImplements, visited)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean canInclude(boolean includeInterfaces, @NotNull JSClass superClass) {
        if (superClass == null) {
            JSClassUtils.$$$reportNull$$$0(20);
        }
        return (includeInterfaces || !(superClass instanceof TypeScriptInterface)) && !"Object".equals(superClass.getName());
    }

    private static boolean processEnumSuperClassesInHierarchy(@NotNull TypeScriptEnum clazz, boolean includeInterfaces, @NotNull TypeScriptUtil.JSClassHierarchyProcessor processor, JSTypeSubstitutor typeSubstitutor, @Nullable Boolean fromImplements, Set<JSClass> visited) {
        if (clazz == null) {
            JSClassUtils.$$$reportNull$$$0(21);
        }
        if (processor == null) {
            JSClassUtils.$$$reportNull$$$0(22);
        }
        for (JSClass aClass : clazz.getSupers()) {
            if (!JSClassUtils.canInclude(includeInterfaces, aClass) || JSClassUtils.processClassesInHierarchyImpl(aClass, includeInterfaces, processor, typeSubstitutor, fromImplements, visited)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static List<JSType> buildTypeArguments(@NotNull JSReferenceListMember referenceListMember) {
        if (referenceListMember == null) {
            JSClassUtils.$$$reportNull$$$0(23);
        }
        JSTypeDeclaration[] typeArgumentDeclarations = referenceListMember.getTypeArguments();
        ArrayList typeArguments = ContainerUtil.newArrayListWithCapacity((int)typeArgumentDeclarations.length);
        for (JSTypeDeclaration typeArgumentDeclaration : typeArgumentDeclarations) {
            typeArguments.add(TypeScriptTypeParser.buildTypeFromTypeScript(typeArgumentDeclaration));
        }
        ArrayList arrayList = typeArguments;
        if (arrayList == null) {
            JSClassUtils.$$$reportNull$$$0(24);
        }
        return arrayList;
    }

    private static JSTypeSubstitutor combineSubstitutor(@Nullable JSTypeSubstitutor typeSubstitutor, @NotNull List<JSType> typeArguments, @NotNull JSClass superClass) {
        JSTypeSubstitutor combinedSubstitutor;
        TypeScriptTypeParameterList typeParameterList;
        JSTypeSubstitutor superClassSubstitutor;
        if (typeArguments == null) {
            JSClassUtils.$$$reportNull$$$0(25);
        }
        if (superClass == null) {
            JSClassUtils.$$$reportNull$$$0(26);
        }
        if ((superClassSubstitutor = TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments(typeParameterList = superClass instanceof TypeScriptTypeParameterListOwner ? ((TypeScriptTypeParameterListOwner)superClass).getTypeParameterList() : null, typeArguments)) != null) {
            combinedSubstitutor = new JSTypeSubstitutor();
            for (Map.Entry entry : superClassSubstitutor.entrySet()) {
                combinedSubstitutor.put(entry.getKey(), (Object)JSTypeUtils.applyGenericArguments((JSType)entry.getValue(), (Map<String, JSType>)typeSubstitutor));
            }
        } else {
            combinedSubstitutor = JSTypeSubstitutor.EMPTY;
        }
        return combinedSubstitutor;
    }

    @NotNull
    public static ResolveResult[] resolveES6Constructor(@NotNull JSClass clazz, @NotNull JSExpression methodExpression) {
        if (clazz == null) {
            JSClassUtils.$$$reportNull$$$0(27);
        }
        if (methodExpression == null) {
            JSClassUtils.$$$reportNull$$$0(28);
        }
        TypeScriptResolveProcessor processor = new TypeScriptResolveProcessor("constructor", methodExpression.getContainingFile(), methodExpression, false);
        THashSet visitedClasses = new THashSet();
        ArrayDeque<JSClass> classQueue = new ArrayDeque<JSClass>();
        PsiElement parent = methodExpression.getParent();
        classQueue.add(clazz);
        while (!classQueue.isEmpty()) {
            PsiElement element;
            JSClass currentClass = (JSClass)classQueue.poll();
            if (!visitedClasses.add(currentClass.getQualifiedName())) continue;
            JSResolveUtil.processDeclarationsInScope((JSElement)currentClass, processor, ResolveState.initial(), null, (PsiElement)methodExpression);
            ResolveResult[] results = ((SinkResolveProcessor)processor).getResultsAsResolveResults();
            if (results.length >= 1) {
                if (results == null) {
                    JSClassUtils.$$$reportNull$$$0(29);
                }
                return results;
            }
            if (currentClass instanceof TypeScriptClass && parent instanceof JSNewExpression && (element = JSSuperExpressionImpl.matchTypeScriptSuperConstructor((JSCallExpression)((JSNewExpression)parent), (TypeScriptClass)currentClass)) != null) {
                PsiElementResolveResult[] psiElementResolveResultArray = new PsiElementResolveResult[]{new PsiElementResolveResult(element, true)};
                if (psiElementResolveResultArray == null) {
                    JSClassUtils.$$$reportNull$$$0(30);
                }
                return psiElementResolveResultArray;
            }
            Collections.addAll(classQueue, currentClass.getSuperClasses());
        }
        if (parent instanceof JSNewExpression && ((JSNewExpression)parent).getArguments().length == 0) {
            PsiElementResolveResult[] psiElementResolveResultArray = new PsiElementResolveResult[]{new PsiElementResolveResult((PsiElement)clazz, true)};
            if (psiElementResolveResultArray == null) {
                JSClassUtils.$$$reportNull$$$0(31);
            }
            return psiElementResolveResultArray;
        }
        JSClass resolveResult = clazz;
        if (clazz instanceof TypeScriptClass) {
            TypeScriptFunction[] constructors = ((TypeScriptClass)clazz).getConstructors();
            if (constructors.length == 1) {
                resolveResult = constructors[0];
            }
        } else {
            JSFunction candidate = clazz.getConstructor();
            if (candidate != null) {
                resolveResult = candidate;
            }
        }
        PsiElementResolveResult[] psiElementResolveResultArray = new PsiElementResolveResult[]{new PsiElementResolveResult((PsiElement)resolveResult, false)};
        if (psiElementResolveResultArray == null) {
            JSClassUtils.$$$reportNull$$$0(32);
        }
        return psiElementResolveResultArray;
    }

    @Contract(value="null->false")
    public static boolean isStaticMethodOrField(@Nullable PsiElement element) {
        JSClass clazz = JSUtils.getMemberContainingClass(element);
        if (clazz == null || clazz.isInterface()) {
            return false;
        }
        return JSPsiImplUtils.hasModifier((JSAttributeListOwner)element, JSAttributeList.ModifierType.STATIC);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 24: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 24: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 24: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/util/JSClassUtils";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 14: 
            case 16: 
            case 21: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 15: 
            case 17: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSubstitutor";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 20: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superClass";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceListMember";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeArguments";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/util/JSClassUtils";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createClassFunctionName";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCast";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTypeArguments";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveES6Constructor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canHaveClasses";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createClassFunctionName";
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 24: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultFieldQualifier";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAnyTypeString";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCast";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isAllowImplementation";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processClassesInHierarchy";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "processClassesInHierarchyImpl";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "canInclude";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "processEnumSuperClassesInHierarchy";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeArguments";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "combineSubstitutor";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "resolveES6Constructor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 24: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

