/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.util;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.findUsages.JSReadWriteAccessDetector;
import com.intellij.lang.javascript.index.JSPackageIndex;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSBreakStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCaseClause;
import com.intellij.lang.javascript.psi.JSContinueStatement;
import com.intellij.lang.javascript.psi.JSDoWhileStatement;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSEmptyStatement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionCodeFragment;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSThrowStatement;
import com.intellij.lang.javascript.psi.JSTryStatement;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSPackage;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSUtils {
    private static final TokenSet ATTRIBUTE_LIST_STOP_AT = TokenSet.orSet((TokenSet[])new TokenSet[]{JSExtendedLanguagesTokenSetProvider.SOURCE_ELEMENTS, TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.LBRACE})});

    @Nullable
    public static JSLanguageDialect getDialect(@Nullable PsiFile file) {
        if (file == null) {
            return null;
        }
        Language language = file.getLanguage();
        return language instanceof JSLanguageDialect ? (JSLanguageDialect)language : DialectDetector.getLanguageDialect((PsiElement)file);
    }

    public static boolean isJavaScriptFile(VirtualFile file) {
        return file != null && DialectDetector.JAVASCRIPT_FILE_TYPES.contains(file.getFileType());
    }

    public static boolean isJavaScriptFile(PsiFile file) {
        return file != null && DialectDetector.JAVASCRIPT_FILE_TYPES.contains(file.getFileType());
    }

    public static boolean isNeedParenthesis(JSExpression oldExpr, JSExpression newExpr) {
        int priority = JSUtils.getExpressionPrecedence(newExpr);
        PsiElement parent = oldExpr.getParent();
        if (!(parent instanceof JSExpression) || parent instanceof JSFunctionExpression) {
            return false;
        }
        int parentPriority = JSUtils.getExpressionPrecedence((JSExpression)parent);
        if (priority < parentPriority) {
            return true;
        }
        if (priority == parentPriority && parent instanceof JSCallExpression && newExpr instanceof JSFunctionExpression) {
            return true;
        }
        if (priority == parentPriority && parent instanceof JSBinaryExpression) {
            IElementType operationSign = ((JSBinaryExpression)parent).getOperationSign();
            if (oldExpr != ((JSBinaryExpression)parent).getROperand()) {
                return false;
            }
            if (!JSTokenTypes.ASSOC_OPERATIONS.contains(operationSign)) {
                return true;
            }
            return ((JSBinaryExpression)newExpr).getOperationSign() != operationSign;
        }
        return false;
    }

    private static int getExpressionPrecedence(JSExpression expr) {
        IElementType i = expr.getNode().getElementType();
        if (i == JSElementTypes.ASSIGNMENT_EXPRESSION) {
            return 0;
        }
        if (i == JSElementTypes.CONDITIONAL_EXPRESSION) {
            return 1;
        }
        if (i == JSElementTypes.BINARY_EXPRESSION) {
            IElementType opType = ((JSBinaryExpression)expr).getOperationSign();
            if (opType == JSTokenTypes.OROR) {
                return 2;
            }
            if (opType == JSTokenTypes.ANDAND) {
                return 3;
            }
            if (opType == JSTokenTypes.OR) {
                return 4;
            }
            if (opType == JSTokenTypes.XOR) {
                return 5;
            }
            if (opType == JSTokenTypes.AND) {
                return 6;
            }
            if (JSTokenTypes.EQUALITY_OPERATIONS.contains(opType)) {
                return 7;
            }
            if (JSTokenTypes.RELATIONAL_OPERATIONS.contains(opType)) {
                return 8;
            }
            if (JSTokenTypes.SHIFT_OPERATIONS.contains(opType)) {
                return 9;
            }
            if (JSTokenTypes.ADDITIVE_OPERATIONS.contains(opType)) {
                return 10;
            }
            if (JSTokenTypes.MULTIPLICATIVE_OPERATIONS.contains(opType)) {
                return 11;
            }
            return 8;
        }
        if (i == JSElementTypes.PREFIX_EXPRESSION) {
            return 12;
        }
        if (i == JSElementTypes.POSTFIX_EXPRESSION) {
            return 13;
        }
        return 14;
    }

    @Nullable
    public static PsiElement findFunctionAnchor(@Nullable PsiElement scope, @Nullable PsiElement functionAnchor, boolean shouldPlaceAtScopeStart) {
        PsiElement grandParent;
        PsiComment docComment;
        if (scope == null || functionAnchor == null) {
            return null;
        }
        while (functionAnchor != null && functionAnchor.getParent() != scope) {
            functionAnchor = functionAnchor.getParent();
        }
        if (functionAnchor instanceof JSProperty && (docComment = JSDocumentationUtils.findDocComment(functionAnchor)) != null) {
            functionAnchor = docComment;
        }
        if ((grandParent = scope.getParent()) instanceof JSFunction && shouldPlaceAtScopeStart) {
            JSStatement statement = JSPsiImplUtils.findFirstFunctionStatement((JSFunction)grandParent);
            while (statement instanceof JSVarStatement && !PsiTreeUtil.isAncestor((PsiElement)statement, (PsiElement)grandParent, (boolean)true) || statement instanceof PsiWhiteSpace || statement instanceof PsiComment) {
                statement = statement.getNextSibling();
            }
            if (statement != null) {
                return statement;
            }
        }
        return functionAnchor;
    }

    @Nullable
    public static PsiElement findStatementAnchor(PsiElement referenceExpression, PsiFile file) {
        return JSUtils.findStatementAnchor(referenceExpression, file, false);
    }

    @Nullable
    public static PsiElement findStatementAnchor(PsiElement referenceExpression, PsiFile file, boolean withSource) {
        JSEmbeddedContent scriptTagAnchor;
        PsiElement anchor;
        Object object = anchor = withSource ? JSUtils.findSourceAnchor(referenceExpression, DialectDetector.isActionScript(referenceExpression)) : PsiTreeUtil.getParentOfType((PsiElement)referenceExpression, JSStatement.class);
        if (anchor != null) {
            if (anchor instanceof JSPackageStatement) {
                return null;
            }
            PsiElement anchorParent = anchor.getParent();
            if (anchorParent instanceof JSIfStatement || anchorParent instanceof JSTryStatement) {
                anchor = PsiTreeUtil.getParentOfType((PsiElement)anchor, JSStatement.class);
            }
        }
        if (file instanceof XmlFile && PsiTreeUtil.getParentOfType((PsiElement)referenceExpression, XmlAttributeValue.class) != null && (scriptTagAnchor = JSUtils.findScriptTagContent((XmlFile)file)) != null) {
            return scriptTagAnchor;
        }
        return anchor;
    }

    @Nullable
    public static JSEmbeddedContent findScriptTagContent(@NotNull XmlFile file) {
        XmlTag scriptTag;
        XmlTag headTag;
        XmlTag tag;
        TemplateLanguageFileViewProvider viewProvider;
        PsiFile psi;
        XmlFile root;
        if (file == null) {
            JSUtils.$$$reportNull$$$0(0);
        }
        if ((root = file).getViewProvider() instanceof TemplateLanguageFileViewProvider && (psi = (viewProvider = (TemplateLanguageFileViewProvider)root.getViewProvider()).getPsi(viewProvider.getTemplateDataLanguage())) instanceof XmlFile) {
            root = (XmlFile)psi;
        }
        if ((tag = root.getDocument().getRootTag()) != null && (headTag = tag.findFirstSubTag("head")) != null && (scriptTag = headTag.findFirstSubTag("script")) != null) {
            return (JSEmbeddedContent)PsiTreeUtil.getChildOfType((PsiElement)scriptTag, JSEmbeddedContent.class);
        }
        return null;
    }

    @Nullable
    public static JSSourceElement findSourceAnchor(PsiElement expression, boolean acceptMembers) {
        PsiElement anchor = PsiTreeUtil.getParentOfType((PsiElement)expression, JSSourceElement.class, (boolean)true);
        if (anchor == null || anchor instanceof JSStatement && (acceptMembers || !JSUtils.isMember(anchor))) {
            return (JSSourceElement)anchor;
        }
        if (!(anchor instanceof JSExpression || !acceptMembers && JSUtils.isMember(anchor))) {
            return (JSSourceElement)anchor;
        }
        return JSUtils.findSourceAnchor(anchor, acceptMembers);
    }

    @NotNull
    public static JSAttributeList.AccessType getImplicitAccessType(@NotNull PsiElement element) {
        boolean typeScript;
        PsiElement parent;
        if (element == null) {
            JSUtils.$$$reportNull$$$0(1);
        }
        if ((parent = element.getContext()) == null) {
            JSAttributeList.AccessType accessType = JSAttributeList.AccessType.PACKAGE_LOCAL;
            if (accessType == null) {
                JSUtils.$$$reportNull$$$0(2);
            }
            return accessType;
        }
        if (parent instanceof JSClass && ((JSClass)parent).isInterface()) {
            JSAttributeList.AccessType accessType = JSAttributeList.AccessType.PUBLIC;
            if (accessType == null) {
                JSUtils.$$$reportNull$$$0(3);
            }
            return accessType;
        }
        DialectOptionHolder dialect = DialectDetector.dialectOfElement(element);
        boolean bl = typeScript = dialect != null && dialect.isTypeScript;
        if (typeScript) {
            JSAttributeListOwner firstAttributeListParent;
            PsiFile file = parent.getContainingFile();
            if (file != null && DialectDetector.isTypeScriptDefinitionFile(file) && !(element instanceof TypeScriptImportStatement)) {
                JSAttributeList.AccessType accessType = JSAttributeList.AccessType.PUBLIC;
                if (accessType == null) {
                    JSUtils.$$$reportNull$$$0(4);
                }
                return accessType;
            }
            if (element instanceof TypeScriptModule && element.getParent() instanceof JSFile && file instanceof JSFile && !((JSFile)file).isCommonJSModule()) {
                JSAttributeList.AccessType accessType = JSAttributeList.AccessType.PUBLIC;
                if (accessType == null) {
                    JSUtils.$$$reportNull$$$0(5);
                }
                return accessType;
            }
            JSAttributeListOwner attrListOwner = firstAttributeListParent = (JSAttributeListOwner)PsiTreeUtil.getContextOfType((PsiElement)parent, JSAttributeListOwner.class, (boolean)false);
            if (!(element instanceof TypeScriptImportStatement)) {
                while (attrListOwner != null) {
                    JSAttributeList attributeList = attrListOwner.getAttributeList();
                    if (attributeList != null && attributeList.hasModifier(JSAttributeList.ModifierType.DECLARE)) {
                        JSAttributeList.AccessType accessType = JSAttributeList.AccessType.PUBLIC;
                        if (accessType == null) {
                            JSUtils.$$$reportNull$$$0(6);
                        }
                        return accessType;
                    }
                    attrListOwner = (JSAttributeListOwner)PsiTreeUtil.getContextOfType((PsiElement)attrListOwner, (Class[])new Class[]{JSAttributeListOwner.class});
                }
            }
            if (firstAttributeListParent instanceof TypeScriptModule) {
                JSAttributeList.AccessType accessType = JSAttributeList.AccessType.PRIVATE;
                if (accessType == null) {
                    JSUtils.$$$reportNull$$$0(7);
                }
                return accessType;
            }
        }
        if (parent instanceof TypeScriptModule) {
            JSAttributeList.AccessType accessType = JSAttributeList.AccessType.PRIVATE;
            if (accessType == null) {
                JSUtils.$$$reportNull$$$0(8);
            }
            return accessType;
        }
        if (typeScript && !(parent instanceof JSFile)) {
            JSAttributeList.AccessType accessType = JSAttributeList.AccessType.PUBLIC;
            if (accessType == null) {
                JSUtils.$$$reportNull$$$0(9);
            }
            return accessType;
        }
        JSAttributeList.AccessType accessType = dialect != null && dialect.isECMA4 ? JSAttributeList.AccessType.PACKAGE_LOCAL : JSAttributeList.AccessType.PUBLIC;
        if (accessType == null) {
            JSUtils.$$$reportNull$$$0(10);
        }
        return accessType;
    }

    public static boolean packageExists(String packageName, GlobalSearchScope scope) {
        if (StringUtil.isEmpty((String)packageName)) {
            return true;
        }
        return !FileBasedIndex.getInstance().getValues(JSPackageIndex.INDEX_ID, (Object)packageName, scope).isEmpty();
    }

    public static boolean isValidClassName(String name, boolean acceptFqn) {
        if (StringUtil.isEmptyOrSpaces((String)name)) {
            return false;
        }
        if (acceptFqn) {
            return name.trim().matches("[\\p{Alpha}][\\p{Alnum}_]*(\\.[\\p{Alpha}][\\p{Alnum}_]*)*");
        }
        return name.trim().matches("[\\p{Alpha}][\\p{Alnum}_]*");
    }

    public static boolean isMember(PsiElement element) {
        return JSUtils.getMemberContainingClass(element) != null;
    }

    @Contract(value="null->null")
    public static JSClass getMemberContainingClass(@Nullable PsiElement methodOrField) {
        PsiElement clazz = null;
        if (methodOrField instanceof JSFunction) {
            clazz = methodOrField.getContext();
            if (clazz instanceof JSExpressionCodeFragment) {
                clazz = clazz.getContext();
            }
        } else if (methodOrField instanceof JSParameter) {
            JSFunction function;
            JSParameter parameter = (JSParameter)methodOrField;
            if (TypeScriptPsiUtil.isFieldParameter(parameter) && (function = parameter.getDeclaringFunction()) instanceof TypeScriptFunction && function.isConstructor()) {
                clazz = function.getContext();
            }
        } else if (methodOrField instanceof JSVariable) {
            clazz = methodOrField.getContext().getContext();
        } else if (methodOrField instanceof JSVarStatement) {
            clazz = methodOrField.getContext();
        } else if (methodOrField instanceof JSField) {
            clazz = methodOrField.getContext();
        }
        if (clazz instanceof JSFile) {
            clazz = JSResolveUtil.getXmlBackedClass((JSFile)clazz);
        }
        if (clazz instanceof TypeScriptObjectType) {
            clazz = clazz.getContext();
        }
        return clazz instanceof JSClass ? (JSClass)clazz : null;
    }

    @Nullable
    public static JSReferenceExpression getMethodNameIfInsideCall(PsiElement parent) {
        JSExpression invokedMethod;
        PsiElement grandParent;
        if (parent instanceof JSArgumentList && (grandParent = parent.getParent()) instanceof JSCallExpression && (invokedMethod = ((JSCallExpression)grandParent).getMethodExpression()) instanceof JSReferenceExpression) {
            return (JSReferenceExpression)invokedMethod;
        }
        return null;
    }

    @Nullable
    public static JSCallExpression findCallExprByArg(@Nullable PsiElement arg) {
        PsiElement argList;
        PsiElement psiElement = argList = arg == null ? null : arg.getParent();
        if (argList instanceof JSArgumentList) {
            return (JSCallExpression)ObjectUtils.tryCast((Object)argList.getParent(), JSCallExpression.class);
        }
        return null;
    }

    public static int findParameterIndex(JSFunction function, JSParameter parameter) {
        JSParameter[] parameters = function.getParameterVariables();
        for (int i = 0; i < parameters.length; ++i) {
            if (parameters[i] != parameter) continue;
            return i;
        }
        return -1;
    }

    public static JSReferenceExpression findRefExprThatStartCallChaining(JSReferenceExpression qualifier) {
        JSExpression methodExpression;
        JSExpression expression;
        JSReferenceExpression localQualifier = qualifier;
        while ((expression = localQualifier.getQualifier()) instanceof JSCallExpression && (methodExpression = ((JSCallExpression)expression).getMethodExpression()) instanceof JSReferenceExpression) {
            localQualifier = (JSReferenceExpression)methodExpression;
        }
        return localQualifier;
    }

    @Nullable
    @Contract(value="!null->!null")
    public static JSExpression unparenthesize(@Nullable JSExpression expression) {
        while (expression instanceof JSParenthesizedExpression) {
            expression = ((JSParenthesizedExpression)expression).getInnerExpression();
        }
        return expression;
    }

    @Nullable
    public static PsiElement getParentSkipParentheses(@NotNull PsiElement element) {
        if (element == null) {
            JSUtils.$$$reportNull$$$0(11);
        }
        return PsiTreeUtil.skipParentsOfType((PsiElement)element, (Class[])new Class[]{JSParenthesizedExpression.class});
    }

    public static JSExpression[] findExpressionOccurrences(JSElement scope, Pair<JSExpression, TextRange> expr, boolean visitInnerFunctions) {
        if (expr.second != null) {
            return new JSExpression[]{(JSExpression)expr.first};
        }
        ArrayList<JSExpression> array = new ArrayList<JSExpression>();
        JSUtils.addExpressionOccurrences(JSUtils.unparenthesize((JSExpression)expr.first), array, (PsiElement)scope, visitInnerFunctions);
        return array.toArray(new JSExpression[array.size()]);
    }

    private static void addExpressionOccurrences(JSExpression expr, List<JSExpression> array, PsiElement scope, boolean visitInnerFunctions) {
        PsiElement[] children;
        for (PsiElement child : children = scope.getChildren()) {
            if (child instanceof JSExpression) {
                child = JSUtils.unparenthesize((JSExpression)child);
            }
            if (child == null) continue;
            if (child instanceof JSExpression) {
                boolean add = PsiEquivalenceUtil.areElementsEquivalent((PsiElement)child, (PsiElement)expr, null, (element1, element2) -> {
                    assert (element1 != null);
                    assert (element2 != null);
                    if (element1.textMatches(element2)) {
                        return 0;
                    }
                    if (element1.getNode().getElementType() == JSTokenTypes.STRING_LITERAL && element2.getNode().getElementType() == JSTokenTypes.STRING_LITERAL) {
                        String text1 = element1.getText();
                        String text2 = element2.getText();
                        if (StringUtil.equals((CharSequence)JSStringUtil.unquoteAndUnescapeString(text1), (CharSequence)JSStringUtil.unquoteAndUnescapeString(text2))) {
                            return 0;
                        }
                    }
                    return 1;
                });
                if (add && child != expr) {
                    add = !JSResolveUtil.isSelfReference(scope, child);
                    add &= JSReadWriteAccessDetector.ourInstance.getExpressionAccess(child) == ReadWriteAccessDetector.Access.Read || JSResolveUtil.isSelfReference((PsiElement)expr);
                }
                if ((add &= !(scope instanceof JSPrefixExpression) || ((JSPrefixExpression)scope).getOperationSign() != JSTokenTypes.DELETE_KEYWORD) && child instanceof JSParenthesizedExpression && (scope instanceof JSPrefixExpression && (((JSPrefixExpression)scope).getOperationSign() == JSTokenTypes.DELETE_KEYWORD || ((JSPrefixExpression)scope).getOperationSign() == JSTokenTypes.TYPEOF_KEYWORD) || scope instanceof JSNewExpression || scope instanceof JSCaseClause || scope instanceof JSReturnStatement || scope instanceof JSBinaryExpression && ((JSBinaryExpression)scope).getOperationSign() == JSTokenTypes.INSTANCEOF_KEYWORD)) {
                    add = false;
                }
                if (add) {
                    array.add((JSExpression)child);
                    continue;
                }
            }
            if (!visitInnerFunctions && child instanceof JSFunction && JSPsiImplUtils.tryGetArrowFunctionReturnExpression((JSFunction)child) == null) continue;
            JSUtils.addExpressionOccurrences(expr, array, child, visitInnerFunctions);
        }
    }

    @NotNull
    public static String getConfigJavaScriptDirPath() {
        String string = PathManager.getConfigPath() + File.separatorChar + "javascript";
        if (string == null) {
            JSUtils.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    public static String getExtLibsDirPath() {
        String string = JSUtils.getConfigJavaScriptDirPath() + File.separatorChar + "extLibs";
        if (string == null) {
            JSUtils.$$$reportNull$$$0(13);
        }
        return string;
    }

    public static boolean isScopeOwner(@NotNull PsiElement element) {
        if (element == null) {
            JSUtils.$$$reportNull$$$0(14);
        }
        return element instanceof JSFunction || element instanceof JSClass || element instanceof TypeScriptModule || element instanceof JSPackageStatement || element instanceof JSPackage;
    }

    @Nullable
    public static PsiElement getChildExcludingTypes(@NotNull PsiElement element, Class<?> ... classes) {
        if (element == null) {
            JSUtils.$$$reportNull$$$0(15);
        }
        if (classes == null) {
            JSUtils.$$$reportNull$$$0(16);
        }
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            boolean filtered = false;
            for (Class<?> aClass : classes) {
                if (!aClass.isInstance(child)) continue;
                filtered = true;
                break;
            }
            if (filtered) continue;
            return child;
        }
        return null;
    }

    public static boolean isLineBreakWhiteSpace(PsiElement element) {
        return element instanceof PsiWhiteSpace && StringUtil.containsLineBreak((CharSequence)element.getText());
    }

    @Nullable
    public static JSAttributeList getAttributeList(@NotNull StubBasedPsiElementBase<?> elementBase) {
        if (elementBase == null) {
            JSUtils.$$$reportNull$$$0(17);
        }
        return (JSAttributeList)JSStubBasedPsiTreeUtil.getStubOrPsiChild(elementBase, JSStubElementTypes.ATTRIBUTE_LISTS, ATTRIBUTE_LIST_STOP_AT);
    }

    public static boolean isStatementUsuallyRequiringSemicolon(@NotNull JSStatement node) {
        if (node == null) {
            JSUtils.$$$reportNull$$$0(18);
        }
        return node instanceof JSVarStatement || node instanceof JSExpressionStatement || node instanceof JSBreakStatement || node instanceof JSContinueStatement || node instanceof JSReturnStatement || node instanceof JSThrowStatement || node instanceof JSDoWhileStatement || node instanceof JSEmptyStatement;
    }

    @NotNull
    public static List<JSFunction> getRelatedFunctions(@Nullable PsiElement psiElement) {
        List<JSFunction> list = JSUtils.getRelatedFunctions(psiElement, 0);
        if (list == null) {
            JSUtils.$$$reportNull$$$0(19);
        }
        return list;
    }

    @NotNull
    private static List<JSFunction> getRelatedFunctions(@Nullable PsiElement psiElement, int depth) {
        if (psiElement instanceof JSFunction) {
            if (psiElement instanceof TypeScriptFunction && ((TypeScriptFunction)psiElement).isOverloadImplementation()) {
                List overloads = ((TypeScriptFunction)psiElement).getOverloadDeclarations();
                ArrayList result = ContainerUtil.newArrayListWithCapacity((int)overloads.size());
                result.addAll(overloads);
                ArrayList arrayList = result;
                if (arrayList == null) {
                    JSUtils.$$$reportNull$$$0(20);
                }
                return arrayList;
            }
            ArrayList arrayList = ContainerUtil.newArrayList((Object[])new JSFunction[]{(JSFunction)psiElement});
            if (arrayList == null) {
                JSUtils.$$$reportNull$$$0(21);
            }
            return arrayList;
        }
        if (psiElement instanceof JSVariable) {
            if (depth > 10) {
                List list = ContainerUtil.emptyList();
                if (list == null) {
                    JSUtils.$$$reportNull$$$0(22);
                }
                return list;
            }
            JSExpression initializer = ((JSVariable)psiElement).getInitializerOrStub();
            if (!(initializer instanceof JSReferenceExpression)) {
                List list = ContainerUtil.emptyList();
                if (list == null) {
                    JSUtils.$$$reportNull$$$0(23);
                }
                return list;
            }
            ResolveResult[] results = ((JSReferenceExpression)initializer).multiResolve(false);
            PsiElement resolve = JSResolveResult.resolve(results);
            if (resolve == null) {
                ArrayList functions = ContainerUtil.newArrayList();
                for (ResolveResult result : results) {
                    if (!result.isValidResult() || !(result.getElement() instanceof JSFunction)) continue;
                    JSFunction function = (JSFunction)result.getElement();
                    functions.add(function);
                }
                List list = functions.size() > 0 ? functions : ContainerUtil.emptyList();
                if (list == null) {
                    JSUtils.$$$reportNull$$$0(24);
                }
                return list;
            }
            PsiElement element = JSStubBasedPsiTreeUtil.calculateMeaningfulElement(resolve);
            List<JSFunction> list = JSUtils.getRelatedFunctions(element, depth + 1);
            if (list == null) {
                JSUtils.$$$reportNull$$$0(25);
            }
            return list;
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            JSUtils.$$$reportNull$$$0(26);
        }
        return list;
    }

    @NotNull
    public static JSParameterListElement[] resolveOverloadParameterList(@NotNull List<? extends JSFunctionItem> functions, @NotNull JSExpression[] arguments) {
        if (functions == null) {
            JSUtils.$$$reportNull$$$0(27);
        }
        if (arguments == null) {
            JSUtils.$$$reportNull$$$0(28);
        }
        JSParameterListElement[] parameters = JSParameterListElement.EMPTY_ARRAY;
        for (JSFunctionItem jSFunctionItem : functions) {
            ArrayList argTypes = ContainerUtil.newArrayListWithCapacity((int)arguments.length);
            for (JSExpression expression : arguments) {
                argTypes.add(TypeScriptGenericTypesEvaluator.getExplicitTypeOrAny(expression, TypeScriptGenericTypesEvaluator.getParameterExpressionType(expression)));
            }
            JSTypeSource explicitlyDeclaredSource = JSTypeSourceFactory.createTypeSource((PsiElement)jSFunctionItem, true);
            SmartList parameterTypes = new SmartList();
            for (JSParameterItem parameter : jSFunctionItem.getParameters()) {
                parameterTypes.add(parameter.getTypeDecorator());
            }
            JSFunctionTypeImpl type = new JSFunctionTypeImpl(explicitlyDeclaredSource, (List<JSParameterTypeDecorator>)parameterTypes, jSFunctionItem.getReturnType());
            if (!JSTypeUtils.canBeCalledWithArguments(type, argTypes, false) || !(jSFunctionItem instanceof TypeScriptFunction)) continue;
            JSParameterItem[] funcParameters = jSFunctionItem.getParameters();
            parameters = (JSParameterListElement[])funcParameters;
            break;
        }
        if (parameters == null) {
            JSUtils.$$$reportNull$$$0(29);
        }
        return parameters;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 11: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/util/JSUtils";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementBase";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functions";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/util/JSUtils";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplicitAccessType";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigJavaScriptDirPath";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtLibsDirPath";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelatedFunctions";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveOverloadParameterList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findScriptTagContent";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getImplicitAccessType";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 29: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getParentSkipParentheses";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isScopeOwner";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getChildExcludingTypes";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeList";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isStatementUsuallyRequiringSemicolon";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "resolveOverloadParameterList";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

