/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.introduce;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.findUsages.JSReadWriteAccessDetector;
import com.intellij.lang.javascript.flex.ImportUtils;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.inspections.NewLineEraser;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSLabeledStatement;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.ES6ReferenceList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSGenericSignature;
import com.intellij.lang.javascript.psi.ecmal4.JSImportStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSPackage;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.ActionScriptResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.HighlightingUtils;
import com.intellij.lang.javascript.refactoring.JSChangeVisibilityUtil;
import com.intellij.lang.javascript.refactoring.JSIntroduceTargetChooser;
import com.intellij.lang.javascript.refactoring.introduce.BaseIntroduceSettings;
import com.intellij.lang.javascript.refactoring.introduce.BasicIntroducedEntityInfoProvider;
import com.intellij.lang.javascript.refactoring.introduce.ClassLevelIntroduceSettings;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseInplaceIntroducer;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseIntroduceDialog;
import com.intellij.lang.javascript.refactoring.introduce.JSIntroducedExpressionReplacer;
import com.intellij.lang.javascript.refactoring.introduceVariable.InplaceSettings;
import com.intellij.lang.javascript.refactoring.introduceVariable.JSIntroduceVariableHandler;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.typescript.psi.TypeScriptEntityName;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlText;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.introduce.inplace.OccurrencesChooser;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ConstantFunction;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NullableConsumer;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSBaseIntroduceHandler<T extends JSElement, S extends BaseIntroduceSettings, D extends JSBaseIntroduceDialog>
implements RefactoringActionHandler {
    protected static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.javascript.refactoring.introduce.JSBaseIntroduceHandler");
    @NotNull
    private final JSIntroduceTargetChooser<JSExpression> myIntroducedExpressionChooser;
    public static final JSIntroduceTargetChooser<JSExpression> DEFAULT_EXPRESSION_CHOOSER = (editor, elements, callback, presenter) -> callback.pass(ContainerUtil.getLastItem((List)elements));

    public JSBaseIntroduceHandler() {
        this(ApplicationManager.getApplication().isUnitTestMode() ? DEFAULT_EXPRESSION_CHOOSER : IntroduceTargetChooser::showChooser);
    }

    public JSBaseIntroduceHandler(@NotNull JSIntroduceTargetChooser<JSExpression> introducedExpressionChooser) {
        if (introducedExpressionChooser == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(0);
        }
        this.myIntroducedExpressionChooser = introducedExpressionChooser;
    }

    @Nullable
    public static List<Pair<JSExpression, TextRange>> findExpressionsInRange(@NotNull PsiFile file, int startOffset, int endOffset) {
        PsiElement sibling;
        int expressionEnd;
        PsiElement element2;
        if (file == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(1);
        }
        PsiElement element1 = file.findElementAt(startOffset);
        ArrayList<Pair<JSExpression, TextRange>> result = new ArrayList<Pair<JSExpression, TextRange>>();
        if (startOffset == endOffset) {
            element1 = file.findElementAt(startOffset - 1);
            boolean checkedForInsideAnonymousEventHandler = false;
            for (element1 = JSBaseIntroduceHandler.adjustElement(startOffset, element1); element1 != null && !(element1 instanceof JSStatement); element1 = element1.getParent()) {
                if (element1 instanceof JSExpression) {
                    if (!checkedForInsideAnonymousEventHandler) {
                        checkedForInsideAnonymousEventHandler = true;
                        if (ActionScriptResolveUtil.computeIfInsideAnonymousEventHandler(element1, new ConstantFunction((Object)Boolean.TRUE)) != null) {
                            return null;
                        }
                    }
                    if (!JSBaseIntroduceHandler.isValidExpressionForSmartIntroduce(element1)) continue;
                    result.add((Pair<JSExpression, TextRange>)new Pair((Object)((JSExpression)element1), null));
                    continue;
                }
                if (!(element1 instanceof JSArgumentList) && !result.isEmpty()) break;
            }
            return result;
        }
        if (element1 instanceof PsiWhiteSpace) {
            startOffset = element1.getTextRange().getEndOffset();
        }
        if ((element2 = file.findElementAt(endOffset - 1)) instanceof PsiWhiteSpace) {
            endOffset = element2.getTextRange().getStartOffset();
        }
        TextRange range = new TextRange(startOffset, endOffset);
        JSExpression expression = (JSExpression)PsiTreeUtil.findElementOfClassAtRange((PsiFile)file, (int)startOffset, (int)endOffset, JSExpression.class);
        if (expression != null && (Boolean.TRUE.equals(ActionScriptResolveUtil.computeIfInsideAnonymousEventHandler((PsiElement)expression, new ConstantFunction((Object)Boolean.TRUE))) || !JSBaseIntroduceHandler.isValidExpression((PsiElement)expression))) {
            return null;
        }
        if (expression == null || (expressionEnd = expression.getTextRange().getEndOffset()) != endOffset && (expressionEnd != endOffset - 1 || (sibling = expression.getNextSibling()) == null || sibling.getNode().getElementType() != JSTokenTypes.SEMICOLON)) {
            expression = null;
        } else if (JSReadWriteAccessDetector.ourInstance.getExpressionAccess((PsiElement)expression) != ReadWriteAccessDetector.Access.Read) {
            return null;
        }
        if (expression == null && element1 == element2 && element1 != null) {
            PsiElement parent = element1.getParent();
            if (parent instanceof XmlText) {
                parent = parent.getParent();
            }
            if (parent instanceof JSLiteralExpression && element1.getTextRange().contains(range)) {
                result.add((Pair<JSExpression, TextRange>)Pair.create((Object)((JSExpression)parent), (Object)range));
                return result;
            }
        }
        if (expression == null && element1 != null && element2 != null) {
            JSExpression element1ExpressionParent = (JSExpression)PsiTreeUtil.getParentOfType((PsiElement)element1, JSExpression.class);
            JSExpression element2ExpressionParent = (JSExpression)PsiTreeUtil.getParentOfType((PsiElement)element2, JSExpression.class);
            range = new TextRange(startOffset, endOffset);
            if (element1ExpressionParent != null && element2ExpressionParent != null && range.contains(element1ExpressionParent.getTextRange()) && range.contains(element2ExpressionParent.getTextRange())) {
                PsiElement nextParent;
                PsiElement parent = PsiTreeUtil.findCommonParent((PsiElement)element1, (PsiElement)element2);
                if (!(parent instanceof JSExpression)) {
                    parent = null;
                }
                while (!(parent == null || parent instanceof JSBinaryExpression && parent.getTextRange().contains(range) || JSBaseIntroduceHandler.elementNotAllowedInRange(range, parent) || !((nextParent = parent.getParent()) instanceof JSExpression))) {
                    parent = nextParent;
                }
                if (parent instanceof JSBinaryExpression) {
                    if ((parent = JSBaseIntroduceHandler.ensureNoIntersection(range, parent, element1ExpressionParent)) != null) {
                        parent = JSBaseIntroduceHandler.ensureNoIntersection(range, parent, element2ExpressionParent);
                    }
                    if (parent != null) {
                        result.add((Pair<JSExpression, TextRange>)Pair.create((Object)((JSExpression)parent), (Object)range));
                        return result;
                    }
                }
            }
        }
        if (expression == null) {
            return null;
        }
        if (expression instanceof JSReferenceExpression && JSBaseIntroduceHandler.isInvalidRefExpr((JSReferenceExpression)expression)) {
            return null;
        }
        result.add((Pair<JSExpression, TextRange>)new Pair((Object)expression, null));
        return result;
    }

    public static PsiElement adjustElement(int startOffset, PsiElement element1) {
        JSExpression returnedExpression;
        JSReturnStatement ret;
        IElementType element1NodeType;
        if (element1 instanceof PsiWhiteSpace && startOffset == element1.getTextRange().getEndOffset()) {
            element1 = PsiTreeUtil.nextLeaf((PsiElement)element1);
        } else if (element1 != null && element1.getNode() != null && ((element1NodeType = element1.getNode().getElementType()) == JSTokenTypes.LPAR || element1NodeType == JSTokenTypes.LBRACKET || element1NodeType == JSTokenTypes.COMMA)) {
            element1 = PsiTreeUtil.nextLeaf((PsiElement)element1);
        }
        if (element1 != null && element1.getNode() != null && (element1.getNode().getElementType() == JSTokenTypes.SEMICOLON || element1.getNode().getElementType() == JSTokenTypes.RPAR)) {
            element1 = PsiTreeUtil.prevLeaf((PsiElement)element1);
        }
        if (element1 != null && element1.getNode() != null && element1.getNode().getElementType() == JSTokenTypes.RETURN_KEYWORD && (ret = (JSReturnStatement)PsiTreeUtil.getParentOfType((PsiElement)element1, JSReturnStatement.class)) != null && (returnedExpression = ret.getExpression()) != null) {
            element1 = returnedExpression.getFirstChild();
        }
        return element1;
    }

    private static boolean isValidExpressionForSmartIntroduce(PsiElement element1) {
        boolean validExpression = JSBaseIntroduceHandler.isValidExpression(element1);
        if (validExpression && element1 instanceof JSReferenceExpression && element1.getParent() instanceof JSCallExpression) {
            validExpression = false;
        }
        return validExpression;
    }

    private static boolean isValidExpression(PsiElement element1) {
        return !(element1 instanceof JSReferenceExpression && JSBaseIntroduceHandler.isInvalidRefExpr((JSReferenceExpression)element1) || element1 instanceof JSDefinitionExpression || element1 instanceof JSLiteralExpression && element1.getParent() instanceof TypeScriptModule || element1 instanceof JSExpression && element1.getParent() instanceof JSReferenceListMember && !(element1.getParent().getParent() instanceof ES6ReferenceList) || element1 instanceof JSReferenceExpression && JSResolveUtil.isExprInStrictTypeContext((JSReferenceExpression)JSResolveUtil.getTopReferenceExpression(element1)) || element1 instanceof JSArrayLiteralExpression && element1.getParent() instanceof JSNewExpression) && (!(element1 instanceof JSCallExpression) || !(JSResolveUtil.getExpressionJSType((JSExpression)element1) instanceof JSVoidType));
    }

    private static boolean isInvalidRefExpr(JSReferenceExpression element1) {
        PsiElement element1Parent = element1.getParent();
        return element1Parent instanceof JSGenericSignature || element1 instanceof TypeScriptEntityName || element1Parent instanceof JSDefinitionExpression || JSResolveUtil.isSelfReference((PsiElement)element1) || element1.getQualifier() == null && element1.resolve() instanceof JSClass || element1.resolve() instanceof JSPackage || element1Parent instanceof JSImportStatement;
    }

    private static PsiElement ensureNoIntersection(TextRange range, PsiElement parent, JSExpression element2ExpressionParent) {
        for (JSExpression e = element2ExpressionParent; e != parent; e = e.getParent()) {
            if (!JSBaseIntroduceHandler.elementNotAllowedInRange(range, (PsiElement)e)) continue;
            parent = null;
            break;
        }
        return parent;
    }

    private static boolean elementNotAllowedInRange(TextRange range, PsiElement parent) {
        return parent instanceof JSParenthesizedExpression && !range.contains(parent.getTextRange());
    }

    protected boolean visitInnerFunctions() {
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(2);
        }
        if (!JSRefactoringUtil.checkReadOnlyStatus((PsiElement)file, editor, this.getRefactoringName())) {
            return;
        }
        String featureId = this.getProductivityFeatureId();
        if (featureId != null) {
            FeatureUsageTracker.getInstance().triggerFeatureUsed(featureId);
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        int start = editor.getSelectionModel().getSelectionStart();
        int end = editor.getSelectionModel().getSelectionEnd();
        List<Pair<JSExpression, TextRange>> candidates = this.getCandidateExpressions(editor, file, start, end);
        if (candidates == null || candidates.isEmpty()) {
            return;
        }
        Consumer<JSExpression> callback = selectedExpression -> {
            Pair expressionDescriptor = (Pair)ContainerUtil.find((Iterable)candidates, e -> e.first == selectedExpression);
            if (expressionDescriptor == null || !this.validateSelectedExpression(file, editor, (Pair<JSExpression, TextRange>)expressionDescriptor)) {
                return;
            }
            this.introduceWithExpression(editor, file, (Pair<JSExpression, TextRange>)expressionDescriptor);
        };
        List expressions = ContainerUtil.map(candidates, jsExpressionTextRangePair -> (JSExpression)jsExpressionTextRangePair.getFirst());
        JSBaseIntroduceHandler.chooseElement(this.myIntroducedExpressionChooser, editor, expressions, callback, PsiElement::getText);
    }

    public void introduceWithExpression(@NotNull Editor editor, @NotNull PsiFile file, @NotNull Pair<JSExpression, TextRange> expressionDescriptor) {
        if (editor == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(3);
        }
        if (file == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(4);
        }
        if (expressionDescriptor == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(5);
        }
        NullableConsumer callback = scope -> {
            if (editor == null) {
                JSBaseIntroduceHandler.$$$reportNull$$$0(42);
            }
            if (file == null) {
                JSBaseIntroduceHandler.$$$reportNull$$$0(43);
            }
            if (expressionDescriptor == null) {
                JSBaseIntroduceHandler.$$$reportNull$$$0(44);
            }
            if (scope == null) {
                this.showErrorHint(editor, file, JSBundle.message((String)"javascript.introduce.variable.arrow.function.parameter.referenced", (Object[])new Object[0]));
                return;
            }
            this.introduceWithScope(editor, expressionDescriptor, (JSElement)scope);
        };
        this.findIntroducedScope(editor, expressionDescriptor, (NullableConsumer<JSElement>)callback);
    }

    private void introduceWithScope(final @NotNull Editor editor, final @NotNull Pair<JSExpression, TextRange> expressionDescriptor, final @NotNull JSElement scope) {
        if (editor == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(6);
        }
        if (expressionDescriptor == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(7);
        }
        if (scope == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(8);
        }
        final Project project = ((JSExpression)expressionDescriptor.getFirst()).getProject();
        final JSExpression[] occurrences = JSUtils.findExpressionOccurrences(scope, expressionDescriptor, this.visitInnerFunctions());
        final boolean inplaceJavaScriptIntroduce = !JSIntroducedExpressionReplacer.willReplacePartOfExpression(expressionDescriptor) && this.isInplaceIntroduce(editor, ((JSExpression)expressionDescriptor.first).getContainingFile());
        Pass<OccurrencesChooser.ReplaceChoice> callback = new Pass<OccurrencesChooser.ReplaceChoice>(){

            public void pass(OccurrencesChooser.ReplaceChoice choice) {
                BaseIntroduceSettings settings;
                if (!JSBaseIntroduceHandler.this.doPreprocess(project, editor, (Pair<JSExpression, TextRange>)expressionDescriptor, scope)) {
                    return;
                }
                InplaceSettings inplaceSettings = JSBaseIntroduceHandler.this.getInplaceSettings((Pair<JSExpression, TextRange>)expressionDescriptor, occurrences, (PsiElement)scope, choice);
                BaseIntroduceSettings baseIntroduceSettings = settings = choice == null ? JSBaseIntroduceHandler.this.getSettings(project, editor, (Pair<JSExpression, TextRange>)expressionDescriptor, occurrences, (PsiElement)scope) : (BaseIntroduceSettings)inplaceSettings.getSettings();
                if (settings == null) {
                    return;
                }
                editor.getSelectionModel().removeSelection();
                BaseIntroduceContext<BaseIntroduceSettings> introduceContext = new BaseIntroduceContext<BaseIntroduceSettings>((Pair<JSExpression, TextRange>)expressionDescriptor, occurrences, (PsiElement)scope, settings);
                if (inplaceJavaScriptIntroduce) {
                    JSBaseInplaceIntroducer<BaseIntroduceSettings> introducer = JSBaseIntroduceHandler.this.createInplaceIntroducer(introduceContext, scope, editor, project, occurrences);
                    introducer.startInplaceIntroduceTemplate();
                } else {
                    CommandProcessor.getInstance().executeCommand(project, () -> {
                        if (editor == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        ApplicationManager.getApplication().runWriteAction(() -> {
                            if (editor == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            JSBaseIntroduceHandler.this.doRefactoring(project, editor, introduceContext, true);
                            JSBaseIntroduceHandler.this.performIntroduce(introduceContext);
                        });
                    }, JSBaseIntroduceHandler.this.getRefactoringName(), null);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "editor";
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/introduce/JSBaseIntroduceHandler$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$pass$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$null$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (inplaceJavaScriptIntroduce) {
            LinkedHashMap<OccurrencesChooser.ReplaceChoice, List<JSExpression>> occurrencesMap = new LinkedHashMap<OccurrencesChooser.ReplaceChoice, List<JSExpression>>();
            occurrencesMap.put(OccurrencesChooser.ReplaceChoice.NO, Collections.singletonList(expressionDescriptor.getFirst()));
            if (occurrences.length > 1) {
                occurrencesMap.put(OccurrencesChooser.ReplaceChoice.ALL, Arrays.asList(occurrences));
            }
            this.chooseOccurrencesToReplace(editor, occurrencesMap, callback);
        } else {
            callback.pass(null);
        }
    }

    protected boolean isInplaceIntroduce(Editor editor, PsiFile file) {
        return (file.getLanguage() != JavaScriptSupportLoader.ECMA_SCRIPT_L4 || this instanceof JSIntroduceVariableHandler) && editor.getSettings().isVariableInplaceRenameEnabled();
    }

    protected void chooseOccurrencesToReplace(Editor editor, Map<OccurrencesChooser.ReplaceChoice, List<JSExpression>> occurrencesMap, Pass<OccurrencesChooser.ReplaceChoice> callback) {
        OccurrencesChooser.simpleChooser((Editor)editor).showChooser(callback, occurrencesMap);
    }

    protected abstract JSBaseInplaceIntroducer<S> createInplaceIntroducer(BaseIntroduceContext<S> var1, JSElement var2, Editor var3, Project var4, JSExpression[] var5);

    protected boolean doPreprocess(Project project, Editor editor, @NotNull Pair<JSExpression, TextRange> expressionDescriptor, @NotNull JSElement scope) {
        if (expressionDescriptor == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(9);
        }
        if (scope == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(10);
        }
        return true;
    }

    @Nullable
    protected String getProductivityFeatureId() {
        return null;
    }

    protected static String prependAccessModifier(BaseIntroduceContext<? extends ClassLevelIntroduceSettings> baseIntroduceContext, String baseDeclText) {
        JSExpression expression;
        JSAttributeList.AccessType type = ((ClassLevelIntroduceSettings)baseIntroduceContext.settings).getAccessType();
        String accessText = JSChangeVisibilityUtil.accessTypeToCodeString(type, (PsiElement)(expression = (JSExpression)baseIntroduceContext.expressionDescriptor.first));
        if (!StringUtil.isEmpty((String)accessText)) {
            baseDeclText = accessText + " " + baseDeclText;
        }
        return baseDeclText;
    }

    public static boolean introduceOverVariableNameRef(PsiElement element) {
        PsiElement parent = element.getParent();
        return parent instanceof JSVariable && JSResolveUtil.isSelfReference(element);
    }

    public static boolean calcDependsOnContext(final PsiElement occurrence, final boolean okToAccessThis, final boolean okToAccessOccurrence) {
        if (occurrence == null) {
            return false;
        }
        final Ref localContextDependent = new Ref();
        occurrence.accept((PsiElementVisitor)new JSRecursiveElementVisitor(){

            public void visitJSReferenceExpression(JSReferenceExpression node) {
                if (node.getQualifier() == null && !JSResolveUtil.isExprInStrictTypeContext(node)) {
                    ResolveResult[] results = node.multiResolve(true);
                    if (results.length == 0) {
                        localContextDependent.set((Object)Boolean.TRUE);
                    } else {
                        PsiElement element = results[0].getElement();
                        if ((element instanceof JSVariable || element instanceof JSFunction) && !(JSResolveUtil.findParent(element) instanceof JSClass) && PsiTreeUtil.findCommonParent((PsiElement)element, (PsiElement)occurrence) != occurrence && (occurrence.getParent() != element || okToAccessOccurrence)) {
                            localContextDependent.set((Object)Boolean.TRUE);
                        }
                    }
                }
                super.visitJSReferenceExpression(node);
            }

            public void visitJSThisExpression(JSThisExpression node) {
                if (!okToAccessThis) {
                    localContextDependent.set((Object)Boolean.TRUE);
                }
                super.visitJSThisExpression(node);
            }
        });
        return localContextDependent.get() == Boolean.TRUE;
    }

    protected static boolean containsAwaitExpressions(@Nullable JSExpression expression) {
        Ref result = new Ref();
        PsiTreeUtil.processElements((PsiElement)expression, element -> {
            if (ES6PsiUtil.isAwaitExpression(element)) {
                result.set((Object)Boolean.TRUE);
                return false;
            }
            return true;
        });
        return Boolean.TRUE == result.get();
    }

    protected void findIntroducedScope(@NotNull Editor editor, @NotNull Pair<JSExpression, TextRange> expressionDescriptor, @NotNull NullableConsumer<JSElement> callback) {
        if (editor == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(11);
        }
        if (expressionDescriptor == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(12);
        }
        if (callback == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(13);
        }
        callback.consume((Object)JSBaseIntroduceHandler.getStatementScope(expressionDescriptor));
    }

    @Nullable
    private static JSExecutionScope getStatementScope(Pair<JSExpression, TextRange> expressionDescriptor) {
        JSExpression expression = (JSExpression)expressionDescriptor.first;
        JSExecutionScope scope = (JSExecutionScope)PsiTreeUtil.getParentOfType((PsiElement)expression, JSExecutionScope.class);
        if (scope != null && scope.getNode().getElementType() == JSElementTypes.EMBEDDED_EXPRESSION) {
            return (JSExecutionScope)PsiTreeUtil.getParentOfType((PsiElement)scope.getParent(), JSExecutionScope.class);
        }
        if (scope instanceof JSFunction && JSPsiImplUtils.tryGetArrowFunctionReturnExpression((JSFunction)scope) != null) {
            JSParameter[] parameters = ((JSFunction)scope).getParameterVariables();
            final THashSet parameterNames = new THashSet();
            for (JSParameter parameter : parameters) {
                parameterNames.add((Object)parameter.getName());
            }
            final Ref paramRefFound = Ref.create((Object)Boolean.FALSE);
            final TextRange range = (TextRange)expressionDescriptor.second;
            expression.accept((PsiElementVisitor)new JSRecursiveElementVisitor(){

                public void visitElement(PsiElement element) {
                    if (!((Boolean)paramRefFound.get()).booleanValue()) {
                        super.visitElement(element);
                    }
                }

                public void visitJSReferenceExpression(JSReferenceExpression node) {
                    if (node.getQualifier() == null && parameterNames.contains((Object)node.getReferenceName()) && (range == null || range.contains(node.getTextRange()))) {
                        paramRefFound.set((Object)Boolean.TRUE);
                    } else {
                        super.visitJSReferenceExpression(node);
                    }
                }
            });
            return (Boolean)paramRefFound.get() != false ? null : (JSExecutionScope)PsiTreeUtil.getParentOfType((PsiElement)scope, JSExecutionScope.class);
        }
        return scope;
    }

    protected abstract String getRefactoringName();

    protected abstract String getCannotIntroduceMessagePropertyKey();

    protected abstract String getCannotIntroduceVoidExpressionTypeMessagePropertyKey();

    protected static boolean isIntroducingPartOfExpression(Pair<JSExpression, TextRange> expressionDescriptor) {
        return expressionDescriptor.second != null;
    }

    @Nullable
    protected List<Pair<JSExpression, TextRange>> getCandidateExpressions(@NotNull Editor editor, @NotNull PsiFile file, int start, int end) {
        List<Pair<JSExpression, TextRange>> candidates;
        if (editor == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(14);
        }
        if (file == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(15);
        }
        if ((candidates = JSBaseIntroduceHandler.findExpressionsInRange(file, start, end)) == null || candidates.isEmpty()) {
            this.showDefaultErrorHint(editor, file);
            return null;
        }
        return candidates;
    }

    protected boolean validateSelectedExpression(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Pair<JSExpression, TextRange> expressionDescriptor) {
        JSType jsType;
        if (file == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(16);
        }
        if (editor == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(17);
        }
        if (expressionDescriptor == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(18);
        }
        if ((jsType = JSResolveUtil.getExpressionJSType((JSExpression)expressionDescriptor.first)) instanceof JSVoidType) {
            this.showErrorHint(editor, file, this.getCannotIntroduceVoidExpressionTypeMessagePropertyKey());
            return false;
        }
        return true;
    }

    protected abstract InplaceSettings<S> getInplaceSettings(Pair<JSExpression, TextRange> var1, JSExpression[] var2, PsiElement var3, OccurrencesChooser.ReplaceChoice var4);

    @Nullable
    protected S getSettings(Project project, Editor editor, Pair<JSExpression, TextRange> expressionDescriptor, JSExpression[] occurrences, PsiElement scope) {
        ArrayList<RangeHighlighter> highlighters = null;
        if (occurrences.length > 1) {
            highlighters = HighlightingUtils.highlightOccurrences(project, editor, (PsiElement[])occurrences);
        }
        D dialog = this.createDialog(project, this.getReplacementExpression(expressionDescriptor), occurrences, scope);
        dialog.show();
        if (highlighters != null) {
            for (RangeHighlighter highlighter : highlighters) {
                HighlightManager.getInstance((Project)project).removeSegmentHighlighter(editor, highlighter);
            }
        }
        if (dialog.getExitCode() != 0) {
            return null;
        }
        return this.createSettings(dialog);
    }

    protected S createSettings(D dialog) {
        return (S)dialog;
    }

    protected abstract D createDialog(Project var1, JSExpression var2, JSExpression[] var3, PsiElement var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    IntroduceInfo doRefactoring(Project project, Editor editor, BaseIntroduceContext<S> introduceContext, boolean replaceExpressions) {
        String type;
        boolean ecma;
        Object settings = introduceContext.settings;
        boolean replaceAllOccurences = settings.isReplaceAllOccurrences();
        Object anchorStatement = this.findAnchor(introduceContext, replaceAllOccurences);
        JSElement dummyAnchor = null;
        if (anchorStatement == null) {
            JSExpression expression = (JSExpression)introduceContext.expressionDescriptor.getFirst();
            PsiElement top = PsiTreeUtil.findFirstParent((PsiElement)expression, el -> el.getParent() instanceof JSFile || el.getParent() instanceof JSEmbeddedContent);
            assert (top != null);
            JSSourceElement fakeElement = (JSSourceElement)JSChangeUtil.createStatementFromText(project, "var a = 1").getPsi(JSSourceElement.class);
            dummyAnchor = (JSElement)top.getParent().addBefore((PsiElement)fakeElement, top);
            anchorStatement = dummyAnchor;
        }
        String varDeclText = this.getDeclText(introduceContext, anchorStatement);
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)project);
        JSExpression expression = (JSExpression)introduceContext.expressionDescriptor.first;
        SmartPsiElementPointer expressionPointer = smartPointerManager.createSmartPsiElementPointer((PsiElement)expression);
        List<JSExpression> occurrences = ContainerUtil.list((Object[])introduceContext.occurences);
        List<SmartPsiElementPointer<JSExpression>> occurrencePointers = JSBaseIntroduceHandler.createPointers(smartPointerManager, occurrences);
        JSIntroducedExpressionReplacer replacer = new JSIntroducedExpressionReplacer(introduceContext.expressionDescriptor);
        JSLanguageDialect languageDialect = DialectDetector.languageDialectOfElement((PsiElement)expression);
        boolean bl = ecma = JavaScriptSupportLoader.ECMA_SCRIPT_L4 == languageDialect;
        if (ecma) {
            type = settings.getVariableType();
            if (type == null) {
                type = new BasicIntroducedEntityInfoProvider(expression, (JSExpression[])ContainerUtil.toArray((Collection)occurrences, (ArrayFactory)JSExpression.ARRAY_FACTORY), introduceContext.scope).evaluateType();
                if ((type = JSResolveUtil.getQualifiedTypeName(type)) == null) {
                    type = JSClassUtils.getAnyTypeString((PsiElement)expression, false);
                }
            }
            if (!JSBaseIntroduceHandler.isIntroducingPartOfExpression(introduceContext.expressionDescriptor)) {
                type = (String)ImportUtils.importAndShortenReference((String)type, (PsiElement)expression, (boolean)true, (boolean)true).first;
                occurrences = JSBaseIntroduceHandler.derefPointers(occurrencePointers);
                Pair rangePair = new Pair((Object)expressionPointer.getElement(), null);
                introduceContext = new BaseIntroduceContext((Pair<JSExpression, TextRange>)rangePair, (JSExpression[])ContainerUtil.toArray(occurrences, (ArrayFactory)JSExpression.ARRAY_FACTORY), introduceContext.scope, introduceContext.settings);
                anchorStatement = this.findAnchor(introduceContext, replaceAllOccurences);
            }
            varDeclText = varDeclText + ":" + type;
        }
        try {
            LOG.assertTrue(anchorStatement != null);
            if (!JSRefactoringUtil.checkReadOnlyStatus((PsiElement)anchorStatement.getContainingFile(), editor, this.getRefactoringName())) {
                type = null;
                return type;
            }
            Pair<JSVarStatement, Boolean> preparedDeclarationStatus = this.prepareDeclaration(varDeclText, introduceContext, project, languageDialect, anchorStatement, editor, expression);
            JSVarStatement declaration = (JSVarStatement)preparedDeclarationStatus.first;
            boolean replacedOriginal = (Boolean)preparedDeclarationStatus.second;
            SmartPsiElementPointer jsVariablePointer = null;
            SmartPsiElementPointer jsVarStatementPointer = null;
            PsiElement elementToFixFormat = null;
            if (!replacedOriginal) {
                JSExpression oldExpression = expression;
                TextRange expressionTextRange = expression.getTextRange();
                TextRange statementTextRange = anchorStatement.getTextRange();
                RangeMarker marker = editor.getDocument().createRangeMarker(expressionTextRange);
                JSVariable jsVariable = this.addStatementBefore(anchorStatement, declaration);
                PsiElement jsStatement = jsVariable.getParent();
                if (jsStatement instanceof JSVarStatement) {
                    jsVarStatementPointer = smartPointerManager.createSmartPsiElementPointer((PsiElement)((JSVarStatement)jsStatement));
                } else {
                    jsVariablePointer = smartPointerManager.createSmartPsiElementPointer((PsiElement)jsVariable);
                }
                if (!expression.isValid()) {
                    JSExpression candidateExpression;
                    int relativeOffset;
                    JSElement newAnchorStatement = (JSElement)PsiTreeUtil.getNextSiblingOfType((PsiElement)jsStatement, anchorStatement.getClass());
                    JSExpression newExpression = (JSExpression)PsiTreeUtil.getParentOfType((PsiElement)newAnchorStatement.findElementAt(relativeOffset = marker.getStartOffset() - statementTextRange.getStartOffset()), oldExpression.getClass());
                    if (newExpression == null) assert (false) : "Could not find " + oldExpression.getClass() + " in " + newAnchorStatement.getText() + " with offset " + marker.getStartOffset();
                    while (newExpression.getTextRange().getLength() != expressionTextRange.getLength() && (candidateExpression = (JSExpression)PsiTreeUtil.getParentOfType((PsiElement)newExpression, oldExpression.getClass())) != null && candidateExpression.getTextRange().getStartOffset() - newAnchorStatement.getTextRange().getStartOffset() == marker.getStartOffset() - statementTextRange.getStartOffset()) {
                        newExpression = candidateExpression;
                    }
                    int expressionIndex = occurrences.indexOf(oldExpression);
                    if (expressionIndex > 0) {
                        occurrences.set(expressionIndex, newExpression);
                    }
                    expression = newExpression;
                    expressionPointer = smartPointerManager.createSmartPsiElementPointer((PsiElement)expression);
                }
                elementToFixFormat = jsStatement;
            } else {
                jsVariablePointer = null;
                jsVarStatementPointer = smartPointerManager.createSmartPsiElementPointer((PsiElement)declaration);
            }
            JSExpression refExpr = this.createRefExpr(project, settings, languageDialect);
            if (replaceExpressions && replaceAllOccurences) {
                ArrayList<JSExpression> newOccurences = new ArrayList<JSExpression>();
                for (JSExpression occurrence : occurrences) {
                    JSExpression jsExpression;
                    if (!(occurrence == expression && replacedOriginal || (jsExpression = JSBaseIntroduceHandler.replaceExpression(replacer, occurrence, refExpr)) == null)) {
                        if (occurrence == expression) {
                            expression = jsExpression;
                        }
                        newOccurences.add(jsExpression);
                    }
                    occurrences = newOccurences;
                }
                ArrayList toHighlight = ContainerUtil.newArrayList(occurrences);
                ContainerUtil.addIfNotNull((Collection)toHighlight, (Object)declaration.getVariables()[0].getInitializer());
                HighlightingUtils.highlightOccurrences(project, editor, (PsiElement[])toHighlight.toArray(new JSExpression[toHighlight.size()]));
            }
            if (!replaceAllOccurences && !replacedOriginal) {
                int expressionIndex = occurrences.indexOf(expression);
                expression = JSBaseIntroduceHandler.replaceExpression(replacer, (JSExpression)expressionPointer.getElement(), refExpr);
                if (expressionIndex > 0) {
                    occurrences.set(expressionIndex, expression);
                }
                expressionPointer = expression != null ? smartPointerManager.createSmartPsiElementPointer((PsiElement)expression) : null;
            }
            occurrencePointers = JSBaseIntroduceHandler.createPointers(smartPointerManager, occurrences);
            PsiDocumentManager instance = PsiDocumentManager.getInstance((Project)project);
            instance.doPostponedOperationsAndUnblockDocument(editor.getDocument());
            instance.commitDocument(editor.getDocument());
            if (elementToFixFormat != null) {
                JSBaseIntroduceHandler.fixFormat(project, elementToFixFormat);
            }
            this.doPostprocess(declaration, settings, editor);
            JSVariable createdVar = null;
            if (jsVarStatementPointer != null) {
                JSVarStatement varStatement = (JSVarStatement)jsVarStatementPointer.getElement();
                if (varStatement != null) {
                    createdVar = varStatement.getVariables()[0];
                }
            } else {
                createdVar = (JSVariable)jsVariablePointer.getElement();
            }
            IntroduceInfo introduceInfo = new IntroduceInfo(createdVar, expressionPointer != null ? (JSExpression)expressionPointer.getElement() : null, JSBaseIntroduceHandler.derefPointers(occurrencePointers));
            return introduceInfo;
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        finally {
            if (dummyAnchor != null) {
                NewLineEraser eraser = new NewLineEraser((PsiElement)dummyAnchor);
                dummyAnchor.delete();
                eraser.process();
            }
        }
        return null;
    }

    @Nullable
    private static JSExpression replaceExpression(@NotNull JSIntroducedExpressionReplacer replacer, @NotNull JSExpression toReplace, @NotNull JSExpression refExpr) {
        if (replacer == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(19);
        }
        if (toReplace == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(20);
        }
        if (refExpr == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(21);
        }
        if (JSBaseIntroduceHandler.introduceOverVariableNameRef((PsiElement)toReplace)) {
            toReplace.getParent().delete();
            return null;
        }
        return replacer.replaceOccurrence(toReplace, refExpr);
    }

    @NotNull
    private static List<JSExpression> derefPointers(List<SmartPsiElementPointer<JSExpression>> occurrencePointers) {
        List list = ContainerUtil.map(occurrencePointers, pointer -> (JSExpression)pointer.getElement());
        if (list == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(22);
        }
        return list;
    }

    @NotNull
    private static List<SmartPsiElementPointer<JSExpression>> createPointers(SmartPointerManager smartPointerManager, List<JSExpression> occurrences) {
        List list = ContainerUtil.mapNotNull(occurrences, occurrence -> occurrence.isValid() ? smartPointerManager.createSmartPsiElementPointer((PsiElement)occurrence) : null);
        if (list == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(23);
        }
        return list;
    }

    protected JSExpression createRefExpr(Project project, S settings, JSLanguageDialect languageDialect) {
        return (JSExpression)JSChangeUtil.createExpressionFromText(project, settings.getVariableName(), languageDialect).getPsi();
    }

    protected static void fixFormat(Project project, PsiElement jsStatement) {
        CodeStyleManager.getInstance((Project)project).reformatNewlyAddedElement(jsStatement.getParent().getNode(), jsStatement.getNode());
    }

    protected void doPostprocess(JSVarStatement declaration, S settings, Editor editor) {
    }

    public void performIntroduce(@NotNull BaseIntroduceContext<S> introduceContext) {
        if (introduceContext == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(24);
        }
    }

    protected Pair<JSVarStatement, Boolean> prepareDeclaration(String varDeclText, BaseIntroduceContext<S> context, Project project, @Nullable JSLanguageDialect languageDialect, T anchorStatement, Editor editor, JSExpression introducedExpression) throws IncorrectOperationException {
        JSExpression initializerReplacementExpression = this.getReplacementExpression(context.expressionDescriptor);
        String text = varDeclText + (initializerReplacementExpression != null ? " = 0" : "") + JSCodeStyleSettings.getSemicolon(context.scope.getContainingFile());
        JSVarStatement declaration = JSChangeUtil.createStatementPsiFromTextWithContext(text, (PsiElement)context.expressionDescriptor.first, JSVarStatement.class);
        this.replaceInitializer(initializerReplacementExpression, declaration);
        return Pair.create((Object)declaration, (Object)Boolean.FALSE);
    }

    protected void replaceInitializer(JSExpression initializerReplacementExpression, JSVarStatement declaration) {
        JSVariable variable = declaration.getVariables()[0];
        JSExpression initializer = variable.getInitializer();
        if (initializer != null && initializerReplacementExpression != null) {
            initializer.replace(initializerReplacementExpression);
        }
    }

    protected JSExpression getReplacementExpression(Pair<JSExpression, TextRange> expressionDescriptor) {
        JSExpression jsExpression = (JSExpression)expressionDescriptor.first;
        if (!JSBaseIntroduceHandler.isIntroducingPartOfExpression(expressionDescriptor)) {
            return jsExpression;
        }
        String value = this.getIntroducedExpressionText(expressionDescriptor);
        JSVarStatement declaration = JSChangeUtil.createStatementPsiFromTextWithContext("var xxx = " + value + JSCodeStyleSettings.getSemicolon(jsExpression.getContainingFile()), (PsiElement)jsExpression, JSVarStatement.class);
        return declaration.getVariables()[0].getInitializer();
    }

    protected String getIntroducedExpressionText(Pair<JSExpression, TextRange> expressionDescriptor) {
        return new JSIntroducedExpressionReplacer(expressionDescriptor).getIntroducedExpressionText();
    }

    @NonNls
    protected String getDeclText(BaseIntroduceContext<S> baseIntroduceContext, T anchor) {
        return this.calcDeclText(baseIntroduceContext, "var", anchor);
    }

    protected String calcDeclText(BaseIntroduceContext<S> baseIntroduceContext, String s, T anchor) {
        boolean isStatic = JSResolveUtil.calculateStaticFromContext((PsiElement)this.getElementForContextTypeCheck(baseIntroduceContext, anchor));
        JSFunction fun = (JSFunction)PsiTreeUtil.getParentOfType(anchor, JSFunction.class);
        if (s.length() > 0) {
            s = s + " ";
        }
        return (isStatic && fun == null ? "static " : "") + s + baseIntroduceContext.settings.getVariableName();
    }

    protected JSElement getElementForContextTypeCheck(BaseIntroduceContext<S> baseIntroduceContext, T anchor) {
        return (JSElement)baseIntroduceContext.expressionDescriptor.first;
    }

    protected JSVariable addStatementBefore(T anchor, JSVarStatement declaration) throws IncorrectOperationException {
        JSVarStatement statement = JSChangeUtil.addSourceElement((JSSourceElement)anchor, declaration, true);
        return statement.getVariables()[0];
    }

    protected T findAnchor(BaseIntroduceContext<S> context, boolean replaceAllOccurences) {
        JSSourceElement anchorStatement;
        JSExpression expression = (JSExpression)context.expressionDescriptor.first;
        JSSourceElement jSSourceElement = anchorStatement = replaceAllOccurences ? JSBaseIntroduceHandler.getAnchorToInsert(context.occurences) : JSUtils.findSourceAnchor((PsiElement)expression, DialectDetector.isActionScript((PsiElement)expression));
        if (anchorStatement instanceof JSVarStatement && anchorStatement.getParent() instanceof JSStatement && !(anchorStatement.getParent() instanceof JSBlockStatement) || anchorStatement != null && anchorStatement.getParent() instanceof JSLabeledStatement) {
            anchorStatement = (JSStatement)anchorStatement.getParent();
        }
        return (T)anchorStatement;
    }

    @Nullable
    private static JSSourceElement getAnchorToInsert(JSExpression[] expressions) {
        JSSourceElement statement;
        JSExpression place = expressions[0];
        block0: while (true) {
            PsiElement statementAnchor;
            if ((statementAnchor = JSUtils.findStatementAnchor((PsiElement)place, place.getContainingFile(), true)) == null) {
                return null;
            }
            statement = statementAnchor instanceof JSSourceElement && !(statementAnchor instanceof JSExpression) ? (JSSourceElement)statementAnchor : JSUtils.findSourceAnchor(statementAnchor, DialectDetector.isActionScript((PsiElement)place));
            LOG.assertTrue(statement != null);
            PsiElement parent = statement.getParent();
            for (JSExpression expression : expressions) {
                if (PsiTreeUtil.isAncestor((PsiElement)parent, (PsiElement)expression, (boolean)true)) continue;
                place = statement;
                continue block0;
            }
            break;
        }
        return statement;
    }

    public static JSElement findClassAnchor(PsiElement expression) {
        PsiElement classRef;
        PsiElement anchor = PsiTreeUtil.findFirstParent((PsiElement)expression, e -> e != null && (e.getParent() instanceof JSClass || e.getParent() instanceof JSFile));
        if (!DialectDetector.isActionScript(expression)) {
            return (JSElement)anchor;
        }
        JSFunctionExpression functionExpression = (JSFunctionExpression)PsiTreeUtil.getParentOfType((PsiElement)expression, JSFunctionExpression.class);
        if (!(anchor == null || functionExpression != null && ActionScriptResolveUtil.isAnonymousEventHandler(functionExpression))) {
            return (JSElement)anchor;
        }
        JSElement parent = (JSElement)PsiTreeUtil.getParentOfType((PsiElement)expression, (Class[])new Class[]{JSFile.class, JSClass.class});
        if (parent instanceof JSFile && (classRef = JSResolveUtil.getClassReferenceForXmlFromContext((PsiElement)parent)) instanceof JSClass) {
            parent = (JSElement)classRef;
        }
        return parent;
    }

    protected static JSVariable addToClassAnchor(JSElement anchor, JSVarStatement declaration) throws IncorrectOperationException {
        JSVarStatement varStatement = anchor instanceof JSClass || anchor instanceof JSFile ? (JSVarStatement)anchor.add((PsiElement)declaration) : (JSVarStatement)anchor.getParent().addBefore((PsiElement)declaration, (PsiElement)anchor);
        return varStatement.getVariables()[0];
    }

    public static <TElement> void chooseElement(@NotNull JSIntroduceTargetChooser<TElement> chooser, @NotNull Editor editor, @NotNull List<TElement> elements, final @NotNull Consumer<TElement> callback, @NotNull Function<TElement, String> presenter) {
        if (chooser == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(25);
        }
        if (editor == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(26);
        }
        if (elements == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(27);
        }
        if (callback == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(28);
        }
        if (presenter == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(29);
        }
        JSBaseIntroduceHandler.chooseElement(chooser, editor, elements, new Pass<TElement>(){

            public void pass(TElement element) {
                callback.accept(element);
            }
        }, presenter);
    }

    public static <TElement> void chooseElement(@NotNull JSIntroduceTargetChooser<TElement> chooser, @NotNull Editor editor, @NotNull List<TElement> elements, @NotNull Pass<TElement> callback, @NotNull Function<TElement, String> presenter) {
        if (chooser == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(30);
        }
        if (editor == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(31);
        }
        if (elements == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(32);
        }
        if (callback == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(33);
        }
        if (presenter == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(34);
        }
        if (elements.isEmpty()) {
            return;
        }
        if (elements.size() == 1) {
            callback.pass(elements.get(0));
        } else {
            chooser.invoke(editor, elements, callback, presenter);
        }
    }

    protected void showDefaultErrorHint(@NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(35);
        }
        if (file == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(36);
        }
        this.showErrorHint(editor, file, JSBundle.message((String)this.getCannotIntroduceMessagePropertyKey(), (Object[])new Object[0]));
    }

    protected void showErrorHint(@NotNull Editor editor, @NotNull PsiFile file, @NotNull String message) {
        if (editor == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(37);
        }
        if (file == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(38);
        }
        if (message == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(39);
        }
        CommonRefactoringUtil.showErrorHint((Project)file.getProject(), (Editor)editor, (String)message, (String)this.getRefactoringName(), null);
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(40);
        }
        if (elements == null) {
            JSBaseIntroduceHandler.$$$reportNull$$$0(41);
        }
        throw new RuntimeException("Not implemented");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 22: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 22: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "introducedExpressionChooser";
                break;
            }
            case 1: 
            case 4: 
            case 15: 
            case 16: 
            case 36: 
            case 38: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: 
            case 11: 
            case 14: 
            case 17: 
            case 26: 
            case 31: 
            case 35: 
            case 37: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 18: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionDescriptor";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 13: 
            case 28: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacer";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toReplace";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refExpr";
                break;
            }
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/introduce/JSBaseIntroduceHandler";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "introduceContext";
                break;
            }
            case 25: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chooser";
                break;
            }
            case 27: 
            case 32: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 29: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presenter";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/introduce/JSBaseIntroduceHandler";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "derefPointers";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createPointers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findExpressionsInRange";
                break;
            }
            case 2: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "introduceWithExpression";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "introduceWithScope";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doPreprocess";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findIntroducedScope";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getCandidateExpressions";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "validateSelectedExpression";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "replaceExpression";
                break;
            }
            case 22: 
            case 23: {
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "performIntroduce";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "chooseElement";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "showDefaultErrorHint";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "showErrorHint";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "lambda$introduceWithExpression$4";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 22: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class IntroduceInfo {
        final JSVariable createdVariable;
        final JSExpression expression;
        final List<JSExpression> occurrences;

        public IntroduceInfo(JSVariable variable, JSExpression expression, List<JSExpression> occurrences) {
            this.createdVariable = variable;
            this.expression = expression;
            this.occurrences = occurrences;
        }
    }

    public static final class BaseIntroduceContext<S extends BaseIntroduceSettings> {
        public final S settings;
        final JSExpression[] occurences;
        final PsiElement scope;
        public final Pair<JSExpression, TextRange> expressionDescriptor;

        public BaseIntroduceContext(Pair<JSExpression, TextRange> _mainoccurence, JSExpression[] _occurences, PsiElement _scope, S _settings) {
            this.occurences = _occurences;
            this.expressionDescriptor = _mainoccurence;
            this.settings = _settings;
            this.scope = _scope;
        }
    }
}

