/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service;

import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.lang.javascript.integration.JSAnnotationRangeError;
import com.intellij.lang.javascript.linter.LinterLanguageServiceClient;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.ResultWithError;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import java.io.File;
import java.net.URL;
import java.net.URLDecoder;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLanguageServiceUtil {
    public static final long TIMEOUT_MILLS;
    public static final long QUOTA_MILLS = 10L;
    public static long TEST_TIMEOUT_MILLIS;

    @Nullable
    public static <T> T awaitFuture(@Nullable Future<T> future) {
        return JSLanguageServiceUtil.awaitFuture(future, TIMEOUT_MILLS);
    }

    @Nullable
    public static <T> T awaitFuture(@Nullable Future<T> future, long timeoutMillis) {
        return JSLanguageServiceUtil.awaitFuture(future, timeoutMillis, 10L, null);
    }

    @Nullable
    public static <T> T awaitFuture(@Nullable Future<T> future, long timeoutMills, long quotaMills, @Nullable ProgressIndicator indicator) {
        return JSLanguageServiceUtil.awaitFuture(future, timeoutMills, quotaMills, indicator, true, null);
    }

    @Nullable
    public static <T> T awaitFuture(@Nullable Future<T> future, long timeoutMills, long quotaMills, @Nullable ProgressIndicator indicator, boolean cancelFutureIfTimeout, @Nullable Computable<Boolean> cancelCheck) {
        if (future == null) {
            return null;
        }
        if (ApplicationManager.getApplication().isDispatchThread() && !ApplicationManager.getApplication().isUnitTestMode()) {
            JSLanguageServiceQueue.LOGGER.error("Await future on EDT may cause a deadlock");
        }
        try {
            if (future.isDone()) {
                return future.get();
            }
            for (long totalWait = timeoutMills; !(totalWait <= 0L || cancelCheck != null && Boolean.TRUE.equals(cancelCheck.compute())); totalWait -= quotaMills) {
                try {
                    return future.get(quotaMills, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException timeoutException) {
                }
                catch (InterruptedException | CancellationException e) {
                    return null;
                }
                if (indicator == null) {
                    ProgressManager.checkCanceled();
                    continue;
                }
                indicator.checkCanceled();
            }
            if (future.isDone()) {
                return future.get();
            }
            if (cancelFutureIfTimeout) {
                future.cancel(false);
            }
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @NotNull
    public static <Result> ResultWithError<Result> awaitLanguageService(@Nullable Future<Result> future, @NotNull LinterLanguageServiceClient languageService) {
        if (languageService == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(0);
        }
        if (future == null) {
            if (JSLanguageServiceUtil.languageServiceHasError(languageService)) {
                ResultWithError resultWithError = ResultWithError.error(JSLanguageServiceUtil.getLanguageServiceCreationError(languageService));
                if (resultWithError == null) {
                    JSLanguageServiceUtil.$$$reportNull$$$0(1);
                }
                return resultWithError;
            }
            ResultWithError resultWithError = ResultWithError.empty();
            if (resultWithError == null) {
                JSLanguageServiceUtil.$$$reportNull$$$0(2);
            }
            return resultWithError;
        }
        long timeout = ApplicationManager.getApplication().isUnitTestMode() ? TEST_TIMEOUT_MILLIS : TIMEOUT_MILLS;
        Result result = JSLanguageServiceUtil.awaitFuture(future, timeout, 10L, null, true, (Computable<Boolean>)((Computable)() -> {
            if (languageService == null) {
                JSLanguageServiceUtil.$$$reportNull$$$0(19);
            }
            return languageService.getServiceCreationError() != null;
        }));
        if (future.isCancelled()) {
            if (JSLanguageServiceUtil.languageServiceHasError(languageService)) {
                ResultWithError resultWithError = ResultWithError.error(JSLanguageServiceUtil.getLanguageServiceCreationError(languageService));
                if (resultWithError == null) {
                    JSLanguageServiceUtil.$$$reportNull$$$0(3);
                }
                return resultWithError;
            }
            ResultWithError resultWithError = ResultWithError.error("Language service execution timeout");
            if (resultWithError == null) {
                JSLanguageServiceUtil.$$$reportNull$$$0(4);
            }
            return resultWithError;
        }
        if (result == null) {
            if (JSLanguageServiceUtil.languageServiceHasError(languageService)) {
                ResultWithError resultWithError = ResultWithError.error(JSLanguageServiceUtil.getLanguageServiceCreationError(languageService));
                if (resultWithError == null) {
                    JSLanguageServiceUtil.$$$reportNull$$$0(5);
                }
                return resultWithError;
            }
            ResultWithError resultWithError = ResultWithError.empty();
            if (resultWithError == null) {
                JSLanguageServiceUtil.$$$reportNull$$$0(6);
            }
            return resultWithError;
        }
        ResultWithError<Result> resultWithError = ResultWithError.result(result);
        if (resultWithError == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(7);
        }
        return resultWithError;
    }

    private static boolean languageServiceHasError(@NotNull LinterLanguageServiceClient languageService) {
        if (languageService == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(8);
        }
        return !languageService.isServiceCreated() || languageService.getServiceCreationError() != null;
    }

    @NotNull
    public static String getLanguageServiceCreationError(@NotNull LinterLanguageServiceClient languageService) {
        if (languageService == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(9);
        }
        String string = (String)ObjectUtils.coalesce((Object)languageService.getServiceCreationError(), (Object)"Cannot start language service process");
        if (string == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Nullable
    public static PsiElementInfo getElementInfo(@Nullable PsiFile file, @NotNull Document document, @NotNull JSAnnotationError result) {
        if (document == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(11);
        }
        if (result == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(12);
        }
        int endLine = result instanceof JSAnnotationRangeError ? ((JSAnnotationRangeError)result).getEndLine() : -1;
        int endColumn = result instanceof JSAnnotationRangeError ? ((JSAnnotationRangeError)result).getEndColumn() : -1;
        return JSLanguageServiceUtil.getElementInfo(file, document, result.getLine(), result.getColumn(), endLine, endColumn);
    }

    @Nullable
    public static PsiElementInfo getElementInfo(@Nullable PsiFile file, @NotNull Document document, int line, int column, int endLine, int endColumn) {
        if (document == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(13);
        }
        try {
            int lineStartOffset;
            if (line < 0 || line >= document.getLineCount()) {
                return null;
            }
            int errorStartOffset = lineStartOffset = document.getLineStartOffset(line);
            int lineEndOffset = document.getLineEndOffset(line);
            if ((errorStartOffset += column) > lineEndOffset) {
                return null;
            }
            PsiElement element = null;
            TextRange range = null;
            if (endLine < 0 && file != null) {
                element = file.findElementAt(errorStartOffset);
                if (element == null && lineStartOffset < errorStartOffset) {
                    element = file.findElementAt(errorStartOffset - 1);
                }
            } else {
                if (endLine < 0 || endLine >= document.getLineCount()) {
                    return null;
                }
                int errorEndOffset = document.getLineStartOffset(endLine);
                int lineToEndOffset = document.getLineEndOffset(endLine);
                if ((errorEndOffset += endColumn) > lineToEndOffset) {
                    return null;
                }
                range = TextRange.create((int)errorStartOffset, (int)errorEndOffset);
            }
            return new PsiElementInfo(element, range);
        }
        catch (Exception e) {
            JSLanguageServiceQueue.LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Nullable
    public static String getInterpreterPathIfValid(@Nullable NodeJsInterpreter interpreter) {
        NodeJsLocalInterpreter localInterpreter = NodeJsLocalInterpreter.tryCast(interpreter);
        if (localInterpreter != null && localInterpreter.isValid()) {
            return localInterpreter.getInterpreterSystemDependentPath();
        }
        return null;
    }

    @Nullable
    public static String normalizePathDoNotFollowSymlinks(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(14);
        }
        if (!virtualFile.isInLocalFileSystem()) {
            return null;
        }
        return FileUtil.toSystemDependentName((String)virtualFile.getPath());
    }

    @Nullable
    public static String normalizeNameAndPath(@NotNull VirtualFile name) {
        if (name == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(15);
        }
        String path = name.getCanonicalPath();
        if (!name.isInLocalFileSystem() || null == path) {
            return null;
        }
        return FileUtil.toSystemDependentName((String)path);
    }

    @Contract(value="!null -> !null")
    public static String normalizeNameAndPath(@Nullable String path) {
        if (null == path) {
            return null;
        }
        return FileUtil.toSystemDependentName((String)path);
    }

    @NotNull
    public static File getPluginStarterDirectory() {
        File file = JSLanguageServiceUtil.getPluginDirectory(TypeScriptUtil.class, "jsLanguageServicesImpl");
        if (file == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(16);
        }
        return file;
    }

    public static File getPluginDirectory(@NotNull Class<?> pluginClass, @NotNull String resourceName) {
        if (pluginClass == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(17);
        }
        if (resourceName == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(18);
        }
        try {
            String jarPath = PathUtil.getJarPathForClass(pluginClass);
            if (!jarPath.endsWith(".jar")) {
                URL resource = pluginClass.getClassLoader().getResource(resourceName);
                if (resource == null) {
                    throw new RuntimeException("Cannot find file compiler implementation");
                }
                return new File(URLDecoder.decode(resource.getPath(), "UTF-8"));
            }
            File jarFile = new File(jarPath);
            if (!jarFile.isFile()) {
                throw new RuntimeException("jar file cannot be null");
            }
            File pluginBaseDir = jarFile.getParentFile().getParentFile();
            return new File(pluginBaseDir, resourceName);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    static {
        TEST_TIMEOUT_MILLIS = TIMEOUT_MILLS = TimeUnit.SECONDS.toMillis(20L);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageService";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/service/JSLanguageServiceUtil";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginClass";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/service/JSLanguageServiceUtil";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "awaitLanguageService";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageServiceCreationError";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginStarterDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "awaitLanguageService";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 16: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "languageServiceHasError";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageServiceCreationError";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getElementInfo";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "normalizePathDoNotFollowSymlinks";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "normalizeNameAndPath";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getPluginDirectory";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "lambda$awaitLanguageService$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class PsiElementInfo {
        @Nullable
        private final PsiElement myElement;
        @Nullable
        private final TextRange myRange;

        public PsiElementInfo(@Nullable PsiElement element, @Nullable TextRange range) {
            this.myElement = element;
            this.myRange = range;
        }

        @Nullable
        public PsiElement getElement() {
            return this.myElement;
        }

        @Nullable
        public TextRange getRange() {
            return this.myRange;
        }
    }
}

