/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.types;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSLanguageUtil;
import com.intellij.lang.javascript.index.JavaScriptIndex;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.impl.JSFileBaseImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSFileCachedData;
import com.intellij.lang.javascript.psi.stubs.impl.JSFileStubBuilder;
import com.intellij.lang.javascript.psi.stubs.impl.JSFileStubImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.StubBuilder;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.tree.IStubFileElementType;
import gnu.trove.THashMap;
import java.io.IOException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class JSFileElementType
extends IStubFileElementType {
    private static final int BASE_VERSION = 300;
    private static final Map<Language, JSFileElementType> INSTANCES = new THashMap();

    protected JSFileElementType(Language language) {
        super(language);
    }

    public static synchronized JSFileElementType create(Language language) {
        JSFileElementType type = new JSFileElementType(language);
        JSFileElementType previous = INSTANCES.put(language, type);
        assert (previous == null);
        return type;
    }

    protected Language getLanguageForParser(PsiElement psi) {
        return JSLanguageUtil.getLanguageForParser(psi);
    }

    @NotNull
    public String getExternalId() {
        String string = this.getLanguage() + ":" + this.toString();
        if (string == null) {
            JSFileElementType.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean shouldBuildStubFor(VirtualFile file) {
        return JavaScriptIndex.ourIndexedFilesFilter.acceptInput(file);
    }

    public int getStubVersion() {
        return JSFileElementType.getVersion();
    }

    public static int getVersion() {
        return 300 + JavaScriptIndex.getVersionStatic();
    }

    public static int getVersionForPrebuiltStubs() {
        return 300;
    }

    public StubBuilder getBuilder() {
        return new JSFileStubBuilder();
    }

    public void serialize(@NotNull PsiFileStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            JSFileElementType.$$$reportNull$$$0(1);
        }
        if (dataStream == null) {
            JSFileElementType.$$$reportNull$$$0(2);
        }
        dataStream.writeName(stub.getType().getLanguage().getID());
        JSFileCachedData cachedData = ((JSFileStubImpl)stub).getCachedData();
        if (cachedData == null) {
            JSFile file = (JSFile)((JSFileStubImpl)stub).getPsi();
            if (file instanceof JSFileBaseImpl) {
                cachedData = ((JSFileBaseImpl)file).getCachedData();
            } else {
                cachedData = new JSFileCachedData();
                if (file != null) {
                    cachedData.applyModuleStatus(file.getModuleStatus());
                    cachedData.setTestFileType(file.getTestFileType());
                    if (file.hasES6Syntax()) {
                        cachedData.setHasES6Syntax();
                    }
                    cachedData.setReferencedPaths(file.getReferencedPaths());
                    cachedData.setExportsInnerAlias(file.getExportsInnerAlias());
                }
            }
        }
        cachedData.serialize(dataStream);
    }

    @NotNull
    public PsiFileStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            JSFileElementType.$$$reportNull$$$0(3);
        }
        String languageId = dataStream.readName().getString();
        JSFileCachedData cachedData = JSFileCachedData.deserialize(dataStream);
        JSFileStubImpl jSFileStubImpl = new JSFileStubImpl(Language.findLanguageByID((String)languageId), cachedData);
        if (jSFileStubImpl == null) {
            JSFileElementType.$$$reportNull$$$0(4);
        }
        return jSFileStubImpl;
    }

    public static synchronized JSFileElementType getByLanguage(Language language) {
        return INSTANCES.get(language);
    }

    public static synchronized Map<Language, JSFileElementType> getAll() {
        return new THashMap(INSTANCES);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/types/JSFileElementType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalId";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/types/JSFileElementType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "deserialize";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

