/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation;

import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6FunctionProperty;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6NamespaceImportExport;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.highlighting.JSHighlighter;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSGeneratorExpression;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;

public class JSKeywordHighlighterVisitor
extends JSRecursiveWalkingElementVisitor {
    protected final AnnotationHolder myHolder;

    public JSKeywordHighlighterVisitor(AnnotationHolder holder) {
        this.myHolder = holder;
    }

    public void visitJSGeneratorExpression(JSGeneratorExpression element) {
        this.highlightChildKeywordOfType((PsiElement)element, JSTokenTypes.EACH_KEYWORD);
        super.visitJSGeneratorExpression(element);
    }

    public void visitJSForInStatement(JSForInStatement element) {
        this.highlightChildKeywordOfType((PsiElement)element, JSTokenTypes.EACH_KEYWORD);
        super.visitJSForInStatement(element);
    }

    public void visitJSFunctionExpression(@NotNull JSFunctionExpression function) {
        if (function == null) {
            JSKeywordHighlighterVisitor.$$$reportNull$$$0(0);
        }
        this.highlightKeywordGetterAndSetter((JSFunction)function);
        super.visitJSFunctionExpression(function);
    }

    public void visitES6FunctionProperty(ES6FunctionProperty function) {
        this.highlightKeywordGetterAndSetter((JSFunction)function);
        super.visitES6FunctionProperty(function);
    }

    public void visitJSFunctionDeclaration(@NotNull JSFunction function) {
        if (function == null) {
            JSKeywordHighlighterVisitor.$$$reportNull$$$0(1);
        }
        this.highlightKeywordGetterAndSetter(function);
        super.visitJSFunctionDeclaration(function);
    }

    public void visitES6FromClause(ES6FromClause element) {
        this.highlightChildKeywordOfType((PsiElement)element, JSTokenTypes.FROM_KEYWORD);
        super.visitES6FromClause(element);
    }

    public void visitES6NamespaceImportExport(ES6NamespaceImportExport element) {
        this.highlightChildKeywordOfType((PsiElement)element, JSTokenTypes.AS_KEYWORD);
        super.visitES6NamespaceImportExport(element);
    }

    public void visitES6ImportSpecifierAlias(ES6ImportSpecifierAlias specifierAlias) {
        this.highlightChildKeywordOfType((PsiElement)specifierAlias, JSTokenTypes.AS_KEYWORD);
        super.visitES6ImportSpecifierAlias(specifierAlias);
    }

    protected void highlightKeywordGetterAndSetter(@NotNull JSFunction function) {
        PsiElement nameIdentifier;
        if (function == null) {
            JSKeywordHighlighterVisitor.$$$reportNull$$$0(2);
        }
        if ((nameIdentifier = function.getNameIdentifier()) == null) {
            return;
        }
        ASTNode accessNode = function.getNode().findChildByType(JSTokenTypes.GET_SET);
        if (accessNode != null && accessNode != nameIdentifier.getNode()) {
            JSKeywordHighlighterVisitor.highlightKeyword(accessNode, this.myHolder);
        }
    }

    public static void highlightKeyword(@NotNull ASTNode keyword, @NotNull AnnotationHolder holder) {
        if (keyword == null) {
            JSKeywordHighlighterVisitor.$$$reportNull$$$0(3);
        }
        if (holder == null) {
            JSKeywordHighlighterVisitor.$$$reportNull$$$0(4);
        }
        Annotation anno = holder.createAnnotation(HighlightInfoType.SYMBOL_TYPE_SEVERITY, keyword.getTextRange(), null);
        anno.setTextAttributes(JSHighlighter.JS_KEYWORD);
    }

    protected void highlightChildKeywordOfTypes(@NotNull PsiElement parent, @NotNull TokenSet types) {
        ASTNode keyword;
        if (parent == null) {
            JSKeywordHighlighterVisitor.$$$reportNull$$$0(5);
        }
        if (types == null) {
            JSKeywordHighlighterVisitor.$$$reportNull$$$0(6);
        }
        if ((keyword = parent.getNode().findChildByType(types)) != null) {
            JSKeywordHighlighterVisitor.highlightKeyword(keyword, this.myHolder);
        }
    }

    protected void highlightChildKeywordOfType(@NotNull PsiElement parent, @NotNull IElementType type) {
        ASTNode keyword;
        if (parent == null) {
            JSKeywordHighlighterVisitor.$$$reportNull$$$0(7);
        }
        if (type == null) {
            JSKeywordHighlighterVisitor.$$$reportNull$$$0(8);
        }
        if ((keyword = parent.getNode().findChildByType(type)) != null) {
            JSKeywordHighlighterVisitor.highlightKeyword(keyword, this.myHolder);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyword";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/validation/JSKeywordHighlighterVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSFunctionExpression";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSFunctionDeclaration";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "highlightKeywordGetterAndSetter";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "highlightKeyword";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "highlightChildKeywordOfTypes";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "highlightChildKeywordOfType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

