/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler;

import com.intellij.lang.javascript.service.JSLanguageService;
import com.intellij.lang.javascript.service.JSLanguageServiceBase;
import com.intellij.lang.javascript.service.JSLanguageServiceProvider;
import com.intellij.lang.javascript.service.JSLanguageServiceResultContainer;
import com.intellij.lang.javascript.service.JSLanguageServiceUpdateContext;
import com.intellij.lang.javascript.service.highlighting.JSLanguageServiceFilter;
import com.intellij.lang.javascript.service.ui.JSLanguageServiceToolWindowManager;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.TypeScriptToolWindowProvider;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceUtil;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptServerServiceImpl;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptServiceCommandClean;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptCompletionResponse;
import com.intellij.lang.typescript.compiler.ui.TypeScriptServerServiceSettings;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import java.util.List;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TypeScriptCompilerService
extends JSLanguageServiceBase
implements JSLanguageService {
    @NotNull
    public static TypeScriptCompilerService getDefaultService(@NotNull Project project) {
        if (project == null) {
            TypeScriptCompilerService.$$$reportNull$$$0(0);
        }
        TypeScriptCompilerService typeScriptCompilerService = (TypeScriptCompilerService)ServiceManager.getService((Project)project, TypeScriptServerServiceImpl.class);
        if (typeScriptCompilerService == null) {
            TypeScriptCompilerService.$$$reportNull$$$0(1);
        }
        return typeScriptCompilerService;
    }

    @Nullable
    public static TypeScriptCompilerService getServiceForFile(@NotNull Project project, VirtualFile file) {
        if (project == null) {
            TypeScriptCompilerService.$$$reportNull$$$0(2);
        }
        return (TypeScriptCompilerService)ReadAction.compute(() -> {
            if (project == null) {
                TypeScriptCompilerService.$$$reportNull$$$0(12);
            }
            List<JSLanguageService> services = JSLanguageServiceProvider.getLanguageServices(project);
            for (JSLanguageService service : services) {
                if (!(service instanceof TypeScriptCompilerService) || !service.isAcceptable(file) || !JSLanguageServiceFilter.checkAvailable(project, service, file)) continue;
                return (TypeScriptCompilerService)service;
            }
            return null;
        });
    }

    public static void restartServices(@NotNull Project project) {
        if (project == null) {
            TypeScriptCompilerService.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        TypeScriptCompilerService.restartServices(project, true);
    }

    public static void restartServices(@NotNull Project project, boolean recreateToolWindow) {
        if (project == null) {
            TypeScriptCompilerService.$$$reportNull$$$0(4);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        TypeScriptCompilerService.processForServices(project, (Consumer<TypeScriptCompilerService>)((Consumer)service -> {
            if (service.isServiceCreated()) {
                service.terminateStartedProcess(recreateToolWindow);
            }
        }));
    }

    public static void sendCleanCommand(Project project, TypeScriptServiceCommandClean command) {
        TypeScriptCompilerService.processForServices(project, (Consumer<TypeScriptCompilerService>)((Consumer)service -> {
            if (service.isServiceCreated()) {
                service.sendCleanCommandToCompiler(command);
            }
        }));
    }

    public static void processVfsChangesForFiles(Project project, @NotNull List<VirtualFile> files) {
        if (files == null) {
            TypeScriptCompilerService.$$$reportNull$$$0(5);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        TypeScriptCompilerService.processForServices(project, (Consumer<TypeScriptCompilerService>)((Consumer)service -> {
            if (files == null) {
                TypeScriptCompilerService.$$$reportNull$$$0(11);
            }
            List<VirtualFile> toProcess = files.stream().filter(el -> service.isAcceptable((VirtualFile)el) && JSLanguageServiceFilter.checkAvailable(project, service, el)).collect(Collectors.toList());
            service.processVfsChangesForFiles(toProcess);
        }));
    }

    public abstract void flushCompileQueue();

    public static void processForServices(@NotNull Project project, Consumer<TypeScriptCompilerService> consumer) {
        if (project == null) {
            TypeScriptCompilerService.$$$reportNull$$$0(6);
        }
        if (project.isDisposed()) {
            return;
        }
        List<JSLanguageService> services = JSLanguageServiceProvider.getLanguageServices(project);
        services.forEach(service -> {
            if (service instanceof TypeScriptCompilerService) {
                consumer.consume((Object)((TypeScriptCompilerService)service));
            }
        });
    }

    public static List<TypeScriptCompilerService> getAll(@NotNull Project project) {
        if (project == null) {
            TypeScriptCompilerService.$$$reportNull$$$0(7);
        }
        List<JSLanguageService> services = JSLanguageServiceProvider.getLanguageServices(project);
        return services.stream().filter(el -> el instanceof TypeScriptCompilerService).map(el -> (TypeScriptCompilerService)el).collect(Collectors.toList());
    }

    public static void initToolWindow(Project project) {
        if (!TypeScriptLanguageServiceUtil.checkProject(project) || ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        JSLanguageServiceToolWindowManager manager = TypeScriptToolWindowProvider.getToolWindow(project);
        if (manager == null) {
            return;
        }
        manager.lazyInit((Condition<JSLanguageServiceToolWindowManager>)((Condition)el -> TypeScriptLanguageServiceUtil.checkProject(project) && TypeScriptCompilerSettings.getSettings(project).useServiceForProjectsWithoutConfig()));
    }

    public TypeScriptCompilerService(@NotNull Project project) {
        if (project == null) {
            TypeScriptCompilerService.$$$reportNull$$$0(8);
        }
        this(project, "Console");
    }

    protected TypeScriptCompilerService(@NotNull Project project, @NotNull String consoleId) {
        if (project == null) {
            TypeScriptCompilerService.$$$reportNull$$$0(9);
        }
        if (consoleId == null) {
            TypeScriptCompilerService.$$$reportNull$$$0(10);
        }
        super(project, consoleId);
    }

    public abstract void sendCleanCommandToCompiler(@NotNull TypeScriptServiceCommandClean var1);

    @Nullable
    public abstract Future<JSLanguageServiceResultContainer> compileFileAndGetErrors(@NotNull VirtualFile var1);

    @Nullable
    public abstract Future<JSLanguageServiceResultContainer> compileConfigProjectAndGetErrors(@NotNull TypeScriptConfig var1);

    protected abstract void processVfsChangesForFiles(@NotNull List<VirtualFile> var1);

    @Nullable
    public abstract Future<List<TypeScriptCompletionResponse.CompletionEntryDetail>> updateAndGetCompletionItems(@NotNull VirtualFile var1, @NotNull PsiFile var2, @NotNull Document var3, int var4);

    @Nullable
    public abstract Future<List<TypeScriptCompletionResponse.CompletionEntryDetail>> getDetailedCompletionItems(@NotNull VirtualFile var1, @NotNull List<TypeScriptCompletionResponse.CompletionEntryDetail> var2, @NotNull Document var3, int var4);

    @Nullable
    public abstract Future<Boolean> update(JSLanguageServiceUpdateContext var1);

    @Nullable
    public abstract TypeScriptServerServiceSettings getServiceSettings();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/compiler/TypeScriptCompilerService";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/compiler/TypeScriptCompilerService";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultService";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getServiceForFile";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "restartServices";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processVfsChangesForFiles";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processForServices";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAll";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processVfsChangesForFiles$4";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getServiceForFile$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

