/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.languageService.protocol;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.ide.macro.Macro;
import com.intellij.ide.macro.ProjectFileDirMacro;
import com.intellij.ide.macro.ProjectNameMacro;
import com.intellij.ide.macro.ProjectPathMacro;
import com.intellij.ide.macro.UnixSeparatorsMacro;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswerConsumer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceCommand;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceNodeStdProtocolBase;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceObject;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceUtil;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCommandSetRequest;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptServiceInitialStateObject;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptServiceStandardOutputProtocol
extends JSLanguageServiceNodeStdProtocolBase {
    private static final Set<Macro> PROJECT_LEVEL_MACRO = ContainerUtil.newHashSet((Object[])new Macro[]{new UnixSeparatorsMacro(), new ProjectFileDirMacro(), new ProjectNameMacro(), new ProjectPathMacro()});
    public static final String EVENT_TYPE = "event";
    public static final String EVENT_PROPERTY = "event";
    public static final String REQUEST_COMPLETED = "requestCompleted";
    public static final String BODY = "body";
    @NotNull
    private final TypeScriptCompilerSettings mySettings;
    @NotNull
    private final Consumer<JSLanguageServiceAnswer> myEventConsumer;

    public TypeScriptServiceStandardOutputProtocol(@NotNull Project project, @NotNull TypeScriptCompilerSettings settings, @NotNull Consumer<?> readyConsumer, @NotNull Consumer<JSLanguageServiceAnswer> eventConsumer) {
        if (project == null) {
            TypeScriptServiceStandardOutputProtocol.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            TypeScriptServiceStandardOutputProtocol.$$$reportNull$$$0(1);
        }
        if (readyConsumer == null) {
            TypeScriptServiceStandardOutputProtocol.$$$reportNull$$$0(2);
        }
        if (eventConsumer == null) {
            TypeScriptServiceStandardOutputProtocol.$$$reportNull$$$0(3);
        }
        super(project, readyConsumer);
        this.mySettings = settings;
        this.myEventConsumer = eventConsumer;
    }

    @Override
    public TypeScriptServiceInitialStateObject createState() {
        TypeScriptServiceInitialStateObject state = new TypeScriptServiceInitialStateObject();
        this.fillState(state);
        return state;
    }

    protected void fillState(TypeScriptServiceInitialStateObject state) {
        state.pluginName = "typescript";
        state.pluginPath = new File(TypeScriptUtil.getTypeScriptCompilerFolderFile(), "typescript/ts-plugin").getAbsolutePath();
        state.serverFolderPath = this.getServicePath();
        state.sessionId = String.valueOf(this.mySessionId);
        state.isUseSingleInferredProject = this.mySettings.isUseSingleInferredProject();
        state.pluginProbeLocations = this.getProbLocations(state);
        this.setManualOptions(state);
    }

    @NotNull
    private String[] getProbLocations(TypeScriptServiceInitialStateObject state) {
        String path;
        HashSet pluginProbeLocations = ContainerUtil.newHashSet();
        pluginProbeLocations.add(new File(state.serverFolderPath).getParent());
        VirtualFile dir = this.myProject.getBaseDir();
        if (dir != null && (path = dir.getCanonicalPath()) != null) {
            pluginProbeLocations.add(FileUtil.toSystemDependentName((String)path));
        }
        String[] stringArray = ArrayUtil.toStringArray((Collection)pluginProbeLocations);
        if (stringArray == null) {
            TypeScriptServiceStandardOutputProtocol.$$$reportNull$$$0(4);
        }
        return stringArray;
    }

    protected void setManualOptions(@NotNull TypeScriptServiceInitialStateObject state) {
        if (state == null) {
            TypeScriptServiceStandardOutputProtocol.$$$reportNull$$$0(5);
        }
        state.hasManualParams = this.mySettings.useDeprecatedSettings();
        String params = this.mySettings.getDefaultServiceOptions();
        boolean emptyOrSpaces = StringUtil.isEmptyOrSpaces((String)params);
        if (emptyOrSpaces && !state.hasManualParams) {
            return;
        }
        Object[] parsedParams = emptyOrSpaces ? ArrayUtil.EMPTY_STRING_ARRAY : ParametersList.parse((String)params);
        ArrayList paramList = ContainerUtil.newArrayList((Object[])parsedParams);
        if (!state.hasManualParams) {
            if (paramList.size() != 0) {
                state.commandLineArguments = ArrayUtil.toStringArray((Collection)paramList);
            }
            return;
        }
        String outFile = null;
        boolean hasMainFile = this.hasMainFile();
        if (this.hasOutputDirectory()) {
            state.projectPath = this.getProjectPathString();
            Pair<String, String> pair = null;
            try {
                pair = this.getOutInformation(hasMainFile);
            }
            catch (Exception e) {
                JSLanguageServiceQueue.LOGGER.error(e.getMessage(), (Throwable)e);
            }
            if (pair != null) {
                outFile = (String)pair.first;
                String outDir = (String)pair.second;
                if (!StringUtil.isEmpty((String)outDir)) {
                    if (outFile == null && !outDir.contains("$")) {
                        paramList.add("--outDir");
                        paramList.add(FileUtilRt.toSystemDependentName((String)outDir));
                    } else {
                        state.outPath = (String)pair.second;
                    }
                }
            }
        }
        boolean existsCommandLineOutParam = this.checkExistsCommandLineOut((String[])parsedParams);
        if (!StringUtil.isEmpty(outFile) && !existsCommandLineOutParam) {
            paramList.add("--outFile");
            paramList.add(FileUtilRt.toSystemDependentName(outFile));
        }
        if (this.mySettings.isGenerateSourceMap()) {
            paramList.add("--sourceMap");
        }
        if (!paramList.isEmpty()) {
            state.commandLineArguments = ArrayUtil.toStringArray((Collection)paramList);
        }
        if (hasMainFile) {
            state.mainFilePath = this.mySettings.getMainFilePath();
        }
    }

    @NotNull
    protected String expandOutputDirectoryMacro() throws Macro.ExecutionCancelledException {
        String outWithExpandedProjectMacro = FileUtil.toSystemIndependentName((String)this.mySettings.getOutDirectory());
        DataContext context = SimpleDataContext.getProjectContext((Project)this.myProject);
        for (Macro macro : PROJECT_LEVEL_MACRO) {
            String macroName = "$" + macro.getName() + "$";
            if (!outWithExpandedProjectMacro.contains(macroName)) continue;
            String expand = macro.expand(context);
            if (expand == null) {
                expand = "";
            }
            outWithExpandedProjectMacro = StringUtil.replace((String)outWithExpandedProjectMacro, (String)macroName, (String)expand);
        }
        String string = outWithExpandedProjectMacro;
        if (string == null) {
            TypeScriptServiceStandardOutputProtocol.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    protected void processAnswer(@NotNull JSLanguageServiceAnswer answer, @NotNull String text) {
        if (answer == null) {
            TypeScriptServiceStandardOutputProtocol.$$$reportNull$$$0(7);
        }
        if (text == null) {
            TypeScriptServiceStandardOutputProtocol.$$$reportNull$$$0(8);
        }
        if ("event".equals(answer.getType())) {
            if (!this.processAsEventCompletion(answer)) {
                this.myEventConsumer.consume((Object)answer);
            }
            return;
        }
        super.processAnswer(answer, text);
    }

    private boolean processAsEventCompletion(@NotNull JSLanguageServiceAnswer answer) {
        String property;
        if (answer == null) {
            TypeScriptServiceStandardOutputProtocol.$$$reportNull$$$0(9);
        }
        if (!REQUEST_COMPLETED.equals(property = answer.getProperty("event"))) {
            return false;
        }
        JsonObject element = answer.getElement();
        JsonElement body = element.get(BODY);
        if (body == null || !body.isJsonObject()) {
            return false;
        }
        JsonObject object = body.getAsJsonObject();
        JsonElement seq = object.get("request_seq");
        if (seq == null || !seq.isJsonPrimitive()) {
            return false;
        }
        int intSeq = seq.getAsInt();
        JSLanguageServiceAnswerConsumer callback = (JSLanguageServiceAnswerConsumer)this.myCallbacks.remove(intSeq);
        if (callback == null) {
            return false;
        }
        callback.consume(answer);
        return true;
    }

    @Override
    protected String getNodeInterpreter() {
        return TypeScriptLanguageServiceUtil.getNodeInterpreterPath(this.myProject);
    }

    @Override
    public final Object sendCommand(@NotNull JSLanguageServiceCommand command, @NotNull JSLanguageServiceObject data, final @Nullable JSLanguageServiceAnswerConsumer resultConsumer) throws Exception {
        if (command == null) {
            TypeScriptServiceStandardOutputProtocol.$$$reportNull$$$0(10);
        }
        if (data == null) {
            TypeScriptServiceStandardOutputProtocol.$$$reportNull$$$0(11);
        }
        if (!(data instanceof TypeScriptCommandSetRequest)) {
            return super.sendCommand(command, data, resultConsumer);
        }
        final LinkedHashMap<JSLanguageServiceObject, JSLanguageServiceCommand> requests = ((TypeScriptCommandSetRequest)data).nestedRequests;
        if (requests.size() == 1) {
            JSLanguageServiceObject item = (JSLanguageServiceObject)ContainerUtil.getFirstItem(requests.keySet());
            JSLanguageServiceCommand serviceCommand = requests.get(item);
            assert (item != null);
            return super.sendCommand(serviceCommand, item, resultConsumer);
        }
        JSLanguageServiceAnswerConsumer mergedConsumer = resultConsumer == null ? null : new JSLanguageServiceAnswerConsumer(){
            final AtomicInteger requestsCount;
            {
                this.requestsCount = new AtomicInteger(requests.size());
            }

            @Override
            public void consume(JSLanguageServiceAnswer message) {
                if (this.requestsCount.decrementAndGet() == 0) {
                    resultConsumer.consume(message);
                }
            }
        };
        ArrayList ids = ContainerUtil.newArrayList();
        try {
            requests.forEach((nestedObject, nestedCommand) -> {
                try {
                    ids.add(super.sendCommand((JSLanguageServiceCommand)nestedCommand, (JSLanguageServiceObject)nestedObject, mergedConsumer));
                }
                catch (IOException e) {
                    throw new IORuntimeException(e);
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            });
        }
        catch (IORuntimeException e) {
            throw e.getCause();
        }
        return ids;
    }

    @Override
    protected void addNodeProcessAdditionalArguments(@NotNull GeneralCommandLine commandLine) {
        if (commandLine == null) {
            TypeScriptServiceStandardOutputProtocol.$$$reportNull$$$0(12);
        }
        if (JSLanguageServiceQueue.LOGGER.isDebugEnabled()) {
            commandLine.withEnvironment("TSS_LOG", JSLanguageServiceQueue.LOGGER.isTraceEnabled() ? "-level verbose" : "");
        }
        String nodeArgsRaw = null;
        try {
            nodeArgsRaw = Registry.stringValue((String)"typescript.service.node.arguments");
        }
        catch (Exception e) {
            JSLanguageServiceQueue.LOGGER.debug(e.getMessage(), (Throwable)e);
        }
        if (!StringUtil.isEmptyOrSpaces((String)nodeArgsRaw)) {
            String[] arguments = nodeArgsRaw.split("\n");
            commandLine.addParameters(arguments);
        }
    }

    @NotNull
    protected String getServicePath() {
        TypeScriptCompilerSettings settings = TypeScriptCompilerSettings.getSettings(this.myProject);
        if (this.myProject.isDisposed() || !settings.useService()) {
            String string = TypeScriptServiceStandardOutputProtocol.defaultServicePath(settings);
            if (string == null) {
                TypeScriptServiceStandardOutputProtocol.$$$reportNull$$$0(13);
            }
            return string;
        }
        String directory = TypeScriptLanguageServiceUtil.getActualLibDirectory(this.myProject, settings);
        if (StringUtil.isNotEmpty((String)directory)) {
            String string = TypeScriptCompilerSettings.getOSDependTypeScriptServicesPathByDirectory(directory) + '/';
            if (string == null) {
                TypeScriptServiceStandardOutputProtocol.$$$reportNull$$$0(14);
            }
            return string;
        }
        String string = TypeScriptServiceStandardOutputProtocol.defaultServicePath(settings);
        if (string == null) {
            TypeScriptServiceStandardOutputProtocol.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    private static String defaultServicePath(@NotNull TypeScriptCompilerSettings settings) {
        if (settings == null) {
            TypeScriptServiceStandardOutputProtocol.$$$reportNull$$$0(16);
        }
        String string = TypeScriptCompilerSettings.getOSDependTypeScriptServicesPathByDirectory(settings.getDefaultTypeScriptServiceDirectory()) + '/';
        if (string == null) {
            TypeScriptServiceStandardOutputProtocol.$$$reportNull$$$0(17);
        }
        return string;
    }

    protected boolean hasMainFile() {
        return this.mySettings.useMainFile() && !StringUtil.isEmpty((String)this.mySettings.getMainFilePath());
    }

    protected boolean hasOutputDirectory() {
        return this.mySettings.isHasOutDirectory() && !StringUtil.isEmpty((String)this.mySettings.getOutDirectory());
    }

    @NotNull
    protected Pair<String, String> getOutInformation(boolean hasMainFile) throws Macro.ExecutionCancelledException {
        int indexOfSeparator;
        int indexOfDot;
        String outFile = null;
        String outWithExpandedProjectMacro = this.expandOutputDirectoryMacro();
        if (hasMainFile && (indexOfDot = outWithExpandedProjectMacro.lastIndexOf(46)) > 0 && indexOfDot > (indexOfSeparator = outWithExpandedProjectMacro.lastIndexOf(47))) {
            if (indexOfSeparator >= 0) {
                outFile = VfsUtil.extractFileName((String)outWithExpandedProjectMacro);
                outWithExpandedProjectMacro = VfsUtil.getParentDir((String)outWithExpandedProjectMacro);
            } else {
                outFile = outWithExpandedProjectMacro;
                outWithExpandedProjectMacro = null;
            }
        }
        if (!StringUtil.isEmpty((String)outWithExpandedProjectMacro)) {
            String path = FileUtil.toSystemDependentName((String)outWithExpandedProjectMacro);
            Pair pair = Pair.create(outFile, (Object)path);
            if (pair == null) {
                TypeScriptServiceStandardOutputProtocol.$$$reportNull$$$0(18);
            }
            return pair;
        }
        Pair pair = Pair.create(outFile, null);
        if (pair == null) {
            TypeScriptServiceStandardOutputProtocol.$$$reportNull$$$0(19);
        }
        return pair;
    }

    @NotNull
    protected String getProjectPathString() {
        String path = this.myProject.getBasePath();
        String string = FileUtil.toSystemDependentName((String)StringUtil.notNullize((String)path));
        if (string == null) {
            TypeScriptServiceStandardOutputProtocol.$$$reportNull$$$0(20);
        }
        return string;
    }

    protected boolean checkExistsCommandLineOut(String[] parse) {
        for (String s : parse) {
            if (!"-out".equals(s)) continue;
            return true;
        }
        return false;
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "readyConsumer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventConsumer";
                break;
            }
            case 4: 
            case 6: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/compiler/languageService/protocol/TypeScriptServiceStandardOutputProtocol";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "answer";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/compiler/languageService/protocol/TypeScriptServiceStandardOutputProtocol";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProbLocations";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "expandOutputDirectoryMacro";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getServicePath";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "defaultServicePath";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutInformation";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectPathString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 6: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setManualOptions";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processAnswer";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processAsEventCompletion";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "sendCommand";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addNodeProcessAdditionalArguments";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "defaultServicePath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class IORuntimeException
    extends RuntimeException {
        public IORuntimeException(IOException cause) {
            super(cause);
        }

        @Override
        public synchronized IOException getCause() {
            return (IOException)super.getCause();
        }
    }
}

