/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.documentation;

import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.actions.JSShowTypeInfoAction;
import com.intellij.lang.javascript.documentation.JSDocumentationProvider;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.JSTypeEvaluationResult;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptField;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterfaceClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.ui.JSFormatUtil;
import com.intellij.lang.typescript.psi.TypeScriptDeclarationMappings;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptDocumentationProvider
extends JSDocumentationProvider {
    @Override
    protected void appendVariableInitializer(@NotNull JSVariable variable, StringBuilder result) {
        String text;
        if (variable == null) {
            TypeScriptDocumentationProvider.$$$reportNull$$$0(0);
        }
        if ((text = variable.getLiteralOrReferenceInitializerText()) != null) {
            super.appendVariableInitializer(variable, result);
        }
    }

    @Override
    protected void appendClassAttributesAndName(@NotNull JSClass jsClass, PsiElement originalElement, StringBuilder result) {
        JSTypeSubstitutor substitutor;
        String generics;
        if (jsClass == null) {
            TypeScriptDocumentationProvider.$$$reportNull$$$0(1);
        }
        if (jsClass instanceof TypeScriptTypeAlias) {
            this.appendAttrList((JSAttributeListOwner)jsClass, result);
            result.append("type ");
            result.append(jsClass.getName());
        } else {
            super.appendClassAttributesAndName(jsClass, originalElement, result);
        }
        if (jsClass instanceof TypeScriptTypeParameterListOwner && (generics = TypeScriptDocumentationProvider.getGenerics((TypeScriptTypeParameterListOwner)jsClass, substitutor = this.getTypeSubstitutor((JSElement)jsClass, originalElement))) != null) {
            result.append(generics);
        }
    }

    @Override
    protected void appendClassExtendsAndImplements(@NotNull JSClass jsClass, String packageName, StringBuilder result) {
        if (jsClass == null) {
            TypeScriptDocumentationProvider.$$$reportNull$$$0(2);
        }
        if (jsClass instanceof TypeScriptTypeAlias) {
            return;
        }
        super.appendClassExtendsAndImplements(jsClass, packageName, result);
    }

    @Override
    protected JSType getVariableOrFieldType(@NotNull JSTypeDeclarationOwner variable) {
        if (variable == null) {
            TypeScriptDocumentationProvider.$$$reportNull$$$0(3);
        }
        return JSShowTypeInfoAction.getTypeForDocumentation((PsiElement)variable);
    }

    @Override
    @NotNull
    protected String getFunctionPrefix(@NotNull JSFunction function, boolean get, boolean set) {
        JSClass jsClass;
        if (function == null) {
            TypeScriptDocumentationProvider.$$$reportNull$$$0(4);
        }
        if (!get && !set && (jsClass = JSUtils.getMemberContainingClass((PsiElement)function)) != null) {
            if ("" == null) {
                TypeScriptDocumentationProvider.$$$reportNull$$$0(5);
            }
            return "";
        }
        String string = super.getFunctionPrefix(function, get, set);
        if (string == null) {
            TypeScriptDocumentationProvider.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    protected void appendAttrList(JSAttributeListOwner owner, StringBuilder result) {
        JSAttributeList attributeList = owner.getAttributeList();
        if (attributeList != null) {
            JSAttributeList.AccessType type = attributeList.getAccessType();
            String ns = JSResolveUtil.getNamespaceValue(attributeList);
            if (ns == null) {
                JSClass jsClass = JSUtils.getMemberContainingClass((PsiElement)owner);
                if (jsClass != null) {
                    ns = JSFormatUtil.formatVisibility(type, (PsiElement)owner);
                } else if (owner instanceof JSQualifiedNamedElement) {
                    if (((JSQualifiedNamedElement)owner).isExported()) {
                        ns = "export";
                    } else if (((JSQualifiedNamedElement)owner).isExportedWithDefault()) {
                        ns = "export default";
                    }
                }
            }
            if (ns != null) {
                result.append(ns);
                result.append(" ");
            }
            TypeScriptDocumentationProvider.appendModifier(result, attributeList, JSAttributeList.ModifierType.STATIC);
            TypeScriptDocumentationProvider.appendModifier(result, attributeList, JSAttributeList.ModifierType.READONLY);
        }
    }

    @Override
    @NotNull
    protected String getVarPrefix(@NotNull JSVariable variable) {
        if (variable == null) {
            TypeScriptDocumentationProvider.$$$reportNull$$$0(7);
        }
        if (variable instanceof TypeScriptField || variable instanceof JSParameter) {
            if ("" == null) {
                TypeScriptDocumentationProvider.$$$reportNull$$$0(8);
            }
            return "";
        }
        String string = super.getVarPrefix(variable);
        if (string == null) {
            TypeScriptDocumentationProvider.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Override
    protected void appendParentInfo(@Nullable PsiElement parent, @NotNull StringBuilder builder, @NotNull PsiNamedElement element, @NotNull JSTypeSubstitutor substitutor) {
        String generics;
        if (builder == null) {
            TypeScriptDocumentationProvider.$$$reportNull$$$0(10);
        }
        if (element == null) {
            TypeScriptDocumentationProvider.$$$reportNull$$$0(11);
        }
        if (substitutor == null) {
            TypeScriptDocumentationProvider.$$$reportNull$$$0(12);
        }
        if (element instanceof JSParameter && TypeScriptPsiUtil.isFieldParameter((JSParameter)element)) {
            parent = JSUtils.getMemberContainingClass((PsiElement)element);
        }
        if (parent instanceof TypeScriptInterfaceClass && (generics = TypeScriptDocumentationProvider.getGenerics((TypeScriptTypeParameterListOwner)parent, substitutor)) != null) {
            String className = StringUtil.notNullize((String)((JSClass)parent).getQualifiedName(), (String)"class");
            builder.append(className);
            builder.append(generics);
            builder.append("\n");
            return;
        }
        super.appendParentInfo(parent, builder, element, substitutor);
    }

    @Override
    protected void appendFunctionAttributesAndName(@NotNull JSFunction function, @NotNull StringBuilder result, @NotNull JSTypeSubstitutor substitutor) {
        String generics;
        if (function == null) {
            TypeScriptDocumentationProvider.$$$reportNull$$$0(13);
        }
        if (result == null) {
            TypeScriptDocumentationProvider.$$$reportNull$$$0(14);
        }
        if (substitutor == null) {
            TypeScriptDocumentationProvider.$$$reportNull$$$0(15);
        }
        super.appendFunctionAttributesAndName(function, result, substitutor);
        if (function instanceof TypeScriptTypeParameterListOwner && (generics = TypeScriptDocumentationProvider.getGenerics((TypeScriptTypeParameterListOwner)function, substitutor)) != null) {
            result.append(generics);
        }
    }

    @Nullable
    private static String getGenerics(@NotNull TypeScriptTypeParameterListOwner owner, @NotNull JSTypeSubstitutor substitutor) {
        TypeScriptTypeParameterList list;
        if (owner == null) {
            TypeScriptDocumentationProvider.$$$reportNull$$$0(16);
        }
        if (substitutor == null) {
            TypeScriptDocumentationProvider.$$$reportNull$$$0(17);
        }
        if ((list = owner.getTypeParameterList()) == null) {
            return null;
        }
        Object[] parameters = list.getTypeParameters();
        if (parameters.length == 0) {
            return null;
        }
        StringBuilder newBuilder = new StringBuilder();
        newBuilder.append("<");
        newBuilder.append(StringUtil.join((Object[])parameters, el -> {
            JSType type;
            String name;
            if (substitutor == null) {
                TypeScriptDocumentationProvider.$$$reportNull$$$0(36);
            }
            if ((name = el.getName()) == null) {
                name = "?";
            }
            return (type = (JSType)substitutor.get((Object)name)) == null ? name : type.getTypeText(JSType.TypeTextFormat.PRESENTABLE);
        }, (String)","));
        newBuilder.append(">");
        return StringUtil.escapeXml((String)newBuilder.toString());
    }

    @Override
    protected void appendParameterDoc(@NotNull StringBuilder builder, @NotNull JSParameter parameter) {
        JSType type;
        if (builder == null) {
            TypeScriptDocumentationProvider.$$$reportNull$$$0(18);
        }
        if (parameter == null) {
            TypeScriptDocumentationProvider.$$$reportNull$$$0(19);
        }
        if (!DumbService.isDumb((Project)parameter.getProject()) && (type = JSShowTypeInfoAction.getTypeForDocumentation((PsiElement)parameter)) != null && !(type instanceof JSAnyType)) {
            builder.append("* ");
            builder.append("@param ");
            builder.append("{");
            builder.append(this.getTypeTextForGenerateDoc(type));
            builder.append("} ");
            builder.append(parameter.getName());
            return;
        }
        super.appendParameterDoc(builder, parameter);
    }

    @Override
    @NotNull
    protected JSTypeSubstitutor getTypeSubstitutor(@NotNull JSElement member, @NotNull PsiElement originalElement) {
        if (member == null) {
            TypeScriptDocumentationProvider.$$$reportNull$$$0(20);
        }
        if (originalElement == null) {
            TypeScriptDocumentationProvider.$$$reportNull$$$0(21);
        }
        if (TypeScriptDocumentationProvider.isElementFromTSSources(member, originalElement = TypeScriptDocumentationProvider.getOriginalElementOrParent(originalElement))) {
            member = TypeScriptDocumentationProvider.getOriginalResolvedElement(member, (JSReferenceExpression)originalElement);
        }
        JSTypeSubstitutor jSTypeSubstitutor = TypeScriptGenericTypesEvaluator.getInstance().getTypeSubstitutorForMember(member, originalElement);
        if (jSTypeSubstitutor == null) {
            TypeScriptDocumentationProvider.$$$reportNull$$$0(22);
        }
        return jSTypeSubstitutor;
    }

    @Contract(value="!null->!null")
    private static PsiElement getOriginalElementOrParent(@Nullable PsiElement originalElement) {
        if (originalElement instanceof LeafPsiElement && JSKeywordSets.IDENTIFIER_NAMES.contains(originalElement.getNode().getElementType())) {
            originalElement = originalElement.getParent();
        }
        return originalElement;
    }

    @Override
    protected void appendVariableOrFieldType(@NotNull JSFieldVariable variableOrField, @Nullable PsiElement originalElement, @NotNull StringBuilder result, @NotNull JSTypeSubstitutor substitutor) {
        if (variableOrField == null) {
            TypeScriptDocumentationProvider.$$$reportNull$$$0(23);
        }
        if (result == null) {
            TypeScriptDocumentationProvider.$$$reportNull$$$0(24);
        }
        if (substitutor == null) {
            TypeScriptDocumentationProvider.$$$reportNull$$$0(25);
        }
        JSType definedType = variableOrField.getType();
        if (variableOrField instanceof JSVariable) {
            String name = variableOrField.getName();
            originalElement = TypeScriptDocumentationProvider.getOriginalElementOrParent(originalElement);
            if (name != null && originalElement instanceof JSReferenceExpression && ((JSReferenceExpression)originalElement).getQualifier() == null) {
                String narrowTypeForDocumentation;
                String definedTypeDocumentation;
                JSType narrowType;
                JSTypeEvaluationResult type = JSTypeEvaluator.getExpressionType((JSExpression)originalElement);
                JSType jSType = narrowType = type != null ? type.getType() : null;
                if (narrowType != null && narrowType != definedType && !StringUtil.equals((CharSequence)(definedTypeDocumentation = this.getTypeTextForQuickNavigate(definedType, substitutor)), (CharSequence)(narrowTypeForDocumentation = this.getTypeTextForQuickNavigate(narrowType, substitutor)))) {
                    this.appendType((PsiElement)variableOrField, result, narrowTypeForDocumentation);
                    if (!StringUtil.isEmpty((String)definedTypeDocumentation)) {
                        result.append(" <i>(").append(StringUtil.escapeXml((String)definedTypeDocumentation)).append(")</i>");
                    }
                    return;
                }
            }
        }
        super.appendVariableOrFieldType(variableOrField, originalElement, result, substitutor);
    }

    private static boolean isElementFromTSSources(@NotNull JSElement member, @NotNull PsiElement originalElement) {
        if (member == null) {
            TypeScriptDocumentationProvider.$$$reportNull$$$0(26);
        }
        if (originalElement == null) {
            TypeScriptDocumentationProvider.$$$reportNull$$$0(27);
        }
        return originalElement instanceof JSReferenceExpression && Boolean.TRUE.equals(TypeScriptDeclarationMappings.SOURCE_FILE_MARKER.get((UserDataHolder)member));
    }

    @Override
    @Nullable
    protected JSType getFunctionReturnTypeForInfoDoc(@NotNull JSFunction function) {
        if (function == null) {
            TypeScriptDocumentationProvider.$$$reportNull$$$0(28);
        }
        if (function instanceof TypeScriptFunction && function.getReturnTypeElement() != null) {
            return function.getReturnType();
        }
        return super.getFunctionReturnTypeForInfoDoc(function);
    }

    @Override
    @Nullable
    protected String getTypeTextForQuickNavigate(@Nullable JSType rawType, @NotNull JSTypeSubstitutor substitutor) {
        if (substitutor == null) {
            TypeScriptDocumentationProvider.$$$reportNull$$$0(29);
        }
        rawType = JSTypeUtils.applyCompositeMapping(rawType, (Function<JSType, JSType>)((Function)el -> JSCompositeTypeImpl.optimizeTypeIfComposite(el)));
        return super.getTypeTextForQuickNavigate(rawType, substitutor);
    }

    @Override
    @NotNull
    protected String getTypeTextForGenerateDoc(@NotNull JSType rawType) {
        if (rawType == null) {
            TypeScriptDocumentationProvider.$$$reportNull$$$0(30);
        }
        rawType = JSTypeUtils.applyCompositeMapping(rawType, (Function<JSType, JSType>)((Function)el -> JSCompositeTypeImpl.optimizeTypeIfComposite(el)));
        String string = super.getTypeTextForGenerateDoc(rawType);
        if (string == null) {
            TypeScriptDocumentationProvider.$$$reportNull$$$0(31);
        }
        return string;
    }

    @NotNull
    private static JSElement getOriginalResolvedElement(@NotNull JSElement member, @NotNull JSReferenceExpression originalElement) {
        ResolveResult[] results;
        Collection<PsiElement> resolvedElements;
        if (member == null) {
            TypeScriptDocumentationProvider.$$$reportNull$$$0(32);
        }
        if (originalElement == null) {
            TypeScriptDocumentationProvider.$$$reportNull$$$0(33);
        }
        if ((resolvedElements = JSResolveResult.toElements(results = originalElement.multiResolve(false))).size() != 1) {
            JSElement jSElement = member;
            if (jSElement == null) {
                TypeScriptDocumentationProvider.$$$reportNull$$$0(34);
            }
            return jSElement;
        }
        PsiElement candidate = (PsiElement)ContainerUtil.getFirstItem(resolvedElements);
        if (candidate instanceof JSElement) {
            member = (JSElement)candidate;
        }
        JSElement jSElement = member;
        if (jSElement == null) {
            TypeScriptDocumentationProvider.$$$reportNull$$$0(35);
        }
        return jSElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 22: 
            case 31: 
            case 34: 
            case 35: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 22: 
            case 31: 
            case 34: 
            case 35: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 4: 
            case 13: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 22: 
            case 31: 
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/documentation/TypeScriptDocumentationProvider";
                break;
            }
            case 10: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: 
            case 15: 
            case 17: 
            case 25: 
            case 29: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 14: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 20: 
            case 26: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 21: 
            case 27: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalElement";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableOrField";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/documentation/TypeScriptDocumentationProvider";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionPrefix";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getVarPrefix";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSubstitutor";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeTextForGenerateDoc";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalResolvedElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "appendVariableInitializer";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "appendClassAttributesAndName";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "appendClassExtendsAndImplements";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getVariableOrFieldType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionPrefix";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 22: 
            case 31: 
            case 34: 
            case 35: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getVarPrefix";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "appendParentInfo";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "appendFunctionAttributesAndName";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getGenerics";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "appendParameterDoc";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getTypeSubstitutor";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "appendVariableOrFieldType";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isElementFromTSSources";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionReturnTypeForInfoDoc";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getTypeTextForQuickNavigate";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getTypeTextForGenerateDoc";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getOriginalResolvedElement";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getGenerics$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 22: 
            case 31: 
            case 34: 
            case 35: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

