/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.refactoring;

import com.intellij.lang.Language;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.refactoring.JSDefaultRenameProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.rename.inplace.MemberInplaceRenameHandler;
import com.intellij.refactoring.rename.inplace.MemberInplaceRenamer;
import com.intellij.util.Query;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptMemberInplaceRenameHandler
extends MemberInplaceRenameHandler {
    protected boolean isAvailable(PsiElement element, Editor editor, PsiFile file) {
        boolean isTypeScriptContext;
        if (!(file instanceof JSFile) || element == null || !DialectDetector.isTypeScript((PsiElement)file)) {
            return false;
        }
        PsiElement context = file.findElementAt(editor.getCaretModel().getOffset());
        if (context == null && editor.getCaretModel().getOffset() > 0) {
            context = file.findElementAt(editor.getCaretModel().getOffset() - 1);
        }
        boolean bl = isTypeScriptContext = context != null && DialectDetector.isTypeScript(context);
        if (!isTypeScriptContext) {
            return false;
        }
        if (TypeScriptMemberInplaceRenameHandler.elementIsAcceptable(element)) {
            return editor.getSettings().isVariableInplaceRenameEnabled();
        }
        return false;
    }

    private static boolean elementIsAcceptable(@Nullable PsiElement element) {
        if (element == null) {
            return false;
        }
        return TypeScriptMemberInplaceRenameHandler.isClassOrInterfaceWithName(element) || element instanceof TypeScriptVariable && !(element.getUseScope() instanceof LocalSearchScope) || element instanceof TypeScriptFunction && !(element.getUseScope() instanceof LocalSearchScope) || element instanceof ES6ImportExportSpecifierAlias || element instanceof ES6ImportedBinding || element instanceof JSField || element instanceof TypeScriptImportStatement || element instanceof TypeScriptModule && ((TypeScriptModule)element).isInternal();
    }

    private static boolean isClassOrInterfaceWithName(@NotNull PsiElement element) {
        if (element == null) {
            TypeScriptMemberInplaceRenameHandler.$$$reportNull$$$0(0);
        }
        return element instanceof JSClass && ((JSClass)element).getName() != null;
    }

    @NotNull
    protected MemberInplaceRenamer createMemberRenamer(final @NotNull PsiElement element, PsiNameIdentifierOwner elementToRename, Editor editor) {
        if (element == null) {
            TypeScriptMemberInplaceRenameHandler.$$$reportNull$$$0(1);
        }
        if (element instanceof PsiNameIdentifierOwner) {
            elementToRename = (PsiNameIdentifierOwner)element;
        }
        MemberInplaceRenamer memberInplaceRenamer = new MemberInplaceRenamer((PsiNamedElement)elementToRename, (PsiElement)elementToRename, editor){

            protected boolean acceptReference(PsiReference reference) {
                return JSDefaultRenameProcessor.acceptReference(reference, false, true, element);
            }

            public boolean performInplaceRename() {
                return this.checkNeedInplace() && super.performInplaceRename();
            }

            private boolean checkNeedInplace() {
                String name;
                if (!JSDefaultRenameProcessor.getSearchJavaScriptReferences(element)) {
                    return true;
                }
                SearchScope scope = JSDefaultRenameProcessor.getScope(element, JSDefaultRenameProcessor.ReferencesType.JS);
                if (element instanceof JSNamedElement && scope instanceof GlobalSearchScope && (name = ((JSNamedElement)element).getName()) != null) {
                    PsiSearchHelper.SearchCostResult cheapEnough = PsiSearchHelper.SERVICE.getInstance((Project)element.getProject()).isCheapEnoughToSearch(name, (GlobalSearchScope)scope, element.getContainingFile(), null);
                    if (cheapEnough == PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES) {
                        return false;
                    }
                    if (cheapEnough == PsiSearchHelper.SearchCostResult.ZERO_OCCURRENCES) {
                        return true;
                    }
                }
                Ref useInplace = Ref.create((Object)true);
                Query search = ReferencesSearch.search((PsiElement)element, (SearchScope)scope);
                search.forEach(el -> {
                    useInplace.set((Object)false);
                    return false;
                });
                return (Boolean)useInplace.get();
            }

            @NotNull
            protected TextRange getRangeToRename(@NotNull PsiElement element2) {
                if (element2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (element2.getNode().getElementType() != JSTokenTypes.STRING_LITERAL) {
                    TextRange textRange = super.getRangeToRename(element2);
                    if (textRange == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return textRange;
                }
                if (!(element2.getParent() instanceof JSRecordType.PropertySignature)) {
                    TextRange textRange = super.getRangeToRename(element2);
                    if (textRange == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return textRange;
                }
                TextRange textRange = new TextRange(1, element2.getTextLength() - 1);
                if (textRange == null) {
                    1.$$$reportNull$$$0(3);
                }
                return textRange;
            }

            protected boolean isIdentifier(String newName, Language language) {
                PsiNamedElement element2 = this.myElementToRename;
                if (!(element2 instanceof JSRecordType.PropertySignature)) {
                    return super.isIdentifier(newName, language);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/typescript/refactoring/TypeScriptMemberInplaceRenameHandler$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/typescript/refactoring/TypeScriptMemberInplaceRenameHandler$1";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getRangeToRename";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getRangeToRename";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (memberInplaceRenamer == null) {
            TypeScriptMemberInplaceRenameHandler.$$$reportNull$$$0(2);
        }
        return memberInplaceRenamer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/refactoring/TypeScriptMemberInplaceRenameHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/refactoring/TypeScriptMemberInplaceRenameHandler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createMemberRenamer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isClassOrInterfaceWithName";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createMemberRenamer";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

