/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.resolve;

import com.intellij.javascript.JSFunctionWithSubstitutor;
import com.intellij.lang.ecmascript6.psi.JSClassExpression;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.ecmascript6.TypeScriptImportHandler;
import com.intellij.lang.javascript.ecmascript6.TypeScriptSignatureChooser;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeEvaluationResult;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.resolve.JavaScriptQualifiedItemProcessor;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSIntersectionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.JSTypeofTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptGenericThisTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptGenericTypesEvaluator
extends JSGenericTypesEvaluator {
    private static TypeScriptGenericTypesEvaluator INSTANCE = null;

    protected TypeScriptGenericTypesEvaluator() {
    }

    public static TypeScriptGenericTypesEvaluator getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new TypeScriptGenericTypesEvaluator();
        }
        return INSTANCE;
    }

    @NotNull
    private static Set<String> getGenericNames(@Nullable PsiElement resolvedFunction) {
        if (resolvedFunction instanceof TypeScriptTypeParameterListOwner) {
            TypeScriptTypeParameter[] parameters = TypeScriptPsiUtil.getTypeParametersForOwner(resolvedFunction);
            Set<String> set = Arrays.stream(parameters).map(p -> p.getName()).collect(Collectors.toSet());
            if (set == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(0);
            }
            return set;
        }
        Set<String> set = Collections.emptySet();
        if (set == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(1);
        }
        return set;
    }

    private static void addGenericDependencyFromType(final @NotNull Set<String> names, final @NotNull MultiMap<Integer, String> results, final int ownName, @Nullable JSType type) {
        if (names == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(2);
        }
        if (results == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(3);
        }
        if (type == null) {
            return;
        }
        new JSRecursiveTypeVisitor(){

            public void visitJSTypeImpl(JSType type) {
                if (type instanceof JSGenericParameterImpl && names.contains(((JSGenericParameterImpl)type).getName())) {
                    results.putValue((Object)ownName, (Object)((JSGenericParameterImpl)type).getName());
                }
            }
        }.visitJSType(type);
    }

    @NotNull
    private static Integer[] reorderByDependencies(@NotNull JSExpression[] arguments, @NotNull List<JSType> parameterTypes, @NotNull Set<String> names) {
        if (arguments == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(4);
        }
        if (parameterTypes == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(5);
        }
        if (names == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(6);
        }
        int length = arguments.length;
        Integer[] result = new Integer[length];
        MultiMap results = new MultiMap();
        for (int i = 0; i < length; ++i) {
            result[i] = i;
            if (i >= parameterTypes.size()) continue;
            TypeScriptGenericTypesEvaluator.addGenericDependencyFromType(names, (MultiMap<Integer, String>)results, i, parameterTypes.get(i));
        }
        Arrays.sort(result, (r1, r2) -> {
            Collection all1 = results.get(r1);
            Collection all2 = results.get(r2);
            return all1.stream().anyMatch(i -> all2.contains(i)) ? -1 : 1;
        });
        if (result == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(7);
        }
        return result;
    }

    @Override
    @NotNull
    public MultiMap<String, JSType> inferGenericArgumentsFromCall(List<JSType> parameterTypes, JSExpression[] arguments, int paramToSkip, PsiElement resolvedFunction) {
        Set<String> names = TypeScriptGenericTypesEvaluator.getGenericNames(resolvedFunction);
        Integer[] newIndices = TypeScriptGenericTypesEvaluator.reorderByDependencies(arguments, parameterTypes, names);
        MultiMap genericArguments = MultiMap.createSmart();
        JSTypeSubstitutor substitutor = new JSTypeSubstitutor();
        ProcessingContext processingContext = new ProcessingContext();
        processingContext.put(ourGenericArgumentsMapKey, (Object)genericArguments);
        for (int i = 0; i < arguments.length; ++i) {
            int j = newIndices[i];
            if (j == paramToSkip) continue;
            if (j >= parameterTypes.size()) break;
            JSType paramType = parameterTypes.get(j);
            if (paramType instanceof JSTypeofTypeImpl) {
                paramType = paramType.substitute();
            }
            if (!substitutor.isEmpty()) {
                paramType = JSTypeUtils.applyGenericArguments(paramType, (Map<String, JSType>)substitutor, true);
            }
            if (!JSTypeUtils.hasGenericParameter(paramType)) continue;
            JSExpression argument = arguments[j];
            JSType exprType = TypeScriptGenericTypesEvaluator.getParameterExpressionType(argument);
            if (exprType != null && exprType.getSource().isTypeScript()) {
                exprType = TypeScriptGenericTypesEvaluator.getExplicitTypeOrAny(argument, exprType);
            }
            TypeScriptGenericTypesEvaluator.matchGenericTypes(processingContext, exprType, paramType, resolvedFunction);
            for (Map.Entry entry : genericArguments.entrySet()) {
                String key = (String)entry.getKey();
                Collection types = (Collection)entry.getValue();
                if (types.size() != 1) continue;
                substitutor.putIfAbsent((Object)key, types.iterator().next());
            }
        }
        MultiMap multiMap = genericArguments;
        if (multiMap == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(8);
        }
        return multiMap;
    }

    @Override
    @NotNull
    public JSType evaluateGenericsFromQualifier(@NotNull JSType type, @NotNull JSExpression qualifier, @NotNull JSReferenceExpression methodExpression) {
        JSType rawQualifier;
        if (type == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(9);
        }
        if (qualifier == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(10);
        }
        if (methodExpression == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(11);
        }
        if (!type.getSource().isTypeScript()) {
            type = super.evaluateGenericsFromQualifier(type, qualifier, methodExpression);
        }
        boolean hasGenerics = JSTypeUtils.hasGenericParameter(type);
        boolean hasThisGenericType = JSTypeUtils.hasThisGenericType(type);
        if (!hasGenerics && !hasThisGenericType) {
            if (!(type instanceof JSResolvableType)) {
                JSType jSType = type;
                if (jSType == null) {
                    TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(12);
                }
                return jSType;
            }
            JSResolvableType jsType = (JSResolvableType)type;
            JSResolvedTypeInfo resolvedType = jsType.resolveType();
            if (resolvedType != null && !resolvedType.isLocal()) {
                JSType jSType = type;
                if (jSType == null) {
                    TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(13);
                }
                return jSType;
            }
        }
        if ((rawQualifier = JSResolveUtil.getExpressionJSType(qualifier)) != null && hasThisGenericType) {
            type = TypeScriptGenericTypesEvaluator.evaluateThisType(type, rawQualifier);
        }
        PsiElement sourceElement = type.getSource().getSourceElement();
        JSType jSType = type = TypeScriptGenericTypesEvaluator.evaluateGenericsFromQualifierType(type, rawQualifier, sourceElement, methodExpression);
        if (jSType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(14);
        }
        return jSType;
    }

    private static boolean isApplicableRecordTypeForThis(@NotNull JSRecordType recordType) {
        if (recordType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(15);
        }
        PsiElement sourceElement = recordType.getSource().getSourceElement();
        return sourceElement instanceof JSClassExpression;
    }

    private static JSType evaluateThisType(@NotNull JSType type, @NotNull JSType qualifierType) {
        if (type == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(16);
        }
        if (qualifierType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(17);
        }
        return type.transformTypeHierarchy(jsType -> {
            if (qualifierType == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(75);
            }
            if (jsType instanceof TypeScriptGenericThisTypeImpl && (!(qualifierType instanceof JSRecordType) || TypeScriptGenericTypesEvaluator.isApplicableRecordTypeForThis((JSRecordType)qualifierType))) {
                return qualifierType;
            }
            return jsType;
        });
    }

    @Contract(value="!null,_,_,_ -> !null")
    private static JSType evaluateGenericsFromQualifierType(@Nullable JSType type, @Nullable JSType qualifierType, @Nullable PsiElement sourceElement, @NotNull JSReferenceExpression methodExpression) {
        JSTypeSubstitutor substitutor;
        if (methodExpression == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(18);
        }
        if (type != null && qualifierType != null && !(substitutor = TypeScriptGenericTypesEvaluator.getTypeSubstitutorFromQualifierType(qualifierType, sourceElement, (PsiElement)methodExpression)).isEmpty()) {
            type = JSTypeUtils.applyGenericArguments(type, (Map<String, JSType>)substitutor);
        }
        return type;
    }

    @NotNull
    private static JSTypeSubstitutor getTypeSubstitutorFromQualifierType(@NotNull JSType qualifierType, @Nullable PsiElement sourceElement, @Nullable PsiElement place) {
        JSClass parentClass;
        JSType constraintType;
        if (qualifierType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(19);
        }
        JSTypeSubstitutor substitutor = new JSTypeSubstitutor();
        if ((qualifierType = JSTypeUtils.unwrapDecorations(qualifierType)) instanceof JSIntersectionTypeImpl) {
            for (JSType typeToProcess : ((JSIntersectionTypeImpl)qualifierType).getTypes()) {
                JSTypeSubstitutor candidate = TypeScriptGenericTypesEvaluator.getTypeSubstitutorFromQualifierType(typeToProcess, sourceElement, place);
                substitutor.putAll((Map)candidate);
            }
            JSTypeSubstitutor jSTypeSubstitutor = substitutor;
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(20);
            }
            return jSTypeSubstitutor;
        }
        if (qualifierType instanceof JSGenericTypeImpl) {
            JSGenericTypeImpl genericType = (JSGenericTypeImpl)qualifierType;
            Map<String, JSType> outerArguments = genericType.getOuterArguments();
            if (outerArguments != null) {
                substitutor.putAll(outerArguments);
            }
        } else if (qualifierType instanceof JSRecordType) {
            MultiMap<String, JSType> generics;
            PsiElement qualifierSource = qualifierType.getSource().getSourceElement();
            JSType objectType = null;
            if (qualifierSource instanceof TypeScriptObjectType) {
                objectType = TypeScriptTypeParser.buildTypeFromTypeScript((JSTypeDeclaration)((TypeScriptObjectType)qualifierSource));
            } else if (qualifierSource instanceof JSClass) {
                objectType = TypeScriptTypeParser.buildTypeFromClass((JSClass)qualifierSource, false);
            } else if (qualifierSource instanceof JSObjectLiteralExpression) {
                objectType = JSResolveUtil.getExpressionJSType((JSExpression)qualifierSource);
            }
            if (objectType != null && !(generics = TypeScriptGenericTypesEvaluator.findGenericsTypeValues(qualifierType, objectType)).isEmpty()) {
                JSTypeSubstitutor candidate = TypeScriptGenericTypesEvaluator.intersectGenerics(generics, sourceElement, null);
                substitutor.putAll((Map)candidate);
                JSTypeSubstitutor jSTypeSubstitutor = substitutor;
                if (jSTypeSubstitutor == null) {
                    TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(21);
                }
                return jSTypeSubstitutor;
            }
        } else if (qualifierType instanceof TypeScriptGenericThisTypeImpl) {
            qualifierType = qualifierType.substitute();
        }
        List<JSType> arguments = JSTypeUtils.getGenericTypeArguments(qualifierType);
        if (arguments == null && qualifierType instanceof JSGenericParameterImpl && (constraintType = ((JSGenericParameterImpl)qualifierType).getConstraintType()) != null) {
            qualifierType = constraintType;
            arguments = JSTypeUtils.getGenericTypeArguments(qualifierType);
        }
        if (sourceElement != null && (arguments != null && JSTypeUtils.getQualifiedNameMatchingType(qualifierType, false) != null || qualifierType instanceof JSTypeImpl) && (parentClass = (JSClass)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)sourceElement, JSClass.class)) != null) {
            Collection<JSClass> qualifierClasses = TypeScriptGenericTypesEvaluator.getQualifierClasses(qualifierType, place);
            for (JSClass qualifierClass : qualifierClasses) {
                List<JSType> argumentsList = arguments == null || arguments.isEmpty() ? TypeScriptGenericTypesEvaluator.getArgumentsListForQualifierType(qualifierType, qualifierClass) : arguments;
                Ref ref = Ref.create((Object)substitutor);
                TypeScriptGenericTypesEvaluator.processClassWithGenericArguments(qualifierClass, argumentsList, parentClass, (Ref<JSTypeSubstitutor>)ref);
                if (ref.isNull()) continue;
                substitutor = (JSTypeSubstitutor)ref.get();
            }
        }
        JSTypeSubstitutor jSTypeSubstitutor = substitutor;
        if (jSTypeSubstitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(22);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    private static List<JSType> getArgumentsListForQualifierType(@NotNull JSType qualifierType, @NotNull JSClass qualifierClass) {
        TypeScriptTypeParameter[] parameters;
        if (qualifierType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(23);
        }
        if (qualifierClass == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(24);
        }
        if (TypeScriptGenericTypesEvaluator.isInstanceJSTypeImpl(qualifierType) && (parameters = TypeScriptPsiUtil.getTypeParametersForOwner((PsiElement)qualifierClass)).length > 0) {
            List<JSType> list = Arrays.stream(parameters).map(JSGenericTypesEvaluator::getTypeParameterDefaultType).collect(Collectors.toList());
            if (list == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(25);
            }
            return list;
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(26);
        }
        return list;
    }

    private static boolean isInstanceJSTypeImpl(@NotNull JSType qualifierType) {
        if (qualifierType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(27);
        }
        return qualifierType instanceof JSTypeImpl && ((JSTypeImpl)qualifierType).getTypeContext().toJSContext() == JSContext.INSTANCE;
    }

    @NotNull
    public static JSType processClassWithGenericArguments(@Nullable JSClass aClass, @NotNull List<JSType> typeArgumentsList, @Nullable JSClass requiredParentClass, @NotNull JSType appliedGenerics) {
        if (typeArgumentsList == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(28);
        }
        if (appliedGenerics == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(29);
        }
        Ref substitutor = Ref.create();
        TypeScriptGenericTypesEvaluator.processClassWithGenericArguments(aClass, typeArgumentsList, requiredParentClass, (Ref<JSTypeSubstitutor>)substitutor);
        JSType jSType = JSTypeUtils.applyGenericArguments(appliedGenerics, (Map)substitutor.get());
        if (jSType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(30);
        }
        return jSType;
    }

    public static void processClassWithGenericArguments(@Nullable JSClass contextClass, @NotNull List<JSType> typeArgumentsList, @Nullable JSClass expectedGenericOwnerClass, @NotNull Ref<JSTypeSubstitutor> substitutor) {
        if (typeArgumentsList == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(31);
        }
        if (substitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(32);
        }
        TypeScriptGenericTypesEvaluator.processClassWithGenericArguments(contextClass, typeArgumentsList, expectedGenericOwnerClass, substitutor, ContainerUtil.newHashSet());
    }

    public static boolean processClassWithGenericArguments(@Nullable JSClass contextClass, @NotNull List<JSType> typeArgumentsList, @Nullable JSClass expectedGenericOwnerClass, @NotNull Ref<JSTypeSubstitutor> substitutor, @NotNull Set<JSClass> visitedClasses) {
        if (typeArgumentsList == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(33);
        }
        if (substitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(34);
        }
        if (visitedClasses == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(35);
        }
        if (!(contextClass instanceof TypeScriptTypeParameterListOwner) || expectedGenericOwnerClass == null) {
            return true;
        }
        if (contextClass.isEquivalentTo((PsiElement)expectedGenericOwnerClass)) {
            JSTypeSubstitutor genericArguments = TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments((TypeScriptTypeParameterListOwner)contextClass, typeArgumentsList);
            JSTypeSubstitutor oldSubstitutor = (JSTypeSubstitutor)substitutor.get();
            if (oldSubstitutor != null && genericArguments != null) {
                genericArguments.putAll((Map)oldSubstitutor);
            }
            substitutor.set((Object)genericArguments);
            return false;
        }
        ArrayList superReferences = ContainerUtil.newArrayList();
        JSReferenceList extendsList = contextClass.getExtendsList();
        JSReferenceList implementsList = contextClass.getImplementsList();
        if (extendsList != null) {
            superReferences.addAll(extendsList.getResolvedExpressions());
        }
        if (implementsList != null) {
            superReferences.addAll(implementsList.getResolvedExpressions());
        }
        if (!superReferences.isEmpty()) {
            JSTypeSubstitutor typeArguments = TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments((TypeScriptTypeParameterListOwner)contextClass, typeArgumentsList);
            for (Pair reference : superReferences) {
                if (reference.second == null || ((Collection)reference.second).isEmpty()) continue;
                List<JSType> superclassTypeArguments = TypeScriptGenericTypesEvaluator.getTypeArgumentsForDeclarations(((JSReferenceListMember)reference.first).getTypeArguments(), (Map<String, JSType>)typeArguments);
                for (JSClass jsSuperClass : (Collection)reference.second) {
                    if (!JSInheritanceUtil.isParentClass(jsSuperClass, expectedGenericOwnerClass, false)) continue;
                    if (!visitedClasses.add(jsSuperClass)) {
                        return false;
                    }
                    if (TypeScriptGenericTypesEvaluator.processClassWithGenericArguments(jsSuperClass, superclassTypeArguments, expectedGenericOwnerClass, substitutor, visitedClasses)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @NotNull
    public static List<JSType> getTypeArgumentsForDeclarations(@NotNull JSTypeDeclaration[] declarations, @Nullable Map<String, JSType> typeArguments) {
        if (declarations == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(36);
        }
        List mappedArguments = ContainerUtil.newSmartList();
        for (JSTypeDeclaration typeArgument : declarations) {
            JSType expandedType = TypeScriptTypeParser.buildTypeFromTypeScript(typeArgument);
            if (typeArguments != null) {
                expandedType = JSTypeUtils.applyGenericArguments(expandedType, typeArguments);
            }
            mappedArguments.add(expandedType);
        }
        List list = mappedArguments;
        if (list == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(37);
        }
        return list;
    }

    @Nullable
    public static JSTypeSubstitutor getSubstitutorForTypeArguments(@Nullable TypeScriptTypeParameterListOwner typeParameterListOwner, @Nullable JSType genericType) {
        List<JSType> arguments = JSTypeUtils.getGenericTypeArguments(genericType);
        return arguments == null ? null : TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments(typeParameterListOwner, arguments);
    }

    @Nullable
    public static JSTypeSubstitutor getSubstitutorForTypeArguments(@Nullable TypeScriptTypeParameterListOwner typeParameterListOwner, @NotNull List<JSType> typeArgumentsList) {
        if (typeArgumentsList == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(38);
        }
        if (typeParameterListOwner == null) {
            return null;
        }
        return TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments(typeParameterListOwner.getTypeParameterList(), typeArgumentsList);
    }

    @Nullable
    public static JSTypeSubstitutor getSubstitutorForTypeArguments(@Nullable TypeScriptTypeParameterList typeParameterList, @NotNull List<JSType> typeArgumentsList) {
        if (typeArgumentsList == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(39);
        }
        if (typeArgumentsList.isEmpty() || typeParameterList == null) {
            return null;
        }
        TypeScriptTypeParameter[] parameters = typeParameterList.getTypeParameters();
        return TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments(parameters, typeArgumentsList);
    }

    @NotNull
    public static JSTypeSubstitutor getSubstitutorForTypeArguments(@NotNull TypeScriptTypeParameter[] parameters, @NotNull List<JSType> typeArgumentsList) {
        if (parameters == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(40);
        }
        if (typeArgumentsList == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(41);
        }
        if (typeArgumentsList.size() == 0 || parameters.length == 0) {
            JSTypeSubstitutor jSTypeSubstitutor = new JSTypeSubstitutor();
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(42);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutor genericArguments = new JSTypeSubstitutor();
        for (int i = 0; i < parameters.length; ++i) {
            String name;
            TypeScriptTypeParameter parameter = parameters[i];
            JSType type = null;
            if (typeArgumentsList.size() > i) {
                type = typeArgumentsList.get(i);
            }
            if (type == null) {
                type = TypeScriptGenericTypesEvaluator.getTypeParameterDefaultType(parameter);
            }
            if ((name = parameter.getName()) == null) continue;
            genericArguments.put((Object)name, (Object)type);
        }
        JSTypeSubstitutor jSTypeSubstitutor = genericArguments;
        if (jSTypeSubstitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(43);
        }
        return jSTypeSubstitutor;
    }

    @Override
    @Nullable
    public JSType evaluateGenerics(@Nullable JSType type, @Nullable JSExpression methodExpression, @Nullable PsiElement resolvedFunction, @Nullable JSGenericTypesEvaluator.GenericErrorReporter reporter, int paramToSkip) {
        if (!this.canHaveGenericParameters(type)) {
            return type;
        }
        if (methodExpression != null) {
            JSReferenceList list;
            TypeScriptClass tsClass;
            PsiElement callExpression = methodExpression.getParent();
            JSTypeSubstitutor map = TypeScriptGenericTypesEvaluator.addExplicitGenericArgumentsFromCall(resolvedFunction, callExpression, null);
            if (TypeScriptGenericTypesEvaluator.isConstructorSuperCall(resolvedFunction, (PsiElement)methodExpression) && (tsClass = (TypeScriptClass)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)methodExpression, TypeScriptClass.class)) != null && resolvedFunction instanceof TypeScriptFunction && (list = tsClass.getExtendsList()) != null) {
                if (tsClass.getIndirectSuperConstructors().contains(resolvedFunction)) {
                    JSExpression element = (JSExpression)ArrayUtil.getFirstElement((Object[])list.getExpressions());
                    List<JSType> typesForGenerics = element != null ? TypeScriptGenericTypesEvaluator.getTypeArgumentsForDeclarations(TypeScriptPsiUtil.getNestedTypeArguments(element.getParent()), null) : ContainerUtil.emptyList();
                    TypeScriptFunction tsFunction = (TypeScriptFunction)resolvedFunction;
                    JSTypeSubstitutor argumentsFromSuper = TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments((TypeScriptTypeParameterListOwner)tsFunction, typesForGenerics);
                    if (map != null && argumentsFromSuper != null) {
                        map.putAll(argumentsFromSuper);
                    }
                } else {
                    JSClass parentClass = (JSClass)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)resolvedFunction, JSClass.class);
                    type = TypeScriptGenericTypesEvaluator.processClassWithGenericArguments((JSClass)tsClass, (List<JSType>)ContainerUtil.emptyList(), parentClass, type);
                }
            }
            type = JSTypeUtils.applyGenericArguments(type, (Map<String, JSType>)map, false, reporter);
        }
        return super.evaluateGenerics(type, methodExpression, resolvedFunction, reporter, paramToSkip);
    }

    @NotNull
    public JSTypeSubstitutor getTypeSubstitutorForMember(@Nullable PsiElement member, @Nullable PsiElement place, @Nullable JSType qualifierType, @Nullable JSTypeSubstitutor additionalSubstitutor) {
        JSTypeSubstitutor candidate;
        PsiElement parent;
        boolean isFunctionCallContext;
        if (place == null || !(member instanceof JSQualifiedNamedElement)) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(44);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutor substitutor = new JSTypeSubstitutor();
        if (additionalSubstitutor != null) {
            substitutor.putAll((Map)additionalSubstitutor);
        }
        boolean bl = isFunctionCallContext = (parent = place.getParent()) instanceof JSCallExpression && member instanceof TypeScriptTypeParameterListOwner;
        if (isFunctionCallContext) {
            candidate = this.inferGenericTypesForCall(member, (JSCallExpression)parent, null);
            candidate.forEach((key, value) -> {
                if (!(value instanceof JSAnyType)) {
                    substitutor.put(key, value);
                }
            });
        }
        if (qualifierType != null) {
            candidate = TypeScriptGenericTypesEvaluator.getTypeSubstitutorFromQualifierType(qualifierType, member, place);
            substitutor.putAll((Map)candidate);
        }
        if (isFunctionCallContext) {
            substitutor.putAll((Map)TypeScriptGenericTypesEvaluator.addExplicitGenericArgumentsFromCall(member, parent, substitutor));
        }
        JSTypeSubstitutor jSTypeSubstitutor = substitutor;
        if (jSTypeSubstitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(45);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    public JSTypeSubstitutor getTypeSubstitutorForMember(@Nullable JSElement member, @NotNull PsiElement place) {
        List<JSFunctionWithSubstitutor> elements;
        JSFunctionWithSubstitutor functionWithSubstitutor;
        if (place == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(46);
        }
        if (member == null || !DialectDetector.isTypeScript((PsiElement)member) || !(place instanceof JSReferenceExpression)) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(47);
            }
            return jSTypeSubstitutor;
        }
        JSReferenceExpression referenceExpression = (JSReferenceExpression)place;
        JSExpression qualifier = referenceExpression.getQualifier();
        JSType qualifierType = null;
        if (qualifier != null) {
            qualifierType = JSResolveUtil.getExpressionJSType(qualifier);
        }
        if (referenceExpression.getParent() instanceof JSCallExpression && (functionWithSubstitutor = (JSFunctionWithSubstitutor)ContainerUtil.getFirstItem(elements = TypeScriptSignatureChooser.getFunctionElementsWithCheckParameterTypes((PsiElement)referenceExpression))) != null) {
            JSFunctionItem functionItem = functionWithSubstitutor.myFunctionItem;
            JSTypeSubstitutor additionalSubstitutor = functionWithSubstitutor.myTypeSubstitutor;
            JSTypeSubstitutor jSTypeSubstitutor = this.getTypeSubstitutorForMember((PsiElement)functionItem, place, qualifierType, additionalSubstitutor);
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(48);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutor jSTypeSubstitutor = this.getTypeSubstitutorForMember((PsiElement)member, place, qualifierType, null);
        if (jSTypeSubstitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(49);
        }
        return jSTypeSubstitutor;
    }

    private static boolean isConstructorSuperCall(PsiElement resolveResult, PsiElement callExpression) {
        return callExpression instanceof JSSuperExpression && callExpression.getParent() instanceof JSCallExpression && resolveResult instanceof JSFunction && ((JSFunction)resolveResult).isConstructor();
    }

    @Nullable
    public static JSType getParameterExpressionType(@NotNull JSExpression expression) {
        if (expression == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(50);
        }
        Ref exprTypeRef = Ref.create(null);
        JSTypeEvaluator.processWithEvaluationGuard(expression, JSEvaluateContext.JSEvaluationPlace.PARAMETER_TYPE, e -> exprTypeRef.set((Object)JSTypeEvaluator.getExpressionType(e)));
        JSTypeEvaluationResult result = (JSTypeEvaluationResult)exprTypeRef.get();
        if (result == null) {
            return null;
        }
        List<JSTypeEvaluationResult.JSTypeEvaluationResultElement> results = result.getResults();
        if (results.size() <= 1) {
            return JSTypeUtils.getValuableType(result.getType());
        }
        ArrayList types = ContainerUtil.newArrayList();
        JSTypeSource source = null;
        for (JSTypeEvaluationResult.JSTypeEvaluationResultElement element : results) {
            JSType type = JSTypeUtils.getValuableType(element.getType());
            if (type == null) continue;
            types.add(type);
            JSTypeSource typeSource = type.getSource();
            source = source == null ? typeSource : JSTypeSourceFactory.copyTypeSource(source, source.isStrict() && typeSource.isStrict());
        }
        if (types.size() <= 1) {
            return (JSType)ContainerUtil.getFirstItem((List)types);
        }
        return new JSCompositeTypeImpl(source == null ? JSTypeSource.EMPTY_TS : source, types);
    }

    public static void fillExplicitGenericArguments(@NotNull TypeScriptTypeParameter[] typeParameters, @NotNull JSTypeDeclaration[] typeArguments, @NotNull Map<String, JSType> genericArguments) {
        if (typeParameters == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(51);
        }
        if (typeArguments == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(52);
        }
        if (genericArguments == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(53);
        }
        if (typeParameters.length == 0) {
            return;
        }
        for (int i = 0; i < typeParameters.length; ++i) {
            String name;
            JSType type;
            TypeScriptTypeParameter parameter = typeParameters[i];
            JSTypeDeclaration typeArgument = typeArguments.length > i ? typeArguments[i] : null;
            JSType jSType = type = typeArgument != null ? TypeScriptTypeParser.buildTypeFromTypeScript(typeArgument) : null;
            if (typeArguments.length > 0 && type == null) {
                type = TypeScriptGenericTypesEvaluator.getTypeParameterDefaultType(parameter);
            }
            if ((name = parameter.getName()) == null || genericArguments.containsKey(name) && type == null) continue;
            genericArguments.put(name, type);
        }
    }

    @Contract(value="_,_,!null -> !null")
    public static JSTypeSubstitutor addExplicitGenericArgumentsFromCall(PsiElement resolveResult, PsiElement callExpression, @Nullable JSTypeSubstitutor genericArguments) {
        TypeScriptTypeParameter[] typeParameters;
        JSClass clazz;
        if (!(resolveResult instanceof TypeScriptTypeParameterListOwner)) {
            return genericArguments == null ? null : new JSTypeSubstitutor((Map)genericArguments);
        }
        JSTypeSubstitutor substitutor = genericArguments == null ? new JSTypeSubstitutor() : new JSTypeSubstitutor((Map)genericArguments);
        TypeScriptTypeParameterList typeParameterList = ((TypeScriptTypeParameterListOwner)resolveResult).getTypeParameterList();
        if (typeParameterList != null) {
            TypeScriptTypeParameter[] typeParameters2 = typeParameterList.getTypeParameters();
            JSTypeDeclaration[] typeArguments = TypeScriptPsiUtil.getNestedTypeArguments(callExpression);
            TypeScriptGenericTypesEvaluator.fillExplicitGenericArguments(typeParameters2, typeArguments, (Map<String, JSType>)substitutor);
        }
        if ((clazz = (JSClass)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)resolveResult, JSClass.class)) instanceof TypeScriptTypeParameterListOwner && (typeParameters = TypeScriptPsiUtil.getTypeParametersForOwner((PsiElement)clazz)).length > 0) {
            JSTypeDeclaration[] typeArguments = TypeScriptPsiUtil.getNewExpressionTypeArguments(callExpression);
            TypeScriptGenericTypesEvaluator.fillExplicitGenericArguments(typeParameters, typeArguments, (Map<String, JSType>)substitutor);
        }
        return substitutor;
    }

    @NotNull
    public static List<JSType> getArgumentTypesForSignatureChecking(@NotNull JSCallExpression callExpression) {
        JSExpression[] arguments;
        if (callExpression == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(54);
        }
        if ((arguments = callExpression.getArguments()).length == 0) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(55);
            }
            return list;
        }
        DialectOptionHolder holder = DialectDetector.dialectOfElement((PsiElement)callExpression);
        boolean isTypeScript = holder != null && holder.isTypeScript;
        List argumentTypes = ContainerUtil.newSmartList();
        for (JSExpression expression : arguments) {
            JSType type = TypeScriptGenericTypesEvaluator.getParameterExpressionType(expression);
            argumentTypes.add(isTypeScript ? TypeScriptGenericTypesEvaluator.getExplicitTypeOrAny(expression, type) : (type != null ? type : JSAnyType.get((PsiElement)expression, false)));
        }
        List list = argumentTypes;
        if (list == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(56);
        }
        return list;
    }

    @NotNull
    public static JSType getExplicitTypeOrAny(@NotNull JSExpression expression, @Nullable JSType type) {
        if (expression == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(57);
        }
        JSType jSType = type == null ? JSAnyType.get((PsiElement)expression, false) : JSTypeUtils.replaceImplicitTypesWithAny(type);
        if (jSType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(58);
        }
        return jSType;
    }

    @NotNull
    public static Collection<JSClass> getQualifierClasses(@Nullable JSType qualifierType, @Nullable PsiElement place) {
        if (qualifierType == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(59);
            }
            return list;
        }
        JSTypeSource source = qualifierType.getSource();
        String type = JSTypeUtils.getQualifiedNameMatchingType(qualifierType, false);
        PsiElement element = source.getSourceElement();
        if (type == null || element == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(60);
            }
            return list;
        }
        Collection<? extends PsiElement> elements = TypeScriptGenericTypesEvaluator.getElementsForQualifierClassName(type, element, place);
        List result = ContainerUtil.newSmartList();
        for (PsiElement psiElement : elements) {
            if (!(psiElement instanceof JSClass)) continue;
            result.add((JSClass)psiElement);
        }
        List list = result;
        if (list == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(61);
        }
        return list;
    }

    @NotNull
    private static Collection<? extends PsiElement> getElementsForQualifierClassName(@NotNull String type, @NotNull PsiElement element, @Nullable PsiElement place) {
        boolean isJSPlace;
        if (type == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(62);
        }
        if (element == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(63);
        }
        boolean bl = isJSPlace = place != null && !DialectDetector.isTypeScript(place);
        if (isJSPlace && (!DialectDetector.isTypeScript(element) || JSCorePredefinedLibrariesProvider.isLibraryElement(element))) {
            Collection<PsiElement> collection = JavaScriptQualifiedItemProcessor.resolveGlobalTypeElementsByName(type, place);
            if (collection == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(64);
            }
            return collection;
        }
        JSTypeResolveResult resolveResults = TypeScriptImportHandler.getInstance().resolveMainElementName(type, element);
        Collection<? extends PsiElement> collection = resolveResults.getElements();
        if (collection == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(65);
        }
        return collection;
    }

    @NotNull
    public static List<JSType> buildGenericParameters(@NotNull TypeScriptTypeParameter[] parameters) {
        if (parameters == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(66);
        }
        List<JSType> list = TypeScriptGenericTypesEvaluator.buildGenericParameters(parameters, false);
        if (list == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(67);
        }
        return list;
    }

    @NotNull
    public static List<JSType> buildGenericParameters(@NotNull TypeScriptTypeParameter[] parameters, boolean callEnv) {
        if (parameters == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(68);
        }
        ArrayList generics = ContainerUtil.newArrayList();
        for (TypeScriptTypeParameter parameter : parameters) {
            String name;
            TypeScriptType constraint = parameter.getTypeConstraint();
            JSType constraintType = null;
            if (constraint != null) {
                constraintType = TypeScriptTypeParser.buildTypeFromTypeScript((JSTypeDeclaration)constraint);
            }
            if ((name = parameter.getName()) == null) continue;
            generics.add(new JSGenericParameterImpl(name, JSTypeSourceFactory.createTypeSource((PsiElement)parameter, true), constraintType, callEnv));
        }
        ArrayList arrayList = generics;
        if (arrayList == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(69);
        }
        return arrayList;
    }

    @NotNull
    public static JSType applyTypeScriptGenericArguments(@NotNull JSFunctionTypeImpl functionType, @NotNull JSCallExpression callExpression) {
        if (functionType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(70);
        }
        if (callExpression == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(71);
        }
        PsiElement sourceElement = functionType.getSource().getSourceElement();
        JSTypeSubstitutor defaultParamsSubstitutor = new JSTypeSubstitutor();
        JSType resultType = TypeScriptGenericTypesEvaluator.wrapReturnTypeWithGenerics(functionType, callExpression, defaultParamsSubstitutor);
        JSExpression methodExpression = callExpression.getMethodExpression();
        JSType evaluatedType = TypeScriptGenericTypesEvaluator.getInstance().evaluateGenerics(resultType, methodExpression, sourceElement);
        JSType jSType = JSTypeUtils.applyGenericArguments(evaluatedType, (Map<String, JSType>)defaultParamsSubstitutor);
        if (jSType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(72);
        }
        return jSType;
    }

    private static JSType wrapReturnTypeWithGenerics(@NotNull JSFunctionTypeImpl functionType, @NotNull JSCallExpression callExpression, JSTypeSubstitutor defaultParamsSubstitutor) {
        if (functionType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(73);
        }
        if (callExpression == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(74);
        }
        PsiElement sourceElement = functionType.getSource().getSourceElement();
        if (callExpression instanceof JSNewExpression && sourceElement instanceof TypeScriptClass) {
            JSType returnType = functionType.getReturnType();
            TypeScriptTypeParameter[] typeParameters = TypeScriptPsiUtil.getTypeParametersForOwner(sourceElement);
            if (typeParameters.length > 0 && returnType instanceof JSNamedType) {
                List<JSType> defaultGenerics;
                JSTypeDeclaration[] arguments = TypeScriptPsiUtil.getNewExpressionTypeArguments((PsiElement)callExpression);
                if (arguments.length == 0) {
                    Arrays.stream(typeParameters).forEach(el -> {
                        JSType cfr_ignored_0 = (JSType)defaultParamsSubstitutor.put((Object)el.getName(), (Object)TypeScriptGenericTypesEvaluator.getTypeParameterDefaultType(el));
                    });
                    defaultGenerics = TypeScriptGenericTypesEvaluator.buildGenericParameters(typeParameters);
                } else {
                    defaultGenerics = TypeScriptGenericTypesEvaluator.getTypeArgumentsForDeclarations(arguments, (Map<String, JSType>)defaultParamsSubstitutor);
                }
                JSGenericTypeImpl newReturnType = new JSGenericTypeImpl(functionType.getSource(), returnType, defaultGenerics);
                return new JSFunctionTypeImpl(functionType.getSource(), functionType.getParameters(), newReturnType);
            }
        }
        return functionType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 46: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 57: 
            case 62: 
            case 63: 
            case 66: 
            case 68: 
            case 70: 
            case 71: 
            case 73: 
            case 74: 
            case 75: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 46: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 57: 
            case 62: 
            case 63: 
            case 66: 
            case 68: 
            case 70: 
            case 71: 
            case 73: 
            case 74: 
            case 75: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterTypes";
                break;
            }
            case 9: 
            case 16: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 11: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodExpression";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recordType";
                break;
            }
            case 17: 
            case 19: 
            case 23: 
            case 27: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierType";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierClass";
                break;
            }
            case 28: 
            case 31: 
            case 33: 
            case 38: 
            case 39: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeArgumentsList";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appliedGenerics";
                break;
            }
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitedClasses";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarations";
                break;
            }
            case 40: 
            case 66: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 50: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameters";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeArguments";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "genericArguments";
                break;
            }
            case 54: 
            case 71: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 70: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGenericNames";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 46: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 57: 
            case 62: 
            case 63: 
            case 66: 
            case 68: 
            case 70: 
            case 71: 
            case 73: 
            case 74: 
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "reorderByDependencies";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "inferGenericArgumentsFromCall";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluateGenericsFromQualifier";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSubstitutorFromQualifierType";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentsListForQualifierType";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "processClassWithGenericArguments";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeArgumentsForDeclarations";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstitutorForTypeArguments";
                break;
            }
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSubstitutorForMember";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentTypesForSignatureChecking";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "getExplicitTypeOrAny";
                break;
            }
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifierClasses";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsForQualifierClassName";
                break;
            }
            case 67: 
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "buildGenericParameters";
                break;
            }
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "applyTypeScriptGenericArguments";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addGenericDependencyFromType";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "reorderByDependencies";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "evaluateGenericsFromQualifier";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableRecordTypeForThis";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "evaluateThisType";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "evaluateGenericsFromQualifierType";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getTypeSubstitutorFromQualifierType";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getArgumentsListForQualifierType";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isInstanceJSTypeImpl";
                break;
            }
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "processClassWithGenericArguments";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getTypeArgumentsForDeclarations";
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getSubstitutorForTypeArguments";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getTypeSubstitutorForMember";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getParameterExpressionType";
                break;
            }
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "fillExplicitGenericArguments";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getArgumentTypesForSignatureChecking";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "getExplicitTypeOrAny";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "getElementsForQualifierClassName";
                break;
            }
            case 66: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "buildGenericParameters";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "applyTypeScriptGenericArguments";
                break;
            }
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "wrapReturnTypeWithGenerics";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "lambda$evaluateThisType$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 46: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 57: 
            case 62: 
            case 63: 
            case 66: 
            case 68: 
            case 70: 
            case 71: 
            case 73: 
            case 74: 
            case 75: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

