/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.tsconfig;

import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigImpl;
import com.intellij.lang.typescript.tsconfig.TypeScriptExtendedConfigImpl;
import com.intellij.lang.typescript.tsconfig.TypeScriptImportConfigResolveContextImpl;
import com.intellij.lang.typescript.tsconfig.TypeScriptImportResolveContext;
import com.intellij.lang.typescript.tsconfig.checkers.TypeScriptConfigDirectoryInclude;
import com.intellij.lang.typescript.tsconfig.checkers.TypeScriptConfigFilesInclude;
import com.intellij.lang.typescript.tsconfig.checkers.TypeScriptConfigIncludeBase;
import com.intellij.lang.typescript.tsconfig.checkers.TypeScriptConfigPatternInclude;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class TypeScriptConfigBase
implements TypeScriptConfig {
    private final NotNullLazyValue<TypeScriptConfigIncludeBase> myIncludeChecker = new NotNullLazyValue<TypeScriptConfigIncludeBase>(){

        @NotNull
        protected TypeScriptConfigIncludeBase compute() {
            if (TypeScriptConfigBase.this.hasIncludesList()) {
                TypeScriptConfigPatternInclude typeScriptConfigPatternInclude = new TypeScriptConfigPatternInclude(TypeScriptConfigBase.this);
                if (typeScriptConfigPatternInclude == null) {
                    1.$$$reportNull$$$0(0);
                }
                return typeScriptConfigPatternInclude;
            }
            if (TypeScriptConfigBase.this.hasFilesList()) {
                TypeScriptConfigFilesInclude typeScriptConfigFilesInclude = new TypeScriptConfigFilesInclude(TypeScriptConfigBase.this);
                if (typeScriptConfigFilesInclude == null) {
                    1.$$$reportNull$$$0(1);
                }
                return typeScriptConfigFilesInclude;
            }
            TypeScriptConfigDirectoryInclude typeScriptConfigDirectoryInclude = new TypeScriptConfigDirectoryInclude(TypeScriptConfigBase.this);
            if (typeScriptConfigDirectoryInclude == null) {
                1.$$$reportNull$$$0(2);
            }
            return typeScriptConfigDirectoryInclude;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigBase$1", "compute"));
        }
    };
    private final NotNullLazyValue<TypeScriptImportResolveContext> myResolveContext = new NotNullLazyValue<TypeScriptImportResolveContext>(){

        @NotNull
        protected TypeScriptImportResolveContext compute() {
            TypeScriptImportConfigResolveContextImpl typeScriptImportConfigResolveContextImpl = new TypeScriptImportConfigResolveContextImpl(TypeScriptConfigBase.this);
            if (typeScriptImportConfigResolveContextImpl == null) {
                2.$$$reportNull$$$0(0);
            }
            return typeScriptImportConfigResolveContextImpl;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigBase$2", "compute"));
        }
    };

    TypeScriptConfigBase() {
    }

    static TypeScriptConfig getConfig(@NotNull PsiFile rawFile) {
        if (rawFile == null) {
            TypeScriptConfigBase.$$$reportNull$$$0(0);
        }
        return TypeScriptConfigBase.getConfig(rawFile, ContainerUtil.newHashSet());
    }

    @Nullable
    static TypeScriptConfig getConfig(@NotNull PsiFile rawFile, @NotNull Collection<VirtualFile> visited) {
        if (rawFile == null) {
            TypeScriptConfigBase.$$$reportNull$$$0(1);
        }
        if (visited == null) {
            TypeScriptConfigBase.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (!visited.add(rawFile.getVirtualFile())) {
            return null;
        }
        TypeScriptConfigImpl simpleConfig = TypeScriptConfigImpl.getSimpleConfigImpl(rawFile);
        if (simpleConfig == null) {
            return null;
        }
        VirtualFile parent = simpleConfig.getExtendsParent();
        if (parent == null) {
            return simpleConfig;
        }
        PsiManager manager = rawFile.getManager();
        PsiFile parentFile = manager.findFile(parent);
        if (parentFile == null) {
            return simpleConfig;
        }
        TypeScriptConfig parentConfig = TypeScriptConfigBase.getConfig(parentFile, visited);
        if (parentConfig == null) {
            return simpleConfig;
        }
        return new TypeScriptExtendedConfigImpl(simpleConfig, parentConfig);
    }

    @Override
    public final boolean accept(@NotNull VirtualFile file) {
        if (file == null) {
            TypeScriptConfigBase.$$$reportNull$$$0(3);
        }
        return this.getInclude().accept(file);
    }

    @Override
    public TypeScriptConfig.ModuleResolution getEffectiveResolution() {
        TypeScriptConfig.ModuleResolution resolution = this.getResolution();
        if (resolution != TypeScriptConfig.ModuleResolution.UNKNOWN) {
            return resolution;
        }
        TypeScriptConfig.ModuleTarget module = this.getModule();
        return module == TypeScriptConfig.ModuleTarget.COMMON_JS ? TypeScriptConfig.ModuleResolution.NODE : TypeScriptConfig.ModuleResolution.CLASSIC;
    }

    @Override
    @NotNull
    public final TypeScriptConfigIncludeBase getInclude() {
        TypeScriptConfigIncludeBase typeScriptConfigIncludeBase = (TypeScriptConfigIncludeBase)this.myIncludeChecker.getValue();
        if (typeScriptConfigIncludeBase == null) {
            TypeScriptConfigBase.$$$reportNull$$$0(4);
        }
        return typeScriptConfigIncludeBase;
    }

    @Override
    @NotNull
    public final TypeScriptImportResolveContext getResolveContext() {
        TypeScriptImportResolveContext typeScriptImportResolveContext = (TypeScriptImportResolveContext)this.myResolveContext.getValue();
        if (typeScriptImportResolveContext == null) {
            TypeScriptConfigBase.$$$reportNull$$$0(5);
        }
        return typeScriptImportResolveContext;
    }

    @Override
    public boolean isExcludedFile(@NotNull VirtualFile file) {
        if (file == null) {
            TypeScriptConfigBase.$$$reportNull$$$0(6);
        }
        return this.getInclude().isExcludedFile(file);
    }

    @Override
    public boolean isIncludeTypesFile(@NotNull VirtualFile file) {
        if (file == null) {
            TypeScriptConfigBase.$$$reportNull$$$0(7);
        }
        return this.getInclude().isIncludeTypesFile(file);
    }

    @Override
    public boolean isFromRootDirs(@NotNull VirtualFile file) {
        if (file == null) {
            TypeScriptConfigBase.$$$reportNull$$$0(8);
        }
        return this.getInclude().isFromRootDirs(file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/tsconfig/TypeScriptConfigBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/tsconfig/TypeScriptConfigBase";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInclude";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getConfig";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isExcludedFile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isIncludeTypesFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isFromRootDirs";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

