/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.validation;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.types.TypeScriptTypePredicateTypeImpl;
import com.intellij.lang.javascript.validation.JSProblemReporter;
import com.intellij.lang.javascript.validation.JSTypeChecker;
import com.intellij.lang.typescript.inspections.TypeScriptValidateJSTypesInspection;
import com.intellij.lang.typescript.inspections.TypeScriptValidateTypesInspection;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public class TypeScriptTypeChecker
extends JSTypeChecker<Annotation> {
    private final JSProblemReporter<Annotation> myReporter;

    public TypeScriptTypeChecker(JSProblemReporter<Annotation> reporter) {
        this.myReporter = reporter;
    }

    @Override
    public Annotation registerProblem(PsiElement place, String message, @Nullable ProblemHighlightType highlightType, LocalQuickFix ... fixes) {
        PsiElement reference;
        boolean isStrict = true;
        if (place.getParent() instanceof JSArgumentList && (reference = place.getParent().getParent()) instanceof JSCallExpression && (reference = ((JSCallExpression)reference).getMethodExpression()) instanceof JSReferenceExpression && !TypeScriptUtil.resolveIsStrict((JSReferenceExpression)reference)) {
            isStrict = false;
        }
        String inspectionId = isStrict && (highlightType == ProblemHighlightType.GENERIC_ERROR || highlightType == ProblemHighlightType.ERROR) ? this.getValidateTypesInspectionId() : TypeScriptValidateJSTypesInspection.SHORT_NAME;
        return this.myReporter.registerProblem(place, message, null, inspectionId, fixes);
    }

    @Override
    public void checkTypesInReturnStatement(@NotNull JSReturnStatement node) {
        JSExpression expression;
        if (node == null) {
            TypeScriptTypeChecker.$$$reportNull$$$0(0);
        }
        if ((expression = node.getExpression()) == null) {
            return;
        }
        JSFunction fun = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)node, JSFunction.class);
        if (fun == null || fun.isGenerator()) {
            return;
        }
        PsiElement returnTypeElement = fun.getReturnTypeElement();
        if (returnTypeElement == null) {
            return;
        }
        JSType returnType = fun.getReturnType();
        if (ES6PsiUtil.isAsyncContext(fun) && returnType != null) {
            returnType = this.getAsyncFunctionReturnTypeForValidation(fun, returnType);
        }
        if (returnType instanceof TypeScriptTypePredicateTypeImpl) {
            returnType = ((TypeScriptTypePredicateTypeImpl)returnType).asBoolean();
        }
        this.checkExpressionIsAssignableToType(expression, returnType, "javascript.returned.expression.type.mismatch", (PsiElement)fun, true);
    }

    @Override
    public void checkExpressionIsAssignableToVariable(JSVariable p, JSExpression expr, PsiFile containingFile, @PropertyKey(resourceBundle="messages.JavaScriptBundle") String problemKey, boolean allowChangeVariableTypeFix) {
        JSType type = null;
        if (p.getTypeElement() != null || p.getInitializer() != expr) {
            type = p.getType();
        }
        this.checkExpressionIsAssignableToType(expr, type, problemKey, (PsiElement)(allowChangeVariableTypeFix ? p : null), true);
    }

    @Override
    @Nullable
    protected JSType getExpressionType(JSExpression expr) {
        JSType type = super.getExpressionType(expr);
        return type == null ? null : JSTypeUtils.replaceImplicitTypesWithAny(type);
    }

    @Override
    protected String getValidateTypesInspectionId() {
        return TypeScriptValidateTypesInspection.SHORT_NAME;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/typescript/validation/TypeScriptTypeChecker", "checkTypesInReturnStatement"));
    }
}

