/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.xml.xmlbeans;

import com.intellij.history.LocalHistory;
import com.intellij.javaee.UriUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataConstants;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ws.WSBundle;
import com.intellij.ws.WebServicesPluginSettings;
import com.intellij.ws.engines.ExternalEngine;
import com.intellij.ws.utils.BaseWSFromFileAction;
import com.intellij.ws.utils.CommonWsUtils;
import com.intellij.ws.utils.LibUtils;
import com.intellij.ws.xml.xmlbeans.GenerateJavaFromXmlBeansSchemasDialog;
import com.intellij.ws.xml.xmlbeans.XmlBeansMappingEngine;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenerateJavaFromXmlBeansSchemasAction
extends BaseWSFromFileAction {
    @NonNls
    static final String JAR_FILE_EXTENSION = "jar";

    public void actionPerformed(AnActionEvent event) {
        DataContext dataContext = event.getDataContext();
        Project project = (Project)dataContext.getData(DataConstants.PROJECT);
        this.runAction(project, null);
    }

    private void runAction(Project project, @Nullable GenerateJavaFromXmlBeansSchemasDialog previousDialog) {
        GenerateJavaFromXmlBeansSchemasDialog dialog = new GenerateJavaFromXmlBeansSchemasDialog(project, previousDialog);
        if (dialog.showAndGet()) {
            this.doAction(project, dialog);
        }
    }

    private void doAction(Project project, GenerateJavaFromXmlBeansSchemasDialog dialog) {
        ApplicationManager.getApplication().saveAll();
        LocalHistory.getInstance().putSystemLabel(project, WSBundle.message("generate.java.code.from.xmlbeans.schemas.lvcs.action", new Object[0]));
        String url = (String)dialog.getUrl().getComboBox().getSelectedItem();
        boolean addToLibs = dialog.getAddLibs().isSelected();
        String completeFileName = dialog.getOutputFileName();
        ExternalEngine xmlBeansEngine = WebServicesPluginSettings.getInstance().getEngineManager().getExternalEngineByName("XmlBeans 2");
        VirtualFile schemaFile = UriUtil.findRelativeFile((String)url, null);
        Module moduleForFile = ProjectRootManager.getInstance((Project)project).getFileIndex().getModuleForFile(schemaFile);
        if (moduleForFile == null) {
            moduleForFile = ModuleManager.getInstance((Project)project).getModules()[0];
        }
        url = StringUtil.trimStart((String)url, (String)"file:");
        Module moduleForFile1 = moduleForFile;
        String url1 = url;
        XmlBeansMappingEngine.doXmlBeanGen(url, completeFileName, LibUtils.getLibUrlsForToolRunning(xmlBeansEngine, moduleForFile), moduleForFile, addToLibs, () -> {
            VirtualFile outputFile;
            LibUtils.setupLibsForGeneratedCode(moduleForFile1, xmlBeansEngine, null);
            CommonWsUtils.doFileSystemRefresh();
            VirtualFile inputFile = UriUtil.findRelativeFile((String)url1, null);
            if (inputFile != null && (outputFile = UriUtil.findRelativeFile((String)completeFileName, (VirtualFile)inputFile.getParent())) != null) {
                new OpenFileDescriptor(project, outputFile).navigate(true);
            }
        }, () -> this.runAction(project, dialog));
    }

    public boolean isAcceptableFile(VirtualFile file) {
        return GenerateJavaFromXmlBeansSchemasAction.isAcceptableFileForJavaFromXmlBeans(file);
    }

    static boolean isAcceptableFileForJavaFromXmlBeans(@NotNull VirtualFile virtualFile) {
        String extension;
        if (virtualFile == null) {
            GenerateJavaFromXmlBeansSchemasAction.$$$reportNull$$$0(0);
        }
        return "xsd".equals(extension = virtualFile.getExtension()) || "wsdl".equals(extension) || JAR_FILE_EXTENSION.equals(extension);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/ws/xml/xmlbeans/GenerateJavaFromXmlBeansSchemasAction", "isAcceptableFileForJavaFromXmlBeans"));
    }
}

