/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.reference;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.translate.callTranslator.CallTranslator;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.reference.AccessTranslator;
import org.jetbrains.kotlin.js.translate.utils.InlineUtils;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;

public class VariableAccessTranslator
extends AbstractTranslator
implements AccessTranslator {
    private final ResolvedCall<? extends VariableDescriptor> resolvedCall;
    private final KtReferenceExpression referenceExpression;
    private final JsExpression receiver;

    public static VariableAccessTranslator newInstance(@NotNull TranslationContext context, @NotNull KtReferenceExpression referenceExpression, @Nullable JsExpression receiver) {
        ResolvedCall<? extends VariableDescriptor> resolvedCall2;
        if (context == null) {
            VariableAccessTranslator.$$$reportNull$$$0(0);
        }
        if (referenceExpression == null) {
            VariableAccessTranslator.$$$reportNull$$$0(1);
        }
        if ((resolvedCall2 = CallUtilKt.getVariableResolvedCallWithAssert(referenceExpression, context.bindingContext())) instanceof VariableAsFunctionResolvedCall) {
            resolvedCall2 = ((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getVariableCall();
        }
        return new VariableAccessTranslator(context, referenceExpression, resolvedCall2, receiver);
    }

    private VariableAccessTranslator(@NotNull TranslationContext context, @NotNull KtReferenceExpression referenceExpression, @NotNull ResolvedCall<? extends VariableDescriptor> resolvedCall2, @Nullable JsExpression receiver) {
        if (context == null) {
            VariableAccessTranslator.$$$reportNull$$$0(2);
        }
        if (referenceExpression == null) {
            VariableAccessTranslator.$$$reportNull$$$0(3);
        }
        if (resolvedCall2 == null) {
            VariableAccessTranslator.$$$reportNull$$$0(4);
        }
        super(context);
        this.referenceExpression = referenceExpression;
        this.receiver = receiver;
        this.resolvedCall = resolvedCall2;
    }

    @Override
    @NotNull
    public JsExpression translateAsGet() {
        PropertyGetterDescriptor getter2;
        JsExpression e = CallTranslator.INSTANCE.translateGet(this.context(), this.resolvedCall, this.receiver);
        CallableDescriptor original = this.resolvedCall.getResultingDescriptor().getOriginal();
        if (original instanceof PropertyDescriptor && InlineUtil.isInline(getter2 = ((PropertyDescriptor)original).getGetter())) {
            if (e instanceof JsNameRef) {
                InlineUtils.setInlineCallMetadata((JsNameRef)e, (KtExpression)this.referenceExpression, (CallableDescriptor)getter2, this.context());
            } else {
                InlineUtils.setInlineCallMetadata(e, (KtExpression)this.referenceExpression, (CallableDescriptor)getter2, this.context());
            }
        }
        JsExpression jsExpression = e;
        if (jsExpression == null) {
            VariableAccessTranslator.$$$reportNull$$$0(5);
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsExpression translateAsSet(@NotNull JsExpression setTo) {
        PropertySetterDescriptor setter2;
        if (setTo == null) {
            VariableAccessTranslator.$$$reportNull$$$0(6);
        }
        JsExpression e = CallTranslator.INSTANCE.translateSet(this.context(), this.resolvedCall, setTo, this.receiver);
        CallableDescriptor original = this.resolvedCall.getResultingDescriptor().getOriginal();
        if (original instanceof PropertyDescriptor && InlineUtil.isInline(setter2 = ((PropertyDescriptor)original).getSetter())) {
            if (e instanceof JsBinaryOperation && ((JsBinaryOperation)e).getOperator().isAssignment()) {
                InlineUtils.setInlineCallMetadata((JsNameRef)((JsBinaryOperation)e).getArg1(), (KtExpression)this.referenceExpression, (CallableDescriptor)setter2, this.context());
            } else {
                InlineUtils.setInlineCallMetadata(e, (KtExpression)this.referenceExpression, (CallableDescriptor)setter2, this.context());
            }
        }
        JsExpression jsExpression = e;
        if (jsExpression == null) {
            VariableAccessTranslator.$$$reportNull$$$0(7);
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public AccessTranslator getCached() {
        JsExpression cachedReceiver = this.receiver != null ? this.context().cacheExpressionIfNeeded(this.receiver) : null;
        CachedVariableAccessTranslator cachedVariableAccessTranslator = new CachedVariableAccessTranslator(this.context(), this.referenceExpression, this.resolvedCall, cachedReceiver);
        if (cachedVariableAccessTranslator == null) {
            VariableAccessTranslator.$$$reportNull$$$0(8);
        }
        return cachedVariableAccessTranslator;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedCall";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/translate/reference/VariableAccessTranslator";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setTo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/translate/reference/VariableAccessTranslator";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "translateAsGet";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "translateAsSet";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCached";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "newInstance";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "translateAsSet";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CachedVariableAccessTranslator
    extends VariableAccessTranslator
    implements AccessTranslator {
        public CachedVariableAccessTranslator(@NotNull TranslationContext context, @NotNull KtReferenceExpression referenceExpression, @NotNull ResolvedCall<? extends VariableDescriptor> resolvedCall2, @Nullable JsExpression cachedReceiver) {
            if (context == null) {
                CachedVariableAccessTranslator.$$$reportNull$$$0(0);
            }
            if (referenceExpression == null) {
                CachedVariableAccessTranslator.$$$reportNull$$$0(1);
            }
            if (resolvedCall2 == null) {
                CachedVariableAccessTranslator.$$$reportNull$$$0(2);
            }
            super(context, referenceExpression, resolvedCall2, cachedReceiver);
        }

        @Override
        @NotNull
        public AccessTranslator getCached() {
            CachedVariableAccessTranslator cachedVariableAccessTranslator = this;
            if (cachedVariableAccessTranslator == null) {
                CachedVariableAccessTranslator.$$$reportNull$$$0(3);
            }
            return cachedVariableAccessTranslator;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "referenceExpression";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resolvedCall";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/js/translate/reference/VariableAccessTranslator$CachedVariableAccessTranslator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/js/translate/reference/VariableAccessTranslator$CachedVariableAccessTranslator";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCached";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

