/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.actions.rename;

import com.intellij.css.util.CssPsiUtil;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.refactoring.actions.BaseRefactoringAction;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssCustomPropertyRenameHandler
extends PsiElementRenameHandler {
    public boolean isAvailableOnDataContext(DataContext dataContext) {
        CssDeclaration elementToRename;
        PsiElement element = CssCustomPropertyRenameHandler.getElement((DataContext)dataContext);
        if (element == null) {
            Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
            PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
            if (editor != null && psiFile != null) {
                element = BaseRefactoringAction.getElementAtCaret((Editor)editor, (PsiFile)psiFile);
            }
        }
        return (elementToRename = CssCustomPropertyRenameHandler.getElementToRename(element)) != null && !CssCustomPropertyRenameHandler.isVetoed((PsiElement)elementToRename);
    }

    @Nullable
    private static CssDeclaration getElementToRename(@Nullable PsiElement context) {
        if (context == null || CssPsiUtil.getStylesheetLanguage((PsiElement)context) == null) {
            return null;
        }
        ASTNode node = context.getNode();
        if (node != null && node.getElementType() == CssElementTypes.CSS_IDENT) {
            for (PsiReference reference : context.getReferences()) {
                ProgressIndicatorProvider.checkCanceled();
                if (reference instanceof PsiPolyVariantReference) {
                    for (ResolveResult result : ((PsiPolyVariantReference)reference).multiResolve(false)) {
                        ProgressIndicatorProvider.checkCanceled();
                        PsiElement element = result.getElement();
                        if (!(element instanceof CssDeclaration)) continue;
                        return (CssDeclaration)element;
                    }
                    continue;
                }
                return (CssDeclaration)ObjectUtils.tryCast((Object)reference.resolve(), CssDeclaration.class);
            }
        }
        return null;
    }

    public boolean isRenaming(DataContext dataContext) {
        return this.isAvailableOnDataContext(dataContext);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            CssCustomPropertyRenameHandler.$$$reportNull$$$0(0);
        }
        PsiElement context = BaseRefactoringAction.getElementAtCaret((Editor)editor, (PsiFile)file);
        CssDeclaration elementToRename = CssCustomPropertyRenameHandler.getElementToRename(context);
        if (context != null && elementToRename != null) {
            FeatureUsageTracker.getInstance().triggerFeatureUsed("refactoring.rename");
            editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                String initialName = (String)PsiElementRenameHandler.DEFAULT_NAME.getData(dataContext);
                CssCustomPropertyRenameHandler.rename((PsiElement)elementToRename, (Project)project, (PsiElement)context, (Editor)editor, (String)initialName);
                return;
            }
            CssCustomPropertyRenameHandler.invoke((PsiElement)elementToRename, (Project)project, (PsiElement)context, (Editor)editor);
        }
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            CssCustomPropertyRenameHandler.$$$reportNull$$$0(1);
        }
        if (elements == null) {
            CssCustomPropertyRenameHandler.$$$reportNull$$$0(2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "elements";
                break;
            }
        }
        objectArray[1] = "com/intellij/psi/css/actions/rename/CssCustomPropertyRenameHandler";
        objectArray[2] = "invoke";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

