/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInspection.LocalQuickFixBase;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssPropertyDescriptor;
import com.intellij.psi.css.impl.util.completion.LengthUserLookup;
import com.intellij.psi.css.impl.util.completion.PercentageUserLookup;
import com.intellij.psi.css.util.CssSuffixes;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;

class InsertUnitQualifier
extends LocalQuickFixBase {
    private Object[] mySuffixVariants = ArrayUtil.EMPTY_OBJECT_ARRAY;

    public InsertUnitQualifier(CssDeclaration declaration) {
        super(CssBundle.message((String)"css.inspections.unitless.number.fix.message", (Object[])new Object[0]));
        CssPropertyDescriptor descriptor = declaration.getDescriptor();
        if (descriptor != null) {
            String[] lengthSuffixes = CssSuffixes.LENGTH_SUFFIXES;
            int variantsCount = (InsertUnitQualifier.allowsLengths(descriptor) ? lengthSuffixes.length : 0) + (InsertUnitQualifier.allowsPercentages(descriptor) ? 1 : 0);
            this.mySuffixVariants = new Object[variantsCount];
            if (InsertUnitQualifier.allowsLengths(descriptor)) {
                System.arraycopy(lengthSuffixes, 0, this.mySuffixVariants, 0, lengthSuffixes.length);
            }
            if (InsertUnitQualifier.allowsPercentages(descriptor)) {
                this.mySuffixVariants[this.mySuffixVariants.length - 1] = "%";
            }
        }
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        Editor editor;
        if (project == null) {
            InsertUnitQualifier.$$$reportNull$$$0(0);
        }
        if (descriptor == null) {
            InsertUnitQualifier.$$$reportNull$$$0(1);
        }
        final TemplateManager instance = TemplateManager.getInstance((Project)project);
        final Template template = instance.createTemplate("", "");
        final TextResult defaultText = new TextResult("px");
        final LookupElement[] lookupItems = (LookupElement[])ContainerUtil.map((Object[])this.mySuffixVariants, o -> o instanceof LookupElement ? (LookupElement)o : LookupElementBuilder.create((String)((String)o)), (Object[])LookupElement.EMPTY_ARRAY);
        Expression expression = new Expression(){

            public com.intellij.codeInsight.template.Result calculateResult(ExpressionContext context) {
                return defaultText;
            }

            public com.intellij.codeInsight.template.Result calculateQuickResult(ExpressionContext context) {
                return null;
            }

            public LookupElement[] calculateLookupItems(ExpressionContext context) {
                return lookupItems;
            }
        };
        template.addVariable("name", expression, expression, true);
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
        PsiElement psiElement = descriptor.getPsiElement();
        PsiFile containingFile = psiElement.getContainingFile();
        if (containingFile != null && (editor = fileEditorManager.openTextEditor(new OpenFileDescriptor(project, containingFile.getVirtualFile(), psiElement.getTextRange().getEndOffset()), false)) != null) {
            new WriteCommandAction(project, new PsiFile[]{descriptor.getPsiElement().getContainingFile()}){

                protected void run(@NotNull Result result) throws Throwable {
                    if (result == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    instance.startTemplate(editor, template);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/psi/css/inspections/InsertUnitQualifier$2", "run"));
                }
            }.execute();
        }
    }

    private static boolean allowsLengths(@NotNull CssPropertyDescriptor descriptor) {
        if (descriptor == null) {
            InsertUnitQualifier.$$$reportNull$$$0(2);
        }
        return ContainerUtil.findInstance((Object[])descriptor.getAllVariants(), LengthUserLookup.class) != null;
    }

    private static boolean allowsPercentages(@NotNull CssPropertyDescriptor descriptor) {
        if (descriptor == null) {
            InsertUnitQualifier.$$$reportNull$$$0(3);
        }
        return ContainerUtil.findInstance((Object[])descriptor.getAllVariants(), PercentageUserLookup.class) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/css/inspections/InsertUnitQualifier";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "applyFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "allowsLengths";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "allowsPercentages";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

