/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.config;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.config.AbstractConfigUtils;
import org.jetbrains.plugins.groovy.util.LibrariesUtil;

public abstract class GroovyConfigUtils
extends AbstractConfigUtils {
    @NonNls
    public static final Pattern GROOVY_ALL_JAR_PATTERN = Pattern.compile("groovy-all(-minimal)?(-(\\d+(\\.\\d+)*))?(-indy|-alpha.*)?\\.jar");
    public static final int VERSION_GROUP_NUMBER = 3;
    @NonNls
    public static final Pattern GROOVY_JAR_PATTERN = Pattern.compile("groovy(-(\\d+(\\.\\d+)*))?(-indy|-alpha.*)?\\.jar");
    public static final String NO_VERSION = "<no version>";
    public static final String GROOVY1_7 = "1.7";
    public static final String GROOVY1_8 = "1.8";
    public static final String GROOVY2_0 = "2.0";
    public static final String GROOVY2_1 = "2.1";
    public static final String GROOVY2_2 = "2.2";
    public static final String GROOVY2_2_2 = "2.2.2";
    public static final String GROOVY2_3 = "2.3";
    private static GroovyConfigUtils myGroovyConfigUtils;

    private GroovyConfigUtils() {
    }

    public static GroovyConfigUtils getInstance() {
        if (myGroovyConfigUtils == null) {
            myGroovyConfigUtils = new GroovyConfigUtils(){
                {
                    this.STARTER_SCRIPT_FILE_NAME = "groovy";
                }
            };
        }
        return myGroovyConfigUtils;
    }

    @NotNull
    public static File[] getGroovyAllJars(@NotNull String path) {
        if (path == null) {
            GroovyConfigUtils.$$$reportNull$$$0(0);
        }
        File[] fileArray = LibrariesUtil.getFilesInDirectoryByPattern(path, GROOVY_ALL_JAR_PATTERN);
        if (fileArray == null) {
            GroovyConfigUtils.$$$reportNull$$$0(1);
        }
        return fileArray;
    }

    public static boolean matchesGroovyAll(@NotNull String name) {
        if (name == null) {
            GroovyConfigUtils.$$$reportNull$$$0(2);
        }
        return GROOVY_ALL_JAR_PATTERN.matcher(name).matches() && !name.contains("src") && !name.contains("doc");
    }

    @Override
    @NotNull
    public String getSDKVersion(@NotNull String path) {
        String groovyJarVersion;
        if (path == null) {
            GroovyConfigUtils.$$$reportNull$$$0(3);
        }
        if ((groovyJarVersion = GroovyConfigUtils.getSDKJarVersion(path + "/lib", GROOVY_JAR_PATTERN, "META-INF/MANIFEST.MF", 3)) == null) {
            groovyJarVersion = GroovyConfigUtils.getSDKJarVersion(path + "/lib", GROOVY_ALL_JAR_PATTERN, "META-INF/MANIFEST.MF", 3);
        }
        if (groovyJarVersion == null) {
            groovyJarVersion = GroovyConfigUtils.getSDKJarVersion(path + "/embeddable", GROOVY_ALL_JAR_PATTERN, "META-INF/MANIFEST.MF", 3);
        }
        if (groovyJarVersion == null) {
            groovyJarVersion = GroovyConfigUtils.getSDKJarVersion(path, GROOVY_ALL_JAR_PATTERN, "META-INF/MANIFEST.MF", 3);
        }
        String string = groovyJarVersion == null ? "undefined" : groovyJarVersion;
        if (string == null) {
            GroovyConfigUtils.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    public boolean isSDKLibrary(Library library) {
        if (library == null) {
            return false;
        }
        return LibrariesUtil.getGroovyLibraryHome(library.getFiles(OrderRootType.CLASSES)) != null;
    }

    @Nullable
    public String getSDKVersion(@NotNull Module module) {
        if (module == null) {
            GroovyConfigUtils.$$$reportNull$$$0(5);
        }
        return (String)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            String path;
            if (module == null) {
                GroovyConfigUtils.$$$reportNull$$$0(9);
            }
            return CachedValueProvider.Result.create((Object)((path = LibrariesUtil.getGroovyHomePath(module)) == null ? null : this.getSDKVersion(path)), (Object[])new Object[]{ProjectRootManager.getInstance((Project)module.getProject())});
        });
    }

    public boolean isVersionAtLeast(PsiElement psiElement, String version) {
        return this.isVersionAtLeast(psiElement, version, true);
    }

    public boolean isVersionAtLeast(PsiElement psiElement, String version, boolean unknownResult) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
        if (module == null) {
            return unknownResult;
        }
        String sdkVersion = this.getSDKVersion(module);
        if (sdkVersion == null) {
            return unknownResult;
        }
        return sdkVersion.compareTo(version) >= 0;
    }

    @NotNull
    public String getSDKVersion(PsiElement psiElement) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
        if (module == null) {
            if (NO_VERSION == null) {
                GroovyConfigUtils.$$$reportNull$$$0(6);
            }
            return NO_VERSION;
        }
        String s = this.getSDKVersion(module);
        String string = s != null ? s : NO_VERSION;
        if (string == null) {
            GroovyConfigUtils.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    public boolean isSDKHome(VirtualFile file) {
        String path;
        return file != null && file.isDirectory() && (LibrariesUtil.getFilesInDirectoryByPattern((path = file.getPath()) + "/lib", GROOVY_JAR_PATTERN).length > 0 || LibrariesUtil.getFilesInDirectoryByPattern(path + "/embeddable", GROOVY_ALL_JAR_PATTERN).length > 0 || LibrariesUtil.getFilesInDirectoryByPattern(path, GROOVY_JAR_PATTERN).length > 0);
    }

    @NotNull
    public String getSDKLibVersion(Library library) {
        String string = this.getSDKVersion(LibrariesUtil.getGroovyLibraryHome(library));
        if (string == null) {
            GroovyConfigUtils.$$$reportNull$$$0(8);
        }
        return string;
    }

    public Collection<String> getSDKVersions(Library[] libraries) {
        return ContainerUtil.map2List((Object[])libraries, library -> this.getSDKLibVersion((Library)library));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/config/GroovyConfigUtils";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/config/GroovyConfigUtils";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroovyAllJars";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSDKVersion";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSDKLibVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getGroovyAllJars";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "matchesGroovyAll";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSDKVersion";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getSDKVersion$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

