/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.highlighter;

import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.annotator.GrHighlightUtil;
import org.jetbrains.plugins.groovy.highlighter.GroovySyntaxHighlighter;
import org.jetbrains.plugins.groovy.highlighter.UtilKt;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationNameValuePair;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLabeledStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTraitTypeDefinition;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=2, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0005\u001a\u00020\u0003H\u0002\u001a\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u00012\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bH\u0002\u00a8\u0006\t"}, d2={"getDeclarationHighlightingAttribute", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "declaration", "Lcom/intellij/psi/PsiElement;", "getElementAttribute", "element", "getReferenceHighlightingAttribute", "reference", "Lorg/jetbrains/plugins/groovy/lang/psi/GrReferenceElement;", "groovy-psi"})
public final class DeclarationsKt {
    private static final TextAttributesKey getElementAttribute(PsiElement element) {
        PsiElement parent = element.getParent();
        if (parent instanceof GrAnnotation && element.getNode().getElementType() == GroovyTokenTypes.mAT) {
            return GroovySyntaxHighlighter.ANNOTATION;
        }
        if (parent instanceof GrAnnotationNameValuePair && ((GrAnnotationNameValuePair)parent).getNameIdentifierGroovy() == element) {
            return GroovySyntaxHighlighter.ANNOTATION_ATTRIBUTE_NAME;
        }
        return null;
    }

    private static final TextAttributesKey getReferenceHighlightingAttribute(GrReferenceElement<?> reference) {
        Object object;
        if (UtilKt.isReferenceWithLiteralName(reference)) {
            return null;
        }
        if (UtilKt.isAnonymousClassReference(reference)) {
            return null;
        }
        GroovyResolveResult resolveResult = reference.advancedResolve();
        PsiElement psiElement = resolveResult.getElement();
        if (psiElement == null) {
            return null;
        }
        PsiElement resolved = psiElement;
        if (resolved instanceof PsiMethod) {
            if (((PsiMethod)resolved).isConstructor()) {
                IElementType referenceNodeType;
                PsiElement psiElement2 = reference.getReferenceNameElement();
                IElementType iElementType = psiElement2 != null && (psiElement2 = psiElement2.getNode()) != null ? psiElement2.getElementType() : (referenceNodeType = null);
                object = Intrinsics.areEqual((Object)referenceNodeType, (Object)GroovyTokenTypes.kTHIS) || Intrinsics.areEqual((Object)referenceNodeType, (Object)GroovyTokenTypes.kSUPER) ? null : GroovySyntaxHighlighter.CONSTRUCTOR_CALL;
            } else {
                boolean isStatic = ((PsiMethod)resolved).hasModifierProperty("static");
                object = resolveResult.isInvokedOnProperty() ? (isStatic ? GroovySyntaxHighlighter.STATIC_PROPERTY_REFERENCE : GroovySyntaxHighlighter.INSTANCE_PROPERTY_REFERENCE) : (isStatic ? GroovySyntaxHighlighter.STATIC_METHOD_ACCESS : GroovySyntaxHighlighter.METHOD_CALL);
            }
        } else {
            PsiElement psiElement3 = resolved;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"resolved");
            object = DeclarationsKt.getDeclarationHighlightingAttribute(psiElement3);
        }
        return object;
    }

    private static final TextAttributesKey getDeclarationHighlightingAttribute(PsiElement declaration) {
        Object object;
        PsiElement psiElement = declaration;
        if (psiElement instanceof GrLabeledStatement) {
            object = GroovySyntaxHighlighter.LABEL;
        } else if (psiElement instanceof PsiTypeParameter) {
            object = GroovySyntaxHighlighter.TYPE_PARAMETER;
        } else if (psiElement instanceof PsiMethod) {
            object = ((PsiMethod)declaration).isConstructor() ? GroovySyntaxHighlighter.CONSTRUCTOR_DECLARATION : (UtilKt.isMethodWithLiteralName((PsiMethod)declaration) ? null : GroovySyntaxHighlighter.METHOD_DECLARATION);
        } else if (psiElement instanceof PsiClass) {
            object = declaration instanceof GrTraitTypeDefinition ? GroovySyntaxHighlighter.TRAIT_NAME : (declaration instanceof GrAnonymousClassDefinition ? GroovySyntaxHighlighter.ANONYMOUS_CLASS_NAME : (((PsiClass)declaration).isAnnotationType() ? GroovySyntaxHighlighter.ANNOTATION : (((PsiClass)declaration).isInterface() ? GroovySyntaxHighlighter.INTERFACE_NAME : (((PsiClass)declaration).isEnum() ? GroovySyntaxHighlighter.ENUM_NAME : GroovySyntaxHighlighter.CLASS_REFERENCE))));
        } else if (psiElement instanceof PsiField) {
            object = ((PsiField)declaration).hasModifierProperty("static") ? GroovySyntaxHighlighter.STATIC_FIELD : GroovySyntaxHighlighter.INSTANCE_FIELD;
        } else if (psiElement instanceof GrParameter) {
            object = GrHighlightUtil.isReassigned((GrVariable)declaration) ? GroovySyntaxHighlighter.REASSIGNED_PARAMETER : GroovySyntaxHighlighter.PARAMETER;
        } else if (psiElement instanceof GrVariable) {
            object = ResolveUtil.isScriptField((GrVariable)declaration) ? (((GrVariable)declaration).hasModifierProperty("static") ? GroovySyntaxHighlighter.STATIC_FIELD : GroovySyntaxHighlighter.INSTANCE_FIELD) : (GrHighlightUtil.isReassigned((GrVariable)declaration) ? GroovySyntaxHighlighter.REASSIGNED_LOCAL_VARIABLE : GroovySyntaxHighlighter.LOCAL_VARIABLE);
        } else {
            return null;
        }
        return object;
    }

    @Nullable
    public static final /* synthetic */ TextAttributesKey access$getReferenceHighlightingAttribute(@NotNull GrReferenceElement reference) {
        return DeclarationsKt.getReferenceHighlightingAttribute(reference);
    }

    @Nullable
    public static final /* synthetic */ TextAttributesKey access$getDeclarationHighlightingAttribute(@NotNull PsiElement declaration) {
        return DeclarationsKt.getDeclarationHighlightingAttribute(declaration);
    }

    @Nullable
    public static final /* synthetic */ TextAttributesKey access$getElementAttribute(@NotNull PsiElement element) {
        return DeclarationsKt.getElementAttribute(element);
    }
}

