/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.folding;

import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.folding.XmlPropertyPlaceholderFoldingBuilder;
import com.intellij.spring.model.values.PlaceholderPropertyReference;
import com.intellij.util.SmartList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J+\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0014\u00a8\u0006\u0012"}, d2={"Lcom/intellij/spring/folding/CodePropertyPlaceholderFoldingBuilder;", "Lcom/intellij/spring/folding/XmlPropertyPlaceholderFoldingBuilder;", "()V", "buildFoldRegions", "", "Lcom/intellij/lang/folding/FoldingDescriptor;", "root", "Lcom/intellij/psi/PsiElement;", "document", "Lcom/intellij/openapi/editor/Document;", "quick", "", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/editor/Document;Z)[Lcom/intellij/lang/folding/FoldingDescriptor;", "getRangeForFolding", "Lcom/intellij/openapi/util/TextRange;", "element", "reference", "Lcom/intellij/spring/model/values/PlaceholderPropertyReference;", "spring-core"})
public final class CodePropertyPlaceholderFoldingBuilder
extends XmlPropertyPlaceholderFoldingBuilder {
    @Override
    @NotNull
    public FoldingDescriptor[] buildFoldRegions(@NotNull PsiElement root, @NotNull Document document, boolean quick) {
        Collection $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        if (quick || !this.isEnabled() || !SpringLibraryUtil.hasSpringLibrary((Project)root.getProject())) {
            Intrinsics.checkExpressionValueIsNotNull((Object)FoldingDescriptor.EMPTY, (String)"FoldingDescriptor.EMPTY");
            return FoldingDescriptor.EMPTY;
        }
        UElement uElement = UastContextKt.toUElement((PsiElement)root);
        if (uElement == null) {
            Intrinsics.checkExpressionValueIsNotNull((Object)FoldingDescriptor.EMPTY, (String)"FoldingDescriptor.EMPTY");
            return FoldingDescriptor.EMPTY;
        }
        UElement uFile = uElement;
        SmartList descriptors = new SmartList();
        uFile.accept((UastVisitor)new AbstractUastVisitor(this, descriptors){
            final /* synthetic */ CodePropertyPlaceholderFoldingBuilder this$0;
            final /* synthetic */ SmartList $descriptors;

            public boolean visitAnnotation(@NotNull UAnnotation annotation) {
                block3: {
                    FoldingDescriptor foldingDescriptor;
                    Intrinsics.checkParameterIsNotNull((Object)annotation, (String)"annotation");
                    if (Intrinsics.areEqual((Object)annotation.getQualifiedName(), (Object)"org.springframework.beans.factory.annotation.Value") ^ true) {
                        return false;
                    }
                    UExpression uExpression = annotation.findDeclaredAttributeValue("value");
                    if (uExpression == null) {
                        return false;
                    }
                    UExpression value = uExpression;
                    PsiElement psiElement = value.getPsi();
                    if (psiElement == null) {
                        return false;
                    }
                    PsiElement psi = psiElement;
                    FoldingDescriptor foldingDescriptor2 = this.this$0.createDescriptor(psi);
                    if (foldingDescriptor2 == null) break block3;
                    FoldingDescriptor it = foldingDescriptor = foldingDescriptor2;
                    this.$descriptors.add((Object)it);
                }
                return false;
            }
            {
                this.this$0 = $outer;
                this.$descriptors = $captured_local_variable$1;
            }
        });
        Collection thisCollection$iv = $receiver$iv = (Collection)descriptors;
        FoldingDescriptor[] foldingDescriptorArray = thisCollection$iv.toArray(new FoldingDescriptor[thisCollection$iv.size()]);
        if (foldingDescriptorArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return foldingDescriptorArray;
    }

    @Override
    @NotNull
    protected TextRange getRangeForFolding(@NotNull PsiElement element, @NotNull PlaceholderPropertyReference reference) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)((Object)reference), (String)"reference");
        TextRange refRange = reference.getFullTextRange();
        String wrappedRefText = "${" + refRange.substring(element.getText()) + '}';
        Integer n = StringsKt.indexOf$default((CharSequence)element.getText(), (String)wrappedRefText, (int)0, (boolean)false, (int)6, null);
        int it = ((Number)n).intValue();
        Integer n2 = it != -1 ? n : null;
        if (n2 == null || (n2 = TextRange.from((int)(it = ((Number)(n = n2)).intValue()), (int)wrappedRefText.length())) == null) {
            n2 = refRange;
        }
        Integer wrappedRefRange = n2;
        TextRange textRange = wrappedRefRange.shiftRight(element.getTextRange().getStartOffset());
        Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"wrappedRefRange.shiftRig\u2026nt.textRange.startOffset)");
        return textRange;
    }
}

