/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.sherpa.interaction;

import android.support.constraint.solver.widgets.Animator;
import android.support.constraint.solver.widgets.ConstraintAnchor;
import android.support.constraint.solver.widgets.ConstraintWidget;
import android.support.constraint.solver.widgets.ConstraintWidgetContainer;
import android.support.constraint.solver.widgets.Guideline;
import android.support.constraint.solver.widgets.Snapshot;
import com.android.tools.sherpa.animation.AnimatedDestroyCircle;
import com.android.tools.sherpa.animation.AnimatedDestroyLine;
import com.android.tools.sherpa.drawing.SceneDraw;
import com.android.tools.sherpa.drawing.ViewTransform;
import com.android.tools.sherpa.drawing.decorator.ColorTheme;
import com.android.tools.sherpa.drawing.decorator.WidgetDecorator;
import com.android.tools.sherpa.interaction.ConstraintHandle;
import com.android.tools.sherpa.interaction.DrawPicker;
import com.android.tools.sherpa.interaction.ResizeHandle;
import com.android.tools.sherpa.interaction.SnapCandidate;
import com.android.tools.sherpa.interaction.WidgetInteractionTargets;
import com.android.tools.sherpa.interaction.WidgetMotion;
import com.android.tools.sherpa.interaction.WidgetResize;
import com.android.tools.sherpa.structure.Selection;
import com.android.tools.sherpa.structure.WidgetCompanion;
import com.android.tools.sherpa.structure.WidgetsScene;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class MouseInteraction {
    private static int sMargin = 8;
    private boolean mIsControlDown;
    private boolean mIsShiftDown;
    private boolean mIsAltDown;
    private boolean mMouseDown = false;
    private boolean mMoveOnlyMode = false;
    private final ViewTransform mViewTransform;
    private final WidgetsScene mWidgetsScene;
    private final SceneDraw mSceneDraw;
    private final Selection mSelection;
    private final WidgetMotion mWidgetMotion;
    private final WidgetResize mWidgetResize;
    private ConstraintWidget mInteractionComponent;
    private Point mStartPoint = new Point();
    private Point mLastMousePosition = new Point();
    private Snapshot mSnapshot = null;
    private boolean mUseDefinedMargin = true;
    private boolean mAutoConnect = true;
    private int mMouseCursor = 0;
    private ConstraintWidget mPreviousHoverWidget = null;
    private long mPressTime = 0L;
    private final int SELECTION_TARGET_SLOPE = 4;
    private static final int LONG_PRESS_THRESHOLD = 500;
    private static final int BASELINE_TIME_THRESHOLD = 800;
    private NeedsLayoutCallback mNeedsLayoutCallback;
    private MouseMode mMouseMode = MouseMode.SELECT;
    private HitListener mHoverListener = new HitListener(1);
    private HitListener mClickListener = new HitListener(0);
    private HitListener mDragListener = new HitListener(2);
    private Timer mBaselineTimer = new Timer(800, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ((MouseInteraction)MouseInteraction.this).mClickListener.mEnableBaseline = true;
            ((MouseInteraction)MouseInteraction.this).mHoverListener.mEnableBaseline = true;
            MouseInteraction.this.updateFromHoverListener(MouseInteraction.this.mHoverListener.mLastX, MouseInteraction.this.mHoverListener.mLastY);
            MouseInteraction.this.mBaselineTimer.stop();
        }
    });

    public static void setMargin(int margin) {
        sMargin = margin;
    }

    public MouseInteraction(ViewTransform transform, WidgetsScene widgetsScene, Selection selection, WidgetMotion widgetMotion, WidgetResize widgetResize, SceneDraw sceneDraw, MouseInteraction previous) {
        this.mViewTransform = transform;
        this.mWidgetsScene = widgetsScene;
        this.mSelection = selection;
        this.mWidgetMotion = widgetMotion;
        this.mWidgetResize = widgetResize;
        this.mSceneDraw = sceneDraw;
        if (previous != null) {
            this.mMoveOnlyMode = previous.mMoveOnlyMode;
            this.mAutoConnect = previous.mAutoConnect;
            this.mUseDefinedMargin = previous.mUseDefinedMargin;
        }
    }

    public void setNeedsLayoutCallback(NeedsLayoutCallback callback) {
        this.mNeedsLayoutCallback = callback;
    }

    public void setInteractionComponent(ConstraintWidget interactionComponent) {
        this.mInteractionComponent = interactionComponent;
    }

    public ArrayList<SnapCandidate> getSnapCandidates() {
        return this.mWidgetMotion.getSnapCandidates();
    }

    public Point getStartPoint() {
        return this.mStartPoint;
    }

    public Point getLastPoint() {
        return this.mLastMousePosition;
    }

    public boolean isControlDown() {
        return this.mIsControlDown;
    }

    public void setIsControlDown(boolean value) {
        this.mIsControlDown = value;
    }

    public boolean isShiftDown() {
        return this.mIsShiftDown;
    }

    public void setIsShiftDown(boolean value) {
        this.mIsShiftDown = value;
    }

    public boolean isAltDown() {
        return this.mIsAltDown;
    }

    public void setIsAltDown(boolean value) {
        this.mIsAltDown = value;
    }

    public boolean isMouseDown() {
        return this.mMouseDown;
    }

    public void setSnapshot(Snapshot snapshot) {
        this.mSnapshot = snapshot;
    }

    public Snapshot getSnapshot() {
        return this.mSnapshot;
    }

    public void setStartPoint(int x, int y) {
        this.mStartPoint.setLocation(x, y);
    }

    public boolean isUseDefinedMargin() {
        return this.mUseDefinedMargin;
    }

    public void setUseDefinedMargin(boolean useDefinedMargin) {
        this.mUseDefinedMargin = useDefinedMargin;
    }

    public boolean isAutoConnect() {
        return this.mAutoConnect;
    }

    public void setAutoConnect(boolean autoConnect) {
        this.mAutoConnect = autoConnect;
    }

    public int getMouseCursor() {
        return this.mMouseCursor;
    }

    public void clearIndicators() {
        this.mWidgetMotion.getSnapCandidates().clear();
        this.mWidgetMotion.getSimilarMargins().clear();
    }

    private WidgetDecorator getDecorator(ConstraintWidget widget) {
        WidgetCompanion companion = (WidgetCompanion)widget.getCompanionWidget();
        WidgetDecorator decorator = companion.getWidgetDecorator(this.mSceneDraw.getCurrentStyle());
        return decorator;
    }

    public void mousePressed(float x, float y, boolean isRightClick) {
        if (isRightClick) {
            this.mMouseMode = MouseMode.INACTIVE;
            return;
        }
        for (ConstraintWidget w : this.mWidgetsScene.getWidgets()) {
            this.getDecorator(w).setShowActions(false);
        }
        this.mPressTime = System.currentTimeMillis();
        Animator.setAnimationEnabled(true);
        this.mMouseDown = true;
        this.mStartPoint.setLocation(x, y);
        this.mLastMousePosition.setLocation(x, y);
        this.mSelection.setConnectionCandidateAnchor(null);
        this.mSelection.setSelectedAnchor(null);
        this.mSelection.setSelectedGuideline(null);
        this.mSelection.setLastConnectedAnchor(null);
        this.mMouseMode = MouseMode.SELECT;
        this.mWidgetsScene.updatePositions(this.mViewTransform);
        this.mClickListener.populate();
        this.mClickListener.find(this.mViewTransform.getSwingFX(x), this.mViewTransform.getSwingFY(y));
        ConstraintWidget widget = this.mClickListener.mHitWidget;
        ConstraintAnchor anchor = this.mClickListener.getConstraintAnchor();
        ResizeHandle resizeHandle = this.mClickListener.mHitResizeHandle;
        for (ConstraintWidget w : this.mWidgetsScene.getWidgets()) {
            ConstraintWidget widgetHit = this.getDecorator(w).mousePressed(x, y, this.mViewTransform, this.mSelection);
            if (widgetHit == null || widget != null) continue;
            widget = widgetHit;
        }
        WidgetDecorator.WidgetAction widgetAction = this.mClickListener.getWidgetAction();
        if (widgetAction != null && widgetAction.isVisible()) {
            widget = widgetAction.getWidget();
            if (widgetAction.click()) {
                this.mSelection.addModifiedWidget(widgetAction.getWidget());
            }
        }
        if (widget != null && (widget.isRoot() || widget.isRootContainer())) {
            ConstraintWidget selection;
            widget = !this.mSelection.isEmpty() && this.mInteractionComponent != null && widget != this.mInteractionComponent ? (widget.hasAncestor(selection = this.mSelection.getFirstElement().widget) ? selection : null) : null;
        }
        if (!this.isAltDown() ^ this.mMoveOnlyMode) {
            if (anchor != null) {
                widget = anchor.getOwner();
                if (this.mSelection.contains(widget)) {
                    ConstraintHandle handle = WidgetInteractionTargets.constraintHandle(anchor);
                    this.setStartPoint(handle.getDrawX(), handle.getDrawY());
                    this.mSelection.clear();
                    this.mSelection.add(widget);
                    this.mSelection.setSelectedAnchor(anchor);
                    this.mMouseMode = MouseMode.CONNECT;
                }
            } else if (resizeHandle != null && this.mSelection.contains(widget = resizeHandle.getOwner())) {
                this.mSelection.clear();
                this.mSelection.add(widget);
                this.mSelection.setSelectedResizeHandle(resizeHandle);
                this.mMouseMode = MouseMode.RESIZE;
            }
        }
        for (ConstraintWidget w : this.mWidgetsScene.getWidgets()) {
            Guideline guideline;
            android.support.constraint.solver.widgets.Rectangle head;
            if (!(w instanceof Guideline) || !(head = (guideline = (Guideline)w).getHead()).contains((int)x, (int)y)) continue;
            this.mSelection.setSelectedGuideline(guideline);
            break;
        }
        if (this.mSelection.getSelectedGuideline() != null) {
            this.mSelection.clear();
            this.mSelection.setSelectedResizeHandle(resizeHandle);
            this.mSelection.add(this.mSelection.getSelectedGuideline());
            widget = this.mSelection.getSelectedGuideline();
            if (this.mMouseMode == MouseMode.SELECT) {
                this.mMouseMode = MouseMode.MOVE;
            }
        }
        if (widget == null) {
            this.mSelection.clear();
        }
        if (this.mSelection.getSelectedAnchor() != null) {
            this.mSelection.setSelectedAnchorInitialTarget(this.mSelection.getSelectedAnchor().getTarget());
        }
        this.mSelection.updatePosition();
        this.mSelection.createBounds();
        if (this.mSelection.hasSingleElement()) {
            this.setSnapshot(new Snapshot(this.mSelection.getFirstElement().widget));
        } else {
            this.setSnapshot(null);
        }
        this.mSceneDraw.setCurrentUnderneathAnchor(this.mSelection.getSelectedAnchor());
        this.mSceneDraw.onMousePress(this.mSelection.getSelectedAnchor());
        this.mBaselineTimer.stop();
    }

    public void mouseReleased(int x, int y) {
        Selection.Element element;
        android.support.constraint.solver.widgets.Rectangle head;
        ConstraintWidget widget;
        for (ConstraintWidget constraintWidget : this.mWidgetsScene.getWidgets()) {
            this.getDecorator(constraintWidget).setShowActions(true);
        }
        boolean longPress = false;
        if (System.currentTimeMillis() - this.mPressTime > 500L) {
            longPress = true;
        }
        if (this.mMouseMode == MouseMode.INACTIVE) {
            return;
        }
        if (this.mAutoConnect) {
            for (SnapCandidate candidate : this.mWidgetMotion.getSnapCandidates()) {
                if (!candidate.source.isConnectionAllowed(candidate.target.getOwner())) continue;
                int margin = candidate.margin;
                if (candidate.padding != 0) {
                    margin = candidate.padding;
                }
                margin = Math.abs(margin);
                ConstraintWidget widget3 = candidate.source.getOwner();
                widget3.connect(candidate.source, candidate.target, margin, 2);
                this.mSelection.addModifiedWidget(candidate.source.getOwner());
            }
            for (ConstraintWidget widget4 : this.mSelection.getModifiedWidgets()) {
                for (ConstraintAnchor anchor : widget4.getAnchors()) {
                    if (!anchor.isConnected() || anchor.getConnectionCreator() != 2) continue;
                    WidgetDecorator.getConstraintHandle(anchor).startLock();
                }
            }
        }
        this.mWidgetMotion.mouseReleased();
        this.mWidgetResize.mouseReleased();
        this.mSceneDraw.mouseReleased();
        this.mClickListener.clearSelection();
        this.mClickListener.find(this.mViewTransform.getSwingFX(x), this.mViewTransform.getSwingFY(y));
        ConstraintAnchor constraintAnchor = this.mClickListener.getConstraintAnchor();
        if (this.mSelection.getSelectedAnchor() != null && this.mSelection.getConnectionCandidateAnchor() == null && constraintAnchor == this.mSelection.getSelectedAnchor() && !longPress && this.mSelection.getSelectedAnchor().isConnected() && this.mSelection.getSelectedAnchor().getTarget() == this.mSelection.getSelectedAnchorInitialTarget()) {
            widget = this.mSelection.getSelectedAnchor().getOwner();
            ConstraintAnchor selectedAnchor = this.mSelection.getSelectedAnchor();
            if (selectedAnchor.isVerticalAnchor()) {
                widget.setVerticalBiasPercent(0.5f);
            } else {
                widget.setHorizontalBiasPercent(0.5f);
            }
            widget.resetAnchor(selectedAnchor);
            ConstraintHandle selectedHandle = WidgetInteractionTargets.constraintHandle(selectedAnchor);
            if (this.mSelection.getSelectedAnchor().getType() == ConstraintAnchor.Type.BASELINE) {
                this.mSceneDraw.getChoreographer().addAnimation(new AnimatedDestroyLine(selectedHandle));
            } else {
                this.mSceneDraw.getChoreographer().addAnimation(new AnimatedDestroyCircle(selectedHandle));
            }
            this.mSelection.addModifiedWidget(widget);
        }
        if ((widget = this.mClickListener.mHitWidget) != null && this.mMouseMode == MouseMode.SELECT) {
            if (!this.mSelection.contains(widget)) {
                if (!this.isShiftDown() && !this.isControlDown()) {
                    this.mSelection.clear();
                }
                this.mSelection.add(widget);
            } else if (this.isControlDown()) {
                this.mSelection.remove(widget);
            }
        }
        if (this.mSelection.isEmpty() && this.mSelection.getSelectedAnchor() == null) {
            int x1 = Math.min(this.getStartPoint().x, this.getLastPoint().x);
            int x2 = Math.max(this.getStartPoint().x, this.getLastPoint().x);
            int y1 = Math.min(this.getStartPoint().y, this.getLastPoint().y);
            int y2 = Math.max(this.getStartPoint().y, this.getLastPoint().y);
            android.support.constraint.solver.widgets.Rectangle selectionRect = new android.support.constraint.solver.widgets.Rectangle();
            selectionRect.setBounds(x1, y1, x2 - x1, y2 - y1);
            if (selectionRect.width > 0 && selectionRect.height > 0) {
                ArrayList<ConstraintWidget> selection = this.mWidgetsScene.findWidgets(this.mWidgetsScene.getRoot(), selectionRect.x, selectionRect.y, selectionRect.width, selectionRect.height);
                for (ConstraintWidget w : selection) {
                    this.mSelection.add(w);
                }
            }
        }
        if (this.mSelection.getSelectedGuideline() != null && (head = this.mSelection.getSelectedGuideline().getHead()).contains(this.getStartPoint().x, this.getStartPoint().y) && (element = this.mSelection.get(this.mSelection.getSelectedGuideline())) != null) {
            if (this.mSelection.getSelectedGuideline().getOrientation() == 1) {
                if (element.origin.x == this.mSelection.getSelectedGuideline().getDrawX()) {
                    this.mSelection.getSelectedGuideline().cyclePosition();
                    this.mSelection.addModifiedWidget(this.mSelection.getSelectedGuideline());
                }
            } else if (element.origin.y == this.mSelection.getSelectedGuideline().getDrawY()) {
                this.mSelection.getSelectedGuideline().cyclePosition();
                this.mSelection.addModifiedWidget(this.mSelection.getSelectedGuideline());
            }
        }
        for (Selection.Element selection : this.mSelection.getElements()) {
            this.getDecorator(selection.widget).mouseRelease(x, y, this.mViewTransform, this.mSelection);
        }
        for (Selection.Element selection : this.mSelection.getElements()) {
            selection.directionLocked = 0;
        }
        this.mSceneDraw.setCurrentUnderneathAnchor(null);
        this.mMouseMode = MouseMode.INACTIVE;
        this.mSelection.setSelectedAnchor(null);
        this.mSelection.setSelectedResizeHandle(null);
        this.mSelection.setConnectionCandidateAnchor(null);
        this.mSelection.clearBounds();
        this.mSelection.selectionHasChanged();
        this.mLastMousePosition.setLocation(0, 0);
        this.mSnapshot = null;
        this.mMouseDown = false;
        Animator.setAnimationEnabled(true);
    }

    public int mouseDragged(int x, int y) {
        if (this.mMouseMode == MouseMode.SELECT) {
            ConstraintWidget widget = this.mClickListener.mHitWidget;
            if (widget != null && widget.getParent() instanceof ConstraintWidgetContainer) {
                if (!this.mSelection.contains(widget)) {
                    if (!this.isShiftDown() && !this.isControlDown()) {
                        this.mSelection.clear();
                    }
                    this.mSelection.add(widget);
                } else if (this.isControlDown()) {
                    this.mSelection.remove(widget);
                }
            }
            if (!this.mSelection.isEmpty()) {
                this.mMouseMode = MouseMode.MOVE;
            }
        }
        int directionLockedStatus = 0;
        this.mLastMousePosition.setLocation(x, y);
        switch (this.mMouseMode) {
            case MOVE: {
                if (this.mSelection.isEmpty()) break;
                for (Selection.Element selection : this.mSelection.getElements()) {
                    boolean didResetAutoConnections = false;
                    for (ConstraintAnchor anchor : selection.widget.getAnchors()) {
                        if (!anchor.isConnected() || anchor.getConnectionCreator() != 2) continue;
                        anchor.getOwner().resetAnchor(anchor);
                        WidgetDecorator.getConstraintHandle(anchor).stopLock();
                        didResetAutoConnections = true;
                    }
                    if (didResetAutoConnections) {
                        this.mSelection.addModifiedWidget(selection.widget);
                    }
                    for (ConstraintWidget widget : this.mWidgetsScene.getWidgets()) {
                        widget.disconnectUnlockedWidget(selection.widget);
                        this.mSelection.addModifiedWidget(widget);
                    }
                }
                boolean snapPosition = this.mSelection.hasSingleElement();
                if (!this.mSelection.hasSingleElement() && this.mSelection.getSelectionBounds() != null) {
                    Iterator<Selection.Element> bounds = this.mSelection.getSelectionBounds();
                    ((Selection.Element)((Object)bounds)).widget.setParent(this.mWidgetsScene.getRoot());
                    directionLockedStatus = this.mWidgetMotion.dragWidget(this.getStartPoint(), (Selection.Element)((Object)bounds), x, y, true, this.isShiftDown(), this.mViewTransform);
                    this.mSelection.updatePositionsFromBounds();
                } else {
                    for (Selection.Element selection : this.mSelection.getElements()) {
                        directionLockedStatus = this.mWidgetMotion.dragWidget(this.getStartPoint(), selection, x, y, snapPosition, this.isShiftDown(), this.mViewTransform);
                    }
                }
                for (Selection.Element selection : this.mSelection.getElements()) {
                    this.mSelection.addModifiedWidget(selection.widget);
                }
                this.mSelection.fireContinuousChange();
                if (this.mNeedsLayoutCallback == null) break;
                this.mNeedsLayoutCallback.needsLayout(false);
                break;
            }
            case RESIZE: {
                if (this.mSelection.getSelectedResizeHandle() == null) break;
                Selection.Element selection = this.mSelection.getFirstElement();
                if (this.mSelection.getSelectedResizeHandle() != null && !selection.widget.isRoot() && !selection.widget.isRootContainer()) {
                    ArrayList<ConstraintWidget> widgetsToCheck = new ArrayList<ConstraintWidget>();
                    for (ConstraintWidget w : this.mWidgetsScene.getWidgets()) {
                        widgetsToCheck.add(w);
                    }
                    this.mWidgetResize.resizeWidget(widgetsToCheck, selection.widget, this.mSelection.getSelectedResizeHandle(), this.mSelection.getOriginalWidgetBounds(), x, y);
                    this.mSelection.addModifiedWidget(selection.widget);
                }
                if (this.mNeedsLayoutCallback == null) break;
                this.mNeedsLayoutCallback.needsLayout(false);
                break;
            }
            case CONNECT: {
                if (this.mSelection.getSelectedAnchor() == null || !this.mSelection.hasSingleElement()) break;
                ConstraintWidget selectedWidget = this.mSelection.getFirstElement().widget;
                this.mDragListener.populate();
                this.mDragListener.find(this.mViewTransform.getSwingFX(this.getLastPoint().x), this.mViewTransform.getSwingFY(this.getLastPoint().y));
                ConstraintAnchor anchor = this.mDragListener.getConstraintAnchor();
                if (anchor != null && anchor != this.mSelection.getSelectedAnchor() && this.mSelection.getSelectedAnchor().isValidConnection(anchor) && this.mSelection.getSelectedAnchor().isConnectionAllowed(anchor.getOwner(), anchor)) {
                    boolean useExistingDistance;
                    if (this.mSelection.getConnectionCandidateAnchor() != anchor) {
                        if (this.mSelection.getConnectionCandidateAnchor() != null && this.getSnapshot() != null) {
                            this.getSnapshot().applyTo(selectedWidget);
                            this.mSelection.addModifiedWidget(selectedWidget);
                            if (this.mNeedsLayoutCallback != null) {
                                this.mNeedsLayoutCallback.needsLayout(true);
                            }
                        }
                        this.mSelection.setConnectionCandidateAnchor(anchor);
                    }
                    if (this.mSelection.getSelectedAnchor().getTarget() == this.mSelection.getConnectionCandidateAnchor()) break;
                    int margin = 0;
                    boolean bl = useExistingDistance = !this.mUseDefinedMargin;
                    if (this.isControlDown()) {
                        useExistingDistance = !useExistingDistance;
                    }
                    ConstraintHandle handle = WidgetInteractionTargets.constraintHandle(this.mSelection.getSelectedAnchor());
                    ConstraintHandle handleTarget = WidgetInteractionTargets.constraintHandle(this.mSelection.getConnectionCandidateAnchor());
                    int existingDistance = handle.getCreationMarginFrom(handleTarget);
                    if (useExistingDistance) {
                        margin = existingDistance;
                    } else if (existingDistance >= sMargin) {
                        margin = sMargin;
                    }
                    if (handleTarget.getAnchor().getType() == handle.getAnchor().getType()) {
                        margin = handleTarget.getOwner().isRootContainer() ? Math.max(16, margin) : 0;
                    }
                    ConstraintAnchor.Strength strength = ConstraintAnchor.Strength.STRONG;
                    if (this.isShiftDown()) {
                        strength = ConstraintAnchor.Strength.WEAK;
                    }
                    ConstraintWidget widget = this.mSelection.getSelectedAnchor().getOwner();
                    widget.connect(this.mSelection.getSelectedAnchor(), this.mSelection.getConnectionCandidateAnchor(), margin, strength, 0);
                    this.mSelection.addModifiedWidget(widget);
                    this.mSelection.setLastConnectedAnchor(this.mSelection.getSelectedAnchor());
                    if (this.mNeedsLayoutCallback == null) break;
                    this.mNeedsLayoutCallback.needsLayout(true);
                    break;
                }
                if (this.mSelection.getConnectionCandidateAnchor() == null) break;
                this.mSelection.setConnectionCandidateAnchor(null);
                if (this.getSnapshot() == null) break;
                this.getSnapshot().applyTo(selectedWidget);
                this.mSelection.addModifiedWidget(selectedWidget);
                if (this.mNeedsLayoutCallback == null) break;
                this.mNeedsLayoutCallback.needsLayout(true);
            }
        }
        return directionLockedStatus;
    }

    public void dragAndDrop(ConstraintWidget widget, int x, int y) {
        this.mMouseMode = MouseMode.MOVE;
        this.mWidgetMotion.dragWidget(new Point(x, y), new Selection.Element(widget), x, y, true, this.isShiftDown(), this.mViewTransform);
    }

    public void mouseMoved(float x, float y) {
        if (this.mMoveOnlyMode) {
            return;
        }
        this.mClickListener.mEnableBaseline = false;
        this.mHoverListener.mEnableBaseline = false;
        this.mBaselineTimer.restart();
        this.updateFromHoverListener(this.mViewTransform.getSwingFX(x), this.mViewTransform.getSwingFY(y));
    }

    private void updateFromHoverListener(int x, int y) {
        this.mHoverListener.populate();
        this.mHoverListener.find(x, y);
        ConstraintWidget widget = this.mHoverListener.mHitWidget;
        ConstraintAnchor anchor = this.mHoverListener.getConstraintAnchor();
        ResizeHandle handle = this.mHoverListener.mHitResizeHandle;
        this.mMouseCursor = this.updateMouseCursor(handle);
        if (this.mPreviousHoverWidget != null && !this.mSelection.contains(this.mPreviousHoverWidget)) {
            this.getDecorator(this.mPreviousHoverWidget).setLook(ColorTheme.Look.NORMAL);
        }
        if (widget != null) {
            if (!this.mSelection.contains(widget)) {
                this.getDecorator(widget).setLook(ColorTheme.Look.HIGHLIGHTED);
            }
            this.mPreviousHoverWidget = widget;
        }
        this.mSceneDraw.setCurrentUnderneathAnchor(anchor);
        this.mSceneDraw.repaint();
    }

    private int updateMouseCursor(ResizeHandle handle) {
        if (handle == null) {
            return 0;
        }
        switch (handle.getType()) {
            case LEFT_BOTTOM: {
                return 4;
            }
            case LEFT_TOP: {
                return 6;
            }
            case RIGHT_BOTTOM: {
                return 5;
            }
            case RIGHT_TOP: {
                return 7;
            }
            case LEFT_SIDE: {
                return 10;
            }
            case RIGHT_SIDE: {
                return 11;
            }
            case TOP_SIDE: {
                return 8;
            }
            case BOTTOM_SIDE: {
                return 9;
            }
        }
        return 0;
    }

    public void mousePressed(MouseEvent e) {
        this.mIsControlDown = e.isControlDown();
        this.mIsShiftDown = e.isShiftDown();
        this.mIsAltDown = e.isAltDown();
        float x = this.mViewTransform.getAndroidFX(e.getX());
        float y = this.mViewTransform.getAndroidFY(e.getY());
        this.mousePressed(x, y, SwingUtilities.isRightMouseButton(e));
    }

    public void mouseReleased(MouseEvent e) {
        int x = this.mViewTransform.getAndroidX(e.getX());
        int y = this.mViewTransform.getAndroidY(e.getY());
        this.mouseReleased(x, y);
    }

    public int mouseDragged(MouseEvent e) {
        this.mIsControlDown = e.isControlDown();
        this.mIsShiftDown = e.isShiftDown();
        this.mIsAltDown = e.isAltDown();
        int x = this.mViewTransform.getAndroidX(e.getX());
        int y = this.mViewTransform.getAndroidY(e.getY());
        return this.mouseDragged(x, y);
    }

    public void mouseEntered(MouseEvent e) {
        this.mIsControlDown = e.isControlDown();
        this.mIsShiftDown = e.isShiftDown();
        this.mIsAltDown = e.isAltDown();
    }

    public void mouseMoved(MouseEvent e) {
        this.mIsControlDown = e.isControlDown();
        this.mIsShiftDown = e.isShiftDown();
        this.mIsAltDown = e.isAltDown();
        float x = this.mViewTransform.getAndroidFX(e.getX());
        float y = this.mViewTransform.getAndroidFY(e.getY());
        this.mouseMoved(x, y);
    }

    public void keyPressed(KeyEvent e) {
        this.mIsControlDown = e.isControlDown();
        this.mIsShiftDown = e.isShiftDown();
        this.mIsAltDown = e.isAltDown();
    }

    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 17) {
            this.mIsControlDown = false;
        }
        if (e.getKeyCode() == 16) {
            this.mIsShiftDown = false;
        }
    }

    public boolean isMoveOnlyMode() {
        return this.mMoveOnlyMode;
    }

    public void setMoveOnlyMode(boolean moveOnlyMode) {
        this.mMoveOnlyMode = moveOnlyMode;
    }

    class HitListener
    implements DrawPicker.HitElementListener {
        private DrawPicker mPicker = new DrawPicker();
        private ConstraintWidget mHitWidget = null;
        private double mHitWidgetDistance = 0.0;
        private ConstraintHandle mHitConstraintHandle = null;
        private double mHitConstraintHandleDistance = 0.0;
        private ResizeHandle mHitResizeHandle = null;
        private double mHitResizeHandleDistance = 0.0;
        private WidgetDecorator.WidgetAction mHitWidgetAction = null;
        private double mHitWidgetActionDistance = 0.0;
        public boolean mEnableBaseline = false;
        static final int CLICK_MODE = 0;
        static final int HOVER_MODE = 1;
        static final int DRAG_MODE = 2;
        private final int mMode;
        private int mLastX;
        private int mLastY;

        public HitListener(int mode) {
            this.mMode = mode;
            this.mPicker.setSelectListener(this);
        }

        public void reset() {
            this.mPicker.reset();
            this.clearSelection();
        }

        public void clearSelection() {
            if (this.mHitWidget != null) {
                MouseInteraction.this.getDecorator(this.mHitWidget).over(false);
            }
            this.mHitWidget = null;
            this.mHitWidgetDistance = Double.MAX_VALUE;
            this.mHitConstraintHandle = null;
            this.mHitConstraintHandleDistance = Double.MAX_VALUE;
            this.mHitResizeHandle = null;
            this.mHitResizeHandleDistance = Double.MAX_VALUE;
            if (this.mHitWidgetAction != null) {
                this.mHitWidgetAction.over(false);
            }
            this.mHitWidgetAction = null;
            this.mHitWidgetActionDistance = Double.MAX_VALUE;
        }

        public void populate() {
            this.reset();
            Collection<ConstraintWidget> widgets = MouseInteraction.this.mWidgetsScene.getWidgets();
            for (ConstraintWidget widget : widgets) {
                if ((widget.isRoot() || widget.isRootContainer()) && this.mMode != 2 && this.mMode != 0 || widget == MouseInteraction.this.mInteractionComponent && this.mMode == 0) continue;
                this.addWidgetToPicker(widget, this.mPicker);
            }
        }

        public ConstraintAnchor getConstraintAnchor() {
            if (this.mHitConstraintHandle == null) {
                return null;
            }
            return this.mHitConstraintHandle.getAnchor();
        }

        public WidgetDecorator.WidgetAction getWidgetAction() {
            return this.mHitWidgetAction;
        }

        @Override
        public void over(Object over, double dist) {
            if (over instanceof ConstraintWidget) {
                ConstraintWidget widget = (ConstraintWidget)over;
                if (this.mHitWidget == null || this.mHitWidgetDistance >= dist) {
                    if (this.mHitWidget != null) {
                        MouseInteraction.this.getDecorator(this.mHitWidget).over(false);
                    }
                    if (dist == 0.0 && this.mHitWidget != null && !widget.hasAncestor(this.mHitWidget)) {
                        return;
                    }
                    this.mHitWidget = widget;
                    this.mHitWidgetDistance = dist;
                    if (dist == 0.0) {
                        MouseInteraction.this.getDecorator(this.mHitWidget).over(true);
                    }
                }
            } else if (over instanceof ConstraintHandle) {
                ConstraintHandle handle = (ConstraintHandle)over;
                if (this.mHitConstraintHandle == null || this.mHitConstraintHandleDistance >= dist || dist < 4.0) {
                    if (this.mHitConstraintHandle != null && this.mHitConstraintHandleDistance < 4.0 && MouseInteraction.this.mSelection.contains(this.mHitConstraintHandle.getOwner()) && !MouseInteraction.this.mSelection.contains(handle.getOwner())) {
                        return;
                    }
                    if (this.mMode != 2 && handle.getOwner() instanceof Guideline) {
                        return;
                    }
                    if (dist < 4.0 && this.mHitConstraintHandle != null) {
                        ConstraintWidget currentWidget = this.mHitConstraintHandle.getOwner();
                        ConstraintWidget candidateWidget = handle.getOwner();
                        if (!candidateWidget.hasAncestor(currentWidget)) {
                            return;
                        }
                        ConstraintWidget parent = candidateWidget.getParent();
                        if (!(parent instanceof ConstraintWidgetContainer)) {
                            return;
                        }
                    }
                    if (handle.getAnchor().getType() == ConstraintAnchor.Type.BASELINE) {
                        if ((this.mEnableBaseline || this.mMode == 2) && dist < 4.0) {
                            this.mHitConstraintHandle = handle;
                            this.mHitConstraintHandleDistance = dist;
                        }
                    } else {
                        this.mHitConstraintHandle = handle;
                        this.mHitConstraintHandleDistance = dist;
                    }
                }
            } else if (over instanceof ResizeHandle) {
                ResizeHandle handle = (ResizeHandle)over;
                if (this.mHitResizeHandle == null || this.mHitResizeHandleDistance > dist || dist < 4.0) {
                    if (this.mHitResizeHandle != null && this.mHitResizeHandleDistance < 4.0 && MouseInteraction.this.mSelection.contains(this.mHitResizeHandle.getOwner()) && !MouseInteraction.this.mSelection.contains(handle.getOwner())) {
                        return;
                    }
                    this.mHitResizeHandle = handle;
                    this.mHitResizeHandleDistance = dist;
                }
            } else if (over instanceof WidgetDecorator.WidgetAction && (this.mHitWidgetAction == null || this.mHitWidgetActionDistance > dist)) {
                WidgetDecorator.WidgetAction action = (WidgetDecorator.WidgetAction)over;
                if (this.mHitWidgetAction != null) {
                    this.mHitWidgetAction.over(false);
                }
                this.mHitWidgetAction = action;
                this.mHitWidgetActionDistance = dist;
                if (dist == 0.0) {
                    this.mHitWidgetAction.over(true);
                }
            }
        }

        private void addWidgetToPicker(ConstraintWidget widget, DrawPicker picker) {
            int l = MouseInteraction.this.mViewTransform.getSwingX(widget.getDrawX());
            int t = MouseInteraction.this.mViewTransform.getSwingY(widget.getDrawY());
            int r = l + MouseInteraction.this.mViewTransform.getSwingDimension(widget.getDrawWidth());
            int b = t + MouseInteraction.this.mViewTransform.getSwingDimension(widget.getDrawHeight());
            int widgetSelectionMargin = 8;
            int handleSelectionMargin = 8;
            if (widget instanceof Guideline) {
                Guideline guideline = (Guideline)widget;
                if (guideline.getOrientation() == 0) {
                    picker.addLine(guideline, widgetSelectionMargin, l, t, r, t);
                } else {
                    picker.addLine(guideline, widgetSelectionMargin, l, t, l, b);
                }
                if (MouseInteraction.this.mSelection.contains(guideline) && this.mMode == 2) {
                    return;
                }
            }
            picker.addRect(widget, widgetSelectionMargin, l, t, r, b);
            WidgetCompanion companion = (WidgetCompanion)widget.getCompanionWidget();
            WidgetInteractionTargets targets = companion.getWidgetInteractionTargets();
            if (this.mMode == 1 && !MouseInteraction.this.mSelection.contains(widget)) {
                return;
            }
            block6: for (ConstraintHandle constraintHandle : targets.getConstraintHandles()) {
                int x = MouseInteraction.this.mViewTransform.getSwingX(constraintHandle.getDrawX());
                int y = MouseInteraction.this.mViewTransform.getSwingY(constraintHandle.getDrawY());
                ConstraintAnchor.Type type = constraintHandle.getAnchor().getType();
                if (type == ConstraintAnchor.Type.CENTER || type == ConstraintAnchor.Type.CENTER_X || type == ConstraintAnchor.Type.CENTER_Y) continue;
                if (type == ConstraintAnchor.Type.BASELINE) {
                    if (widget.getBaselineDistance() <= 0) continue;
                    picker.addLine(constraintHandle, handleSelectionMargin, l, y, r, y);
                    continue;
                }
                if (this.mMode == 2) {
                    switch (type) {
                        case LEFT: {
                            picker.addLine(constraintHandle, handleSelectionMargin, l, t, l, b);
                            continue block6;
                        }
                        case RIGHT: {
                            picker.addLine(constraintHandle, handleSelectionMargin, r, t, r, b);
                            continue block6;
                        }
                        case TOP: {
                            picker.addLine(constraintHandle, handleSelectionMargin, l, t, r, t);
                            continue block6;
                        }
                        case BOTTOM: {
                            picker.addLine(constraintHandle, handleSelectionMargin, l, b, r, b);
                            continue block6;
                        }
                    }
                    picker.addPoint(constraintHandle, handleSelectionMargin, x, y);
                    continue;
                }
                picker.addPoint(constraintHandle, handleSelectionMargin, x, y);
            }
            for (ResizeHandle resizeHandle : targets.getResizeHandles()) {
                Rectangle bounds = resizeHandle.getBounds();
                int x = MouseInteraction.this.mViewTransform.getSwingFX((float)bounds.getCenterX());
                int y = MouseInteraction.this.mViewTransform.getSwingFY((float)bounds.getCenterY());
                picker.addPoint(resizeHandle, handleSelectionMargin, x, y);
            }
            WidgetDecorator decorator = companion.getWidgetDecorator(MouseInteraction.this.mSceneDraw.getCurrentStyle());
            for (WidgetDecorator.WidgetAction action : decorator.getWidgetActions()) {
                action.addToPicker(MouseInteraction.this.mViewTransform, picker);
            }
        }

        public void find(int x, int y) {
            this.mPicker.find(x, y);
            this.mLastX = x;
            this.mLastY = y;
        }
    }

    public static interface NeedsLayoutCallback {
        public void needsLayout(boolean var1);
    }

    static enum MouseMode {
        INACTIVE,
        SELECT,
        RESIZE,
        MOVE,
        CONNECT;

    }
}

