/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts2.dom.struts.impl;

import com.intellij.openapi.util.Comparing;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FilePathReferenceProvider;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.struts2.dom.ConverterUtil;
import com.intellij.struts2.dom.struts.IncludeFileResolvingConverter;
import com.intellij.struts2.dom.struts.model.StrutsModel;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.GenericDomValue;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IncludeFileResolvingConverterImpl
extends IncludeFileResolvingConverter {
    public PsiFile fromString(@Nullable @NonNls String value, ConvertContext context) {
        if (value == null) {
            return null;
        }
        XmlElement xmlElement = context.getReferenceXmlElement();
        if (xmlElement == null) {
            return null;
        }
        PsiReference[] references = this.createReferences((GenericDomValue)context.getInvocationElement(), (PsiElement)xmlElement, context);
        if (references.length == 0) {
            return null;
        }
        PsiElement element = references[references.length - 1].resolve();
        return element instanceof PsiFile ? (PsiFile)element : null;
    }

    @NotNull
    public Collection<? extends PsiFile> getVariants(ConvertContext context) {
        List list = Collections.emptyList();
        if (list == null) {
            IncludeFileResolvingConverterImpl.$$$reportNull$$$0(0);
        }
        return list;
    }

    public PsiElement resolve(PsiFile psiFile, ConvertContext context) {
        if (context.getFile().equals(psiFile)) {
            return null;
        }
        StrutsModel model = ConverterUtil.getStrutsModel(context);
        if (model == null) {
            return null;
        }
        return IncludeFileResolvingConverterImpl.isFileAccepted(model, psiFile) ? super.resolve((Object)psiFile, context) : null;
    }

    @NotNull
    public PsiReference[] createReferences(@NotNull GenericDomValue genericDomValue, @NotNull PsiElement element, @NotNull ConvertContext context) {
        String s;
        if (genericDomValue == null) {
            IncludeFileResolvingConverterImpl.$$$reportNull$$$0(1);
        }
        if (element == null) {
            IncludeFileResolvingConverterImpl.$$$reportNull$$$0(2);
        }
        if (context == null) {
            IncludeFileResolvingConverterImpl.$$$reportNull$$$0(3);
        }
        if ((s = genericDomValue.getStringValue()) == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                IncludeFileResolvingConverterImpl.$$$reportNull$$$0(4);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        final StrutsModel model = ConverterUtil.getStrutsModel(context);
        if (model == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                IncludeFileResolvingConverterImpl.$$$reportNull$$$0(5);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        int offset = ElementManipulators.getOffsetInElement((PsiElement)element);
        PsiReference[] psiReferenceArray = new FilePathReferenceProvider(){

            protected boolean isPsiElementAccepted(PsiElement element) {
                return super.isPsiElementAccepted(element) && (!(element instanceof PsiFile) || IncludeFileResolvingConverterImpl.isFileAccepted(model, (PsiFile)element));
            }
        }.getReferencesByElement(element, s, offset, true);
        if (psiReferenceArray == null) {
            IncludeFileResolvingConverterImpl.$$$reportNull$$$0(6);
        }
        return psiReferenceArray;
    }

    public String getErrorMessage(@Nullable String value, ConvertContext context) {
        if (Comparing.equal((String)context.getFile().getName(), (String)value)) {
            return "Recursive inclusion of current file";
        }
        return "Cannot resolve file ''" + value + "'' (not in file set of including file?)";
    }

    private static boolean isFileAccepted(@NotNull StrutsModel model, @NotNull PsiFile file) {
        if (model == null) {
            IncludeFileResolvingConverterImpl.$$$reportNull$$$0(7);
        }
        if (file == null) {
            IncludeFileResolvingConverterImpl.$$$reportNull$$$0(8);
        }
        if (!(file instanceof XmlFile)) {
            return false;
        }
        XmlFile xmlFile = (XmlFile)file;
        Set files = model.getConfigFiles();
        return files.contains(xmlFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/struts2/dom/struts/impl/IncludeFileResolvingConverterImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "genericDomValue";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/struts2/dom/struts/impl/IncludeFileResolvingConverterImpl";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createReferences";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createReferences";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isFileAccepted";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

