/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.uiDesigner.CutCopyPasteSupport;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.actions.AbstractGuiEditorAction;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.lw.IProperty;
import com.intellij.uiDesigner.propertyInspector.properties.BindingProperty;
import com.intellij.uiDesigner.propertyInspector.properties.IntroComponentProperty;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadContainer;
import gnu.trove.TIntHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DuplicateComponentsAction
extends AbstractGuiEditorAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.uiDesigner.actions.DuplicateComponentsAction");

    public DuplicateComponentsAction() {
        super(true);
    }

    @Override
    protected void actionPerformed(GuiEditor editor, List<RadComponent> selection, AnActionEvent e) {
        FormEditingUtil.remapToActionTargets(selection);
        RadContainer parent = FormEditingUtil.getSelectionParent(selection);
        assert (parent != null);
        ArrayList<RadComponent> duplicates = new ArrayList<RadComponent>();
        HashMap<RadComponent, RadComponent> duplicateMap = new HashMap<RadComponent, RadComponent>();
        TIntHashSet insertedRows = new TIntHashSet();
        boolean incrementRow = true;
        if (selection.size() > 1 && DuplicateComponentsAction.canDuplicate(selection, false) && FormEditingUtil.getSelectionBounds(selection).width == 1) {
            incrementRow = false;
        }
        for (RadComponent c : selection) {
            List<RadComponent> copyList;
            int row = c.getConstraints().getCell(incrementRow);
            int rowSpan = c.getConstraints().getSpan(incrementRow);
            int insertIndex = parent.indexOfComponent(c);
            if (parent.getLayoutManager().isGrid() && !insertedRows.contains(row) && !DuplicateComponentsAction.isSpaceBelowEmpty(c, incrementRow)) {
                insertedRows.add(row);
                parent.getGridLayoutManager().copyGridCells(parent, parent, incrementRow, row, rowSpan, row + rowSpan);
            }
            if ((copyList = CutCopyPasteSupport.copyComponents(editor, Collections.singletonList(c))) == null) continue;
            RadComponent copy = copyList.get(0);
            if (parent.getLayoutManager().isGrid()) {
                copy.getConstraints().setCell(incrementRow, row + rowSpan + parent.getGridLayoutManager().getGapCellCount());
                copy.getConstraints().setSpan(incrementRow, rowSpan);
            }
            parent.addComponent(copy, insertIndex + 1);
            DuplicateComponentsAction.fillDuplicateMap(duplicateMap, c, copy);
            duplicates.add(copy);
        }
        DuplicateComponentsAction.adjustDuplicates(duplicateMap);
        FormEditingUtil.selectComponents(editor, duplicates);
    }

    private static void fillDuplicateMap(Map<RadComponent, RadComponent> duplicates, RadComponent c, RadComponent copy) {
        duplicates.put(c, copy);
        if (c instanceof RadContainer) {
            LOG.assertTrue(copy instanceof RadContainer);
            RadContainer container = (RadContainer)c;
            RadContainer containerCopy = (RadContainer)copy;
            for (int i = 0; i < container.getComponentCount(); ++i) {
                DuplicateComponentsAction.fillDuplicateMap(duplicates, container.getComponent(i), containerCopy.getComponent(i));
            }
        }
    }

    private static void adjustDuplicates(Map<RadComponent, RadComponent> duplicates) {
        for (RadComponent c : duplicates.keySet()) {
            RadComponent copy = duplicates.get(c);
            if (c.getBinding() != null) {
                String binding = BindingProperty.getDefaultBinding(copy);
                new BindingProperty(c.getProject()).setValueEx(copy, binding);
                copy.setDefaultBinding(true);
            }
            for (IProperty prop : copy.getModifiedProperties()) {
                if (!(prop instanceof IntroComponentProperty)) continue;
                IntroComponentProperty componentProperty = (IntroComponentProperty)prop;
                String copyValue = componentProperty.getValue(copy);
                for (RadComponent original : duplicates.keySet()) {
                    if (!original.getId().equals(copyValue)) continue;
                    componentProperty.setValueEx(copy, duplicates.get(original).getId());
                }
            }
        }
    }

    private static boolean isSpaceBelowEmpty(RadComponent component, boolean incrementRow) {
        GridConstraints constraints = component.getConstraints();
        int startRow = constraints.getCell(incrementRow) + constraints.getSpan(incrementRow);
        int endRow = constraints.getCell(incrementRow) + constraints.getSpan(incrementRow) * 2 + component.getParent().getGridLayoutManager().getGapCellCount();
        if (endRow > component.getParent().getGridCellCount(incrementRow)) {
            return false;
        }
        for (int row = startRow; row < endRow; ++row) {
            for (int col = constraints.getCell(!incrementRow ? true : false); col < constraints.getCell(!incrementRow) + constraints.getSpan(!incrementRow); ++col) {
                if (component.getParent().getComponentAtGrid(incrementRow, row, col) == null) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    protected void update(@NotNull GuiEditor editor, ArrayList<RadComponent> selection, AnActionEvent e) {
        if (editor == null) {
            DuplicateComponentsAction.$$$reportNull$$$0(0);
        }
        FormEditingUtil.remapToActionTargets(selection);
        RadContainer parent = FormEditingUtil.getSelectionParent(selection);
        e.getPresentation().setEnabled(parent != null && (parent.getLayoutManager().isGrid() || parent.getLayoutManager().isIndexed()));
        if (selection.size() > 1 && parent != null && parent.getLayoutManager().isGrid()) {
            e.getPresentation().setEnabled(DuplicateComponentsAction.canDuplicate(selection, true) || DuplicateComponentsAction.canDuplicate(selection, false));
        }
    }

    private static boolean canDuplicate(List<RadComponent> selection, boolean incrementRow) {
        int aRow = selection.get(0).getConstraints().getCell(incrementRow);
        int aRowSpan = selection.get(0).getConstraints().getSpan(incrementRow);
        for (int i = 1; i < selection.size(); ++i) {
            RadComponent c = selection.get(i);
            if (c.getConstraints().getSpan(incrementRow) <= 1 && aRowSpan <= 1 || c.getConstraints().getCell(incrementRow) == aRow && c.getConstraints().getSpan(incrementRow) == aRowSpan) continue;
            return false;
        }
        return true;
    }

    @Override
    @Nullable
    protected String getCommandName() {
        return UIDesignerBundle.message("command.duplicate", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/uiDesigner/actions/DuplicateComponentsAction", "update"));
    }
}

