/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.quickFix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionDelegate;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ex.QuickFixWrapper;
import com.intellij.lang.Commenter;
import com.intellij.lang.LanguageCommenters;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import junit.framework.TestCase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public class ActionHint {
    private final String myExpectedText;
    private final boolean myShouldPresent;
    private final ProblemHighlightType myHighlightType;
    private final boolean myExactMatch;

    private ActionHint(String expectedText, boolean shouldPresent, ProblemHighlightType severity, boolean exactMatch) {
        this.myExpectedText = expectedText;
        this.myShouldPresent = shouldPresent;
        this.myHighlightType = severity;
        this.myExactMatch = exactMatch;
    }

    public String getExpectedText() {
        return this.myExpectedText;
    }

    public boolean shouldPresent() {
        return this.myShouldPresent;
    }

    @Nullable
    public IntentionAction findAndCheck(Collection<IntentionAction> actions, Supplier<String> infoSupplier) {
        IntentionAction result = actions.stream().filter(t -> {
            String text = t.getText();
            return this.myExactMatch ? text.equals(this.myExpectedText) : text.startsWith(this.myExpectedText);
        }).findFirst().orElse(null);
        if (this.myShouldPresent) {
            if (result == null) {
                Assert.fail((String)(this.exceptionHeader() + " not found\nAvailable actions: " + actions.stream().map(IntentionAction::getText).collect(Collectors.joining(", ", "[", "]\n")) + infoSupplier.get()));
            } else if (this.myHighlightType != null) {
                ProblemHighlightType actualType;
                if (result instanceof IntentionActionDelegate) {
                    result = ((IntentionActionDelegate)((Object)result)).getDelegate();
                }
                if (!(result instanceof QuickFixWrapper)) {
                    Assert.fail((String)(this.exceptionHeader() + " is not a LocalQuickFix, but " + result.getClass().getName() + "\nExpected LocalQuickFix with ProblemHighlightType=" + (Object)((Object)this.myHighlightType) + "\n" + infoSupplier.get()));
                }
                if ((actualType = ((QuickFixWrapper)result).getHighlightType()) != this.myHighlightType) {
                    Assert.fail((String)(this.exceptionHeader() + " has wrong ProblemHighlightType.\nExpected: " + (Object)((Object)this.myHighlightType) + "\nActual: " + (Object)((Object)actualType) + "\n" + infoSupplier.get()));
                }
            }
        } else if (result != null) {
            Assert.fail((String)(this.exceptionHeader() + " is present, but should not\n" + infoSupplier.get()));
        }
        return result;
    }

    private String exceptionHeader() {
        return "Action with " + (this.myExactMatch ? "text" : "prefix") + " '" + this.myExpectedText + "'";
    }

    @NotNull
    public static ActionHint parse(@NotNull PsiFile file, @NotNull String contents) {
        if (file == null) {
            ActionHint.$$$reportNull$$$0(0);
        }
        if (contents == null) {
            ActionHint.$$$reportNull$$$0(1);
        }
        ActionHint actionHint = ActionHint.parse(file, contents, true);
        if (actionHint == null) {
            ActionHint.$$$reportNull$$$0(2);
        }
        return actionHint;
    }

    @NotNull
    public static ActionHint parse(@NotNull PsiFile file, @NotNull String contents, boolean exactMatch) {
        PsiFile hostFile;
        Commenter commenter;
        String comment;
        if (file == null) {
            ActionHint.$$$reportNull$$$0(3);
        }
        if (contents == null) {
            ActionHint.$$$reportNull$$$0(4);
        }
        if ((comment = (commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage((hostFile = InjectedLanguageManager.getInstance(file.getProject()).getTopLevelFile(file)).getLanguage())).getLineCommentPrefix()) == null) {
            comment = commenter.getBlockCommentPrefix();
        }
        assert (comment != null) : commenter;
        Pattern pattern = Pattern.compile("^" + Pattern.quote(comment) + " \"(.*)\" \"(\\w+)\".*", 32);
        Matcher matcher = pattern.matcher(contents);
        TestCase.assertTrue((String)("No comment found in " + file.getVirtualFile()), (boolean)matcher.matches());
        String text = matcher.group(1);
        String state = matcher.group(2);
        if (state.equals("true") || state.equals("false")) {
            ActionHint actionHint = new ActionHint(text, Boolean.parseBoolean(state), null, exactMatch);
            if (actionHint == null) {
                ActionHint.$$$reportNull$$$0(5);
            }
            return actionHint;
        }
        ActionHint actionHint = new ActionHint(text, true, ProblemHighlightType.valueOf(state), exactMatch);
        if (actionHint == null) {
            ActionHint.$$$reportNull$$$0(6);
        }
        return actionHint;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contents";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/quickFix/ActionHint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/quickFix/ActionHint";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

