/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.execution.ParametersListUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParametersList
implements Cloneable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.configurations.ParametersList");
    private static final Pattern PROPERTY_PATTERN = Pattern.compile("-D(\\S+?)=(.+)");
    private List<String> myParameters = new ArrayList<String>();
    private Map<String, String> myMacroMap = null;
    private List<ParamsGroup> myGroups = new ArrayList<ParamsGroup>();

    public boolean hasParameter(@NonNls String param) {
        return this.myParameters.contains(param);
    }

    public boolean hasProperty(@NonNls String name) {
        return this.getPropertyValue(name) != null;
    }

    @Nullable
    public String getPropertyValue(@NotNull @NonNls String name) {
        if (name == null) {
            ParametersList.$$$reportNull$$$0(0);
        }
        String prefix = "-D" + name + "=";
        for (String parameter : this.myParameters) {
            if (!parameter.startsWith(prefix)) continue;
            return parameter.substring(prefix.length());
        }
        return null;
    }

    @NotNull
    public Map<String, String> getProperties() {
        THashMap result = new THashMap();
        for (String parameter : this.myParameters) {
            Matcher matcher = PROPERTY_PATTERN.matcher(parameter);
            if (!matcher.matches()) continue;
            result.put(matcher.group(1), matcher.group(2));
        }
        THashMap tHashMap = result;
        if (tHashMap == null) {
            ParametersList.$$$reportNull$$$0(1);
        }
        return tHashMap;
    }

    @NotNull
    public String getParametersString() {
        String string = ParametersList.join(this.getList());
        if (string == null) {
            ParametersList.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String[] getArray() {
        String[] stringArray = ArrayUtil.toStringArray(this.getList());
        if (stringArray == null) {
            ParametersList.$$$reportNull$$$0(3);
        }
        return stringArray;
    }

    @NotNull
    public List<String> getList() {
        if (this.myGroups.isEmpty()) {
            List<String> list = Collections.unmodifiableList(this.myParameters);
            if (list == null) {
                ParametersList.$$$reportNull$$$0(4);
            }
            return list;
        }
        ArrayList<String> params = new ArrayList<String>(this.myParameters);
        for (ParamsGroup group : this.myGroups) {
            params.addAll(group.getParameters());
        }
        List<String> list = Collections.unmodifiableList(params);
        if (list == null) {
            ParametersList.$$$reportNull$$$0(5);
        }
        return list;
    }

    public void clearAll() {
        this.myParameters.clear();
        this.myGroups.clear();
    }

    public void prepend(@NonNls String parameter) {
        this.addAt(0, parameter);
    }

    public void prependAll(String ... parameter) {
        this.addAll(parameter);
        Collections.rotate(this.myParameters, parameter.length);
    }

    public void addParametersString(String parameters) {
        if (parameters != null) {
            String[] split;
            for (String param : split = ParametersList.parse(parameters)) {
                this.add(param);
            }
        }
    }

    public void add(@NonNls String parameter) {
        this.myParameters.add(this.expandMacros(parameter));
    }

    public ParamsGroup addParamsGroup(@NotNull String groupId) {
        if (groupId == null) {
            ParametersList.$$$reportNull$$$0(6);
        }
        return this.addParamsGroup(new ParamsGroup(groupId));
    }

    public ParamsGroup addParamsGroup(@NotNull ParamsGroup group) {
        if (group == null) {
            ParametersList.$$$reportNull$$$0(7);
        }
        this.myGroups.add(group);
        return group;
    }

    public ParamsGroup addParamsGroupAt(int index, @NotNull ParamsGroup group) {
        if (group == null) {
            ParametersList.$$$reportNull$$$0(8);
        }
        this.myGroups.add(index, group);
        return group;
    }

    public ParamsGroup addParamsGroupAt(int index, @NotNull String groupId) {
        if (groupId == null) {
            ParametersList.$$$reportNull$$$0(9);
        }
        ParamsGroup group = new ParamsGroup(groupId);
        this.myGroups.add(index, group);
        return group;
    }

    public int getParamsGroupsCount() {
        return this.myGroups.size();
    }

    public List<String> getParameters() {
        return Collections.unmodifiableList(this.myParameters);
    }

    public List<ParamsGroup> getParamsGroups() {
        return Collections.unmodifiableList(this.myGroups);
    }

    public ParamsGroup getParamsGroupAt(int index) {
        return this.myGroups.get(index);
    }

    @Nullable
    public ParamsGroup getParamsGroup(@NotNull String name) {
        if (name == null) {
            ParametersList.$$$reportNull$$$0(10);
        }
        for (ParamsGroup group : this.myGroups) {
            if (!name.equals(group.getId())) continue;
            return group;
        }
        return null;
    }

    public ParamsGroup removeParamsGroup(int index) {
        return this.myGroups.remove(index);
    }

    public void addAt(int index, @NotNull String parameter) {
        if (parameter == null) {
            ParametersList.$$$reportNull$$$0(11);
        }
        this.myParameters.add(index, this.expandMacros(parameter));
    }

    public void defineProperty(@NonNls String propertyName, @NonNls String propertyValue) {
        this.addProperty(propertyName, propertyValue);
    }

    public void addProperty(@NonNls String propertyName) {
        this.myParameters.add("-D" + propertyName);
    }

    public void addProperty(@NonNls String propertyName, @NonNls String propertyValue) {
        this.myParameters.add("-D" + propertyName + "=" + propertyValue);
    }

    public void replaceOrAppend(@NonNls String parameterPrefix, @NonNls String replacement) {
        this.replaceOrAdd(parameterPrefix, replacement, this.myParameters.size());
    }

    private void replaceOrAdd(@NonNls String parameterPrefix, @NonNls String replacement, int position) {
        ListIterator<String> iterator = this.myParameters.listIterator();
        while (iterator.hasNext()) {
            String param = iterator.next();
            if (!param.startsWith(parameterPrefix)) continue;
            if (replacement != null && replacement.isEmpty()) {
                iterator.remove();
            } else {
                iterator.set(replacement);
            }
            return;
        }
        if (replacement != null && !replacement.isEmpty()) {
            this.myParameters.add(position, replacement);
        }
    }

    public void replaceOrPrepend(@NonNls String parameter, @NonNls String replacement) {
        this.replaceOrAdd(parameter, replacement, 0);
    }

    public void set(int ind, @NonNls String value) {
        this.myParameters.set(ind, value);
    }

    public String get(int ind) {
        return this.myParameters.get(ind);
    }

    @Nullable
    public String getLast() {
        return this.myParameters.size() > 0 ? this.myParameters.get(this.myParameters.size() - 1) : null;
    }

    public void add(@NonNls String name, @NonNls String value) {
        this.add(name);
        this.add(value);
    }

    public void addAll(String ... parameters) {
        this.addAll(Arrays.asList(parameters));
    }

    public void addAll(List<String> parameters) {
        for (String parameter : parameters) {
            this.add(parameter);
        }
    }

    public ParametersList clone() {
        try {
            ParametersList clone = (ParametersList)super.clone();
            clone.myParameters = new ArrayList<String>(this.myParameters);
            clone.myGroups = new ArrayList<ParamsGroup>(this.myGroups.size() + 1);
            for (ParamsGroup group : this.myGroups) {
                clone.myGroups.add(group.clone());
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    @NotNull
    public static String join(@NotNull List<String> parameters) {
        if (parameters == null) {
            ParametersList.$$$reportNull$$$0(12);
        }
        String string = ParametersListUtil.join(parameters);
        if (string == null) {
            ParametersList.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    public static String join(String ... parameters) {
        String string = ParametersListUtil.join((String[])parameters);
        if (string == null) {
            ParametersList.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    public static String[] parse(@NotNull String string) {
        if (string == null) {
            ParametersList.$$$reportNull$$$0(15);
        }
        String[] stringArray = ParametersListUtil.parseToArray((String)string);
        if (stringArray == null) {
            ParametersList.$$$reportNull$$$0(16);
        }
        return stringArray;
    }

    public String expandMacros(String text) {
        Map<String, String> macroMap = this.getMacroMap();
        Set<String> set = macroMap.keySet();
        for (String from : set) {
            String to = macroMap.get(from);
            text = StringUtil.replace((String)text, (String)from, (String)to, (boolean)true);
        }
        return text;
    }

    private Map<String, String> getMacroMap() {
        if (this.myMacroMap == null) {
            this.myMacroMap = new LinkedHashMap<String, String>();
            Application application = ApplicationManager.getApplication();
            if (application != null) {
                PathMacros pathMacros = PathMacros.getInstance();
                if (pathMacros != null) {
                    for (String name : pathMacros.getUserMacroNames()) {
                        String value = pathMacros.getValue(name);
                        if (value == null) continue;
                        this.myMacroMap.put("${" + name + "}", value);
                    }
                }
                Map env = EnvironmentUtil.getEnvironmentMap();
                for (String name : env.keySet()) {
                    String key = "${" + name + "}";
                    if (this.myMacroMap.containsKey(key)) continue;
                    this.myMacroMap.put(key, (String)env.get(name));
                }
            }
        }
        return this.myMacroMap;
    }

    public String toString() {
        return this.myParameters.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 13: 
            case 14: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 13: 
            case 14: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 13: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/configurations/ParametersList";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/configurations/ParametersList";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getParametersString";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getArray";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getList";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "join";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyValue";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 13: 
            case 14: 
            case 16: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addParamsGroup";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addParamsGroupAt";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getParamsGroup";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addAt";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "join";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 13: 
            case 14: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

