/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.dashboard;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.dashboard.RunDashboardAnimator;
import com.intellij.execution.dashboard.RunDashboardContributor;
import com.intellij.execution.dashboard.RunDashboardListener;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.messages.Topic;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public interface RunDashboardManager {
    public static final Topic<RunDashboardListener> DASHBOARD_TOPIC = Topic.create((String)"run dashboard", RunDashboardListener.class, (Topic.BroadcastDirection)Topic.BroadcastDirection.TO_PARENT);

    public static RunDashboardManager getInstance(Project project) {
        return ServiceManager.getService(project, RunDashboardManager.class);
    }

    public ContentManager getDashboardContentManager();

    public String getToolWindowId();

    public Icon getToolWindowIcon();

    public boolean isToolWindowAvailable();

    public void createToolWindowContent(@NotNull ToolWindow var1);

    public List<Pair<RunnerAndConfigurationSettings, RunContentDescriptor>> getRunConfigurations();

    public boolean isShowConfigurations();

    public void setShowConfigurations(boolean var1);

    public float getContentProportion();

    @Nullable
    public RunDashboardAnimator getAnimator();

    public boolean isShowInDashboard(@NotNull RunConfiguration var1);

    @NotNull
    public Set<String> getTypes();

    public void setTypes(Set<String> var1);

    @Nullable
    public RunDashboardContributor getContributor(@NotNull ConfigurationType var1);
}

