/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jam;

import com.intellij.jam.JamAttributeElement;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiReferenceExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JamEnumAttributeElement<T extends Enum<T>>
extends JamAttributeElement<T> {
    private final Class<T> myModelEnum;

    public JamEnumAttributeElement(@NotNull PsiElementRef<PsiAnnotation> parent, String attributeName, Class<T> modelEnum) {
        if (parent == null) {
            JamEnumAttributeElement.$$$reportNull$$$0(0);
        }
        super(attributeName, parent);
        this.myModelEnum = modelEnum;
    }

    public JamEnumAttributeElement(PsiAnnotationMemberValue exactValue, Class<T> modelEnum) {
        super(exactValue);
        this.myModelEnum = modelEnum;
    }

    @Nullable
    public PsiEnumConstant getEnumConstant() {
        PsiReferenceExpression psiReferenceExpression;
        PsiElement psiElement;
        PsiAnnotationMemberValue memberValue = this.getPsiElement();
        if (memberValue instanceof PsiReferenceExpression && (psiElement = (psiReferenceExpression = (PsiReferenceExpression)memberValue).resolve()) instanceof PsiEnumConstant) {
            return (PsiEnumConstant)psiElement;
        }
        return null;
    }

    @Override
    public String getStringValue() {
        PsiEnumConstant constant = this.getEnumConstant();
        if (constant != null) {
            return constant.getName();
        }
        return null;
    }

    @Override
    public T getValue() {
        String name = this.getStringValue();
        if (name == null) {
            return null;
        }
        try {
            return Enum.valueOf(this.myModelEnum, name);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public Class<T> getModelEnum() {
        return this.myModelEnum;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/jam/JamEnumAttributeElement", "<init>"));
    }
}

