/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.BinaryContentRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangesUtil {
    private static final Key<Boolean> INTERNAL_OPERATION_KEY = Key.create((String)"internal vcs operation");
    public static final TObjectHashingStrategy<FilePath> CASE_SENSITIVE_FILE_PATH_HASHING_STRATEGY = new TObjectHashingStrategy<FilePath>(){

        public int computeHashCode(@Nullable FilePath path2) {
            return path2 != null ? Objects.hash(path2.getPath(), path2.isDirectory()) : 0;
        }

        public boolean equals(@Nullable FilePath path1, @Nullable FilePath path2) {
            if (path1 == path2) {
                return true;
            }
            if (path1 == null || path2 == null) {
                return false;
            }
            return path1.isDirectory() == path2.isDirectory() && path1.getPath().equals(path2.getPath());
        }
    };

    private ChangesUtil() {
    }

    @NotNull
    public static FilePath getFilePath(@NotNull Change change) {
        ContentRevision revision;
        if (change == null) {
            ChangesUtil.$$$reportNull$$$0(0);
        }
        if ((revision = change.getAfterRevision()) == null) {
            revision = change.getBeforeRevision();
            assert (revision != null);
        }
        FilePath filePath2 = revision.getFile();
        if (filePath2 == null) {
            ChangesUtil.$$$reportNull$$$0(1);
        }
        return filePath2;
    }

    @Nullable
    public static FilePath getBeforePath(@NotNull Change change) {
        ContentRevision revision;
        if (change == null) {
            ChangesUtil.$$$reportNull$$$0(2);
        }
        return (revision = change.getBeforeRevision()) == null ? null : revision.getFile();
    }

    @Nullable
    public static FilePath getAfterPath(@NotNull Change change) {
        ContentRevision revision;
        if (change == null) {
            ChangesUtil.$$$reportNull$$$0(3);
        }
        return (revision = change.getAfterRevision()) == null ? null : revision.getFile();
    }

    @Nullable
    public static AbstractVcs getVcsForChange(@NotNull Change change, @NotNull Project project) {
        AbstractVcs result;
        if (change == null) {
            ChangesUtil.$$$reportNull$$$0(4);
        }
        if (project == null) {
            ChangesUtil.$$$reportNull$$$0(5);
        }
        return (result = ChangeListManager.getInstance(project).getVcsFor(change)) != null ? result : ProjectLevelVcsManager.getInstance(project).getVcsFor(ChangesUtil.getFilePath(change));
    }

    @NotNull
    public static Set<AbstractVcs> getAffectedVcses(@NotNull Collection<Change> changes, @NotNull Project project) {
        if (changes == null) {
            ChangesUtil.$$$reportNull$$$0(6);
        }
        if (project == null) {
            ChangesUtil.$$$reportNull$$$0(7);
        }
        Set set = ContainerUtil.map2SetNotNull(changes, change -> {
            if (project == null) {
                ChangesUtil.$$$reportNull$$$0(72);
            }
            return ChangesUtil.getVcsForChange(change, project);
        });
        if (set == null) {
            ChangesUtil.$$$reportNull$$$0(8);
        }
        return set;
    }

    @NotNull
    public static Set<AbstractVcs> getAffectedVcsesForFiles(@NotNull Collection<VirtualFile> files, @NotNull Project project) {
        if (files == null) {
            ChangesUtil.$$$reportNull$$$0(9);
        }
        if (project == null) {
            ChangesUtil.$$$reportNull$$$0(10);
        }
        Set set = ContainerUtil.map2SetNotNull(files, file -> {
            if (project == null) {
                ChangesUtil.$$$reportNull$$$0(71);
            }
            return ChangesUtil.getVcsForFile(file, project);
        });
        if (set == null) {
            ChangesUtil.$$$reportNull$$$0(11);
        }
        return set;
    }

    @Nullable
    public static AbstractVcs getVcsForFile(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            ChangesUtil.$$$reportNull$$$0(12);
        }
        if (project == null) {
            ChangesUtil.$$$reportNull$$$0(13);
        }
        return ProjectLevelVcsManager.getInstance(project).getVcsFor(file);
    }

    @Nullable
    public static AbstractVcs getVcsForFile(@NotNull File file, @NotNull Project project) {
        if (file == null) {
            ChangesUtil.$$$reportNull$$$0(14);
        }
        if (project == null) {
            ChangesUtil.$$$reportNull$$$0(15);
        }
        return ProjectLevelVcsManager.getInstance(project).getVcsFor(VcsUtil.getFilePath(file));
    }

    @NotNull
    public static List<FilePath> getPaths(@NotNull Collection<Change> changes) {
        if (changes == null) {
            ChangesUtil.$$$reportNull$$$0(16);
        }
        List<FilePath> list = ChangesUtil.getPaths(changes.stream()).collect(Collectors.toList());
        if (list == null) {
            ChangesUtil.$$$reportNull$$$0(17);
        }
        return list;
    }

    @NotNull
    public static List<File> getIoFilesFromChanges(@NotNull Collection<Change> changes) {
        if (changes == null) {
            ChangesUtil.$$$reportNull$$$0(18);
        }
        List<File> list = ChangesUtil.getPaths(changes.stream()).map(FilePath::getIOFile).distinct().collect(Collectors.toList());
        if (list == null) {
            ChangesUtil.$$$reportNull$$$0(19);
        }
        return list;
    }

    @NotNull
    public static Stream<FilePath> getPaths(@NotNull Stream<Change> changes) {
        if (changes == null) {
            ChangesUtil.$$$reportNull$$$0(20);
        }
        Stream<FilePath> stream = changes.flatMap(ChangesUtil::getPathsCaseSensitive);
        if (stream == null) {
            ChangesUtil.$$$reportNull$$$0(21);
        }
        return stream;
    }

    @NotNull
    public static Stream<FilePath> getPathsCaseSensitive(@NotNull Change change) {
        if (change == null) {
            ChangesUtil.$$$reportNull$$$0(22);
        }
        FilePath beforePath = ChangesUtil.getBeforePath(change);
        FilePath afterPath = ChangesUtil.getAfterPath(change);
        Stream<FilePath> stream = Stream.of(beforePath, !CASE_SENSITIVE_FILE_PATH_HASHING_STRATEGY.equals((Object)beforePath, (Object)afterPath) ? afterPath : null).filter(Objects::nonNull);
        if (stream == null) {
            ChangesUtil.$$$reportNull$$$0(23);
        }
        return stream;
    }

    @NotNull
    public static Stream<VirtualFile> getFiles(@NotNull Stream<Change> changes) {
        if (changes == null) {
            ChangesUtil.$$$reportNull$$$0(24);
        }
        Stream<VirtualFile> stream = ChangesUtil.getPaths(changes).map(FilePath::getVirtualFile).filter(Objects::nonNull);
        if (stream == null) {
            ChangesUtil.$$$reportNull$$$0(25);
        }
        return stream;
    }

    @Deprecated
    @NotNull
    public static VirtualFile[] getFilesFromChanges(@NotNull Collection<Change> changes) {
        if (changes == null) {
            ChangesUtil.$$$reportNull$$$0(26);
        }
        VirtualFile[] virtualFileArray = (VirtualFile[])ChangesUtil.getFiles(changes.stream()).toArray(VirtualFile[]::new);
        if (virtualFileArray == null) {
            ChangesUtil.$$$reportNull$$$0(27);
        }
        return virtualFileArray;
    }

    @NotNull
    public static Navigatable[] getNavigatableArray(@NotNull Project project, @NotNull VirtualFile[] files) {
        if (project == null) {
            ChangesUtil.$$$reportNull$$$0(28);
        }
        if (files == null) {
            ChangesUtil.$$$reportNull$$$0(29);
        }
        Navigatable[] navigatableArray = ChangesUtil.getNavigatableArray(project, Stream.of(files));
        if (navigatableArray == null) {
            ChangesUtil.$$$reportNull$$$0(30);
        }
        return navigatableArray;
    }

    @NotNull
    public static Navigatable[] getNavigatableArray(@NotNull Project project, @NotNull Stream<VirtualFile> files) {
        if (project == null) {
            ChangesUtil.$$$reportNull$$$0(31);
        }
        if (files == null) {
            ChangesUtil.$$$reportNull$$$0(32);
        }
        Navigatable[] navigatableArray = (Navigatable[])files.filter(file -> !file.isDirectory()).map(file -> {
            if (project == null) {
                ChangesUtil.$$$reportNull$$$0(70);
            }
            return new OpenFileDescriptor(project, (VirtualFile)file);
        }).toArray(Navigatable[]::new);
        if (navigatableArray == null) {
            ChangesUtil.$$$reportNull$$$0(33);
        }
        return navigatableArray;
    }

    @Nullable
    public static ChangeList getChangeListIfOnlyOne(@NotNull Project project, @Nullable Change[] changes) {
        ChangeListManager manager;
        String changeListName;
        if (project == null) {
            ChangesUtil.$$$reportNull$$$0(34);
        }
        return (changeListName = (manager = ChangeListManager.getInstance(project)).getChangeListNameIfOnlyOne(changes)) == null ? null : manager.findChangeList(changeListName);
    }

    public static FilePath getCommittedPath(@NotNull Project project, FilePath filePath2) {
        Change change;
        if (project == null) {
            ChangesUtil.$$$reportNull$$$0(35);
        }
        if ((change = ChangeListManager.getInstance(project).getChange(filePath2)) != null) {
            ContentRevision beforeRevision = change.getBeforeRevision();
            ContentRevision afterRevision = change.getAfterRevision();
            if (beforeRevision != null && afterRevision != null && !beforeRevision.getFile().equals(afterRevision.getFile()) && afterRevision.getFile().equals(filePath2)) {
                filePath2 = beforeRevision.getFile();
            }
        }
        return filePath2;
    }

    public static FilePath getLocalPath(@NotNull Project project, FilePath filePath2) {
        Change change;
        if (project == null) {
            ChangesUtil.$$$reportNull$$$0(36);
        }
        if ((change = (Change)ReadAction.compute(() -> {
            if (project == null) {
                ChangesUtil.$$$reportNull$$$0(69);
            }
            if (project.isDisposed()) {
                throw new ProcessCanceledException();
            }
            return ChangeListManager.getInstance(project).getChange(filePath2);
        })) != null) {
            ContentRevision beforeRevision = change.getBeforeRevision();
            ContentRevision afterRevision = change.getAfterRevision();
            if (beforeRevision != null && afterRevision != null && !beforeRevision.getFile().equals(afterRevision.getFile()) && beforeRevision.getFile().equals(filePath2)) {
                return afterRevision.getFile();
            }
        }
        return filePath2;
    }

    @Nullable
    public static VirtualFile findValidParentUnderReadAction(@NotNull FilePath path2) {
        VirtualFile file;
        if (path2 == null) {
            ChangesUtil.$$$reportNull$$$0(37);
        }
        return (file = path2.getVirtualFile()) != null ? file : ChangesUtil.getValidParentUnderReadAction(path2);
    }

    @Nullable
    public static VirtualFile findValidParentAccurately(@NotNull FilePath filePath2) {
        VirtualFile result;
        if (filePath2 == null) {
            ChangesUtil.$$$reportNull$$$0(38);
        }
        if ((result = filePath2.getVirtualFile()) == null && !ApplicationManager.getApplication().isReadAccessAllowed()) {
            result = LocalFileSystem.getInstance().refreshAndFindFileByPath(filePath2.getPath());
        }
        if (result == null) {
            result = ChangesUtil.getValidParentUnderReadAction(filePath2);
        }
        return result;
    }

    @Nullable
    private static VirtualFile getValidParentUnderReadAction(@NotNull FilePath filePath2) {
        if (filePath2 == null) {
            ChangesUtil.$$$reportNull$$$0(39);
        }
        return (VirtualFile)ReadAction.compute(() -> {
            if (filePath2 == null) {
                ChangesUtil.$$$reportNull$$$0(68);
            }
            VirtualFile result = null;
            LocalFileSystem lfs = LocalFileSystem.getInstance();
            for (FilePath parent = filePath2; result == null && parent != null; parent = parent.getParentPath()) {
                result = lfs.findFileByPath(parent.getPath());
            }
            return result;
        });
    }

    @Nullable
    public static String getProjectRelativePath(@NotNull Project project, @Nullable File fileName) {
        if (project == null) {
            ChangesUtil.$$$reportNull$$$0(40);
        }
        if (fileName == null) {
            return null;
        }
        VirtualFile baseDir = project.getBaseDir();
        if (baseDir == null) {
            return fileName.toString();
        }
        String relativePath = FileUtil.getRelativePath((File)VfsUtilCore.virtualToIoFile(baseDir), (File)fileName);
        if (relativePath != null) {
            return relativePath;
        }
        return fileName.toString();
    }

    public static boolean isBinaryContentRevision(@Nullable ContentRevision revision) {
        return revision instanceof BinaryContentRevision && !revision.getFile().isDirectory();
    }

    public static boolean isBinaryChange(@NotNull Change change) {
        if (change == null) {
            ChangesUtil.$$$reportNull$$$0(41);
        }
        return ChangesUtil.isBinaryContentRevision(change.getBeforeRevision()) || ChangesUtil.isBinaryContentRevision(change.getAfterRevision());
    }

    public static boolean isTextConflictingChange(@NotNull Change change) {
        FileStatus status;
        if (change == null) {
            ChangesUtil.$$$reportNull$$$0(42);
        }
        return FileStatus.MERGED_WITH_CONFLICTS.equals(status = change.getFileStatus()) || FileStatus.MERGED_WITH_BOTH_CONFLICTS.equals(status);
    }

    public static <T> void processItemsByVcs(@NotNull Collection<T> items, @NotNull VcsSeparator<T> separator, @NotNull PerVcsProcessor<T> processor) {
        if (items == null) {
            ChangesUtil.$$$reportNull$$$0(43);
        }
        if (separator == null) {
            ChangesUtil.$$$reportNull$$$0(44);
        }
        if (processor == null) {
            ChangesUtil.$$$reportNull$$$0(45);
        }
        Map changesByVcs = (Map)ReadAction.compute(() -> {
            if (items == null) {
                ChangesUtil.$$$reportNull$$$0(66);
            }
            if (separator == null) {
                ChangesUtil.$$$reportNull$$$0(67);
            }
            return StreamEx.of((Collection)items).mapToEntry(separator::getVcsFor, Function.identity()).nonNullKeys().grouping();
        });
        changesByVcs.forEach(processor::process);
    }

    public static void processChangesByVcs(@NotNull Project project, @NotNull Collection<Change> changes, @NotNull PerVcsProcessor<Change> processor) {
        if (project == null) {
            ChangesUtil.$$$reportNull$$$0(46);
        }
        if (changes == null) {
            ChangesUtil.$$$reportNull$$$0(47);
        }
        if (processor == null) {
            ChangesUtil.$$$reportNull$$$0(48);
        }
        ChangesUtil.processItemsByVcs(changes, change -> {
            if (project == null) {
                ChangesUtil.$$$reportNull$$$0(65);
            }
            return ChangesUtil.getVcsForChange(change, project);
        }, processor);
    }

    public static void processVirtualFilesByVcs(@NotNull Project project, @NotNull Collection<VirtualFile> files, @NotNull PerVcsProcessor<VirtualFile> processor) {
        if (project == null) {
            ChangesUtil.$$$reportNull$$$0(49);
        }
        if (files == null) {
            ChangesUtil.$$$reportNull$$$0(50);
        }
        if (processor == null) {
            ChangesUtil.$$$reportNull$$$0(51);
        }
        ChangesUtil.processItemsByVcs(files, file -> {
            if (project == null) {
                ChangesUtil.$$$reportNull$$$0(64);
            }
            return ChangesUtil.getVcsForFile(file, project);
        }, processor);
    }

    public static void processFilePathsByVcs(@NotNull Project project, @NotNull Collection<FilePath> files, @NotNull PerVcsProcessor<FilePath> processor) {
        if (project == null) {
            ChangesUtil.$$$reportNull$$$0(52);
        }
        if (files == null) {
            ChangesUtil.$$$reportNull$$$0(53);
        }
        if (processor == null) {
            ChangesUtil.$$$reportNull$$$0(54);
        }
        ChangesUtil.processItemsByVcs(files, filePath2 -> {
            if (project == null) {
                ChangesUtil.$$$reportNull$$$0(63);
            }
            return ChangesUtil.getVcsForFile(filePath2.getIOFile(), project);
        }, processor);
    }

    @NotNull
    public static List<File> filePathsToFiles(@NotNull Collection<FilePath> filePaths) {
        if (filePaths == null) {
            ChangesUtil.$$$reportNull$$$0(55);
        }
        List<File> list = filePaths.stream().map(FilePath::getIOFile).collect(Collectors.toList());
        if (list == null) {
            ChangesUtil.$$$reportNull$$$0(56);
        }
        return list;
    }

    public static boolean hasFileChanges(@NotNull Collection<Change> changes) {
        if (changes == null) {
            ChangesUtil.$$$reportNull$$$0(57);
        }
        return changes.stream().map(ChangesUtil::getFilePath).anyMatch(path2 -> !path2.isDirectory());
    }

    public static void markInternalOperation(@NotNull Iterable<Change> changes, boolean set) {
        if (changes == null) {
            ChangesUtil.$$$reportNull$$$0(58);
        }
        for (Change change : changes) {
            VirtualFile file = change.getVirtualFile();
            if (file == null) continue;
            ChangesUtil.markInternalOperation(file, set);
        }
    }

    public static void markInternalOperation(@NotNull VirtualFile file, boolean set) {
        if (file == null) {
            ChangesUtil.$$$reportNull$$$0(59);
        }
        file.putUserData(INTERNAL_OPERATION_KEY, set);
    }

    public static boolean isInternalOperation(@NotNull VirtualFile file) {
        if (file == null) {
            ChangesUtil.$$$reportNull$$$0(60);
        }
        return Boolean.TRUE.equals(file.getUserData(INTERNAL_OPERATION_KEY));
    }

    @Nullable
    public static File findCommonAncestor(@NotNull Collection<Change> changes) {
        if (changes == null) {
            ChangesUtil.$$$reportNull$$$0(61);
        }
        File ancestor = null;
        for (Change change : changes) {
            File currentChangeAncestor = ChangesUtil.getCommonBeforeAfterAncestor(change);
            if (currentChangeAncestor == null) {
                return null;
            }
            if (ancestor == null) {
                ancestor = currentChangeAncestor;
                continue;
            }
            if ((ancestor = FileUtil.findAncestor((File)ancestor, (File)currentChangeAncestor)) != null) continue;
            return null;
        }
        return ancestor;
    }

    @Nullable
    private static File getCommonBeforeAfterAncestor(@NotNull Change change) {
        if (change == null) {
            ChangesUtil.$$$reportNull$$$0(62);
        }
        FilePath before = ChangesUtil.getBeforePath(change);
        FilePath after = ChangesUtil.getAfterPath(change);
        return before == null ? ((FilePath)ObjectUtils.assertNotNull((Object)after)).getIOFile() : (after == null ? before.getIOFile() : FileUtil.findAncestor((File)before.getIOFile(), (File)after.getIOFile()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 8: 
            case 11: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 30: 
            case 33: 
            case 56: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 8: 
            case 11: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 30: 
            case 33: 
            case 56: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 1: 
            case 8: 
            case 11: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 30: 
            case 33: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ChangesUtil";
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 13: 
            case 15: 
            case 28: 
            case 31: 
            case 34: 
            case 35: 
            case 36: 
            case 40: 
            case 46: 
            case 49: 
            case 52: 
            case 63: 
            case 64: 
            case 65: 
            case 69: 
            case 70: 
            case 71: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 16: 
            case 18: 
            case 20: 
            case 24: 
            case 26: 
            case 47: 
            case 57: 
            case 58: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 9: 
            case 29: 
            case 32: 
            case 50: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 12: 
            case 14: 
            case 59: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 38: 
            case 39: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 43: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 44: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 45: 
            case 48: 
            case 51: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangesUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePath";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedVcses";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedVcsesForFiles";
                break;
            }
            case 17: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getPaths";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getIoFilesFromChanges";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathsCaseSensitive";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesFromChanges";
                break;
            }
            case 30: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigatableArray";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "filePathsToFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFilePath";
                break;
            }
            case 1: 
            case 8: 
            case 11: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 30: 
            case 33: 
            case 56: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getBeforePath";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAfterPath";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getVcsForChange";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAffectedVcses";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getAffectedVcsesForFiles";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getVcsForFile";
                break;
            }
            case 16: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getPaths";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getIoFilesFromChanges";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getPathsCaseSensitive";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getFiles";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getFilesFromChanges";
                break;
            }
            case 28: 
            case 29: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getNavigatableArray";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getChangeListIfOnlyOne";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getCommittedPath";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getLocalPath";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "findValidParentUnderReadAction";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "findValidParentAccurately";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getValidParentUnderReadAction";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getProjectRelativePath";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "isBinaryChange";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "isTextConflictingChange";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "processItemsByVcs";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "processChangesByVcs";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "processVirtualFilesByVcs";
                break;
            }
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "processFilePathsByVcs";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "filePathsToFiles";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "hasFileChanges";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "markInternalOperation";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "isInternalOperation";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "findCommonAncestor";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "getCommonBeforeAfterAncestor";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processFilePathsByVcs$11";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processVirtualFilesByVcs$10";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processChangesByVcs$9";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processItemsByVcs$8";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getValidParentUnderReadAction$7";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getLocalPath$6";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getNavigatableArray$4";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getAffectedVcsesForFiles$1";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getAffectedVcses$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 8: 
            case 11: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 30: 
            case 33: 
            case 56: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @FunctionalInterface
    public static interface VcsSeparator<T> {
        @Nullable
        public AbstractVcs getVcsFor(@NotNull T var1);
    }

    @FunctionalInterface
    public static interface PerVcsProcessor<T> {
        public void process(@NotNull AbstractVcs var1, @NotNull List<T> var2);
    }
}

