/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.ui;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ManifestFileConfiguration {
    private final boolean myWritable;
    private List<String> myClasspath;
    private String myMainClass;
    private String myManifestFilePath;

    public ManifestFileConfiguration(@NotNull ManifestFileConfiguration configuration) {
        if (configuration == null) {
            ManifestFileConfiguration.$$$reportNull$$$0(0);
        }
        this.myClasspath = new ArrayList<String>();
        this.myWritable = configuration.isWritable();
        this.myClasspath.addAll(configuration.getClasspath());
        this.myMainClass = configuration.getMainClass();
        this.myManifestFilePath = configuration.getManifestFilePath();
    }

    public ManifestFileConfiguration(@NotNull String manifestFilePath, @Nullable List<String> classpath, @Nullable String mainClass, boolean isWritable) {
        if (manifestFilePath == null) {
            ManifestFileConfiguration.$$$reportNull$$$0(1);
        }
        this.myClasspath = new ArrayList<String>();
        this.myWritable = isWritable;
        if (classpath != null) {
            this.myClasspath.addAll(classpath);
        }
        this.myMainClass = mainClass;
        this.myManifestFilePath = manifestFilePath;
    }

    public List<String> getClasspath() {
        return this.myClasspath;
    }

    public boolean isWritable() {
        return this.myWritable;
    }

    public void setClasspath(List<String> classpath) {
        this.myClasspath = classpath;
    }

    public String getMainClass() {
        return this.myMainClass;
    }

    public void setMainClass(String mainClass) {
        this.myMainClass = mainClass;
    }

    public String getManifestFilePath() {
        return this.myManifestFilePath;
    }

    public void setManifestFilePath(String manifestFilePath) {
        this.myManifestFilePath = manifestFilePath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ManifestFileConfiguration)) {
            return false;
        }
        ManifestFileConfiguration that = (ManifestFileConfiguration)o;
        if (!this.myClasspath.equals(that.myClasspath)) {
            return false;
        }
        if (this.myMainClass != null ? !this.myMainClass.equals(that.myMainClass) : that.myMainClass != null) {
            return false;
        }
        return !(this.myManifestFilePath != null ? !this.myManifestFilePath.equals(that.myManifestFilePath) : that.myManifestFilePath != null);
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    public void addToClasspath(List<String> classpath) {
        for (String path2 : classpath) {
            if (this.myClasspath.contains(path2)) continue;
            this.myClasspath.add(path2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "configuration";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "manifestFilePath";
                break;
            }
        }
        objectArray[1] = "com/intellij/packaging/ui/ManifestFileConfiguration";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

