/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework;

import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.testIntegration.TestFinder;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ComparatorUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsTestFinder
implements TestFinder {
    private static final String[] SUFFIXES = new String[]{"Spec", "-spec", "_spec", ".spec", "Test", "-test", "_test", ".test", "Tests", "-tests", "_tests", ".tests"};
    private static final String[] TEST_DIR_NAMES = new String[]{"spec", "test", "specs", "tests", "testSrc"};

    @Nullable
    public PsiElement findSourceElement(@NotNull PsiElement from) {
        if (from == null) {
            JsTestFinder.$$$reportNull$$$0(0);
        }
        return JsTestFinder.getPhysicalFile(from);
    }

    @NotNull
    public Collection<PsiElement> findTestsForClass(@NotNull PsiElement element) {
        JSFile psiFile;
        VirtualFile file;
        if (element == null) {
            JsTestFinder.$$$reportNull$$$0(1);
        }
        VirtualFile virtualFile = file = (psiFile = JsTestFinder.getPhysicalFile(element)) != null ? psiFile.getVirtualFile() : null;
        if (file == null || psiFile.isTestFile()) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                JsTestFinder.$$$reportNull$$$0(2);
            }
            return list;
        }
        List<VirtualFile> testFiles = JsTestFinder.findTestFiles(element.getProject(), file);
        List<PsiElement> list = JsTestFinder.toPsiFiles(element.getManager(), testFiles);
        if (list == null) {
            JsTestFinder.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    private static List<VirtualFile> findTestFiles(@NotNull Project project, @NotNull VirtualFile srcFile) {
        if (project == null) {
            JsTestFinder.$$$reportNull$$$0(4);
        }
        if (srcFile == null) {
            JsTestFinder.$$$reportNull$$$0(5);
        }
        String nameWithoutExtension = srcFile.getNameWithoutExtension();
        String extension = srcFile.getExtension();
        ArrayList result = ContainerUtil.newArrayList();
        for (String suffix : SUFFIXES) {
            String possibleTestName = nameWithoutExtension + suffix + "." + extension;
            result.addAll(FilenameIndex.getVirtualFilesByName((Project)project, (String)possibleTestName, (GlobalSearchScope)GlobalSearchScope.projectScope((Project)project)));
        }
        List<VirtualFile> testFiles = JsTestFinder.findSameNamedFiles(project, srcFile, true);
        result.addAll(testFiles);
        List<VirtualFile> list = JsTestFinder.sortAndUnique(project, result, srcFile);
        if (list == null) {
            JsTestFinder.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    private static List<VirtualFile> findSameNamedFiles(@NotNull Project project, @NotNull VirtualFile file, boolean searchForTest) {
        ProjectFileIndex fileIndex;
        VirtualFile contentRoot;
        if (project == null) {
            JsTestFinder.$$$reportNull$$$0(7);
        }
        if (file == null) {
            JsTestFinder.$$$reportNull$$$0(8);
        }
        if ((contentRoot = (fileIndex = ProjectFileIndex.getInstance((Project)project)).getContentRootForFile(file, false)) == null || !contentRoot.isValid()) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                JsTestFinder.$$$reportNull$$$0(9);
            }
            return list;
        }
        ArrayList path = ContainerUtil.newArrayList();
        for (VirtualFile dir = file.getParent(); dir != null; dir = dir.getParent()) {
            path.add(dir);
            if (contentRoot.equals(dir)) break;
        }
        Collections.reverse(path);
        List result = ContainerUtil.newSmartList();
        if (searchForTest) {
            for (int i = 0; i < path.size() - 1; ++i) {
                VirtualFile srcDir = (VirtualFile)path.get(i + 1);
                List<VirtualFile> testDirs = JsTestFinder.findTestDirs((VirtualFile)path.get(i));
                for (VirtualFile testDir : testDirs) {
                    VirtualFile testFile;
                    if (testDir.equals(srcDir) || (testFile = JsTestFinder.findFileWithSameRelativePath(file, srcDir, testDir)) == null) continue;
                    result.add(testFile);
                }
            }
        } else {
            for (int i = 0; i < path.size() - 1; ++i) {
                VirtualFile testDir = (VirtualFile)path.get(i + 1);
                if (!ArrayUtil.contains((String)testDir.getName(), (String[])TEST_DIR_NAMES)) continue;
                for (VirtualFile child : ((VirtualFile)path.get(i)).getChildren()) {
                    VirtualFile srcFile;
                    if (testDir.equals(child) || (srcFile = JsTestFinder.findFileWithSameRelativePath(file, testDir, child)) == null) continue;
                    result.add(srcFile);
                }
            }
        }
        List list = result;
        if (list == null) {
            JsTestFinder.$$$reportNull$$$0(10);
        }
        return list;
    }

    @Nullable
    private static VirtualFile findFileWithSameRelativePath(@NotNull VirtualFile file, @NotNull VirtualFile oldBaseDir, @NotNull VirtualFile newBaseDir) {
        String relativePath;
        if (file == null) {
            JsTestFinder.$$$reportNull$$$0(11);
        }
        if (oldBaseDir == null) {
            JsTestFinder.$$$reportNull$$$0(12);
        }
        if (newBaseDir == null) {
            JsTestFinder.$$$reportNull$$$0(13);
        }
        return (relativePath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)oldBaseDir)) != null ? newBaseDir.findFileByRelativePath(relativePath) : null;
    }

    @NotNull
    private static List<VirtualFile> findTestDirs(@NotNull VirtualFile commonParent) {
        if (commonParent == null) {
            JsTestFinder.$$$reportNull$$$0(14);
        }
        List result = ContainerUtil.newSmartList();
        for (String name : TEST_DIR_NAMES) {
            VirtualFile testDir = commonParent.findChild(name);
            if (testDir == null || !testDir.isDirectory() || !testDir.isValid()) continue;
            result.add(testDir);
        }
        List list = result;
        if (list == null) {
            JsTestFinder.$$$reportNull$$$0(15);
        }
        return list;
    }

    @NotNull
    public Collection<PsiElement> findClassesForTest(@NotNull PsiElement element) {
        JSFile psiFile;
        VirtualFile file;
        if (element == null) {
            JsTestFinder.$$$reportNull$$$0(16);
        }
        VirtualFile virtualFile = file = (psiFile = JsTestFinder.getPhysicalFile(element)) != null ? psiFile.getVirtualFile() : null;
        if (file == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                JsTestFinder.$$$reportNull$$$0(17);
            }
            return list;
        }
        List<VirtualFile> testFiles = JsTestFinder.findSourceFiles(element.getProject(), file);
        List<PsiElement> list = JsTestFinder.toPsiFiles(element.getManager(), testFiles);
        if (list == null) {
            JsTestFinder.$$$reportNull$$$0(18);
        }
        return list;
    }

    @NotNull
    private static List<VirtualFile> findSourceFiles(@NotNull Project project, @NotNull VirtualFile testFile) {
        if (project == null) {
            JsTestFinder.$$$reportNull$$$0(19);
        }
        if (testFile == null) {
            JsTestFinder.$$$reportNull$$$0(20);
        }
        String nameWithoutExtension = testFile.getNameWithoutExtension();
        String extension = testFile.getExtension();
        ArrayList result = ContainerUtil.newArrayList();
        for (String suffix : SUFFIXES) {
            if (!nameWithoutExtension.endsWith(suffix)) continue;
            String srcName = nameWithoutExtension.substring(0, nameWithoutExtension.length() - suffix.length()) + "." + extension;
            result.addAll(FilenameIndex.getVirtualFilesByName((Project)project, (String)srcName, (GlobalSearchScope)GlobalSearchScope.projectScope((Project)project)));
        }
        List<VirtualFile> srcFiles = JsTestFinder.findSameNamedFiles(project, testFile, false);
        result.addAll(srcFiles);
        List<VirtualFile> list = JsTestFinder.sortAndUnique(project, result, testFile);
        if (list == null) {
            JsTestFinder.$$$reportNull$$$0(21);
        }
        return list;
    }

    public boolean isTest(@NotNull PsiElement element) {
        JSFile file;
        if (element == null) {
            JsTestFinder.$$$reportNull$$$0(22);
        }
        return (file = JsTestFinder.getPhysicalFile(element)) != null && file.isTestFile();
    }

    @Nullable
    private static JSFile getPhysicalFile(@NotNull PsiElement element) {
        JSFile jsFile;
        PsiFile psiFile;
        if (element == null) {
            JsTestFinder.$$$reportNull$$$0(23);
        }
        if ((psiFile = element.getContainingFile()) != null) {
            psiFile = psiFile.getOriginalFile();
        }
        return (jsFile = (JSFile)ObjectUtils.tryCast((Object)psiFile, JSFile.class)) != null && jsFile.getVirtualFile() != null ? jsFile : null;
    }

    @NotNull
    private static List<PsiElement> toPsiFiles(@NotNull PsiManager manager, @NotNull List<VirtualFile> testFiles) {
        if (manager == null) {
            JsTestFinder.$$$reportNull$$$0(24);
        }
        if (testFiles == null) {
            JsTestFinder.$$$reportNull$$$0(25);
        }
        List psiFiles = ContainerUtil.map(testFiles, arg_0 -> ((PsiManager)manager).findFile(arg_0));
        List list = ContainerUtil.filter((Collection)psiFiles, (Condition)Condition.NOT_NULL);
        if (list == null) {
            JsTestFinder.$$$reportNull$$$0(26);
        }
        return list;
    }

    @NotNull
    private static List<VirtualFile> sortAndUnique(@NotNull Project project, @NotNull Collection<VirtualFile> relatedFiles, @NotNull VirtualFile contextFile) {
        if (project == null) {
            JsTestFinder.$$$reportNull$$$0(27);
        }
        if (relatedFiles == null) {
            JsTestFinder.$$$reportNull$$$0(28);
        }
        if (contextFile == null) {
            JsTestFinder.$$$reportNull$$$0(29);
        }
        ProjectFileIndex fileIndex = ProjectFileIndex.getInstance((Project)project);
        VirtualFile contentRoot = fileIndex.getContentRootForFile(contextFile, true);
        List list = ContainerUtil.map((Collection)ContainerUtil.newHashSet(relatedFiles), file -> {
            VirtualFile cr = fileIndex.getContentRootForFile(file, false);
            return new Data((VirtualFile)file, ComparatorUtil.equalsNullable((Object)cr, (Object)contentRoot));
        });
        Collections.sort(list, (d1, d2) -> {
            if (((Data)d1).myFromTheSameContentRoot != ((Data)d2).myFromTheSameContentRoot) {
                return ((Data)d1).myFromTheSameContentRoot ? -1 : 1;
            }
            return ((Data)d1).myFile.getPath().compareTo(((Data)d2).myFile.getPath());
        });
        List list2 = ContainerUtil.map((Collection)list, data -> ((Data)data).myFile);
        if (list2 == null) {
            JsTestFinder.$$$reportNull$$$0(30);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 15: 
            case 17: 
            case 18: 
            case 21: 
            case 26: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 15: 
            case 17: 
            case 18: 
            case 21: 
            case 26: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 1: 
            case 16: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 15: 
            case 17: 
            case 18: 
            case 21: 
            case 26: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/testFramework/JsTestFinder";
                break;
            }
            case 4: 
            case 7: 
            case 19: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "srcFile";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldBaseDir";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newBaseDir";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonParent";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFile";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFiles";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relatedFiles";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/testFramework/JsTestFinder";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findTestsForClass";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findTestFiles";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findSameNamedFiles";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "findTestDirs";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "findClassesForTest";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "findSourceFiles";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "toPsiFiles";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "sortAndUnique";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findSourceElement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findTestsForClass";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 15: 
            case 17: 
            case 18: 
            case 21: 
            case 26: 
            case 30: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findTestFiles";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findSameNamedFiles";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findFileWithSameRelativePath";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findTestDirs";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findClassesForTest";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findSourceFiles";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isTest";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getPhysicalFile";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "toPsiFiles";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "sortAndUnique";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 15: 
            case 17: 
            case 18: 
            case 21: 
            case 26: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Data {
        private final VirtualFile myFile;
        private final boolean myFromTheSameContentRoot;

        public Data(@NotNull VirtualFile file, boolean fromTheSameContentRoot) {
            if (file == null) {
                Data.$$$reportNull$$$0(0);
            }
            this.myFile = file;
            this.myFromTheSameContentRoot = fromTheSameContentRoot;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javascript/testFramework/JsTestFinder$Data", "<init>"));
        }
    }
}

